<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'tediss_quickcal_get_css' ) ) {
	add_filter( 'tediss_filter_get_css', 'tediss_quickcal_get_css', 10, 2 );
	function tediss_quickcal_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body table.booked-calendar button,
body .booked-modal input[type="submit"],
body .booked-modal button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName {
    {$fonts['h2_font-family']}
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS

/* Form fields */
#booked-page-form {
	color: {$colors['text']};
	border-color: {$colors['bd_color']};
}

#booked-profile-page .booked-profile-header {
	background-color: {$colors['bg_color']} !important;
	border-color: transparent !important;
	color: {$colors['text']};
}
#booked-profile-page .booked-user h3 {
	color: {$colors['text_dark']};
}
#booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_link']};
}

#booked-profile-page .booked-tabs {
	border-color: {$colors['alter_bd_color']} !important;
}

.booked-modal .bm-window p.booked-title-bar {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['extra_bg_color']} !important;
}
.booked-modal .bm-window .close i {
	color: {$colors['extra_dark']};
}
.booked-modal .bm-window .close:hover i {
	color: {$colors['text_link']};
}

.booked-modal .bm-window #customerChoices {
	background-color: {$colors['extra_bg_hover']};
	border-color: {$colors['extra_bd_hover']};
}
.booked-form .booked-appointments {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_hover']} !important;	
}
.booked-form .checkbox-radio-block {
	color: {$colors['alter_text']};
}
.booked-modal .bm-window p.appointment-title {
	color: {$colors['alter_dark']};	
}

/* Profile page and tabs */
.booked-calendarSwitcher.calendar,
.booked-calendarSwitcher.calendar select{
	background-color: {$colors['alter_bg_color']} !important;
}
#booked-profile-page .booked-tabs {
    background-color: {$colors['text_hover2']} !important;
}
body #booked-profile-page .appt-block .booked-cal-buttons .google-cal-button{
	background-color: {$colors['text_hover2']} !important;
	border-color:{$colors['text_hover2']} !important;
}
#booked-profile-page .booked-tabs li a, body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons a{
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['extra_bg_color']} !important;
	border-color:{$colors['extra_bg_color']} !important;
}
#booked-profile-page .booked-tabs li a i {
	color: {$colors['extra_dark']};
}
body #booked-profile-page .appt-block .booked-cal-buttons .google-cal-button:hover{
    background-color: {$colors['text_link']} !important;
	border-color:{$colors['text_link']} !important;
}
#booked-profile-page .booked-tabs li.active a,body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons a:hover,
#booked-profile-page .booked-tabs li.active a:hover,
#booked-profile-page .booked-tabs li a:hover {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['text_link']} !important;
	border-color:{$colors['text_link']} !important;
}
body #booked-profile-page .booked-profile-appt-list .appt-block > i.booked-icon{
    color: {$colors['text_link']};
}

body #booked-profile-page .booked-profile-appt-list .appt-block .status-block{
    background-color: {$colors['text_link']} !important;
}
#booked-profile-page .booked-tab-content {
	background-color: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}
body div.booked-calendar-wrap div.booked-calendar,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col:hover .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.next-month .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.prev-month .date,
body table.booked-calendar td.next-month .date, body table.booked-calendar td.prev-month .date {
    background-color: {$colors['bg_color']}!important;
}
/* Calendar */
table.booked-calendar thead tr {
	background-color: {$colors['extra_bg_color']} !important;
}

body table.booked-calendar thead tr:not(.days) th{
    border-color: {$colors['alter_hover']} !important;
}
table.booked-calendar thead tr th {
	color: {$colors['extra_dark']} !important;
	border-color: {$colors['alter_bd_color']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-left i:hover,
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-right i:hover,
table.booked-calendar thead th i:hover {
	color: {$colors['text_link']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-left i,
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-right i,
table.booked-calendar thead th i {
	color: {$colors['extra_dark']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName a,
table.booked-calendar thead th .monthName a {
	color: {$colors['extra_link']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName a:hover,
table.booked-calendar thead th .monthName a:hover {
	color: {$colors['extra_hover']};
}
body .booked-modal input[type=submit].button-primary:hover, .booked-form .field .booked-forgot-goback:hover{
    background-color: {$colors['text_link2']} !important;
    color: {$colors['text_hover']} !important;
}
body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover,
table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover{
    background-color: {$colors['text_hover']} !important;
    color: {$colors['extra_dark']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col,
table.booked-calendar tbody tr td {
	color: {$colors['alter_text']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.entryBlock,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col,
table.booked-calendar tbody tr td {
	border-color: {$colors['alter_bd_color']} !important;
}

body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.active .date{
	border-bottom-color: {$colors['alter_bg_color']} !important;
}

table.booked-calendar tbody tr td:hover {
	color: {$colors['alter_dark']} !important;
}
table.booked-calendar tbody tr td.today .date {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['extra_dark']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.today .date span,
table.booked-calendar tbody tr td.today .date span {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['text_hover']} !important;
	border-color: {$colors['text_hover']} !important;
}
table.booked-calendar tbody td.today:hover .date span {
	background-color: {$colors['text_link2']} !important;
	color: {$colors['text_hover']} !important;
	border-color: {$colors['text_link2']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.entryBlock,
body .booked-appt-list,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.active .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.active:hover .date,
body table.booked-calendar tr.week td.active .date,
body table.booked-calendar tr.week td.active:hover .date, 
body table.booked-calendar tr.entryBlock{
    background-color: {$colors['alter_bg_color']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.active .date .number,
table.booked-calendar tr.week td.active .date .number {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['text_hover']} !important;
	border-color: {$colors['text_hover']};
}

.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot {
	border-color: {$colors['alter_bd_color']};	
}
.booked-calendar-wrap .booked-appt-list .timeslot:hover {
	background-color: {$colors['alter_bg_hover']};	
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-title {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row.top .bc-col,
body table.booked-calendar th {
   background-color: {$colors['text_hover']}!important;	 
}
body div.booked-calendar .bc-row.days .bc-col,
body table.booked-calendar tr.days th {
   color: {$colors['text_dark']} !important;
   background-color: {$colors['bd_color']}!important;
   border-color: {$colors['alter_bd_color']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.prev-date .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.blur .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.prev-date .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.prev-date:hover .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.blur .date,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.blur:hover .date,
body table.booked-calendar td.prev-date .date,
body table.booked-calendar td.next-date .date, 
body table.booked-calendar td.prev-date:hover .date,
body table.booked-calendar td.next-date:hover .date{
    color: {$colors['text_light']}!important;
    background-color: {$colors['extra_dark']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.prev-date:hover .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.blur:hover .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col:hover .date span,
body table.booked-calendar td.prev-date:hover .date span{
    color: {$colors['extra_dark']}!important;
    background-color: {$colors['text_link']}!important;
    border-color: {$colors['text_link']}!important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.prev-date .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.blur .date span,
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col .date span,
body table.booked-calendar td .date .number{
    background-color: {$colors['alter_bg_color']}!important;	
    border-color: {$colors['alter_bg_color']}!important;
}
body table.booked-calendar td:hover .date {
    background-color: {$colors['extra_dark']}!important;
}
body table.booked-calendar td:hover .date .number{
     background-color: {$colors['text_hover']}!important;	
      color: {$colors['extra_dark']}!important; 
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.today:hover .date span{
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['text_link']} !important;
	border-color: {$colors['text_link']} !important;
}

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button .spots-available {
	color: {$colors['inverse_link']};
}

body #booked-profile-page input[type="submit"].button-primary,
body #booked-profile-page input[type="submit"].cancel, 
body #booked-profile-page button.cancel, body .booked-list-view input[type="submit"].cancel, 
body .booked-list-view button.cancel, body .booked-calendar input[type="submit"].cancel, 
body .booked-calendar button.cancel, 
body .booked-modal input[type="submit"].cancel, body .booked-modal button.cancel,
body .booked-modal input[type="submit"].button-primary,
body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button{
	color: {$colors['inverse_link']}!important;
	background-color: {$colors['text_link']}!important;
	border-color: {$colors['text_link']}!important;
}

body #booked-profile-page input[type="submit"].button-primary:hover,
body #booked-profile-page input[type="submit"].cancel:hover, 
body #booked-profile-page button.cancel:hover, 
body .booked-list-view input[type="submit"].cancel:hover, 
body .booked-list-view button.cancel:hover, 
body .booked-calendar input[type="submit"].cancel:hover, 
body .booked-calendar button.cancel:hover, 
body .booked-modal input[type="submit"].cancel:hover, 
body .booked-modal button.cancel:hover,
body .booked-modal input[type="submit"].button-primary:hover,
body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover{
	color: {$colors['extra_dark']}!important;
	background-color: {$colors['extra_bg_color']}!important;
	border-color: {$colors['extra_bg_color']}!important;
}

body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button:disabled {
	border-color: {$colors['text_light']} !important;
    background-color: {$colors['text_light']} !important;
    color: {$colors['text']} !important;
}

CSS;
		}

		return $css;
	}
}

