<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tediss_essential_grid_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'tediss_essential_grid_theme_setup9', 9 );
	function tediss_essential_grid_theme_setup9() {

		add_filter( 'tediss_filter_merge_styles', 'tediss_essential_grid_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'tediss_filter_tgmpa_required_plugins', 'tediss_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'tediss_essential_grid_tgmpa_required_plugins' ) ) {
	
	function tediss_essential_grid_tgmpa_required_plugins( $list = array() ) {
		if ( tediss_storage_isset( 'required_plugins', 'essential-grid' ) && tediss_is_theme_activated() ) {
			$path = tediss_get_plugin_source_path( 'plugins/essential-grid/essential-grid.zip' );
			if ( ! empty( $path ) || tediss_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => tediss_storage_get_array( 'required_plugins', 'essential-grid' ),
					'slug'     => 'essential-grid',
					'source'   => ! empty( $path ) ? $path : 'upload://essential-grid.zip',
					'version'  => '3.1.0',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'tediss_exists_essential_grid' ) ) {
	function tediss_exists_essential_grid() {
		return defined('EG_PLUGIN_PATH') || defined( 'ESG_PLUGIN_PATH' );
	}
}

// Merge custom styles
if ( ! function_exists( 'tediss_essential_grid_merge_styles' ) ) {
	
	function tediss_essential_grid_merge_styles( $list ) {
		if ( tediss_exists_essential_grid() ) {
			$list[] = 'plugins/essential-grid/_essential-grid.scss';
		}
		return $list;
	}
}

