<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tediss_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'tediss_cf7_theme_setup9', 9 );
	function tediss_cf7_theme_setup9() {

		add_filter( 'tediss_filter_merge_scripts', 'tediss_cf7_merge_scripts' );
		add_filter( 'tediss_filter_merge_styles', 'tediss_cf7_merge_styles' );

		if ( tediss_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'tediss_cf7_frontend_scripts', 1100 );
			add_filter('wpcf7_autop_or_not', '__return_false');
		}

		if ( is_admin() ) {
			add_filter( 'tediss_filter_tgmpa_required_plugins', 'tediss_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'tediss_cf7_tgmpa_required_plugins' ) ) {
	
	function tediss_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( tediss_storage_isset( 'required_plugins', 'contact-form-7' ) ) {
			// CF7 plugin
			$list[] = array(
				'name'     => tediss_storage_get_array( 'required_plugins', 'contact-form-7' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'tediss_exists_cf7' ) ) {
	function tediss_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'tediss_cf7_frontend_scripts' ) ) {
	
	function tediss_cf7_frontend_scripts() {
		if ( tediss_exists_cf7() ) {
			if ( tediss_is_on( tediss_get_theme_option( 'debug_mode' ) ) ) {
				$tediss_url = tediss_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
				if ( '' != $tediss_url ) {
					wp_enqueue_script( 'tediss-cf7', $tediss_url, array( 'jquery' ), null, true );
				}
			}
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'tediss_cf7_merge_scripts' ) ) {
	
	function tediss_cf7_merge_scripts( $list ) {
		if ( tediss_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( ! function_exists( 'tediss_cf7_merge_styles' ) ) {
	
	function tediss_cf7_merge_styles( $list ) {
		if ( tediss_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}

