<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tediss_booked_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'tediss_booked_theme_setup9', 9 );
	function tediss_booked_theme_setup9() {
		add_filter( 'tediss_filter_merge_styles', 'tediss_booked_merge_styles' );
		if ( is_admin() ) {
			add_filter( 'tediss_filter_tgmpa_required_plugins', 'tediss_booked_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'tediss_booked_tgmpa_required_plugins' ) ) {
	
	function tediss_booked_tgmpa_required_plugins( $list = array() ) {
		if ( tediss_storage_isset( 'required_plugins', 'booked' ) && tediss_is_theme_activated() ) {
			$path = tediss_get_plugin_source_path( 'plugins/booked/booked.zip' );
			if ( ! empty( $path ) || tediss_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => tediss_storage_get_array( 'required_plugins', 'booked' ),
					'slug'     => 'booked',
					'source'   => ! empty( $path ) ? $path : 'upload://booked.zip',
					'version'  => '2.4.4',
					'required' => false,
				);
			}

		}
		return $list;
	}
}


// Check if plugin installed and activated
if ( ! function_exists( 'tediss_exists_booked' ) ) {
	function tediss_exists_booked() {
		return class_exists( 'booked_plugin' );
	}
}

// Merge custom styles
if ( ! function_exists( 'tediss_booked_merge_styles' ) ) {
	
	function tediss_booked_merge_styles( $list ) {
		if ( tediss_exists_booked() ) {
			$list[] = 'plugins/booked/_booked.scss';
		}
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( tediss_exists_booked() ) {
	require_once TEDISS_THEME_DIR . 'plugins/booked/booked-styles.php'; }

