<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

tediss_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	tediss_blog_archive_start();

	$tediss_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$tediss_sticky_out = tediss_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $tediss_stickies ) && count( $tediss_stickies ) > 0 && get_query_var( 'paged' ) < 1;

	// Show filters
	$tediss_cat          = tediss_get_theme_option( 'parent_cat' );
	$tediss_post_type    = tediss_get_theme_option( 'post_type' );
	$tediss_taxonomy     = tediss_get_post_type_taxonomy( $tediss_post_type );
	$tediss_show_filters = tediss_get_theme_option( 'show_filters' );
	$tediss_tabs         = array();
	if ( ! tediss_is_off( $tediss_show_filters ) ) {
		$tediss_args           = array(
			'type'         => $tediss_post_type,
			'child_of'     => $tediss_cat,
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 1,
			'hierarchical' => 0,
			'taxonomy'     => $tediss_taxonomy,
			'pad_counts'   => false,
		);
		$tediss_portfolio_list = get_terms( $tediss_args );
		if ( is_array( $tediss_portfolio_list ) && count( $tediss_portfolio_list ) > 0 ) {
			$tediss_tabs[ $tediss_cat ] = esc_html__( 'All', 'tediss' );
			foreach ( $tediss_portfolio_list as $tediss_term ) {
				if ( isset( $tediss_term->term_id ) ) {
					$tediss_tabs[ $tediss_term->term_id ] = $tediss_term->name;
				}
			}
		}
	}
	if ( count( $tediss_tabs ) > 0 ) {
		$tediss_portfolio_filters_ajax   = true;
		$tediss_portfolio_filters_active = $tediss_cat;
		$tediss_portfolio_filters_id     = 'portfolio_filters';
		?>
		<div class="portfolio_filters tediss_tabs tediss_tabs_ajax">
			<ul class="portfolio_titles tediss_tabs_titles">
				<?php
				foreach ( $tediss_tabs as $tediss_id => $tediss_title ) {
					?>
					<li><a href="<?php echo esc_url( tediss_get_hash_link( sprintf( '#%s_%s_content', $tediss_portfolio_filters_id, $tediss_id ) ) ); ?>" data-tab="<?php echo esc_attr( $tediss_id ); ?>"><?php echo esc_html( $tediss_title ); ?></a></li>
					<?php
				}
				?>
			</ul>
			<?php
			$tediss_ppp = tediss_get_theme_option( 'posts_per_page' );
			if ( tediss_is_inherit( $tediss_ppp ) ) {
				$tediss_ppp = '';
			}
			foreach ( $tediss_tabs as $tediss_id => $tediss_title ) {
				$tediss_portfolio_need_content = $tediss_id == $tediss_portfolio_filters_active || ! $tediss_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr( sprintf( '%s_%s_content', $tediss_portfolio_filters_id, $tediss_id ) ); ?>"
					class="portfolio_content tediss_tabs_content"
					data-blog-template="<?php echo esc_attr( tediss_storage_get( 'blog_template' ) ); ?>"
					data-blog-style="<?php echo esc_attr( tediss_get_theme_option( 'blog_style' ) ); ?>"
					data-posts-per-page="<?php echo esc_attr( $tediss_ppp ); ?>"
					data-post-type="<?php echo esc_attr( $tediss_post_type ); ?>"
					data-taxonomy="<?php echo esc_attr( $tediss_taxonomy ); ?>"
					data-cat="<?php echo esc_attr( $tediss_id ); ?>"
					data-parent-cat="<?php echo esc_attr( $tediss_cat ); ?>"
					data-need-content="<?php echo ( false === $tediss_portfolio_need_content ? 'true' : 'false' ); ?>"
				>
					<?php
					if ( $tediss_portfolio_need_content ) {
						tediss_show_portfolio_posts(
							array(
								'cat'        => $tediss_id,
								'parent_cat' => $tediss_cat,
								'taxonomy'   => $tediss_taxonomy,
								'post_type'  => $tediss_post_type,
								'page'       => 1,
								'sticky'     => $tediss_sticky_out,
							)
						);
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		tediss_show_portfolio_posts(
			array(
				'cat'        => $tediss_cat,
				'parent_cat' => $tediss_cat,
				'taxonomy'   => $tediss_taxonomy,
				'post_type'  => $tediss_post_type,
				'page'       => 1,
				'sticky'     => $tediss_sticky_out,
			)
		);
	}

	tediss_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
