<?php
/**
 * The template for homepage posts with custom style
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.50
 */

tediss_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	$tediss_blog_style = tediss_get_theme_option( 'blog_style' );
	$tediss_parts      = explode( '_', $tediss_blog_style );
	$tediss_columns    = ! empty( $tediss_parts[1] ) ? max( 1, min( 6, (int) $tediss_parts[1] ) ) : 1;
	$tediss_blog_id    = tediss_get_custom_blog_id( $tediss_blog_style );
	$tediss_blog_meta  = tediss_get_custom_layout_meta( $tediss_blog_id );
	if ( ! empty( $tediss_blog_meta['margin'] ) ) {
		tediss_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( tediss_prepare_css_value( $tediss_blog_meta['margin'] ) ) ) );
	}
	$tediss_custom_style = ! empty( $tediss_blog_meta['scripts_required'] ) ? $tediss_blog_meta['scripts_required'] : 'none';

	tediss_blog_archive_start();

	$tediss_classes    = 'posts_container blog_custom_wrap' 
							. ( ! tediss_is_off( $tediss_custom_style )
								? sprintf( ' %s_wrap', $tediss_custom_style )
								: ( $tediss_columns > 1 
									? ' columns_wrap columns_padding_bottom' 
									: ''
									)
								);
	$tediss_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$tediss_sticky_out = tediss_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $tediss_stickies ) && count( $tediss_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $tediss_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $tediss_sticky_out ) {
		if ( tediss_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( tediss_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}
		?>
		<div class="<?php echo esc_attr( $tediss_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $tediss_sticky_out && ! is_sticky() ) {
			$tediss_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $tediss_classes ); ?>">
			<?php
		}
		$tediss_part = $tediss_sticky_out && is_sticky() ? 'sticky' : 'custom';
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', $tediss_part ), $tediss_part );
	}
	?>
	</div>
	<?php

	tediss_show_pagination();

	tediss_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
