<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

tediss_storage_set( 'blog_archive', true );

get_header();
// Disable lazy load for masonry
$blog_style = explode( '_', empty( $args['blog_style'] ) ? tediss_get_theme_option( 'blog_style' ) : $args['blog_style'] );
$style      = $blog_style[0];

if ( tediss_is_blog_style_use_masonry( $style ) ) {
	tediss_lazy_load_off();
}

if ( have_posts() ) {

	tediss_blog_archive_start();
	$tediss_classes    = 'posts_container '
						. ( substr( tediss_get_theme_option( 'blog_style' ), 0, 7 ) == 'classic'
							? 'columns_wrap columns_padding_bottom'
							: 'masonry_wrap'
							);
	$tediss_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$tediss_sticky_out = tediss_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $tediss_stickies ) && count( $tediss_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $tediss_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $tediss_sticky_out ) {
		if ( tediss_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( tediss_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}

		?>
		<div class="<?php echo esc_attr( $tediss_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $tediss_sticky_out && ! is_sticky() ) {
			$tediss_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $tediss_classes ); ?>">
			<?php
		}
		$tediss_part = $tediss_sticky_out && is_sticky() ? 'sticky' : 'classic';
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', $tediss_part ), $tediss_part );
	}

	?>
	</div>
	<?php

	tediss_show_pagination();

	tediss_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
