<?php
/**
 * The template for homepage posts with "Chess" style
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

tediss_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	tediss_blog_archive_start();

	$tediss_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$tediss_sticky_out = tediss_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $tediss_stickies ) && count( $tediss_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $tediss_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $tediss_sticky_out ) {
		?>
		<div class="chess_wrap posts_container">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $tediss_sticky_out && ! is_sticky() ) {
			$tediss_sticky_out = false;
			?>
			</div><div class="chess_wrap posts_container">
			<?php
		}
		$tediss_part = $tediss_sticky_out && is_sticky() ? 'sticky' : 'chess';
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', $tediss_part ), $tediss_part );
	}

	?>
	</div>
	<?php

	tediss_show_pagination();

	tediss_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
