<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'tediss_storage_get' ) ) {
	function tediss_storage_get( $var_name, $default = '' ) {
		global $TEDISS_STORAGE;
		return isset( $TEDISS_STORAGE[ $var_name ] ) ? $TEDISS_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'tediss_storage_set' ) ) {
	function tediss_storage_set( $var_name, $value ) {
		global $TEDISS_STORAGE;
		$TEDISS_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'tediss_storage_empty' ) ) {
	function tediss_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $TEDISS_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $TEDISS_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $TEDISS_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $TEDISS_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'tediss_storage_isset' ) ) {
	function tediss_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $TEDISS_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $TEDISS_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $TEDISS_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $TEDISS_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'tediss_storage_inc' ) ) {
	function tediss_storage_inc( $var_name, $value = 1 ) {
		global $TEDISS_STORAGE;
		if ( empty( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = 0;
		}
		$TEDISS_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'tediss_storage_concat' ) ) {
	function tediss_storage_concat( $var_name, $value ) {
		global $TEDISS_STORAGE;
		if ( empty( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = '';
		}
		$TEDISS_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'tediss_storage_get_array' ) ) {
	function tediss_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $TEDISS_STORAGE;
		if ( '' === $key2 ) {
			return ! empty( $var_name ) && '' !== $key && isset( $TEDISS_STORAGE[ $var_name ][ $key ] ) ? $TEDISS_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && '' !== $key && isset( $TEDISS_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $TEDISS_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'tediss_storage_set_array' ) ) {
	function tediss_storage_set_array( $var_name, $key, $value ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$TEDISS_STORAGE[ $var_name ][] = $value;
		} else {
			$TEDISS_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'tediss_storage_set_array2' ) ) {
	function tediss_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $TEDISS_STORAGE[ $var_name ][ $key ] ) ) {
			$TEDISS_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$TEDISS_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$TEDISS_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'tediss_storage_merge_array' ) ) {
	function tediss_storage_merge_array( $var_name, $key, $value ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$TEDISS_STORAGE[ $var_name ] = array_merge( $TEDISS_STORAGE[ $var_name ], $value );
		} else {
			$TEDISS_STORAGE[ $var_name ][ $key ] = array_merge( $TEDISS_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'tediss_storage_set_array_after' ) ) {
	function tediss_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			tediss_array_insert_after( $TEDISS_STORAGE[ $var_name ], $after, $key );
		} else {
			tediss_array_insert_after( $TEDISS_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'tediss_storage_set_array_before' ) ) {
	function tediss_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			tediss_array_insert_before( $TEDISS_STORAGE[ $var_name ], $before, $key );
		} else {
			tediss_array_insert_before( $TEDISS_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'tediss_storage_push_array' ) ) {
	function tediss_storage_push_array( $var_name, $key, $value ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $TEDISS_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $TEDISS_STORAGE[ $var_name ][ $key ] ) ) {
				$TEDISS_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $TEDISS_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'tediss_storage_pop_array' ) ) {
	function tediss_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $TEDISS_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $TEDISS_STORAGE[ $var_name ] ) && is_array( $TEDISS_STORAGE[ $var_name ] ) && count( $TEDISS_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $TEDISS_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $TEDISS_STORAGE[ $var_name ][ $key ] ) && is_array( $TEDISS_STORAGE[ $var_name ][ $key ] ) && count( $TEDISS_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $TEDISS_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'tediss_storage_inc_array' ) ) {
	function tediss_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( empty( $TEDISS_STORAGE[ $var_name ][ $key ] ) ) {
			$TEDISS_STORAGE[ $var_name ][ $key ] = 0;
		}
		$TEDISS_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'tediss_storage_concat_array' ) ) {
	function tediss_storage_concat_array( $var_name, $key, $value ) {
		global $TEDISS_STORAGE;
		if ( ! isset( $TEDISS_STORAGE[ $var_name ] ) ) {
			$TEDISS_STORAGE[ $var_name ] = array();
		}
		if ( empty( $TEDISS_STORAGE[ $var_name ][ $key ] ) ) {
			$TEDISS_STORAGE[ $var_name ][ $key ] = '';
		}
		$TEDISS_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'tediss_storage_call_obj_method' ) ) {
	function tediss_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $TEDISS_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $TEDISS_STORAGE[ $var_name ] ) ? $TEDISS_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $TEDISS_STORAGE[ $var_name ] ) ? $TEDISS_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'tediss_storage_get_obj_property' ) ) {
	function tediss_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $TEDISS_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $TEDISS_STORAGE[ $var_name ]->$prop ) ? $TEDISS_STORAGE[ $var_name ]->$prop : $default;
	}
}
