<?php
/**
 * The Header: Logo and main menu
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js
									<?php
										// Class scheme_xxx need in the <html> as context for the <body>!
										echo ' scheme_' . esc_attr( tediss_get_theme_option( 'color_scheme' ) );
									?>
										">
<head>
	<?php wp_head(); ?>
</head>

<body <?php	body_class(); ?>>
<?php wp_body_open(); ?>

	<?php do_action( 'tediss_action_before_body' ); ?>

	<div class="body_wrap">

		<div class="page_wrap">
			<?php
			// Desktop header
			$tediss_header_type = tediss_get_theme_option( 'header_type' );
			if ( 'custom' == $tediss_header_type && ! tediss_is_layouts_available() ) {
				$tediss_header_type = 'default';
			}
			get_template_part( apply_filters( 'tediss_filter_get_template_part', "templates/header-{$tediss_header_type}" ) );

			// Side menu
			if ( in_array( tediss_get_theme_option( 'menu_style' ), array( 'left', 'right' ) ) ) {
				get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-navi-side' ) );
			}

			// Mobile menu
			get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-navi-mobile' ) );
			
			// Single posts banner after header
			tediss_show_post_banner( 'header' );
			?>

			<div class="page_content_wrap">
				<?php
				// Single posts banner on the background
				if ( is_singular( 'post' ) ) {

					tediss_show_post_banner( 'background' );

					$tediss_post_thumbnail_type  = tediss_get_theme_option( 'post_thumbnail_type' );
					$tediss_post_header_position = tediss_get_theme_option( 'post_header_position' );
					$tediss_post_header_align    = tediss_get_theme_option( 'post_header_align' );

					// Boxed post thumbnail
					if ( in_array( $tediss_post_thumbnail_type, array( 'boxed', 'fullwidth') ) ) {
						?>
						<div class="header_content_wrap header_align_<?php echo esc_attr( $tediss_post_header_align ); ?>">
							<?php
							if ( 'boxed' === $tediss_post_thumbnail_type ) {
								?>
								<div class="content_wrap">
								<?php
							}

							// Post title and meta
							if ( 'above' === $tediss_post_header_position ) {
								tediss_show_post_title_and_meta();
							}

							// Featured image
							tediss_show_post_featured_image();

							// Post title and meta
							if ( in_array( $tediss_post_header_position, array( 'under', 'on_thumb' ) ) ) {
								tediss_show_post_title_and_meta();
							}

							if ( 'boxed' === $tediss_post_thumbnail_type ) {
								?>
								</div>
								<?php
							}
							?>
						</div>
						<?php
					}
				}

				if ( 'fullscreen' != tediss_get_theme_option( 'body_style' ) ) {
					?>
					<div class="content_wrap">
						<?php
				}

				// Widgets area above page content
				tediss_create_widgets_area( 'widgets_above_page' );
				?>

				<div class="content">
					<?php
					// Widgets area inside page content
					tediss_create_widgets_area( 'widgets_above_content' );
