<?php
$tediss_slider_sc = tediss_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $tediss_slider_sc ) && strpos( $tediss_slider_sc, '[' ) !== false && strpos( $tediss_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$tediss_anchor_icon = tediss_get_theme_option( 'front_page_title_anchor_icon' );
		$tediss_anchor_text = tediss_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $tediss_anchor_icon ) || ! empty( $tediss_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $tediss_anchor_icon ) ? ' icon="' . esc_attr( $tediss_anchor_icon ) . '"' : '' )
									. ( ! empty( $tediss_anchor_text ) ? ' title="' . esc_attr( $tediss_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $tediss_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$tediss_scheme = tediss_get_theme_option( 'front_page_title_scheme' );
		if ( ! tediss_is_inherit( $tediss_scheme ) ) {
			echo ' scheme_' . esc_attr( $tediss_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( tediss_get_theme_option( 'front_page_title_paddings' ) );
		?>
		"
		<?php
		$tediss_css      = '';
		$tediss_bg_image = tediss_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $tediss_bg_image ) ) {
			$tediss_css .= 'background-image: url(' . esc_url( tediss_get_attachment_url( $tediss_bg_image ) ) . ');';
		}
		if ( ! empty( $tediss_css ) ) {
			echo ' style="' . esc_attr( $tediss_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$tediss_anchor_icon = tediss_get_theme_option( 'front_page_title_anchor_icon' );
		$tediss_anchor_text = tediss_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $tediss_anchor_icon ) || ! empty( $tediss_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $tediss_anchor_icon ) ? ' icon="' . esc_attr( $tediss_anchor_icon ) . '"' : '' )
									. ( ! empty( $tediss_anchor_text ) ? ' title="' . esc_attr( $tediss_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( tediss_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' tediss-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$tediss_css      = '';
			$tediss_bg_mask  = tediss_get_theme_option( 'front_page_title_bg_mask' );
			$tediss_bg_color_type = tediss_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $tediss_bg_color_type ) {
				$tediss_bg_color = tediss_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $tediss_bg_color_type ) {
				$tediss_bg_color = tediss_get_scheme_color( 'bg_color', $tediss_scheme );
			} else {
				$tediss_bg_color = '';
			}
			if ( ! empty( $tediss_bg_color ) && $tediss_bg_mask > 0 ) {
				$tediss_css .= 'background-color: ' . esc_attr(
					1 == $tediss_bg_mask ? $tediss_bg_color : tediss_hex2rgba( $tediss_bg_color, $tediss_bg_mask )
				) . ';';
			}
			if ( ! empty( $tediss_css ) ) {
				echo ' style="' . esc_attr( $tediss_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$tediss_caption = tediss_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $tediss_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $tediss_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $tediss_caption, 'tediss_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$tediss_description = tediss_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $tediss_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $tediss_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $tediss_description ), 'tediss_kses_content' ) ?></div>
					<?php
				}

				// Buttons
				if ( tediss_get_theme_option( 'front_page_title_button1_link' ) != '' || tediss_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						tediss_show_layout( tediss_customizer_partial_refresh_front_page_title_button1_link() );
						tediss_show_layout( tediss_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
