<div class="front_page_section front_page_section_googlemap<?php
	$tediss_scheme = tediss_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! tediss_is_inherit( $tediss_scheme ) ) {
		echo ' scheme_' . esc_attr( $tediss_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( tediss_get_theme_option( 'front_page_googlemap_paddings' ) );
?>"
		<?php
		$tediss_css      = '';
		$tediss_bg_image = tediss_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $tediss_bg_image ) ) {
			$tediss_css .= 'background-image: url(' . esc_url( tediss_get_attachment_url( $tediss_bg_image ) ) . ');';
		}
		if ( ! empty( $tediss_css ) ) {
			echo ' style="' . esc_attr( $tediss_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$tediss_anchor_icon = tediss_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$tediss_anchor_text = tediss_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $tediss_anchor_icon ) || ! empty( $tediss_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $tediss_anchor_icon ) ? ' icon="' . esc_attr( $tediss_anchor_icon ) . '"' : '' )
									. ( ! empty( $tediss_anchor_text ) ? ' title="' . esc_attr( $tediss_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
	<?php
	if ( tediss_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
		echo ' tediss-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$tediss_css      = '';
			$tediss_bg_mask  = tediss_get_theme_option( 'front_page_googlemap_bg_mask' );
			$tediss_bg_color_type = tediss_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $tediss_bg_color_type ) {
				$tediss_bg_color = tediss_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $tediss_bg_color_type ) {
				$tediss_bg_color = tediss_get_scheme_color( 'bg_color', $tediss_scheme );
			} else {
				$tediss_bg_color = '';
			}
			if ( ! empty( $tediss_bg_color ) && $tediss_bg_mask > 0 ) {
				$tediss_css .= 'background-color: ' . esc_attr(
					1 == $tediss_bg_mask ? $tediss_bg_color : tediss_hex2rgba( $tediss_bg_color, $tediss_bg_mask )
				) . ';';
			}
			if ( ! empty( $tediss_css ) ) {
				echo ' style="' . esc_attr( $tediss_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
			$tediss_layout = tediss_get_theme_option( 'front_page_googlemap_layout' );
		if ( 'fullwidth' != $tediss_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$tediss_caption     = tediss_get_theme_option( 'front_page_googlemap_caption' );
			$tediss_description = tediss_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $tediss_caption ) || ! empty( $tediss_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $tediss_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $tediss_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $tediss_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $tediss_caption, 'tediss_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $tediss_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $tediss_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $tediss_description ), 'tediss_kses_content' )
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $tediss_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$tediss_content = tediss_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $tediss_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $tediss_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $tediss_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $tediss_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $tediss_content, 'tediss_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $tediss_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $tediss_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
			<?php
			if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
				dynamic_sidebar( 'front_page_googlemap_widgets' );
			} elseif ( current_user_can( 'edit_theme_options' ) ) {
				if ( ! tediss_exists_trx_addons() ) {
					tediss_customizer_need_trx_addons_message();
				} else {
					tediss_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
				}
			}
			?>
			</div>
			<?php

			if ( 'columns' == $tediss_layout && ( ! empty( $tediss_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
