<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

						// Widgets area inside page content
						tediss_create_widgets_area( 'widgets_below_content' );
						?>
					</div><!-- </.content> -->

					<?php
					// Show main sidebar
					get_sidebar();

					$tediss_body_style = tediss_get_theme_option( 'body_style' );
					if ( 'fullscreen' != $tediss_body_style ) {
						?>
						</div><!-- </.content_wrap> -->
						<?php
					}

					// Widgets area below page content and related posts below page content
					$tediss_widgets_name = tediss_get_theme_option( 'widgets_below_page' );
					$tediss_show_widgets = ! tediss_is_off( $tediss_widgets_name ) && is_active_sidebar( $tediss_widgets_name );
					$tediss_show_related = is_single() && tediss_get_theme_option( 'related_position' ) == 'below_page';
					if ( $tediss_show_widgets || $tediss_show_related ) {
						if ( 'fullscreen' != $tediss_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $tediss_show_related ) {
							do_action( 'tediss_action_related_posts' );
						}

						// Widgets area below page content
						if ( $tediss_show_widgets ) {
							tediss_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $tediss_body_style ) {
							?>
							</div><!-- </.content_wrap> -->
							<?php
						}
					}
					?>
			</div><!-- </.page_content_wrap> -->

			<?php
			// Single posts banner before footer
			if ( is_singular( 'post' ) ) {
				tediss_show_post_banner('footer');
			}
			// Footer
			$tediss_footer_type = tediss_get_theme_option( 'footer_type' );
			if ( 'custom' == $tediss_footer_type && ! tediss_is_layouts_available() ) {
				$tediss_footer_type = 'default';
			}
			get_template_part( apply_filters( 'tediss_filter_get_template_part', "templates/footer-{$tediss_footer_type}" ) );
			?>

		</div><!-- /.page_wrap -->

	</div><!-- /.body_wrap -->
    <?php
    $custom_on = tediss_get_theme_option('side_button_section');
    $side_button_caption = tediss_get_theme_option('side_button_caption');
    $meta = tediss_get_theme_option('side_button_icon');

    // Custom Section
    if (tediss_is_on($custom_on) && !empty($side_button_caption)) {
        $tediss_custom_id = str_replace('custom-custom-', '', tediss_get_theme_option("side_button_layout"));
        if ((int)$tediss_custom_id == 0) {
            $tediss_custom_id = tediss_get_post_id(array(
                    'name' => $tediss_custom_id,
                    'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
                )
            );
        } else {
            $tediss_custom_id = apply_filters('tediss_filter_get_translated_layout', $tediss_custom_id);
        }
        if (!empty($tediss_custom_id) && (int)$tediss_custom_id != 0) { ?>
            <div class="custom_section">
                <div class="side_button_wrapper">
                    <div class="caption_button">
                        <span class="caption_button_item">
                            <?php
                            if (!empty($meta)) {
                                $meta = basename($meta);
                                echo '<span class="'.$meta.'"></span>';
                            }
                            ?>
                            <i class="caption_button_wrapper"><?php tediss_show_layout($side_button_caption); ?></i></span>
                    </div>
                    <div class="layouts_wrap">
                        <div class="layouts_wrap_inner">
                            <div class="layouts_container">
                                <div class="sc_layouts sc_layouts_custom sc_layouts_<?php echo esc_attr($tediss_custom_id); ?>">
                                    <?php do_action('tediss_action_show_layout', $tediss_custom_id); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    }
    ?>



	<?php wp_footer(); ?>

</body>
</html>