<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_template_args = get_query_var( 'tediss_template_args' );
if ( is_array( $tediss_template_args ) ) {
	$tediss_columns    = empty( $tediss_template_args['columns'] ) ? 2 : max( 1, $tediss_template_args['columns'] );
	$tediss_blog_style = array( $tediss_template_args['type'], $tediss_columns );
} else {
	$tediss_blog_style = explode( '_', tediss_get_theme_option( 'blog_style' ) );
	$tediss_columns    = empty( $tediss_blog_style[1] ) ? 2 : max( 1, $tediss_blog_style[1] );
}
$tediss_post_format = get_post_format();
$tediss_post_format = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );
$tediss_animation   = tediss_get_theme_option( 'blog_animation' );

?><div class="
<?php
if ( ! empty( $tediss_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo 'masonry_item masonry_item-1_' . esc_attr( $tediss_columns );
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_format_' . esc_attr( $tediss_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $tediss_columns )
		. ( is_sticky() && ! is_paged() ? ' sticky' : '' )
	);
	echo ( ! tediss_is_off( $tediss_animation ) && empty( $tediss_template_args['slider'] ) ? ' data-animation="' . esc_attr( tediss_get_animation_classes( $tediss_animation ) ) . '"' : '' );
	?>
>
<?php

// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	$tediss_image_hover = ! empty( $tediss_template_args['hover'] ) && ! tediss_is_inherit( $tediss_template_args['hover'] )
								? $tediss_template_args['hover']
								: tediss_get_theme_option( 'image_hover' );
	// Featured image
	tediss_show_post_featured(
		array(
			'singular'      => false,
			'hover'         => $tediss_image_hover,
			'no_links'      => ! empty( $tediss_template_args['no_links'] ),
			'thumb_size'    => tediss_get_thumb_size(
				strpos( tediss_get_theme_option( 'body_style' ), 'full' ) !== false || $tediss_columns < 3
								? 'masonry-big'
				: 'masonry'
			),
			'show_no_image' => true,
			'class'         => 'dots' == $tediss_image_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $tediss_image_hover ? '<div class="post_info">' . esc_html( get_the_title() ) . '</div>' : '',
		)
	);
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!