<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_template_args = get_query_var( 'tediss_template_args' );
if ( is_array( $tediss_template_args ) ) {
	$tediss_columns    = empty( $tediss_template_args['columns'] ) ? 2 : max( 1, $tediss_template_args['columns'] );
	$tediss_blog_style = array( $tediss_template_args['type'], $tediss_columns );
} else {
	$tediss_blog_style = explode( '_', tediss_get_theme_option( 'blog_style' ) );
	$tediss_columns    = empty( $tediss_blog_style[1] ) ? 2 : max( 1, $tediss_blog_style[1] );
}
$tediss_post_format = get_post_format();
$tediss_post_format = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );
$tediss_animation   = tediss_get_theme_option( 'blog_animation' );
$tediss_image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

?><div class="
<?php
if ( ! empty( $tediss_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo 'masonry_item masonry_item-1_' . esc_attr( $tediss_columns );
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_format_' . esc_attr( $tediss_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $tediss_columns )
		. ' post_layout_gallery'
		. ' post_layout_gallery_' . esc_attr( $tediss_columns )
	);
	echo ( ! tediss_is_off( $tediss_animation ) && empty( $tediss_template_args['slider'] ) ? ' data-animation="' . esc_attr( tediss_get_animation_classes( $tediss_animation ) ) . '"' : '' );
	?>
	data-size="
		<?php
		if ( ! empty( $tediss_image[1] ) && ! empty( $tediss_image[2] ) ) {
			echo intval( $tediss_image[1] ) . 'x' . intval( $tediss_image[2] );}
		?>
	"
	data-src="
		<?php
		if ( ! empty( $tediss_image[0] ) ) {
			echo esc_url( $tediss_image[0] );}
		?>
	"
>
<?php

	// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	// Featured image
	$tediss_image_hover = 'icon';  
if ( in_array( $tediss_image_hover, array( 'icons', 'zoom' ) ) ) {
	$tediss_image_hover = 'dots';
}
$tediss_components = tediss_array_get_keys_by_value( tediss_get_theme_option( 'meta_parts' ) );
$tediss_counters   = tediss_array_get_keys_by_value( tediss_get_theme_option( 'counters' ) );
tediss_show_post_featured(
	array(
		'hover'         => $tediss_image_hover,
		'singular'      => false,
		'no_links'      => ! empty( $tediss_template_args['no_links'] ),
		'thumb_size'    => tediss_get_thumb_size( strpos( tediss_get_theme_option( 'body_style' ), 'full' ) !== false || $tediss_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only'    => true,
		'show_no_image' => true,
		'post_info'     => '<div class="post_details">'
						. '<h2 class="post_title">'
							. ( empty( $tediss_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a>'
								: esc_html( get_the_title() )
								)
						. '</h2>'
						. '<div class="post_description">'
							. ( ! empty( $tediss_components )
								? tediss_show_post_meta(
									apply_filters(
										'tediss_filter_post_meta_args', array(
											'components' => $tediss_components,
											'counters' => $tediss_counters,
											'seo'      => false,
											'echo'     => false,
										), $tediss_blog_style[0], $tediss_columns
									)
								)
								: ''
								)
							. ( empty( $tediss_template_args['hide_excerpt'] )
								? '<div class="post_description_content">' . get_the_excerpt() . '</div>'
								: ''
								)
							. ( empty( $tediss_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__( 'Learn more', 'tediss' ) . '</span></a>'
								: ''
								)
						. '</div>'
					. '</div>',
	)
);
?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
