<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_template_args = get_query_var( 'tediss_template_args' );
if ( is_array( $tediss_template_args ) ) {
	$tediss_columns    = empty( $tediss_template_args['columns'] ) ? 2 : max( 1, $tediss_template_args['columns'] );
	$tediss_blog_style = array( $tediss_template_args['type'], $tediss_columns );
	if ( ! empty( $tediss_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $tediss_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $tediss_columns ); ?>">
		<?php
	}
}
$tediss_expanded    = ! tediss_sidebar_present() && tediss_is_on( tediss_get_theme_option( 'expand_content' ) );
$tediss_post_format = get_post_format();
$tediss_post_format = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );
$tediss_animation   = tediss_get_theme_option( 'blog_animation' );
$tediss_components = tediss_array_get_keys_by_value( tediss_get_theme_option( 'meta_parts' ) );
$tediss_counters   = tediss_array_get_keys_by_value( tediss_get_theme_option( 'counters' ) );
?>
<article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_layout_excerpt post_format_' . esc_attr( $tediss_post_format )); ?>
	<?php echo ( ! tediss_is_off( $tediss_animation ) && empty( $tediss_template_args['slider'] ) ? ' data-animation="' . esc_attr( tediss_get_animation_classes( $tediss_animation ) ) . '"' : '' ); ?>
	>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$tediss_hover = ! empty( $tediss_template_args['hover'] ) && ! tediss_is_inherit( $tediss_template_args['hover'] )
						? $tediss_template_args['hover']
						: tediss_get_theme_option( 'image_hover' );
	tediss_show_post_featured(
		array(
			'singular'   => false,
			'no_links'   => ! empty( $tediss_template_args['no_links'] ),
			'hover'      => $tediss_hover,
			'post_info' => '<div class="extra_date"><span class="post_date">'.get_the_date('d').'<span>'.get_the_date('M').'</span></span></div>',
			'thumb_size' => tediss_get_thumb_size( strpos( tediss_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $tediss_expanded ? 'huge' : 'excerpt' ) ),
		)
	);

	// Title and post meta
	if ( get_the_title() != '' ) {
		?>
		<div class="post_header entry-header">
			<?php
			do_action( 'tediss_action_before_post_title' );

			// Post title
			if ( empty( $tediss_template_args['no_links'] ) ) {
				the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			} else {
				the_title( '<h2 class="post_title entry-title">', '</h2>' );
			}

			do_action( 'tediss_action_before_post_meta' );

			// Post meta


			if ( ! empty( $tediss_components ) && ! in_array( $tediss_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
				tediss_show_post_meta(
					apply_filters(
						'tediss_filter_post_meta_args', array(
							'components' => $tediss_components,
							'counters'   => $tediss_counters,
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( empty( $tediss_template_args['hide_excerpt'] ) ) {

		?>
		<div class="post_content entry-content">
		<?php
		if ( tediss_get_theme_option( 'blog_content' ) == 'fullpost' ) {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				the_content( '' );
				?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'tediss' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'tediss' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
		} else {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
						the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
						the_content( '' );
				} elseif ( in_array( $tediss_post_format, array( 'link', 'aside', 'status' ) ) ) {
						the_content();
				} elseif ( 'quote' == $tediss_post_format ) {
					$quote = tediss_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						tediss_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}

				if (in_array( $tediss_post_format, array( 'quote' ) ) && ! empty( $tediss_components ) ) {
				tediss_show_post_meta(
					apply_filters(
						'tediss_filter_post_meta_args', array(
							'components' => $tediss_components,
							'counters'   => $tediss_counters,
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}

				?>
				</div>
				<?php
				// More button
				if ( empty( $tediss_template_args['no_links'] ) && ! in_array( $tediss_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
					?>
					<p><a class="more-link sc_button sc_button_size_small color_style_dark" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more', 'tediss' ); ?></a></p>
					<?php
				}
		}
		?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
	</article>
<?php

if ( is_array( $tediss_template_args ) ) {
	if ( ! empty( $tediss_template_args['slider'] ) || $tediss_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
