<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.50
 */

$tediss_template_args = get_query_var( 'tediss_template_args' );
if ( is_array( $tediss_template_args ) ) {
	$tediss_columns    = empty( $tediss_template_args['columns'] ) ? 2 : max( 1, $tediss_template_args['columns'] );
	$tediss_blog_style = array( $tediss_template_args['type'], $tediss_columns );
} else {
	$tediss_blog_style = explode( '_', tediss_get_theme_option( 'blog_style' ) );
	$tediss_columns    = empty( $tediss_blog_style[1] ) ? 2 : max( 1, $tediss_blog_style[1] );
}
$tediss_blog_id       = tediss_get_custom_blog_id( join( '_', $tediss_blog_style ) );
$tediss_blog_style[0] = str_replace( 'blog-custom-', '', $tediss_blog_style[0] );
$tediss_expanded      = ! tediss_sidebar_present() && tediss_is_on( tediss_get_theme_option( 'expand_content' ) );
$tediss_animation     = tediss_get_theme_option( 'blog_animation' );
$tediss_components    = tediss_array_get_keys_by_value( tediss_get_theme_option( 'meta_parts' ) );
$tediss_counters      = tediss_array_get_keys_by_value( tediss_get_theme_option( 'counters' ) );

$tediss_post_format   = get_post_format();
$tediss_post_format   = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );

$tediss_blog_meta     = tediss_get_custom_layout_meta( $tediss_blog_id );
$tediss_custom_style  = ! empty( $tediss_blog_meta['scripts_required'] ) ? $tediss_blog_meta['scripts_required'] : 'none';

if ( ! empty( $tediss_template_args['slider'] ) || $tediss_columns > 1 || ! tediss_is_off( $tediss_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $tediss_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo ( tediss_is_off( $tediss_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $tediss_custom_style ) ) . '-1_' . esc_attr( $tediss_columns );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" 
<?php
	post_class(
			'post_item post_format_' . esc_attr( $tediss_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $tediss_columns )
					. ' post_layout_' . esc_attr( $tediss_blog_style[0] )
					. ' post_layout_' . esc_attr( $tediss_blog_style[0] ) . '_' . esc_attr( $tediss_columns )
					. ( ! tediss_is_off( $tediss_custom_style )
						? ' post_layout_' . esc_attr( $tediss_custom_style )
							. ' post_layout_' . esc_attr( $tediss_custom_style ) . '_' . esc_attr( $tediss_columns )
						: ''
						)
		);
	echo ( ! tediss_is_off( $tediss_animation ) && empty( $tediss_template_args['slider'] ) ? ' data-animation="' . esc_attr( tediss_get_animation_classes( $tediss_animation ) ) . '"' : '' );
?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom header's layout
	do_action( 'tediss_action_show_layout', $tediss_blog_id );
	?>
</article><?php
if ( ! empty( $tediss_template_args['slider'] ) || $tediss_columns > 1 || ! tediss_is_off( $tediss_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
