<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_template_args = get_query_var( 'tediss_template_args' );
if ( is_array( $tediss_template_args ) ) {
	$tediss_columns    = empty( $tediss_template_args['columns'] ) ? 1 : max( 1, min( 3, $tediss_template_args['columns'] ) );
	$tediss_blog_style = array( $tediss_template_args['type'], $tediss_columns );
} else {
	$tediss_blog_style = explode( '_', tediss_get_theme_option( 'blog_style' ) );
	$tediss_columns    = empty( $tediss_blog_style[1] ) ? 1 : max( 1, min( 3, $tediss_blog_style[1] ) );
}
$tediss_expanded    = ! tediss_sidebar_present() && tediss_is_on( tediss_get_theme_option( 'expand_content' ) );
$tediss_post_format = get_post_format();
$tediss_post_format = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );
$tediss_animation   = tediss_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_chess'
										. ' post_layout_chess_' . esc_attr( $tediss_columns )
										. ' post_format_' . esc_attr( $tediss_post_format )
										. ( ! empty( $tediss_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! tediss_is_off( $tediss_animation ) && empty( $tediss_template_args['slider'] ) ? ' data-animation="' . esc_attr( tediss_get_animation_classes( $tediss_animation ) ) . '"' : '' );
									?>
	>

	<?php
	// Add anchor
	if ( 1 == $tediss_columns && ! is_array( $tediss_template_args ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode( '[trx_sc_anchor id="post_' . esc_attr( get_the_ID() ) . '" title="' . esc_attr( get_the_title() ) . '" icon="' . esc_attr( tediss_get_post_icon() ) . '"]' );
	}

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$tediss_hover = ! empty( $tediss_template_args['hover'] ) && ! tediss_is_inherit( $tediss_template_args['hover'] )
						? $tediss_template_args['hover']
						: tediss_get_theme_option( 'image_hover' );
	tediss_show_post_featured(
		array(
			'class'         => 1 == $tediss_columns && ! is_array( $tediss_template_args ) ? 'tediss-full-height' : '',
			'singular'      => false,
			'hover'         => $tediss_hover,
			'no_links'      => ! empty( $tediss_template_args['no_links'] ),
			'show_no_image' => true,
			'thumb_ratio'   => '1:1',
			'thumb_bg'      => true,
			'thumb_size'    => tediss_get_thumb_size(
				strpos( tediss_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( 1 < $tediss_columns ? 'huge' : 'original' )
										: ( 2 < $tediss_columns ? 'big' : 'huge' )
			),
		)
	);

	?>
	<div class="post_inner"><div class="post_inner_content"><div class="post_header entry-header">
		<?php
			do_action( 'tediss_action_before_post_title' );

			// Post title
		if ( empty( $tediss_template_args['no_links'] ) ) {
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
		} else {
			the_title( '<h3 class="post_title entry-title">', '</h3>' );
		}

			do_action( 'tediss_action_before_post_meta' );

			// Post meta
			$tediss_components = tediss_array_get_keys_by_value( tediss_get_theme_option( 'meta_parts' ) );
			$tediss_counters   = tediss_array_get_keys_by_value( tediss_get_theme_option( 'counters' ) );
			$tediss_post_meta  = empty( $tediss_components ) || in_array( $tediss_hover, array( 'border', 'pull', 'slide', 'fade' ) )
										? ''
										: tediss_show_post_meta(
											apply_filters(
												'tediss_filter_post_meta_args', array(
													'components' => $tediss_components,
													'counters' => $tediss_counters,
													'seo'  => false,
													'echo' => false,
												), $tediss_blog_style[0], $tediss_columns
											)
										);
			tediss_show_layout( $tediss_post_meta );
			?>
		</div><!-- .entry-header -->

		<div class="post_content entry-content">
		<?php
		if ( empty( $tediss_template_args['hide_excerpt'] ) ) {
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
					the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
					the_content( '' );
				} elseif ( in_array( $tediss_post_format, array( 'link', 'aside', 'status' ) ) ) {
					the_content();
				} elseif ( 'quote' == $tediss_post_format ) {
					$quote = tediss_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						tediss_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
		}
			// Post meta
		if ( in_array( $tediss_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			tediss_show_layout( $tediss_post_meta );
		}
			// More button
		if ( empty( $tediss_template_args['no_links'] ) && ! in_array( $tediss_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			?>
				<p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more', 'tediss' ); ?></a></p>
				<?php
		}
		?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
