<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="assets/images/logo.png" />
    <title>Project Add</title>
    <?php
    include 'includes/css.php';
    ?>
</head>

<body class="sidebar-nonactive">

    <?php
include 'includes/header.php';
?>
    <main>
        <?php
include 'includes/sidebar.php';
?>
        <section class="sec-main">
            <div class="container-fluid">
                <div class="inner-area">
                    <div class="project-add-area">
                        <div class="container-ct">
                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-10 col-xl-9 col-xxl-7">
                                    <div class="card multi-card project-card">
                                        <div class="top-area">
                                            <a href="project-management.php" class="back-btn">
                                                <i class="fa-solid fa-arrow-left"></i>
                                            </a>
                                            <h4>Add a property</h4>
                                        </div>
                                        <div class="form-main">
                                            <form action="">
                                                <div class="row">
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Property Name</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter property name">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Unit Number</label>
                                                            <input type="text" class="form-control ct-fm unit-icon"
                                                                placeholder="Import Unit Number">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Street</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter street number">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">City</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select City</option>
                                                                <option value="1">One</option>
                                                                <option value="2">Two</option>
                                                                <option value="3">Three</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Zip Code</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter Zip Code">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Category</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select category</option>
                                                                <option value="1">One</option>
                                                                <option value="2">Two</option>
                                                                <option value="3">Three</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Start Date</label>
                                                            <input type="text" class="form-control ct-fm calendar-icon"
                                                                placeholder="Select date" onfocus="(this.type='date')"
                                                                onblur="(this.type='text')">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Completion Date</label>
                                                            <input type="text" class="form-control ct-fm calendar-icon"
                                                                placeholder="Select date" onfocus="(this.type='date')"
                                                                onblur="(this.type='text')">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Team Members</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Select team members">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Team Lead</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select team lead</option>
                                                                <option value="1">One</option>
                                                                <option value="2">Two</option>
                                                                <option value="3">Three</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Attach Documents</label>
                                                            <div class="file-upload-area">
                                                                <img src="assets/images/file.png"
                                                                    class="img-fluid upload-icon" alt="">
                                                                <span>Choose or Drag & Drop the Property
                                                                    Documents</span>
                                                                <button type="button" class="btn file-btn">
                                                                    Choose File
                                                                    <input type="file" class="file-upload"
                                                                        value="browse file" multiple>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <button type="submit" class="btn submit-btn">Add
                                                            Property</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php
include 'includes/footer.php';
include 'includes/scripts.php';
?>
</body>

</html>