var options = {
    series: [{
        name: 'Installations',
        data: [500, 800, 500, 1000, 700, 600, 800, 300, 1000, 600, 1000, 400, 300, 800, 200, 700, 500]
    }],
    chart: {
        height: '100%',
        type: 'bar',
        toolbar: {
            show: false
        },
        animations: {
            enabled: true,
            easing: 'easeinout',
            speed: 2000,
        }
    },
    plotOptions: {
        bar: {
            columnWidth: '40px',
            distributed: true,
            borderRadius: 3,
            colors: {
                backgroundBarColors: ['#EEF9FD'], // Light background color behind bars
                backgroundBarOpacity: 1,
            }
        }
    },
    dataLabels: {
        enabled: false
    },

    legend: {
        show: false
    },

    xaxis: {
        categories: ["Toilet", "Supply Line", "Angle Stop", "Flange", "Bath Aer", "Kit Aer", "Shower Head", "System", "Flush Valve", "Faucet Leak", "Tube Leak", "Breezeway LED", "Hallway LED", "Porchlight LED", "Pole Light Led", "Parking Garage LED", "Wall Packs LED"],
        labels: {
            rotate: 0,
            trim: true,
            style: {
                fontSize: '9.9px',
                color: '#2E2E30',
                fontFamily: '"Inter", sans-serif',
                fontWeight: '400',
            }
        },
        position: 'bottom',
        axisBorder: {
            show: false
        },
        axisTicks: {
            show: false
        },
        crosshairs: {
            show: true,
            fill: {
                type: 'gradient',
                gradient: {
                    colorFrom: '#EEF9FD',
                    colorTo: '#EEF9FD',
                    stops: [0, 100],
                    opacityFrom: 1,
                    opacityTo: 1,
                }
            }
        },
        tooltip: {
            enabled: true,
        }
    },
    yaxis: {
        show: false,
        max: 1000,
        axisBorder: {
            show: false
        },
        axisTicks: {
            show: false,
        },
        labels: {
            show: true,
            formatter: function (val) {
                return val.toFixed(0);
            }
        }

    },
    grid: {
        show: false,
    },
    colors: ['#3B90AA']
};

var chart = new ApexCharts(document.querySelector("#bar-chart"), options);
chart.render();