document.addEventListener('DOMContentLoaded', () => {
  // 1. Element References
  const daySelect = document.getElementById('day');
  const monthSelect = document.getElementById('month');
  const yearSelect = document.getElementById('year');
  const agreeButton = document.querySelector('.btn-agree');
  const modalElement = document.getElementById('staticBackdrop'); 
  const requiredAge = 18;
  // --- 2. Populate Dropdowns ---
  // Populate Days (1-31)
  for (let i = 1; i <= 31; i++) {
    const option = new Option(i, i);
    daySelect.add(option);
  }
  // Populate Months (1-12)
  // Note: In JavaScript Date objects, month is 0-indexed (0=Jan, 11=Dec)
  for (let i = 1; i <= 12; i++) {
    const option = new Option(i, i);
    monthSelect.add(option);
  }
  // Populate Years (Current year down to 1900, as requested previously)
  const currentYear = new Date().getFullYear();
  const minYear = 1900;
  for (let i = currentYear; i >= minYear; i--) {
    const option = new Option(i, i);
    yearSelect.add(option);
  }
  // Set default selected values to avoid empty selection
  daySelect.value = 1;
  monthSelect.value = 1;
  yearSelect.value = currentYear; // Common default year

  // --- 3. Auto-Open Modal on Page Load ---
  // Check if the modal element exists and if Bootstrap JS is loaded
  if (modalElement && typeof bootstrap !== 'undefined') {
    const ageVerifyModal = new bootstrap.Modal(modalElement);
    ageVerifyModal.show();
  }

  // --- 4. Age Verification Function ---
  function isOverAgeLimit(day, month, year) {
    // Create the birth date object (Subtract 1 from month for JS 0-indexing)
    const dob = new Date(year, month - 1, day);
    // Get the required cutoff date (18 years ago from today)
    const cutoffDate = new Date();
    cutoffDate.setFullYear(cutoffDate.getFullYear() - requiredAge);
    return dob <= cutoffDate;
  }

  // --- 5. Event Listeners for Buttons ---
  // Listen for the form submission (Agree button)
    agreeButton.closest('form').addEventListener('submit', function(e) {
        // 🛑 CRUCIAL: Stop the page from reloading/submitting the form normally
        e.preventDefault(); 
        const selectedDay = parseInt(daySelect.value, 10);
        const selectedMonth = parseInt(monthSelect.value, 10);
        const selectedYear = parseInt(yearSelect.value, 10);

        // Check for valid date selection
        if (!selectedDay || !selectedMonth || !selectedYear || selectedYear > currentYear) {
            alert("Please select a complete and valid date of birth.");
            return;
        }

        if (isOverAgeLimit(selectedDay, selectedMonth, selectedYear)) {
            // ✅ SUCCESS: Hide the modal and allow website access
            
            // Get the Bootstrap instance of the modal
            const ageVerifyModal = bootstrap.Modal.getInstance(modalElement);
            if (ageVerifyModal) {
                ageVerifyModal.hide(); // Manually hide the modal
            } else {
                 // Fallback if modal instance wasn't found (less common)
                 modalElement.classList.remove('show'); 
                 modalElement.style.display = 'none';
            }
            // OPTIONAL: Set a cookie here to prevent the pop-up on next load
            console.log("Age verified. Entering website.");
            // User can now interact with the main website content

        } else {
            alert(`Sorry, you must be ${requiredAge} years or older to enter this site.`);
        }
    });
});

$(window).ready(function () {
  setTimeout(function () {
    $("#staticBackdrop").modal("show");
  }, 1000);
});

// counter js start
$.fn.jQuerySimpleCounter = function (options) {
  var settings = $.extend({
    start: 0,
    end: 100,
    easing: 'swing',
    duration: 400,
    complete: ''
  }, options);
  var thisElement = $(this);
  $({ count: settings.start }).animate({ count: settings.end }, {
    duration: settings.duration,
    easing: settings.easing,
    step: function () {
      var mathCount = Math.ceil(this.count);
      thisElement.text(mathCount);
    },
    complete: settings.complete
  });
};
$('#number1').jQuerySimpleCounter({ end: parseInt($('#number1').text()), duration: 3000 });
$('#number2').jQuerySimpleCounter({ end: parseInt($('#number2').text()), duration: 3000 });
$('#number3').jQuerySimpleCounter({ end: parseInt($('#number3').text()), duration: 2000 });
$('#number4').jQuerySimpleCounter({ end: parseInt($('#number4').text()), duration: 2000 });
// counter js end
// quantity js start
$(document).on('click', '.quantity-left-minus', function () {
  var sub_qty = parseInt($(this).closest('.numberone').find('input').val());
  if (sub_qty > 1) {
    $(this).closest('.numberone').find('input').val(sub_qty - 1);
    $(this).closest('.numberone').find('input').trigger('change');
  }
});
$(document).on('click', '.quantity-right-plus', function () {
  var add_qty = parseInt($(this).closest('.numberone').find('input').val());
  var max_qty = $(this).closest('.numberone').find('input').attr("max");
  if (add_qty < max_qty) {
    $(this).closest('.numberone').find('input').val(add_qty + 1);
    $(this).closest('.numberone').find('input').trigger('change');
  }
});
// quantity js start

// slider
$('.medical-slider').owlCarousel({
  loop: true,
  margin: 20,
  animateOut: 'fadeOut',
  animateIn: 'fadeIn',
  nav: true,
  dots: false,
  autoplay: false,
  autoplaySpeed: 5000,
  autoplayTimeout: 5000,
  autoplayHoverPause: true,
  mouseDrag: true,
  smartSpeed: 250,
  navText: [
    '<i class="far fa-chevron-left" aria-hidden="true"></i>',
    '<i class="far fa-chevron-right" aria-hidden="true"></i>'
  ],
  responsiveClass: true,
  responsive: {
    0: {
      items: 1
    },
    575: {
      items: 2
    },
    767: {
      items: 3
    },
    991: {
      items: 3
    },
    1199: {
      items: 4
    },
    1399: {
      items: 4
    }
  }
});
// slider

//Scroll event
$(window).scroll(function () {
  var scrolled = $(window).scrollTop();
  if (scrolled > 200) $('.go-top').fadeIn('slow');
  if (scrolled < 200) $('.go-top').fadeOut('slow');
});
//Scroll event
// toggle password
$(".toggle-password").click(function () {
  $(this).toggleClass("fa-eye fa-eye-slash");
  var input = $($(this).attr("toggle"));
  if (input.attr("type") == "password") {
    input.attr("type", "text");
  } else {
    input.attr("type", "password");
  }
});
// toggle password
//Click event
$('.go-top').click(function () {
  $("html, body").animate({ scrollTop: "0" }, 500);
});
//Click event

// product-detail multi img slider
$(document).ready(function () {
  var slider = $("#slider");
  var thumb = $("#thumb");
  var slidesPerPage = 2;
  var syncedSecondary = true;
  slider.owlCarousel({
    items: 1,
    slideSpeed: 5000,
    nav: false,
    autoplay: true,        // ✅ autoplay ON
    autoplaySpeed: 5000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    dots: false,
    loop: true,
    mouseDrag: false,      // ❌ mouse drag disable
    touchDrag: false,      // ❌ touch move disable
    pullDrag: false,       // ❌ no drag
    responsiveRefreshRate: 200
  }).on('changed.owl.carousel', syncPosition);
  thumb
    .on('initialized.owl.carousel', function () {
      thumb.find(".owl-item").eq(0).addClass("current");
    })
    .owlCarousel({
      items: slidesPerPage,
      margin: 10,
      dots: false,
      nav: false,
      autoplay: false,
      smartSpeed: 250,
      slideSpeed: 5000,
      slideBy: slidesPerPage,
      responsiveRefreshRate: 100
    }).on('changed.owl.carousel', syncPosition2);
  function syncPosition(el) {
    var count = el.item.count - 1;
    var current = Math.round(el.item.index - (el.item.count / 2) - .5);
    if (current < 0) current = count;
    if (current > count) current = 0;
    thumb.find(".owl-item").removeClass("current").eq(current).addClass("current");
    var onscreen = thumb.find('.owl-item.active').length - 1;
    var start = thumb.find('.owl-item.active').first().index();
    var end = thumb.find('.owl-item.active').last().index();
    if (current > end) {
      thumb.data('owl.carousel').to(current, 100, true);
    }
    if (current < start) {
      thumb.data('owl.carousel').to(current - onscreen, 100, true);
    }
  }

  function syncPosition2(el) {
    if (syncedSecondary) {
      var number = el.item.index;
      slider.data('owl.carousel').to(number, 100, true);
    }
  }
  thumb.on("click", ".owl-item", function (e) {
    e.preventDefault();
    var number = $(this).index();
    slider.data('owl.carousel').to(number, 300, true);
  });
});
// img zoom
$(".img_producto_container")
  .on("mouseover", function () {
    $(this).children(".img_producto").css({
      transform: "scale(" + $(this).attr("data-scale") + ")"
    });
  })
  .on("mouseout", function () {
    $(this).children(".img_producto").css({ transform: "scale(1)" });
  })
  .on("mousemove", function (e) {
    $(this).children(".img_producto").css({
      "transform-origin":
        ((e.pageX - $(this).offset().left) / $(this).width()) * 100 +
        "% " +
        ((e.pageY - $(this).offset().top) / $(this).height()) * 100 +
        "%"
    });
  });
// product-detail multi img slider

// counter js start
let minusBtn = document.getElementById("minus-btn");
let count = document.getElementById("count");
let plusBtn = document.getElementById("plus-btn");
let countNum = 0;
count.innerHTML = countNum;
minusBtn.addEventListener("click", () => {
  countNum -= 1;
  count.innerHTML = countNum;
});
plusBtn.addEventListener("click", () => {
  countNum += 1;
  count.innerHTML = countNum;
});
// counter js end