#{{uc_id}} {
	box-sizing: border-box;
	cursor: pointer;
	margin: 0;
	overflow: hidden;
	padding: 0;
	position: relative;
	user-select: none;
}

#{{uc_id}} img{
	isolation: unset;
}  

#{{uc_id}} * {
	box-sizing: inherit;
}

#{{uc_id}} ::after,
#{{uc_id}} ::before {
	box-sizing: inherit;
}

#{{uc_id}} img,
#{{uc_id}} picture>img {
	max-width: none;
}

#{{uc_id}}>img,
#{{uc_id}}>picture>img {
	display: block;
	width: 100%;
}

#{{uc_id}}>div:first-child,
picture #{{uc_id}}>div {
	
	left: 0;
	overflow: hidden;
	position: absolute;
	top: 0;
    {% if direction == "horizontal" %}
  	width: {{initial_position}}%;
    height: 100%;
  	{% endif %}	
  	{% if direction == "vertical" %}
    width: 100%;
  	height: {{initial_position}}%;
	{% endif %}	
}

#{{uc_id}} .cocoen-drag {
	position: absolute;
}

#{{uc_id}} .cocoen-drag::before {
	content: '';
  	position: absolute;
  	{% if display == "handle" %}
      left: 50%;
      top: 50%;
	  transform:translate(-50%,-50%);  
    {% endif %}  
}

/* general arrows settings */
{% if display == "arrows" %}
	#{{uc_id}} .cocoen-drag::before,
    #{{uc_id}} .cocoen-drag::after{
		border-style: solid;
    }
    #{{uc_id}} .cocoen-drag::after {
      content: '';
      position: absolute;
    }
  {% endif %}
/* end general arrows settings */

/* horizontal direction */
{% if direction == "horizontal" %}
  #{{uc_id}} .cocoen-drag {
      cursor: ew-resize;
      bottom: 0;
      left: {{initial_position}}%;
      transform:translateX(-50%);
      top: 0;
  }

  {% if display == "arrows" %}
    #{{uc_id}} .cocoen-drag::before,
    #{{uc_id}} .cocoen-drag::after {
        top: 50%;      
    }
	#{{uc_id}} .cocoen-drag::before {
		transform:translate(-100%, -50%);
      	border-bottom-color: transparent;
      	border-left-color: transparent;
      	border-top-color: transparent;
    }
    #{{uc_id}} .cocoen-drag::after {
		transform:translate(0%, -50%);
      	border-right-color: transparent;
      	border-top-color: transparent;
      	border-bottom-color: transparent;
    }
  {% endif %}
{% endif %}	
/* end horizontal direction */

/* vertical direction */
{% if direction == "vertical" %}
  #{{uc_id}} .cocoen-drag {
      cursor: ns-resize;
      left: 0;
      top: {{initial_position}}%;
      transform:translateY(-50%);
      right: 0;
      width: 100%;
  }

  {% if display == "arrows" %}
    #{{uc_id}} .cocoen-drag::before,
    #{{uc_id}} .cocoen-drag::after {
        left: 50%;      
    }
	#{{uc_id}} .cocoen-drag::before {
		transform:translate(-50%, -100%);
      	border-left-color: transparent;
      	border-right-color: transparent;
      	border-top-color: transparent;
    }
    #{{uc_id}} .cocoen-drag::after {
		transform:translate(-50%, 0%);
      	border-left-color: transparent;
      	border-right-color: transparent;
      	border-bottom-color: transparent;
    }	
  {% endif %}
{% endif %}
/* end vertical direction */

{% if show_labels == "true" %}
  #{{uc_id}} .cocoen-label-wrapper{
    position: absolute;
  }

  #{{uc_id}} .cocoen-label{
	transition: all .3s;
  }

  {% if direction == "vertical" %}

    #{{uc_id}} .cocoen-label-wrapper{      
      {% if labels_horizontal_position == "left" %}
            left: 0;
      {% elseif labels_horizontal_position == "center" %}  
            left: 50%;
            transform: translate(-50%, 0);
      {% elseif labels_horizontal_position == "right" %}  
            right: 0;
      {% endif  %}
    }

    #{{uc_id}} .cocoen-label-before-wrapper{
		top: 0;
    }

	#{{uc_id}} .cocoen-label-after-wrapper{
		bottom: 0;
    }
  {% endif  %}

  {% if direction == "horizontal" %}

    #{{uc_id}} .cocoen-label-wrapper{      
      {% if labels_vertical_position == "top" %}
            top: 0;
      {% elseif labels_vertical_position == "center" %}  
            top: 50%;
            transform: translate(0, -50%);
      {% elseif labels_vertical_position == "bottom" %}  
            bottom: 0;
      {% endif  %}
    }

    #{{uc_id}} .cocoen-label-before-wrapper{
		left: 0;
    }

	#{{uc_id}} .cocoen-label-after-wrapper{
		right: 0;
    }
  {% endif  %}
{% endif %}