var $wrap = $('.ANimate'),
    lFollowX = 0,
    lFollowY = 0,
    x = 0,
    y = 0,
    friction = 1 / 12;

function animate() {
  x += (lFollowX - x) * friction;
  y += (lFollowY - y) * friction;

  $wrap.css({
    'transform': 'translate(-50%, -50%) perspective(600px) rotateY(' + -x + 'deg) rotateX(' + y + 'deg)'
  });
  window.requestAnimationFrame(animate);
}

$(window).on('mousemove click', function(e) {
  var lMouseX = Math.max(-100, Math.min(100, $(window).width() / 2 - e.clientX));
  var lMouseY = Math.max(-100, Math.min(100, $(window).height() / 2 - e.clientY));
  lFollowX = (12 * lMouseX) / 100; // 100 : 12 = lMouxeX : lFollow
  lFollowY = (10 * lMouseY) / 100;
});

animate();



$('.team-wrapper').owlCarousel({
  loop:true,
  margin:40,
  center:true,
  nav:false,
  autoplay:false,
  dots:true,
  responsive:{
      0:{
          items:1
      },
      600:{
          items:2
      },
      1000:{
          items:2
      }
  }
})




function customCursor() {
  const cursorInner = document.querySelector(".cursor-inner");
  const cursorOuter = document.querySelector(".cursor-outer");
  let mouseX = 0;
  let mouseY = 0;
  let isHovering = false;

  window.addEventListener("mousemove", function (event) {
      if (!isHovering) {
          gsap.to(cursorOuter, {
              x: event.clientX,
              y: event.clientY,
          });
      }
      gsap.to(cursorInner, {
          x: event.clientX,
          y: event.clientY,
      });
      mouseY = event.clientY;
      mouseX = event.clientX;
  });

  const elementsToTrack = document.querySelectorAll("a, img, .cursor-pointer");
  elementsToTrack.forEach((element) => {
      element.addEventListener("mouseenter", function () {
          cursorInner.classList.add("cursor-hover");
          cursorOuter.classList.add("cursor-hover");
          isHovering = true;
      });

      element.addEventListener("mouseleave", function () {
          if (!(
              element.tagName === "A" ||
              element.tagName === "IMG" ||
              element.closest(".cursor-pointer")
          )) {
              cursorInner.classList.remove("cursor-hover");
              cursorOuter.classList.remove("cursor-hover");
          }
          isHovering = false;
      });
  });

  gsap.set(cursorInner, { visibility: "visible" });
  gsap.set(cursorOuter, { visibility: "visible" });
}

document.addEventListener("DOMContentLoaded", function () {
  customCursor();

  AOS.init({
      duration: 1200,
  });

  const lenis = new Lenis()

  function raf(time) {
      lenis.raf(time)
      requestAnimationFrame(raf)
  }

  requestAnimationFrame(raf)

  const elmOverlay = document.querySelector('.shape-overlays');
  const preloader = new preLoader(elmOverlay, {
      numPoints:2
  });

  if (document.querySelector(".preloader")) {
      setTimeout(function () {
          document.querySelector(".preloader").remove()
          preloader.close();
          preLoader1(tl);
      }, 500)
  }
});



// Wrap every letter in a span
var textWrapper = document.querySelector('.ml2');
textWrapper.innerHTML = textWrapper.textContent.replace(/\S/g, "<span class='letter'>$&</span>");

anime.timeline({loop: true})
  .add({
    targets: '.ml2 .letter',
    scale: [4,1],
    opacity: [0,1],
    translateZ: 0,
    easing: "easeOutExpo",
    duration: 950,
    delay: (el, i) => 70*i
  }).add({
    targets: '.ml2',
    opacity: 0,
    duration: 1000,
    easing: "easeOutExpo",
    delay: 1000
  });


 const faqItems = document.querySelectorAll('.faq-item');

faqItems.forEach(item => {
  const question = item.querySelector('.faq-question');
  const answer = item.nextElementSibling;
  const icon = item.querySelector('i');

  item.addEventListener('click', () => {
    faqItems.forEach(otherItem => {
      if (otherItem !== item) {
        const otherAnswer = otherItem.nextElementSibling;
        const otherIcon = otherItem.querySelector('i');

        otherAnswer.classList.remove('active');
        otherIcon.classList.remove('active');
        otherAnswer.style.maxHeight = "0";
      }
    });

    answer.classList.toggle('active');
    icon.classList.toggle('active');
    if (answer.classList.contains('active')) {
      answer.style.maxHeight = answer.scrollHeight + "px";
    } else {
      answer.style.maxHeight = "0";
    }
  });
});