<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Experience professional custom web designs crafted by expert web designers. Our services ensure your website stands out with tailored, innovative solutions.">
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-B75DBEHNRM"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-B75DBEHNRM');
</script>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css" integrity="sha512-UTNP5BXLIptsaj5WdKFrkFov94lDx+eBvbKyoe1YAfjeRPC+gT5kyZ10kOHCfNZqEui1sxmqvodNUx3KbuYI/A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Righteous&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <link rel="stylesheet" href="css/flipcard.css">
    <link rel="stylesheet" href="css/owl-carousel.css">
    <link rel="stylesheet" href="css/custom.css">
    <link rel="stylesheet" href="css/responsive.css">
    <title>Professional Custom Web Designs | Professional Web Designers </title>
  </head>
  <body>

  <div class="mouse-cursor cursor-outer"></div>
  <div class="mouse-cursor cursor-inner"></div>

    <!-- Header html Start -->
     <header class="Mainheader">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="Customnavbar"  data-aos="fade-right">
                        <nav class="navbar navbar-expand-lg navbar-dark p-0">
                            <a class="navbar-brand" href="#"><img src="images/logo.png" class="Logotop" alt=""></a>
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon"></span>
                            </button>
                            <div class="collapse navbar-collapse" id="navbarNav">
                                <ul class="navbar-nav">
                                <li class="nav-item active">
                                    <a class="nav-link first-btn" href="tel:+1 (949) 994-9191">
                                        <span><i class="fa-solid fa-phone"></i> +1 (949) 994-9191</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link chat-btn" href="javascripts:;"  onclick="setButtonURL();" target="_self" title="Live Chat" >Chat Now</a>
                                </li>
                               
                                </ul>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
     </header>
     <!-- Header html End -->


     <!-- Section-01 Html Start -->
        <section class="Section-01">
          
            <div class="container">
                <div class="row">
                    <div class="col-md-7">
                        <div class="BannerContent" data-aos="fade-down-right">
                                <div class="animation">
                                     <img src="images/price.png" alt="">
                                </div>
                            <h1 class="title">
                                Web Designs
                                <span class="outer" aria-hidden="true">
                                    <span class="inner">Web Designs</span> 
                                </span>  
                                </h1>
                                <h3>Starting From</h3>
                                <h2>Grab <span>50%</span> Off!</h2>
                                <p>
                                    We get it, everyone loves a good deal. That’s why we’re offering top-notch
                                    web design services starting at Just $139. And guess what? For a limited
                                    time, you can snag a whopping 50% off on all our web design packages!
                                </p>

                                <div class="FlexButton">
                                    <a  data-toggle="modal" data-target="#myModal" class="btn btn-Custom">Let's Get Started With Us</a>
                                    <a href="#" class="btn chat-btn" href="javascripts:;"  onclick="setButtonURL();" target="_self" title="Live Chat">Chat Now</a>
                                </div>
                                <div class="logoarea">
                                    <img src="images/logoes.png" alt="">
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
     <!-- Section-01 Html End -->



     <!-- Section-02 Html Start -->
      <section class="Section-02">
        <div class="container">
            <div class="row">
                <div class="col-md-7">
                    <div class="Design-Content" data-aos="zoom-in">
                        <h2>Why  <span>Instant Web Makers</span> Rocks</h2>
                        <div class="Design">
                            <p>
                                <span> Unique Designs:</span> No cookie-cutter templates here! We craft custom websites that truly represent your brand and speak to your audience.
                            </p>

                            <p>
                                <span> Mobile-Friendly:</span> Whether on a laptop, tablet, or phone, your site will look awesome and work perfectly.
                            </p>


                            <p>
                                <span> Quick Turnaround: </span> We know you’re eager to get online. Our streamlined process means your site goes live fast.
                            </p>

                            <p>
                                <span> SEO Savvy:  </span> We build with search engines in mind, so more people can find you easily.
                            </p>

                            <p class="Lsh">
                                <span> Ongoing Support: </span> Our help doesn’t stop at launch. We’re here for updates, tweaks, and any questions you’ve got.


                            </p>


                        </div>
                        <a href="#" class="btn btn-Green">Call Us</a>
                    </div>
                </div>

                <div class="col-md-5">
                    <div class="whyimg" data-aos="zoom-in-up">
                        <img src="images/why-design-flux.png" alt="" class="">
                    </div>
                </div>
            </div>
        </div>
        <div class="ANimate">
                       <img src="images/limi.png" alt="" class="w-100">
              </div>
      </section>

      <!-- Section-02 Css End -->

      <!-- Section-03 Html Start -->
       <section class="Section-03">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="WHatwe" data-aos="zoom-in-down">
                        <h2>What We Do</h2>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="FLipbox" data-aos="zoom-in-right">
                            <div class="service service1">
                                        <div class="front">
                                            <h4> Website Design: </h4>
                                            <p>
                                            From ideas to launch, we handle it all and make your site shine. 
                                            </p>
                                        </div>
                                        <div class="back">
                                        <div class="overlayFlip"></div>
                                            <h3>Graphic Design</h3>
                                            <p>creating modern Business Cards, Templates, logo etc.</p>
                                            <div class="CustomButton">
                                                <a href="#" class="btn btn-green">Get Started</a>
                                            </div>
                                        </div>
                                    </div>
                            </div>


                            <div class="FLipbox" data-aos="zoom-out-down">
                                    <div class="service service2">
                                                <div class="front">
                                                    <h4> SEO & Marketing: </h4>
                                                    <p>
                                                    Get found online! We’ll boost your site’s visibility and bring in more visitors. 
                                                    </p>
                                                </div>
                                                <div class="back">
                                                <div class="overlayFlip"></div>
                                                    <h3>SEO & Marketing: </h3>
                                                    <p>Get found online! We’ll boost your site’s visibility and bring in more visitors.</p>
                                                    <div class="CustomButton">
                                                        <a href="#" class="btn btn-green">Get Started</a>
                                                    </div>
                                                </div>
                                            </div>
                            </div>
                 </div>



                 <div class="col-md-6">
                    <div class="FLipbox" data-aos="zoom-in-left">
                            <div class="service service3">
                                        <div class="front">
                                            <h4>eCommerce Solutions: </h4>
                                            <p>
                                            Ready to sell stuff online? We’ve got you covered with robust, user-friendly e-commerce sites.
                                            </p>
                                        </div>
                                        <div class="back">
                                        <div class="overlayFlip"></div>
                                            <h3>eCommerce Solutions:</h3>
                                            <p>Ready to sell stuff online? We’ve got you covered with robust, user-friendly e-commerce sites.</p>
                                            <div class="CustomButton">
                                                <a href="#" class="btn btn-green">Get Started</a>
                                            </div>
                                        </div>
                                    </div>
                            </div>


                            <div class="FLipbox" data-aos="zoom-out-up">
                                    <div class="service service4">
                                                <div class="front">
                                                    <h4> Website Maintenance: </h4>
                                                    <p>
                                                    From ideas to launch, we handle it all and make your site shine. 
                                                    </p>
                                                </div>
                                                <div class="back">
                                                <div class="overlayFlip"></div>
                                                    <h3>Graphic Design</h3>
                                                    <p>creating modern Business Cards, Templates, logo etc.</p>
                                                    <div class="CustomButton">
                                                        <a href="#" class="btn btn-green">Get Started</a>
                                                    </div>
                                                </div>
                                            </div>
                            </div>
                 </div>
                    <div class="col-md-12">
                        <div class="buttonflex" data-aos="zoom-out-up">
                            <a class="nav-link chat-btn" href="javascripts:;"  onclick="setButtonURL();" target="_self" title="Live Chat" >Chat Now</a>
                            <a href="#" class="btn btn-Green">Call Us</a>
                        </div>
                    </div>
            </div>
        </div>
    </section>
     <!-- Section-03 Html start -->


    <!-- Section-04 Html start -->


     <section class="team">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                        <div class="checkTExt" data-aos="fade-down"
                        data-aos-duration="3000">
                            <h5>Check Out Our Awesome Work</h5>
                            <p>
                            We’ve had the pleasure of working with some amazing clients, and we’re super proud of the websites we’ve created. Here’s a peek
                            at some of our recent projects.
                            </p>
                        </div>
                    </div>
            </div>
        </div>
        <div class="container-fluid px-0">
            <div class="row">
                
                <div class="col-lg-12">

                    <div class="team-wrapper owl-carousel owl-theme owl-drag" data-aos="fade-up"
                    data-aos-duration="3000">
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-1.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                           <div class="items">
                            <div class="team-card">
                                <img src="images/slider-2.jpg" class="img-fluid" alt="">
                             
                               
                            </div>
                        </div>
                           <div class="items">
                            <div class="team-card">
                                <img src="images/slider-3.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-4.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-5.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-6.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-7.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-1.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-2.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                        <div class="items">
                            <div class="team-card">
                                <img src="images/slider-3.jpg" class="img-fluid" alt="">
                             
                            </div>
                        </div>
                       
                    </div>

                </div>
            </div>
        </div>
    </section>
     <!-- Section-04 Html End -->


    <?php include 'include/Home-package.php'?>


<!-- Work Html Start -->
 <section class="Work_sec">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="WOrk-text">
                    <h2>How It Works</h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <div class="Box-WOrk" data-aos="fade-left"
     data-aos-anchor="#example-anchor"
     data-aos-offset="500"
     data-aos-duration="500">
                    <div class="beforetext">
                        <span>01</span>
                    </div>
                    <h5>Chat With Us:</h5>
                    <p>
                    We start with a conversation to get to know your needs and vision.
                    </p>
                </div>
            </div>


            <div class="col-md-3">
                <div class="Box-WOrk" data-aos="fade-right"
     data-aos-anchor="#example-anchor"
     data-aos-offset="500"
     data-aos-duration="500">
                    <div class="beforetext">
                        <span>02</span>
                    </div>
                    <h5>Design & Build:</h5>
                    <p>
                    We start with a conversation to get to know your needs and vision.
                    </p>
                </div>
            </div>


            <div class="col-md-3">
                <div class="Box-WOrk" data-aos="fade-left"
     data-aos-anchor="#example-anchor"
     data-aos-offset="500"
     data-aos-duration="500">
                    <div class="beforetext">
                        <span>03</span>
                    </div>
                    <h5>Launch:</h5>
                    <p>
                    We start with a conversation to get to know your needs and vision.
                    </p>
                </div>
            </div>


            <div class="col-md-3">
                <div class="Box-WOrk" data-aos="fade-right"
     data-aos-anchor="#example-anchor"
     data-aos-offset="500"
     data-aos-duration="500">
                    <div class="beforetext">
                        <span>04</span>
                    </div>
                    <h5>Support & Updates:</h5>
                    <p>
                    We start with a conversation to get to know your needs and vision.
                    </p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="FLexbutton"  data-aos="flip-left"
     data-aos-easing="ease-out-cubic"
     data-aos-duration="2000">
                <a class="nav-link chat-btn" href="javascripts:;"  onclick="setButtonURL();" target="_self" title="Live Chat" >Chat Now</a>
                <a href="#" class="btn btnpackge">See Package</a>
                </div>
            </div>
        </div>
    </div>
 </section>
<!-- Work Html End -->


<!-- Web-Design Html STart -->
<section class="Design_Sec">
    <div class="container-fluid p-0">
        <div class="row align-items-center">
            <div class="col-md-5">
                    <div class="Design_sec" data-aos="fade-up"
                    data-aos-anchor-placement="top-bottom">
                    <h1 class="ml2">Innovative Web Designs</h1>
                        <h3>TO MAKE YOU STAND OUT</h2>
                        <p>
                        We’re passionate about creating beautiful, unique web interfaces that truly make your business shine. Need a custom WordPress site? An e-commerce platform? Or maybe some ongoing website maintenance? Whatever it is, our expert team is here to help.
                        </p>
                        <div class="second-para">
                            <p>
                            We love working with businesses like yours to bring your digital dreams to life. We don’t just build websites; we build relationships and make sure your site continues to thrive long after launch. Ready to make your mark online? Reach out to us today, and let’s chat about how we can turn your vision into reality!
                            </p>
                        </div>
                        <div class="Butonflex" data-aos="fade-up"
                        data-aos-anchor-placement="center-bottom">
                            <a href="#" class="btn Btn-talk">Talk To us</a>
                            <a href="#Pack" class="btn btnpackge">See Package</a>
                        </div>
                    </div>
            </div>
            <div class="col-md-7 p-0"  data-aos="fade-up"
            data-aos-anchor-placement="bottom-bottom">
                <figure class="designImage">
                    <img src="images/design-1.png" alt="">
                </figure>
            </div>
        </div>
    </div>
</section>

<!-- Web-Design Html End -->


<!-- Faq-Sec Html Start -->

<section class="Faq-Sec">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="faqtext">
                    <h2>Frequently Asked Question</h2>
                </div>

                <div class="FaqQuestion" data-aos="zoom-out-left">
                    <div class="faq-container">
                        <div class="faq-item">
                            <div class="faq-question">What services do you offer at Instant Web Makers?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>We specialize in a wide range of services including custom WordPress web design, e-commerce solutions, SEO optimization, website maintenance, and more. Whatever your digital needs, we’ve got you covered!</p>
                        </div>
                        <div class="faq-item">
                            <div class="faq-question">How much does web design and development cost at Instant Web Makers?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>Our pricing varies based on the complexity and scope of your project. We offer competitive rates starting from $139 for basic designs, with options to customize packages according to your specific requirements.</p>
                        </div>
                        <div class="faq-item">
                            <div class="faq-question">How long does it take to complete a website project?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>The timeline depends on the complexity of your website. Typically, our turnaround time ranges from 2 to 6 weeks, ensuring we deliver a high-quality, fully functional website in a reasonable timeframe.</p>
                        </div>


                        <div class="faq-item">
                            <div class="faq-question">What is your design process like?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>Our process begins with a detailed consultation to understand your goals and preferences. From there, we create initial designs for your review and feedback. Once approved, we proceed with development, testing, and final launch.</p>
                        </div>




                        <div class="faq-item">
                            <div class="faq-question">Can I see examples of your previous work?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>Absolutely! Visit our portfolio section to view a variety of projects we’ve completed for clients across different industries. You’ll get a firsthand look at our design style and capabilities.</p>
                        </div>


                        <div class="faq-item">
                            <div class="faq-question">Do you provide ongoing maintenance and support after the website is launched?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>Yes, we offer comprehensive maintenance plans to ensure your website remains secure, up-to-date, and performing optimally. Our team is always available to handle updates, troubleshoot issues, and answer any questions you may have.</p>
                        </div>



                        <div class="faq-item">
                            <div class="faq-question">Will my website be mobile-friendly?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>Yes, all websites we design are fully responsive and optimized for mobile devices. This ensures a seamless user experience across smartphones, tablets, and desktops.</p>
                        </div>




                        <div class="faq-item">
                            <div class="faq-question">Can you help with search engine optimization (SEO)?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>
                            Absolutely! We integrate SEO best practices into our design and development process to help improve your site’s visibility on search engines like Google. This includes keyword optimization, meta tags, and more.
                            </p>
                        </div>



                        <div class="faq-item">
                            <div class="faq-question">How do you handle payments?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>
                            We typically require a deposit upfront to start work on your project, with the remainder due upon completion. Payment methods and terms are discussed and agreed upon before beginning any work.
                            </p>
                        </div>


                        <div class="faq-item">
                            <div class="faq-question">Do you use contracts for your services?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>
                            Yes, we use detailed contracts outlining project scope, timelines, costs, and terms of service. This ensures clarity and transparency throughout the design and development process.
                            </p>
                        </div>



                        <div class="faq-item">
                            <div class="faq-question">How can I get started with Instant Web Makers?</div>
                            <div class="icon-container"><i class="fa-solid fa-square-caret-down"></i></div>
                        </div>
                        <div class="faq-answer">
                            <p>
                            Getting started is easy! Simply contact us via phone, email, or our website to schedule a consultation. We’ll discuss your project goals, provide recommendations, and create a customized plan to bring your vision to life.
                            </p>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
 <!-- Faq-Sec html End -->


 <!-- Footer Html Start -->
<footer>
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="f-logo">
                    <img src="images/logo.png" alt="">
                </div>
            </div>

            <div class="col-md-3">
                <div class="flexFoter">
                    <div class="iconphone">
                       <a href="#"> <i class="fa-solid fa-phone-volume"></i></a>
                    </div>
                    <div class="phonetext">
                        <a href="#">Call Us Now</a>
                        <p>
                        24/7 Available
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="flexFoter">
                    <div class="iconphone">
                       <a href="#"> <i class="fa-regular fa-comments"></i></a>
                    </div>
                    <div class="phonetext">
                    <p>
                        Discuss Your Project
                        </p>
                        <a href="javascripts:;"  onclick="setButtonURL();" target="_self" title="Live Chat">Chat Now</a>
                      
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="Footerbutton">
                    <a href="#" class="btn btn_green">GET a quote</a>
                </div>
            </div>
        </div>

        <div class="row newro">
            <div class="col-md-6">
                <div class="copyright">
                    <p>
                    © Copyright 2024 <strong>Instant Web Makers</strong>. All Rights Reserved
                    </p>
                </div>
            </div>

            <div class="col-md-6">
                <div class="saveim">
                    <img src="images/sa.png" class="" alt="">
                </div>
            </div>
        </div>
    </div>
</footer>
<div class="nitro">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="itrotext">
                    <p>
                      <span>  <img src="images/nitro.svg" alt=""></span>
                        Automated page speed optimizations for fast site performance
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
 <!-- Footer Html End -->
<!-- Button trigger modal -->
<!--<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#staticBackdrop">-->
<!--  Launch static backdrop modal-->
<!--</button>-->

<!-- Modal -->
<div class="modal fade modal-center" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <!--<h5 class="modal-title" id="exampleModalLabel">Modal title</h5>-->
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
         <div class="popup-lady">
                                <img src="images/popup-lady.png" alt="">
                            </div>
        <div class="modal-text">
            <h3>Avail Your Logo Designing / Digital Marketing Services Coupon</h3>
            <div class="row">
                <div class="col-md-6">
                    <div class="availfor">
                        <h4>Save up to 65% Off!</h4>
                        <h5>Limited Time Offer - Only 3 Days Left!</h5>
                    </div>
                    <div class="custom-form" data-aos-duration="1500" data-aos="fade-down">
                        <form action="sendmail.php" method="POST" class="leadForm" enctype="multipart/form-data">
                          <input type="hidden" name="brand_name" value="Website-design.com">
                          <input type="hidden" id="lead_area" name="lead_area" value="https://designfluxlab.com/website-design/">
                              <div class="row align-items-center">
                                    <div class="Itembox">
                                        <div class="form-group mb-0">
                                            <!-- <label for="exampleInputEmail1"><img src="images/envelop.png" alt="">Email address</label> -->
                                            <input type="text" name="name" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Your Name">
                                            
                                        </div>
                                    </div>
                                    <div class="Itembox">
                                        <div class="form-group mb-0">
                                            <!-- <label for="exampleInputEmail1"><img src="images/phone.png" alt="">Phone Number</label> -->
                                            <input type="email" name="email"  class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Your Email ">
                                          
                                        </div>
                                    </div>
                                    <div class="Itembox">
                                        <div class="form-group mb-0">
                                            <!-- <label for="exampleInputEmail1"><img src="images/phone.png" alt="">Phone Number</label> -->
                                            <input type="tel" name="phone" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Phone">
                                          
                                        </div>
                                    </div>
                                    <div class="Itembox">
                                        <div class="form-group mb-0">
                                            <!-- <label for="exampleInputEmail1"><img src="images/calen.png" alt="">Date</label> -->
                                       
                                              <select>
                                                  <option value="0">Select a Service</option>
                                                  <option value="1">Branding</option>
                                                  <option value="2">Digital Marketing</option>
                                                  <option value="3">Logo Design</option>
                                                  <option value="4">Mobile Apps</option>
                                                  <option value="5">Web Design</option>
                    
                                              </select>
                                        
                                        
                                        </div>
                                    </div>
                                    <div class="Itembox">
                                         <div class="form-group">
                                            <textarea name="message" class="form-control" id="exampleFormControlTextarea1" rows="4"></textarea>
                                          </div>
                                    </div>
                                    <div class="col-md-12 p-0">
                                            <button type="submit" class="btn btn-primary"><img src="images/dd.png" alt="">Book Now</button>
                                    </div>
                              </div>
                              
                            </form>
                        </div>
                </div>
                <div class="col-md-6">
                    <div class="call-form">
                       
                        <div class="flexitm">
                           
                            <div class="flex-text">
                                <h5>Call Us:</h5>
                                <a href="#">+1 (949) 994-9191</a>
                            </div>

                            <div class="flex-text">
                                <h5>Email Us:</h5>
                                <a href="mailto:info@instantwebmakers.com">info@instantwebmakers.com </a>
                            </div>
                        </div>

                        <div class="iconf">
                            <a href="https://www.facebook.com/instantwebmakersus"><i class="fa-brands fa-facebook-f"></i></a>
                            <!--<a href="#"><i class="fa-brands fa-instagram"></i></a>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
      </div>
      <!--<div class="modal-footer">-->
      <!--  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>-->
      <!--  <button type="button" class="btn btn-primary">Save changes</button>-->
      <!--</div>-->
    </div>
  </div>
</div>
    <!-- Optional JavaScript; choose one of the two! -->

    <!-- Option 1: jQuery and Bootstrap Bundle (includes Popper) -->
    <script src="https://code.jquery.com/jquery-3.4.1.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-Fy6S3B9q64WdZWQUiU+q4/2Lc9npb8tCaSX9FK7E8HnRr0Jz8D6OP9dO5Vg3Q9ct" crossorigin="anonymous"></script>

    <!-- Option 2: Separate Popper and Bootstrap JS -->
    <!--
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/2.0.2/anime.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/studio-freight/lenis@1.0.27/bundled/lenis.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js" integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js"></script>
    <script src="js/allmin.js"></script>
    <script src="js/pre.js"></script>
    <script src="js/jsap.js"></script>

<script src="js/custom.js"></script>
<script src="https://unpkg.com/aos@next/dist/aos.js"></script>
  <script>
    AOS.init();
  </script>
   <script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=571e6e0f-4250-42e7-a004-3e626417c041"> </script>
 <script type="text/javascript">
     $('.chat-btn').click(function() {
         $zopim.livechat.window.toggle();
     });

    
 </script>

    <script type="text/javascript">
		$('.Section-01').mousemove(function(e){
			var moveinX = (e.pageX * -1/100);
			var moveinY = (e.pageY * -1/100);
			$(this).css('background-position', moveinX + 'px ' + moveinY + 'px ')
		})
	</script>

<script type="text/javascript">
		$('.Section-01').mousemove(function(e){
			var moveinX = (e.pageX * -1/100);
			var moveinY = (e.pageY * -1/100);
			$(this).css('background-position', moveinX + 'px ' + moveinY + 'px ')
		})
	</script>
  </body>
</html>