<?php
    $content = [
        "book-writing" => [
            "heading" => "Why Choose eBook Ghostwriting Services for Ghostwriting Books?",
            "description" => "At eBook Ghostwriting Services, we specialize in providing exceptional ghostwriting services tailored specifically for Books. With a dedicated team of experienced professionals, we offer a seamless process that ensures your vision is brought to life effectively and efficiently.",
            "description2" => "Our approach begins with a deep understanding of your needs and objectives. We take the time to listen to your ideas and preferences, ensuring that we capture the essence of your vision in every word we write. Whether you’re looking to create a gripping fiction novel, an informative self-help guide, or a captivating memoir, our team is equipped with the expertise and versatility to bring your ideas to fruition.",
            "description3" => "Once we have a clear understanding of your project, our skilled ghostwriters get to work, crafting engaging and compelling content that resonates with your target audience. With a keen eye for detail and a commitment to excellence, we ensure that every sentence is meticulously crafted to deliver maximum impact and engagement.",
            "description4" => "In the digital era, an author’s online presence is paramount. An engaging author website serves as the hub for all promotional activities, featuring a comprehensive bio, links to social media, and a platform for interacting with readers. We make online space an extension of the author’s brand and a central point for readers to connect with the author and explore additional works.",
            "description5" => "We also offer comprehensive editing and proofreading to ensure the final product is polished to perfection. Our team of editors meticulously reviews every word, ensuring grammatical accuracy, coherence, and consistency throughout the manuscript.",
            "description6" => "At 360 Book Services, we understand the importance of creating visually appealing Books that captivate readers from the moment they lay eyes on the cover. That’s why we offer professional cover design services that are tailored to reflect the tone and theme of your Book. Our designers work closely with you to create stunning covers that not only grab attention but also accurately represent the content within.",
        ], 
        "ghostwriting-company" => [
            "heading" => "Why Choose eBook Ghostwriting Services",
            "description" => "After our ghostwriting company starts your project with editing. Our developmental editors put forth endless effort to make sure your book flows naturally to your intended readership, turning your concepts into an engaging story. After that, our expert copy editors carefully proofread each sentence for grammar, style, and consistency, creating a polished work of art that will appeal to readers.",
            "description2" => "Then, our team of talented ghostwriters for hire collaborates with designers to help produce a compelling cover. Our ghostwriting company crafts eye-catching designs that not only demand attention but also artfully convey the essence of your literary creation. Let your book cover be the gateway to a world of imagination, designed to captivate your intended readership from the first glance.",
            "description3" => "We create strategies that create buzz, from pre-launch teasers to captivating book descriptions and expertly executed pre-order promotions. Use internet forums, author websites, and social media to interact with prospective readers directly. Our painstakingly prepared book launch parties generate excitement and guarantee that your book commands attention in the crowded literary field.",
            "description4" => "In the digital era, an author’s online presence is paramount. An engaging author website serves as the hub for all promotional activities, featuring a comprehensive bio, links to social media, and a platform for interacting with readers. We make online space an extension of the author’s brand and a central point for readers to connect with the author and explore additional works.",
            "description5" => "We build a foundation of trust and credibility with our book reviews and testimonials services along with our professional ghostwriting company. Our team secures advanced reviews from influential reviewers, setting the stage for a positive reception. Encourage and showcase reader testimonials on prominent platforms like Amazon and Goodreads, amplifying the impact of your work and solidifying your position in the literary world.",
            "description6" => "Finally, maximize the reach of your literary creation with our targeted book distribution services. Ensure your book is available on major online platforms such as Amazon and Barnes & Noble, reaching a global audience. Let our strategic approach to distribution be the catalyst that propels your book into the hands of readers, contributing to its widespread success.",
        ],
        "fiction-writing" => [
            "heading" => "What to anticipate from using our fiction ghostwriting services",
                "description" => "Taking on the literary journey with eBook Ghostwriting Services ensures a distinctive and cooperative experience that goes beyond conventional fiction ghostwriting services for novels. You may expect a customized session right away, during which we delve into the details of your narrative. We deconstruct your story vision, themes, and desired results through in-depth conversations, laying the groundwork for a customized and cooperative creative approach.",
                "description2" => "Next is a strategic exploration of the genre terrain. Together, we carefully consider which genre best captures the core of your story and make sure it fits in the selected literary canon. The real magic happens when you work with our professional writer matchmaking service, which is a methodical approach that matches you with a talented writer whose experience and knowledge flow naturally with the subtleties of your story. This individualized relationship guarantees that a writer who shares your creative vision will not only understand your narrative but will also improve it.",
                "description3" => "Plot development is the next step in our collaborative journey. Through iterative sessions, your ideas are polished and expanded to create a fascinating tale that draws readers in and makes your narrative come to life. Following suit, character sculpting workshops give protagonists, villains, and supporting cast members life in order to create characters that readers will relate to and arouse feelings in.",
                "description4" => "Regular group writing sessions are the beating heart of our method. Every chapter is written with your vision in mind, creating an atmosphere of open dialogue where your comments influence the story as it develops. After we finish the first draft, you can provide suggestions for changes and make sure the document meets all of your requirements.",
                "description5" => "",
                "description6" => "",
        ],
        "memoir-writing" => [
            "heading" => "The Memoir Magic discovered!",
                "description" => "Expect a personalized experience where your narrative is highlighted. The core of our memoir writing services is to capture your essence, ensuring each chapter accurately conveys your voice, character, and distinct experiences. You may anticipate a masterfully written story written by experienced memoir ghostwriters who are knowledgeable about the nuances of storytelling and that genuinely connect with your life’s journey",
                "description2" => "Not only this but we also incorporate your memories into a gripping narrative while allowing you to maintain creative control throughout the process. Anticipate a smooth collaboration in which your perspectives merge with our proficiency, resulting in a memoir that accurately captures your experiences, feelings, and acquired knowledge.",
                "description3" => "You can be confident that we put confidentiality first. You should expect a safe space where your intimate tales and priceless moments are protected during the ghostwriting process. You can share private information with confidence because you know that we will handle your stories with the utmost care and discretion.",
                "description4" => "Get ready for a memoir that goes above and beyond. You can count on a final manuscript that not only tells your story but also draws readers into your world thanks to our attention to detail and dedication to quality. A finished memoir that strikes a deep chord and leaves a lasting impression on whoever opens its pages should be expected, rather than just a book.",
                "description5" => "",
                "description6" => "",
        ],
        "biography-writing" => [
            "heading" => "What should you anticipate from a professional biography writer that you hire?",
                "description" => "Employing our professional biography writer guarantees a thorough comprehension of the subtleties of storytelling. You can count on our biography writer for hire to have a deep understanding of character development, narrative structures, and the craft of turning real-life events into gripping stories. Our professional biography writers’ skill extends beyond simply documenting events; they explore the emotional terrain, skillfully and perceptively capturing the core of your journey.",
                "description2" => "Our professional biography writer is aware of how crucial the authenticity of your story is. Anticipate a customized strategy that incorporates group discussions and keeps your input and vision central to the process. These authors want to tell stories that not only educate you but also deeply connect with you and your audience, necessitating conversation and active engagement to guarantee your story is presented truthfully.",
                "description3" => "You should expect flawless quality and meticulous attention to detail when hiring a biography writer. From careful investigation to well-edited writing, you can anticipate a manuscript that is more than just documentation. Our expert biographers go through stringent editing procedures to guarantee precision, consistency, and artistic grace. The finished product ought to be an engrossing story that honors your distinct journey and captivates readers.",
                "description4" => "The hiring of experts should, arguably above all, produce a biography that evokes strong feelings. Anticipate a tale that sticks with readers long after it has been turned on the page. Our Professional biography writers hope to inspire as well as educate readers, leaving a lasting impression on your story, and making sure that long after they’ve finished reading, your tale will be ingrained in their hearts and thoughts.",
                "description5" => "These demands—know-how, customized strategies, excellent deliverables, and emotional ties—form the basis of a cooperative process that turns your life narrative into a work of art when you work with a professional bio writing services.",
                "description6" => "",
        ],
        "autobiography-writing" => [
            "heading" => "After Engaging Our Autobiography Ghostwriters, What to Anticipate",
                "description" => "Hiring our autobiography ghostwriters is a decision that will transform your life story into an engaging story. What to anticipate when you hire eBook Ghostwriting Service’s autobiography writing services is shown here:",
                "description2" => "You should anticipate a customized and individualized approach from the moment you utilize our autobiography writing services. Our group makes certain that your autobiography accurately captures your voice, experiences, and goals in every way possible.",
                "description3" => "When you work with an expert, it’s more than just hiring a writer—it’s a relationship. Our autobiography ghostwriters collaborate extensively with you, holding many meetings and feedback sessions to make sure the story flows naturally from your perspective.",
                "description4" => "Throughout the process, be prepared for concise and unambiguous communication. From the first discussions to the last evaluation, we keep you updated at every turn, promoting an atmosphere of openness and trust.",
                "description5" => "Your life’s essence is expertly captured by our team of talented authors. They have a great deal of familiarity with your situation and have conducted in-depth interviews and research to create a realistic and compelling story.",
                "description6" => "Following the group writing sessions, the manuscript should be polished and refined. Our editors carefully go over the text to make sure it makes sense and has a literary flair that will make your autobiography stand out more. Be prepared for sensitivity and respect for each and every facet of your trip as your story develops. Our skilled autobiography ghostwriters handle the nuances with caution, making sure that your story is conveyed with the utmost regard for your own experiences. As your ghostwriter autobiography draws to a close, expect advice on the publishing procedure. We provide knowledge, counsel, and assistance to make sure your narrative successfully reaches the people it is meant for. In the end, anticipate leaving behind an everlasting legacy. Carefully written by our ghostwriters, your autobiography becomes more than just a book—rather, it becomes a reflection of the depth and individuality of your life’s experience.",
        ],
        "business-book-writing" => [
            "heading" => "What Makes Our Business Ghostwriting Services Unique",
                "description" => "Our Business Ghostwriting Services have been the driving force behind revolutionary stories and unmatched success in our town’s thriving literary scene, where every company looks for a voice that speaks to its target audience. Why are we the talk of the community? Let’s explore the nature of our offerings and the reasons companies select us as their go-to ghostwriting partner.",
                "description2" => "Our commitment to crafting stories that reflect each company’s own identity is the foundation of our success. We reject the idea of universally applicable answers. Rather, we carefully construct every piece of content to match the goals, objectives, and tone of the company we represent. This customized approach guarantees that each phrase is truly in line with the brand it represents.",
                "description3" => "Our unique selling point is the well-balanced combination of industry knowledge and artistic flair that our ghostwriters provide. Because members of our business ghostwriter team come from a variety of business backgrounds, we can understand the subtle differences and finer points that are unique to each industry. This knowledge, along with a creative storytelling flare, produces narratives that are captivating and educational, positioning our clients as leaders in their industries.",
                "description4" => "We collaborate with businesses instead of merely writing for them. Our collaboration strategy guarantees that the voice of the customer always comes first. Even if we contribute our experience, we never take precedence over the distinctive viewpoints and ideas of our clients. The end product is a well-balanced combination that capitalizes on our ghostwriters’ literary skills while maintaining the business’s authorial authority.",
                "description5" => "",   
                "description6" => "",
        ],
        "hip-hop-writing" => [
            "heading" => "What to expect from Our Hip-Hop Ghostwriters",
                "description" => "Starting the adventure with our hip-hop ghostwriters is a life-changing experience rather than just a joint venture. When you decide to work with eBook Ghostwriting Services to realize your hip-hop vision, you can anticipate the following:",
                "description2" => "As our ghostwriters for rappers delve into your creative realm, get ready to witness the realization of your concept. This immersion guarantees that your lyrics are more than just skillfully composed; they’re a true manifestation of your artistic individuality, from style comprehension to thematic nuance knowledge.",
                "description3" => "Prepare for group brainstorming sessions that will involve more than simply hip-hop ghostwriting. We discuss topics, messages, and storytelling strategies when we sit down together. We collaborate to create verses that really connect with your distinct story, not merely make sense lyrically.",
                "description4" => "Your advice is really helpful. Regular feedback loops are essential to our technique since they let you mold the verses as they develop. Our top goal is your happiness, therefore these feedback sessions make sure the finished lyrics live up to your expectations.",
                "description5" => "Our ghostwriters for rappers do more than just create poetry; they also offer analysis of performance dynamics. We offer advice on how to deliver your rhymes with maximum power, whether you’re hitting the studio or the stage, so your hip-hop recordings leave a lasting impression.",
                "description6" => "",
        ],
        "grant-writing" => [
            "heading" => "Versatile Grant Writing Services for Every Funding Need",
                "description" => "We offer a wide range of funding options in our grant writing services to accommodate a variety of needs. We specialize in writing strong government grant proposals, making sure your application satisfies all national and local regulations. Our staff of qualified grant writers is adept at meeting the particular requirements and expectations of each grant opportunity, whether you’re trying to obtain financing from the local government or are targeting bigger awards from the federal government.",
                "description2" => "We leverage our experience with private foundations and philanthropic groups to specialize in foundation grants in addition to government funding. Our proficiency in composing grant proposals for foundations allows us to customize them to each foundation’s priorities, increasing your chances of receiving the required funds..",
                "description3" => "Another important component of our grant writing services is corporate funding. Our expertise lies in designing proposals that are tailored to corporate sponsorship, ensuring that the objectives of your project are in line with the company’s CSR programs. Our expert grant writing guarantees that your proposal stands out in a crowded industry, whether you’re looking for a grant writer for a small business or a larger organization.",
                "description4" => "We also offer research grant writing services, where we draft thorough and organized submissions to obtain money for different kinds of research initiatives. To convince possible funders of the value and technique of your research, our grant writers are skilled at presenting these points.",
                "description5" => "Last but not least, your group will be able to obtain money from a variety of sources, such as the government, foundations, and corporate sponsors, thanks to our proficiency in non-profit grants. To assist you reach your financial goals, our local grant writers carefully develop proposals that represent your vision and impact, taking into account the unique requirements of non-profits. We can help you succeed whether you need to discover a grant writer or work with a reputable grant writing firm.",
                "description6" => "",
            ],
        "white-paper-writing" => [
            "heading" => "Unleashing Your Ideas' Power - The Benefit of White Papers",
                "description" => "Boost Your Credibility - An expertly written white paper establishes your company as a thought leader in your sector. Your target audience will respect and believe you if you can provide insightful and helpful solutions.",
                "description2" => "Enhance Your Brand Reputation - Your brand identity and values are reinforced by consistently excellent content. A compelling white paper can improve the perception of your company and set you apart from rivals.",
                "description3" => "Produce Superior Leads - White papers are effective resources for generating leads. You may cultivate new clients and create a targeted email list by providing useful material in return for contact details.",
                "description4" => "Boost Your Position in Search Engines - You may increase your internet visibility by adding pertinent keywords and search engine optimizing your white paper. Increased website traffic and brand recognition are directly correlated with higher search ranks.",
                "description5" => "Support Sales and Marketing Efforts - White papers are useful instruments for marketing and sales. They can be shared with prospects to foster relationships and complete sales, and they offer vital information to potential clients.",
                "description6" => "Inform Decision Making - White papers provide in-depth research and data-driven insights to assist your target audience in making wise decisions. This fosters client loyalty and establishes your company as a reliable resource.",
            ]
    ];

    // Get the current URL path
    $currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    // Clean and normalize the path (trim slashes and convert to lowercase)
    $currentPath = trim($currentPath, '/');
    $currentPath = strtolower($currentPath);

    // Adjust path to check for main page cases
    if ($currentPath === "" || $currentPath === "index") {
        $currentPath = "index";
    }

    // Debugging output to check the path being used
    echo "<!-- Debug: Current Path = $currentPath -->";

    // Function to get the matching content based on the URL path
    function getCompanyContent_Wh($path, $content)
    {
        // If a matching key is found, return the content. Otherwise, return default content.
        return $content[$path] ?? $content["index"];
    }

    // Fetch the appropriate content based on the current URL path
    $currentPath = explode('/', $currentPath);
    $currentPath = $currentPath[count($currentPath) - 1];
    $data = getCompanyContent_Wh($currentPath, $content);
    $heading = $data["heading"];
    $description = $data["description"];
    $description2 = $data["description2"];
    $description3 = $data["description3"];
    $description4 = $data["description4"];
    $description5 = $data["description5"];
    $description6 = $data["description6"];
?>
<section class="home_cta why_choose_us">
        <div class="container">
            <div class="row d-flex align-items-center justify-content-center">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                    <div class="content text-center">
                        <h2 class=" mb-5">
                            <?php echo $heading ?>
                        </h2>
                        <p class="text-dark text-center">
                            <?php echo $description ?>
                        </p>
                        <p class="my-4 text-dark text-center">
                            <?php echo $description2 ?>
                        </p>    
                        <p class="text-dark text-center">
                            <?php echo $description3 ?>
                        </p>
                        <p class="my-4 text-dark text-center">
                            <?php echo $description4 ?>
                        </p>
                        <p class=" text-dark text-center">
                            <?php echo $description5 ?>
                        </p>
                        <p class="my-4 text-dark text-center">
                            <?php echo $description6 ?>
                        </p>
                        <div class="btn_group d-flex justify-content-center text-center">
                            <a href="contact-us">GET A QUOTE</a>
                            <a href="tel:<?php echo $number?>"><?php echo $number?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</section>