<?php
    $content = [
        "book-writing" => [
            "heading" => "Elevate Your Narrative: Premier Book Writers for Hire at Your Service!",
            "description" => "At eBook Ghostwriting Services, dedication is a practice rather than a promise, and excellence is not only a goal but also a standard. In the literary world, our book writing services are unique due to their superior caliber, inventiveness, and commitment.",
            "description2" => "Each member of our staff of seasoned authors is a master in their own literary field, and they all offer a lot of knowledge and enthusiasm to every assignment. Not only can our book writers for hire comprehend storytelling, but we are drawn to it. We totally commit to your story, from conception to conclusion, making sure that every chapter is a skillfully crafted thread in the mosaic of your own tale.",
            "description3" => "We also realize that time is of the essence. Our methodical and effective approach to project management guarantees that deadlines are not only fulfilled but also serve as chances to demonstrate our dependability. We coordinate our efforts to quickly translate your thoughts into reality because we understand how important your time is and how urgent your literary goals are.",
            "description4"=>""
        ],
        "ghostwriting-company" => [
            "heading" => "Have Doubts Regarding Ghostwriting Company? Don’t Worry It Has a History!",
            "description" => "Ghostwriting Company can trace its roots back to ancient times when scholars, politicians, and leaders often relied on scribes or speechwriters to draft speeches, documents, or manuscripts on their behalf. During the Renaissance, the demand for written works increased with the flourishing of literature, philosophy, and political discourse. Authors, especially those in positions of power or influence, frequently employed scribes or ghostwriters for hire to articulate their ideas in a polished and eloquent manner.",
            "description2" => "The 18th and 19th centuries saw the rise of literary salons and a growing interest in personal narratives and autobiographies. Professional ghostwriters, often undisclosed, played a role in helping individuals, including public figures, share their life stories or ideas. As the publishing industry expanded, so did the role of ghostwriting company.",
            "description3" => "The mid to late 20th century witnessed a surge in demand for ghostwriting company, especially with the proliferation of celebrity autobiographies. In the digital age, ghostwriting has become even more prevalent. With the rise of self-publishing and the accessibility of online platforms, individuals from various backgrounds seek ghostwriting company to bring their ideas to a wider audience. The stigma associated with ghostwriting has diminished, and many professionals openly acknowledge and celebrate the collaboration.",
            "description4"=>""
        ],
        "book-editing" => [
            "heading" => "The Art of Skillful Book Editing",
            "description" => "Book editors for hire of eBook Ghostwriting Services see editing as an art, a careful balancing act between bringing out the best in each book while still protecting the author’s individual style. Our professional book editors, who are all master craftsmen in their own right, carefully consider every detail in your work to make sure it all fits together beautifully and tells your tale as a whole. We take pleasure in producing literary masterpieces that go beyond the surface and masterfully convey the core of your story to enthrall readers.",
            "description2" => "",
            "description3" => "",
            "description4"=>""
        ],
        "fiction-writing" => [
            "heading" => "Taking Care of the Literary Garden with Ghostwritten Fiction!",
            "description"=>"The profound art of narrative is found in the kaleidoscope world of fiction, where the commonplace gives way to the exceptional. Here at eBook Ghostwriting Services, we think that magic is not only possible but also essential in a story. Our fiction ghostwriting services go beyond simply crafting phrases; they involve creating worlds, characters, and stories that readers will remember long after the last page.",
            "description2"=>"Fiction is the canvas of limitless creativity, and the maestros that bring your dreams to life are our fiction ghostwriters. You open the door to a universe where imagination has no bounds and every concept, no matter how ridiculous, finds a home when you commit your story to our knowledgeable hands.",
            "description3"=>"Our staff includes fiction ghostwriters for hire who specialize in a wide range of genres, from science fiction and fantasy to romance and mystery, and more. We pair you with a writer who is knowledgeable about the nuances of the genre you have selected, whether your story takes place in a small town or a far-off galaxy.",
            "description4"=>"Each writer has a distinct voice, which is crucial when writing fiction. Our fiction ghostwriters go out on a quest to comprehend not only your tale but also the rhythm of your storytelling. What was the outcome? A book that sings the tale in a way that only you can: one that goes beyond simple storytelling."
        ],
        "memoir-writing" => [
            "heading" => "Memoirs: Because Your Life Story Deserves More Drama Than Reality TV!",
            "description"=>"Have you ever thought that your life would make a fantastic screenplay? Welcome to the world of memoirs, where your tumultuous family dinners and morning coffee accidents will become the next big thing! Consider this: memoirs are the ultimate reality show, with the bonus that you get to be the star, writer, and director!",
            "description2"=> "Memoirs present a thrilling chance to weave an extraordinary narrative out of the mundane moments of life. Every story, oddity, and genuine feeling becomes a crucial thread weaving through your memoir. Imagine it as carefully selecting the best songs from your life and weaving them into a literary masterpiece. Memoirs celebrate the diversity of the human experience, from the heartbreakingly poignant moments of introspection to the hilariously relatable mishaps. They give your stories a platform to profoundly resonate and connect with readers, inspiring, evoking empathy, and laughter.",
            "description3"=> "Writing a memoir is like going behind the scenes of your life narrative. Here, you take on the role of nostalgia’s architect and create an engrossing story that captures the essence of your journey. It involves more than just retelling events—it involves giving them your distinct voice, viewpoint, and feelings. Your autobiography is a monument to fortitude, development, and the insight gleaned from life’s highs and lows. By providing you with expert assistance, our skilled memoir writers for hire help you organize your fragmented memories into a coherent narrative that will captivate readers and make a lasting impression on the literary world for your memoir.",
            "description4"=> ""
        ],
        "biography-writing" => [
            "heading" => "Why Choose e-Book Ghostwriting Services for Your Biography?",
            "description"=>"Our biography writing services at eBook Ghostwriting Services are your key to turning life stories into gripping tales that inspire and resound. What distinguishes us? Our group consists of experienced biography writers for hire who are proficient in narrative techniques. Our commitment is to customization; we carefully consider your life experiences, goals, and victories to make sure your biography accurately captures who you are. By involving you at every stage of the process, our collaborative approach ensures that the finished article accurately captures your voice and appeals to your target audience.",
            "description2"=>"Our core value is quality. We conduct in-depth research, fact-check, and edit to guarantee accuracy and a well-written story. Each tale we write is a passionate undertaking, painstakingly constructed to highlight the singularity of your trip.",
            "description3"=>"Furthermore, your biography will not only attract readers but also serve as a testament to the adventures you’ve had in life thanks to our dedication to professionalism and attention to detail.",
            "description4"=>"Selecting eBook Ghostwriting Services is giving your life narrative to a group of people who are enthusiastic about creating enduring stories out of memories. Your biography is more than simply a book to our professional biography writers; it’s a legacy that is ready to be shared with the world and make a lasting impression on future generations."
        ],
        "autobiography-writing" => [
            "heading" => "Why Use a Ghostwriter for Autobiography?",
            "description"=>"Starting to write your life story is a personal and complex undertaking. Although it may seem appealing to write your own autobiography, there are several benefits to hiring an autobiography ghostwriter. An experienced ghostwriter acts as a bridge between your experiences and the written word, making sure that your story is not just well-written but also resonates. The following are some strong arguments in favor of thinking about working with an autobiography ghostwriter.",
            "description2"=> "Ghostwriters for autobiographies possess a plethora of writing expertise and literary understanding. Their skill in organization, storytelling, and narrative flow guarantees that your life experience is not just recorded but also transformed into a work of captivating fiction.",
            "description3"=> "Seeing the world from a different angle can help you discover the real meaning of your existence. Ghostwriters for autobiographies approach your narrative objectively, which helps them pick out the most memorable parts and tell them in a way that appeals to a larger readership.",
            "description4"=>"Writing a thorough ghost writer autobiography requires a substantial time and effort commitment. By taking care of the intricate details of research, writing, and editing, an autobiography ghostwriter frees you up to concentrate on sharing your experiences while still producing a polished and polished product."
        ],
        "business-book-writing" => [
            "heading" => "Crafting Your Brand's Saga: Premier Business Ghostwriters Await",
            "description"=> "Welcome to a world where strategy and storytelling collide, where your brand is more than simply a name; it’s a character in a brilliantly unfolding story. We are here to be the business ghostwriters of your adventure, whether you are an established company ready for an engrossing sequel or a startup writing the first chapter of your success. Together, let’s set out on this magical journey where dreams come true and your tale is transformed into the masterpiece it was always meant to be. Your brand’s story isn’t only published at eBook Ghostwriting Services; it’s also whimsically weaved, painstakingly made, and incredibly adorable. Let’s turn your tale into a local sensation!",
            "description2"=>"Here, we’re passionate about the remarkable journey that every business tale carries, the power of words, and the beauty of stories. Imagine us as the guides on your brand’s literary journey, where all ideas, concepts, and goals are propelled by the creative process. We are your dream weavers, literary architects, and advocates of your own story, turning ordinary things into engrossing narratives and giving your brand life.",
            "description3"=>"",
            "description4"=>""
        ],
        "hip-hop-writing" => [
            "heading" => "Unmatched Genre Expertise: Crafting Hip-Hop Legends: Why Choose eBook Ghostwriting Services?",
            "description"=>"At eBook Ghostwriting Services, we create hip-hop narratives; we’re more than just wordsmiths. Our group is well-versed in the storytelling, culture, and beat specific to the hip-hop genre. Our ghostwriters for rappers bring your lyrics to life, making sure they ring true in the hip-hop scene, whether you’re spitting deep-cut lines or creating anthems that electrify the crowd.",
            "description2"=>"Hip-hop is a movement, a voice, and a culture in addition to being a genre. This is why we take a collaborative approach from the beginning to the end. We become fully immersed in your artistic vision, not just writing your songs. We work together to distill your approach into a single verse that perfectly captures your uniqueness. Hip-hop magic is created by the harmonious fusion of your voice and your experience.",
            "description3"=>"Verse writing is just one aspect of eBook Ghostwriting Services. We are aware that writing is not the only step in the process of creating a full-fledged hip-hop masterpiece from lyrics. Beyond rhyming, we also provide audience interaction, performance dynamics, and even release strategy assistance for your songs. Select us for a comprehensive hip-hop experience that elevates your artistic abilities beyond words alone.",
            "description4"=>""
        ],
        "grant-writing" => [
            "heading" => "Comprehensive Grant Writing Services to Secure Financial Support for Your Projects and Initiatives",
            "description"=>"At Ebook Ghostwriting, we understand the importance of securing grants to fuel your organization’s mission and vision. As one of the top grant writing companies, we specialize in providing top-notch grant writing services to non-profits, businesses, and government agencies. Our team of professional grant writers is dedicated to helping you navigate the complex grant writing process, from research to submission, ensuring that your proposal stands out from the competition.",
            "description2"=>"With years of experience and a proven track record of success, we have established ourselves as a trusted partner for organizations seeking to secure funding. Our professional grant writers possess a deep understanding of the grant writing process, staying up-to-date on the latest trends and requirements. We take the time to understand your organization’s unique needs and goals, crafting compelling proposals that showcase your project’s impact and potential. Whether you’re a small business, non-profit, or government agency, our grant writing services are tailored to meet your specific needs, helping you secure the funding you need to drive growth and success.",
            "description3"=>"As a leading grant writing company, we pride ourselves on our commitment to excellence, integrity, and customer satisfaction. Our professional grant writers are dedicated to delivering high-quality proposals that meet the highest standards. We believe that every organization deserves access to the funding they need to make a meaningful impact. That’s why we’re dedicated to helping you find a grant writer who understands your vision and can help you achieve your goals. With our grant writing services, you can trust that your proposal is in good hands. Let us help you secure the funding you need to drive your organization’s success.",
            "description4"=>""
        ],
        "white-paper-writing" => [
            "heading" => "Don't Know What White Paper Services Are? We've Got You Covered!",
            "description"=>"White papers are strategic tools that can increase your brand’s authority and provide measurable outcomes. They are more than just publications. We at Ebook Ghostwriting are aware of how important white papers are in influencing choices and forming public opinion. Our talented staff of white paper writers is committed to creating engaging material that will have a quantifiable impact on your target audience.",
            "description2"=>"Our white paper writing services cover every step of the procedure, from thorough research and data analysis to compelling storytelling and flawless design. We work together with you to comprehend your target market, business goals, and critical message so that your white paper effortlessly integrates with your entire marketing plan.",
            "description3"=>"Our professional white paper writers possess the knowledge and expertise to provide outstanding outcomes, regardless of the task at hand: a thorough examination of the sector, a convincing case study, or an insightful investigation of new developments. Allow us to turn your ideas into impactful documents that increase leads, foster engagement, and establish your company as a pioneer in your field.",
            "description4"=>"Hire our white paper writer and get in touch with us right now to talk about your white paper project and learn how powerful words can be.",
        ],
        "book-formating" => [
            "heading" => "The Power of Our eBook Formatting Services",
            "description"=>"The way your ebook is presented is crucial in the ever-changing world of digital literature. Our dependable ebook formatting service at eBook Ghostwriting Services is made to make sure your electronic creation is presented with accuracy and clarity. Our skilled staff of book formatters handles the complexities of digital media, making your information as smooth and interesting to read as possible. Our book formatting services may help you establish a polished and businesslike online presence, regardless of whether you’re a publishing house or an independent writer.",
            "description2"=>"",
            "description3"=>"",
            "description4"=>"",
        ],
        "book-proofreading" => [
            "heading" => "The Indispensable Role of a Book Proofreader",
            "description"=>"A book proofreader is an unsung hero in the complex world of words, where every period and comma matters. They carefully choose their way through the intellectual jungle to save your document from the linguistic maelstrom. Consider a proofreader as the wise guide who will ensure that your literary journey runs smoothly by identifying and fixing any typos, grammatical errors, and punctuation errors that could throw you off. A proofreader does more than just fix errors; they give your writing polish, consistency, and clarity, turning it into a seamless story that draws readers in. So why is a book proofreader necessary? A competent book proofreader is the compass that leads your manuscript to literary success in the world of written expression. Accept the value of accuracy, give your writing to a proofreader, and",
            "description2"=>"",
            "description3"=>"",
            "description4"=>"",
        ],
        "children-book-editing" => [
            "heading" => "How We Expertly Meeting the Challenges of Editing Children's Books",
            "description"=>"Editing children’s books calls for a deft hand and a thorough comprehension of the particular difficulties this genre presents. It takes subtle skill to tell a story that appeals to young brains and strikes a balance between sophistication and simplicity. Our team of expert children’s book editors is excellent at this complex assignment because they understand that children’s writing calls for accuracy, imagination, and a deep understanding of developmental phases. Not only must language, grammar, and structure be perfected, but the plot must also be age-appropriate, captivating, and able to pique readers’ interests. Our editors for children’s books have a great deal of expertise in editing children’s books and understand how important it is to instill a love of reading in young children.",
            "description2"=>"",
            "description3"=>"",
            "description4"=>"",
        ],
        "book-cover-design" => [
            "heading" => "Enhance Your Narrative - Marvelous Book Cover Ideas Await!",
            "description"=>"Take a trip through visual splendor with our outstanding book cover designs. Every element—from typography to color scheme—is carefully chosen to make your book stand out in a crowded field of narratives. Your book cover is a reflection of the spirit of your writing, not merely a pretty picture. You can rely on our book cover design services to transform your concepts into engrossing pictures that invite readers to go further into the worlds you’ve created. With our experience, your book will be the talk of the bookshop.",
            "description2"=>"",
            "description3"=>"",
            "description4"=>"",
        ],
        "book-publishing" => [
            "heading" => "Experience Publishing Magic-Your Book, Our Universe!",
            "description"=>"With our all-inclusive and customized Amazon publishing services options, you can let your narrative take off and make sure that readers all over the world can get their hands on your masterpiece. Come along with us, and witness how we deal with your pages as an adventure and ensure your success!",
            "description2"=>"",
            "description3"=>"",
            "description4"=>"",
        ],
        "book-marketing" => [
            "heading" => "Book Marketing is Not Merely a Promotional Endeavor- It's a Strategic Investment!",
            "description"=>"Our book marketing company can significantly contribute to an author’s financial success. Our well-executed marketing campaign creates visibility, generating interest and demand for your book. By reaching a wider audience through targeted strategies, you increase the likelihood of attracting more readers, thereby boosting sales. Furthermore, an effective marketing plan extends beyond the initial launch, establishing a lasting presence in the literary marketplace. Engaging with your audience through various channels, such as social media, email newsletters, and book events, fosters a sense of connection and loyalty. This not only translates into sustained book sales but also positions you as an author with a dedicated following.",
            "description2"=>"",
            "description3"=>"",
            "description4"=>"",
        ],
    ];

    // Get the current URL path
    $currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    // Clean and normalize the path (trim slashes and convert to lowercase)
    $currentPath = trim($currentPath, '/');
    $currentPath = strtolower($currentPath);

    // Adjust path to check for main page cases
    if ($currentPath === "" || $currentPath === "index") {
        $currentPath = "index";
    }

    // Debugging output to check the path being used
    echo "<!-- Debug: Current Path = $currentPath -->";

    // Function to get the matching content based on the URL path
    function getCompanyContent_About($path, $content)
    {
        // If a matching key is found, return the content. Otherwise, return default content.
        return $content[$path] ?? $content["index"];
    }

    // Fetch the appropriate content based on the current URL path
    $currentPath = explode('/', $currentPath);
    $currentPath = $currentPath[count($currentPath) - 1];
    $data = getCompanyContent_About($currentPath, $content);
    $heading = $data["heading"];
    $description = $data["description"];
    $description2 = $data["description2"];
    $description3 = $data["description3"];    
    $description4 = $data["description4"];    
    ?>
<section class="home_about attach_one">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                <img src="assets/images/about-a2.webp" alt="about">
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                <div class="content">
                    <h2 class="clr"><?php echo $heading?></h2>
                    <p><?php echo $description?></p>
                    <p class="my-3"><?php echo $description2?></p>
                    <p><?php echo $description3?></p>
                    <p class="my-3"><?php echo $description4 ?></p>
                    <div class="btn_group d-flex align-items-center justify-content-start text-center">
                        <a href="contact-us"><i class="fa-thin fa-message mx-2"></i> REQUEST A QUOTE</a>
                        <a href="tel:<?php echo $number?>"><i class="fa-thin fa-phone-volume mx-2"></i> <?php echo $number?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>