<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <!-- START: Head-->
    <head>
        <meta charset="UTF-8">
        <title><?php echo e(isset($title)?$title:env('APP_NAME')); ?></title>
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"> 
        <meta name="description" content="<?php echo e(isset($description)?$description:''); ?>">
        <meta name="keywords" content="<?php echo e(isset($keywords)?$keywords:''); ?>">

        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('web/images/favicon.svg')); ?>">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('web/images/favicon.svg')); ?>">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('web/images/favicon.svg')); ?>">
        
        <?php echo $__env->make('web.layouts.links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php echo $__env->yieldContent('css'); ?>
        <!-- END: Custom CSS-->
    </head>
    <!-- END Head-->
    <!-- START: Body-->
     <body>
        <?php echo $__env->make('web.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <input type="hidden" id="web_url" value="<?php echo e(url('/')); ?>"/>
        <!-- START: Main Content-->
        <?php echo $__env->yieldContent('content'); ?>
        <!-- END: Content-->
        <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('web.layouts.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('js'); ?>
    </body>
    <!-- END: Body-->
</html>
<?php /**PATH D:\FareehaShah\V1\resources\views/web/layouts/main.blade.php ENDPATH**/ ?>