<!-- Begin: Top Row -->
<?php
use App\Models\accessories;
use App\Models\config;
$accessories = accessories::where('is_active',1)->where('is_deleted',0)->get();
$contact = config::where('is_active',1)->where('type','contactnumber')->first();
$email = config::where('is_active',1)->where('type','emailaddress')->first();
 ?>

<div class="top-row">

    <div class="container">

        <div class="row">

            <div class="col-md-4">

                <div class="contact-main">

                    <div class="phone">

                        <a href="tel:7609602176"><i class="fa fa-phone" aria-hidden="true"></i><?php echo e($contact->value); ?></a>

                    </div>

                    <div class="mail">

                        <a href="mailto:funracing@sbcglobal.net"><i class="fa fa-envelope" aria-hidden="true"></i><?php echo e($email->value); ?></a>

                    </div>

                </div>

            </div>

            <div class="col-md-3">

                <div class="shipping">

                    <p>Same Day Shipping</p>

                </div>

            </div>

            <div class="col-md-5">

                <div class="gifts-certificate">

                    <a href="#">Need Help?</a>

                    <a href="#">Blog</a>

                    <a href="#">Gift Certificates</a>

                    <a href="#">Compare(0)</a>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- END: Top Row -->

<!-- Begin: Bottom Row -->

<div class="bottom-row">

    <div class="container">

        <div class="row">

            <div class="col-md-2">

                <div class="logo">
                    <?php $logo = App\Models\logo::orderBy('id','desc')->first(); ?>
                    <a href="<?php echo e(route('welcome')); ?>"><img src="<?php echo e(asset($logo->image)); ?>" /></a>

                </div>

            </div>

            <div class="col-md-6">

                <div class="more-options">

                    <ul>

                        <li><a href="<?php echo e(route('about')); ?>">About</a></li>

                        <li><a href="<?php echo e(route('brand')); ?>">Brands</a></li>

                        <li><a href="<?php echo e(route('search')); ?>">Search</a></li>

                        <li><a href="<?php echo e(route('contact')); ?>">Contact</a></li>

                    </ul>

                </div>

            </div>

            <div class="col-md-4">

                <div class="user-options">
                    <?php if(auth()->guard()->guest()): ?>
                    
                    <a href="<?php echo e(route('account')); ?>">

                        <div class="option-main">

                            <div class="option-img">

                                <img src="<?php echo e(asset('web/images/option3.png')); ?>" />

                            </div>

                            <div class="option-info">

                                <p>Login</p>

                            </div>

                        </div>

                    </a>

                    <a href="<?php echo e(route('account')); ?>">

                        <div class="option-main">

                            <div class="option-img">

                                <img src="<?php echo e(asset('web/images/option2.png')); ?>" />

                            </div>

                            <div class="option-info">

                                <p>Register</p>

                            </div>

                        </div>

                    </a>
                    <?php endif; ?>
                    <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="">
                            <?php echo csrf_field(); ?>
                        </form>
                        <div class="option-main">
                            <div class="option-img">
                                <i class="fa fa-sign-out"></i>
                            </div>
                            <div class="option-info">
                                <p>Logout</p>
                            </div>
                        </div>
                    </a>

                    <a href="<?php echo e(route('user_profile')); ?>">
                        <div class="option-main">
                            <div class="option-img">
                                <i class="fa fa-tachometer"></i>
                            </div>
                            <div class="option-info">
                                <p>Dashboard</p>
                            </div>
                        </div>
                    </a>
                    <?php endif; ?>
                

                    <a href="#">

                        <div class="option-main">

                            <div class="option-img">

                                <img src="<?php echo e(asset('web/images/option3.png')); ?>" />

                            </div>

                            <div class="option-info">

                                <p>WishList</p>

                            </div>

                        </div>

                    </a>

                    <a href="<?php echo e(route('cart')); ?>">

                        <div class="option-main">

                            <div class="option-img">

                                <img src="<?php echo e(asset('web/images/option1.png')); ?>" />

                            </div>

                            <div class="option-info">

                                <p>Cart</p>

                            </div>

                            <div class="tag">

                                <span>0</span>

                            </div>

                        </div>

                    </a>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- END: Bottom Row -->

<div class="last-row">

    <div class="container">

        <div class="row">

            <div class="col-md-12">

                <nav class="navbar navbar-expand-md navbar-light">

                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">

                        <span class="navbar-toggler-icon"></span>

                    </button>

                    <div class="collapse navbar-collapse" id="navbarCollapse">

                        <div class="navbar-nav">
                            <?php $__currentLoopData = $accessories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('category_list',Crypt::encrypt($val->id))); ?>" class="nav-item nav-link active"><?php echo e($val->name); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link active">Interior</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Exterior</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Performance</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Lighting</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Wheels&Tires</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Parts</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Body Parts</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">Audio&Electronics</a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">AutomotiveTools </a>

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link">SpecialtyShops</a> -->

                            <a href="<?php echo e(route('product')); ?>" class="nav-item nav-link help">Help!</a>

                        </div>

                    </div>

                </nav>

            </div>

        </div>

    </div>

</div>

<?php /**PATH D:\xampp\htdocs\brembo\resources\views/web/layouts/header.blade.php ENDPATH**/ ?>