
<?php $__env->startSection('content'); ?>
<!-- Header End -->
<!-- breadcrumb  -->
<div class="cart-breadcrumb">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <ul>
                    <li><a href="<?php echo e(route('welcome')); ?>">Home /</a></li>
                    <li><a href="#">Apparel /</a></li>
                    <li><a href="#">Men /</a></li>
                    <li><a href="#" class="active"><?php echo e($product->name); ?></a></li>
                    <li><a href="<?php echo e(route('get_cart')); ?>" class="">View Cart</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb End  -->
<!-- main-container  -->
<div class="our-cart-container">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="laptop-slider">
                    <div class="items">
                        <img src="<?php echo e(asset($product->picture)); ?>" />
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <h1 id="pricediv"><?php echo e($product->name); ?></h1>
                <p id="price">$<?php echo e($product->tagprice); ?></p>
                <div class="add-to-cart">
                    <form class="" id="" method="POST" enctype="multipart/form-data" action="<?php echo e(route('save_cart')); ?>">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                        <input type="hidden" name="product_id" id="product_id" value="<?php echo e($product->id); ?>" />
                        <input type="number" min="1" max="<?php echo e($product->stock); ?>" value="1" name="qty" id="qty" />
                        <span>
                            <button type="button" id="cart_submit" class="btn add-cart">Add to cart</button>
                        </span>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="desc-tab">
    <div class="container">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true"> Description</a>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                <?php echo $product->desc; ?>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $("#cart_submit").click(function(){
        var product_id = $("#product_id").val();
        var qty = $("#qty").val();
        console.log(product_id);
        console.log(qty);
        $.ajax({
            type: 'post',
            dataType : 'json',
            url: "<?php echo e(route('save_cart')); ?>",        
            data: {product_id:product_id, qty:qty, _token: '<?php echo e(csrf_token()); ?>'},
            success: function (response) {
                if (response.status == 0) {
                    toastr.error(response.message);
                }else{
                    location.reload();
                    toastr.success(response.message);
                }
            }
        });
    })
    
</script>
<?php $__env->stopSection(); ?> 

<?php echo $__env->make('shop.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\bbsports\resources\views/shop/viewcart.blade.php ENDPATH**/ ?>