
<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="bread-crumb">
        <ul>
            <li><a href="#">Home ></a></li>
            <li><a href="#">Find a Therapist ></a></li>
            <li><a href="#"><?php echo e($therapist->first_name); ?> <?php echo e($therapist->last_name); ?></a></li>
        </ul>
    </div>
</div>

<section class="crystalshilling-sec">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="client-blk">
                    <div class="clint-img">
                        <?php if(($pic=$model['user']::where(['id'=>$therapist->user_id])->pluck('profile_pic')->first()) != null): ?>
                        <?php $path = $pic; ?>
                        <?php else: ?>
                        <?php $path = "images/no-img.png"; ?>
                        <?php endif; ?>
                        <img src="<?php echo e(asset($path)); ?>" />
                    </div>
                    <div class="client-contact">
                        <a href="#"><?php echo e($therapist->phone); ?></a>
                        <a href="#" class="email">Email Me</a>
                        <a href="#" class="visit">Visit Website</a>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <div class="client-info">
                    <h5> <?php echo e($therapist->first_name); ?> <?php echo e($therapist->last_name); ?> </h5>
                    <h6><?php echo e($therapist->credentials); ?></h6>
                    <div class="feature-main">
                        <div class="feature">
                            <i class="fa fa-star-o" aria-hidden="true">Featured</i>
                        </div>
                        <div class="verify">
                            <a href="#"><i class="fa fa-check-circle-o" aria-hidden="true"></i>Verify</a>
                        </div>
                    </div>
                    <div class="tele-health">
                        <i class="fa fa-laptop" aria-hidden="true"></i>
                        <p>Telehealth Available</p>
                    </div>
                    <div class="telehealth-list">
                        <ul>
                            <?php $profession = unserialize($therapist->profession); ?>
                            <li><span>Professions:</span>
                                <?php $__currentLoopData = $profession; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($pro=$model['profession']::where(['id'=>$pr])->pluck('name')->first()); ?>,
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </li>
                            <li><span>License Status:</span> <?php echo e($pro=$model['license']::where(['id'=>$therapist->license])->pluck('name')->first()); ?></li>
                            <li><span>Primary Credential:</span> <?php echo e($therapist->credentials); ?> - <?php echo e($therapist->ext); ?></li>
                        </ul>
                    </div>
                    <?php if($therapist_details): ?>
                    <div class="billing">
                        <p><span>Billing and Insurance:</span></p>
                        <p><?php echo e($therapist_details->billing); ?></p>
                        <p class="fee">
                            Fees: <?php echo e($therapist_details->fees); ?>

                        </p>
                        <ul>
                            <?php $availability = unserialize($therapist_details->availability); ?>
                            <?php $__currentLoopData = $availability; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $av): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($avo=$model['availability']::where(['id'=>$av])->pluck('name')->first()); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- <li>Sliding Scale Available</li>
                            <li>Weekend Availability</li>
                            <li>Evening Availability</li> -->
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="map">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m10!1m8!1m3!1d23533.951182326677!2d-83.37703!3d42.496997!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sus!4v1643967751047!5m2!1sen!2sus"></iframe>
                </div>
                <div class="office">
                    <h6>Offices</h6>
                    <p>27620 Farmington Road Suite 220</p>
                    <p>Farmington Hills, Michigan 48334</p>
                </div>
            </div>
            <div class="col-md-8">
                <div class="approach-sec">
                    <h2>My Approach to Helping</h2>
                    <p><?php echo e($therapist->approach); ?></p>
                </div>
                <?php if($therapist_details): ?>
                <div class="approach-sec">
                    <h2>MORE INFO ABOUT MY PRACTICE</h2>
                    <p>
                        <?php echo e($therapist_details->practice); ?>

                    </p>
                </div>
                <div class="approach-sec">
                    <h2>MY ROLE AS A THERAPIST</h2>
                    <p><?php echo e($therapist_details->role); ?></p>
                </div>
                <?php endif; ?>
                <div class="approach-sec">
                    <h2>IMAGE GALLERY</h2>
                    <div class="approach-image">
                        <ul>
                            <li>
                                <img src="<?php echo e(asset('web/images/gallery-img1.jpg')); ?>" alt="" />
                            </li>
                            <li>
                                <img src="<?php echo e(asset('web/images/gallery-img2.jpg')); ?>" alt="" />
                            </li>
                            <li>
                                <img src="<?php echo e(asset('web/images/gallery-img3.jpg')); ?>" alt="" />
                            </li>
                            <li>
                                <img src="<?php echo e(asset('web/images/gallery-img4.jpg')); ?>" alt="" />
                            </li>
                            <li>
                                <img src="<?php echo e(asset('web/images/gallery-img5.jpg')); ?>" alt="" />
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="services-provide">
                    <?php $services = unserialize($therapist->services); ?>
                    <h2>SERVICES I PROVIDE</h2>
                    <div class="services-list">
                        <ul>
                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($ser=$model['services']::where(['id'=>$sr])->pluck('name')->first()); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- <li>Clinical Supervision</li>
                            <li>Family Therapy</li>
                            <li>Group Therapy</li>
                            <li>Individual Therapy & Counseling</li>
                            <li>Telehealth</li> -->
                        </ul>
                    </div>
                </div>
                <?php if($therapist_details): ?>
                <div class="services-provide">
                    <h2>AGES I WORK WITH</h2>
                    <div class="services-list">
                        <ul>
                            <?php $work_age = unserialize($therapist_details->work_age); ?>
                            <?php $__currentLoopData = $work_age; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $av): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($avo=$model['work_age']::where(['id'=>$av])->pluck('name')->first()); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           <!--  <li>Children</li>
                            <li>Teens</li>
                            <li>Adults</li>
                            <li>Elders</li> -->
                        </ul>
                    </div>
                </div>
                <div class="services-provide">
                    <h2>LANGUAGES</h2>
                    <div class="services-list">
                        <ul>
                            <?php $languages = unserialize($therapist_details->languages); ?>
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $av): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($avo=$model['languages']::where(['id'=>$av])->pluck('name')->first()); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="services-provide">
                    <h2>GROUPS I WORK WITH</h2>
                    <p><?php echo e($therapist_details->work_group); ?></p>
                </div>
                <div class="services-provide">
                    <h2>INDUSTRIES & COMMUNITIES SERVED</h2>
                    <div class="services-list">
                        <ul>
                            <?php $industries = unserialize($therapist_details->industries); ?>
                            <?php $__currentLoopData = $industries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $av): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($avo=$model['industries']::where(['id'=>$av])->pluck('name')->first()); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
                <div class="services-provide">
                    <h2>CLIENT CONCERNS I TREAT</h2>
                    <?php $treatment = unserialize($therapist->treatment); ?>

                    <div class="services-list">
                        <ul>
                            <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($tre=$model['treatment']::where(['id'=>$tr])->pluck('name')->first()); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <?php if($therapist_details): ?>
                <div class="services-provide">
                    <h2>TYPES OF THERAPY</h2>
                    <div class="services-list">
                        <ul>
                            <?php $therapy_types = unserialize($therapist_details->therapy_types); ?>
                            <?php $__currentLoopData = $therapy_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $av): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($avo=$model['therapy_types']::where(['id'=>$av])->pluck('name')->first()); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
                <div class="link-text">
                    <p>See other therapists in <a href="">Farmington Hills, MI.</a></p>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="terms-services">
    <p>By using this site, you signify your assent and agreement to the <a href="">Terms of Service.</a></p>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\good-therapy\resources\views/web/therapist_profile.blade.php ENDPATH**/ ?>