<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex,nofollow" />
    <title><?php echo e(isset($title) ? $title : 'Home | '.env('APP_NAME')); ?></title>
    <meta name="description" content="<?php echo e(isset($meta_description)?$meta_description :''); ?>">
    <meta name="keywords" content="<?php echo e(isset($meta_keywords)?$meta_keywords :''); ?>">
    <meta name="author" content="Admin">
    <meta property="og:image" content="<?php echo e(asset($blog_image ?? '' )); ?>">
    <meta name="twitter:image" content="<?php echo e(asset($blog_image ?? '')); ?>">
    <link rel="canonical" href="<?php echo e(url(isset($canonical)?$canonical :'https://instantwebmakers.com/blog/')); ?>">
    
    <?php echo $__env->make('web.layouts.links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('css'); ?>

      <!-- Google Tag Manager -->
      <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-M3S75CL6');
        </script>
        <!-- End Google Tag Manager -->
</head>
<body>
     <!-- Google Tag Manager (noscript) -->
     <noscript>
        <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-M3S75CL6" height="0" width="0"
            style="display:none;visibility:hidden"></iframe>
    </noscript>
    <!-- End Google Tag Manager (noscript) -->
    <main>
        <?php echo $__env->make('web.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('web.layouts.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH F:\ahmedshoaib\xxamp\htdocs\ahmedshoaib\laravel-projects\instantwebmalers-blogs\resources\views/web/layouts/main.blade.php ENDPATH**/ ?>