<?php  
$user = Auth::user();
$att_tag = App\Models\attributes::where('is_active' ,1)->select('attribute')->distinct()->get();
$role_assign = App\Models\role_assign::where('is_active' ,1)->where("role_id" ,$user->role_id)->first();
if ($role_assign) {
    $sidebar_data = unserialize($role_assign->assignee);
    $sidebar_data = Helper::create_sidebar($sidebar_data);
}else{
    $sidebar_data = [];
}

?>
<div class="sidebar">
            <div class="site-width">
                <!-- START: Menu-->
                <ul id="side-menu" class="sidebar-menu">
                    <li class="dropdown active"><a href="#"><i class="icon-home mr-1"></i> Dashboard</a>                  
                        <ul>
                            <li class="active"><a href="<?php echo e(url('/')); ?>"><i class="icon-rocket"></i> Dashboard</a></li>
                            <?php if(Auth::user()->role_id == 1): ?>
                            <li><a href="<?php echo e(route('roles')); ?>"><i class="icon-layers"></i> Attributes</a></li>
                            <?php endif; ?>
                            <?php if($sidebar_data): ?>
                                <?php $__currentLoopData = $sidebar_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('listing',$side)); ?>" data-actor="<?php echo e($side); ?>"><i class="fa fa-eye"></i> <?php echo e(ucwords($side)); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            
                            
                        </ul> 
                    </li>

                    <?php if(Auth::user()->role_id == 1 || Auth::user()->role_id == 36): ?>
                    <li class="dropdown"><a href="#"><i class="icon-organization mr-1"></i> Tools</a>
                        <ul>
                            <li class="dropdown"><a href="#"><i class="icon-options"></i>Reports</a>
                                <ul class="sub-menu">
                                    <li><a href="<?php echo e(route('all_registered_user_report',['basic'])); ?>"><i class="icon-energy"></i> All User - Basic Info</a></li>
                                    <li><a href="<?php echo e(route('all_registered_user_report',['personnel'])); ?>"><i class="icon-energy"></i> All User - Personnel Info</a></li>
                                    <li><a href="<?php echo e(route('registered_user_report')); ?>"><i class="icon-energy"></i> Manage User</a></li>
                                    
                                    <?php if($sidebar_data): ?>
                                        <?php $__currentLoopData = $sidebar_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a href="<?php echo e(route('report_user',$side)); ?>" data-actor="<?php echo e($side); ?>"><i class="fa fa-eye"></i> <?php echo e(ucwords($side)); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                    <li><a href="<?php echo e(route('all_leave_application_report')); ?>"><i class="icon-disc"></i> Leave Application</a></li>
                                    <li><a href="<?php echo e(route('birthday_list')); ?>"><i class="icon-present"></i> Upcoming B-Day</a></li>
                                    
                                </ul>
                            </li> 

                            <li class="dropdown"><a href="#"><i class="icon-options"></i>Attendance</a>
                                <ul class="sub-menu">
                                    <li><a href="<?php echo e(route('attendance_sheet_import')); ?>"><i class="icon-energy"></i> Import Sheet</a></li>
                                    
                                </ul>
                            </li>
                            
                            <li class="dropdown"><a href="#"><i class="icon-options"></i>Pay-Roll</a>
                                <ul class="sub-menu">
                                    <li><a href="<?php echo e(route('payroller')); ?>"><i class="icon-energy"></i> Payrolls</a></li>
                                    <li><a href="<?php echo e(route('payslips')); ?>"><i class="icon-energy"></i>Payslips</a></li>
                                </ul>
                            </li>
                            
                        </ul>
                    </li>
                    <?php endif; ?>

                    <li class="dropdown"><a href="#"><i class="icon-layers mr-1"></i> Web Apps</a>                  
                        <ul>
                            <li class="dropdown"><a href="#"><i class="icon-options"></i>Leave Application</a>
                                <ul class="sub-menu">
                                    <li><a href="<?php echo e(route('leave_show')); ?>"><i class="icon-energy"></i> My Leave Application</a></li>
                                    <?php if(Auth::user()->role_id == 1 || Auth::user()->role_id == 2 || Auth::user()->role_id == 3 || Auth::user()->role_id == 36): ?>
                                    <li><a href="<?php echo e(route('leave_teamshow')); ?>"><i class="icon-energy"></i> Team Leave Application</a></li>
                                    <?php endif; ?>

                                    <?php if(Auth::user()->role_id == 1 || Auth::user()->role_id == 36): ?>
                                    <li><a href="<?php echo e(route('all_leave_application')); ?>"><i class="icon-energy"></i> All Leave Applications</a></li>
                                    <?php endif; ?>

                                </ul>
                            </li> 
                            <li><a href="<?php echo e(route('chat')); ?>"><i class="icon-speech"></i> Chat</a></li>
                        </ul>                   
                    </li>

                    
                </ul>
                <!-- END: Menu-->
                <ol class="breadcrumb bg-transparent align-self-center m-0 p-0 ml-auto">
                    <li class="breadcrumb-item"><a href="#">Application</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </div>
        </div><?php /**PATH D:\Projects\Github\HRM-Dashboard\resources\views/layouts/sidebar.blade.php ENDPATH**/ ?>