
<?php $__env->startSection('content'); ?>
<!-- Header End -->
<section class="view-cart">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="cart-vi">
                    <table>
                        <tr>
                            <th></th>
                            <th></th>
                            <th>Product</th>
                            <th>Price</th>
                            <th>Quantity</th>
                            <th>Subtotal</th>
                        </tr>
                        <form class="" id="" method="POST" enctype="multipart/form-data" action="<?php echo e(route('save_cart')); ?>">
                        <?php $__currentLoopData = $cart_arr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="cart_table">
                            <td>
                                <button id="" class="fa fa-times remove_cart" aria-hidden="true" data-product_id = "<?php echo e($cart['product_id']); ?>">
                                    <!-- <i class="fa fa-times" aria-hidden="true"></i> -->
                                </button>
                            </td>
                            <td>
                                <a href="#"><img src="<?php echo e(asset($cart['image'])); ?>" /></a>
                            </td>
                            <td><a href="#"><?php echo e($cart['name']); ?></a></td>
                            <td>$<?php echo e($cart['price']); ?></td>
                            <td>
                                <input type="hidden" name="product_id[]" class="product_id" value="<?php echo e($cart['product_id']); ?>" />
                                <input type="number" min="1" max="<?php echo e($cart['stock']); ?>" value="<?php echo e($cart['qty']); ?>" name="qty[]" class="qty" />
                            </td>
                            <td>$<?php echo e($cart['subtotal']); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </form>
                    </table>
                    <div class="cart-coupon">
                        <!-- <input type="text" name="" /> <a class="coupon res-btn" href="#">Apply Coupon</a> -->
                        <a class="update res-btn" id="update_cart" href="#">Update Cart</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="cart-totals">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6"></div>
            <div class="col-md-6">
                <div class="ct">
                    <div class="ct-heading">
                        <h3>Cart totals</h3>
                    </div>
                    <table>
                        <tr>
                            <td>Subtotal</td>
                            <td>$<?php echo e($cost); ?></td>
                        </tr>
                        <tr>
                            <td>Tax</td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>Total</td>
                            <td>$<?php echo e($cost); ?></td>
                        </tr>
                    </table>
                    <div class="proceed">
                        <a class="res-btn" href="<?php echo e(route('checkout')); ?>">Proceed to checkout</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="product-pagination">
    <?php echo $__env->make('web.layouts.products', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(".remove_cart").click(function(){
        var product_id = $(this).data("product_id");
        $.ajax({
            type: 'post',
            dataType : 'json',
            url: "<?php echo e(route('remove_cart')); ?>",        
            data: {product_id:product_id, _token: '<?php echo e(csrf_token()); ?>'},
            success: function (response) {
                if (response.status == 0) {
                    toastr.error(response.message);
                }else{
                    location.reload();
                    toastr.success(response.message);
                }
            }
        });
    })
    $("#update_cart").click(function(){
        var product_id = $("input[name='product_id[]']").map(function(){return $(this).val();}).get();
        var qty = $("input[name='qty[]']").map(function(){return $(this).val();}).get();
        console.log(product_id);
        console.log(qty);
        $.ajax({
            type: 'post',
            dataType : 'json',
            url: "<?php echo e(route('update_cart')); ?>",        
            data: {product_id:product_id, qty:qty, _token: '<?php echo e(csrf_token()); ?>'},
            success: function (response) {
                if (response.status == 0) {
                    toastr.error(response.message);
                }else{
                    location.reload();
                    toastr.success(response.message);
                }
            }
        });
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shop.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\bbsports\resources\views/shop/cart.blade.php ENDPATH**/ ?>