<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex,nofollow" />
    <title><?php echo e(isset($title) ? $title : 'Home | ' . env('APP_NAME')); ?></title>
    <meta name="description" content="<?php echo e(isset($meta_description) ? $meta_description : ''); ?>">
    <meta name="keywords" content="<?php echo e(isset($meta_keywords) ? $meta_keywords : ''); ?>">
    <meta name="author" content="Admin">
    <meta property="og:image" content="<?php echo e(asset($blog_image ?? '')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset($blog_image ?? '')); ?>">
    <link rel="canonical" href="<?php echo e(url(isset($canonical) ? $canonical : 'https://medicalcarebilling.com/blog/')); ?>">

    <?php echo $__env->make('web.layouts.links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('css'); ?>

    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "ProfessionalService",
            "name": "Medical Care Billing",
            "image": "https://medicalcarebilling.com/assets/images/logo.png",
            "@id": "https://medicalcarebilling.com/",
            "url": "https://medicalcarebilling.com/",
            "telephone": "(619) 393-5052",
            "address": {
                "@type": "PostalAddress",
                "streetAddress": "5005 Texas St #301",
                "addressLocality": "San Diego",
                "addressRegion": "CA",
                "postalCode": "92108",
                "addressCountry": "US"
            },
            "geo": {
                "@type": "GeoCoordinates",
                "latitude": 32.7669716,
                "longitude": -117.1384906
            },
            "sameAs": [
                "www.facebook.com/medicalcarebilling",
                "www.instagram.com/medicalcarebilling",
                "www.linkedin.com/company/medical-care-billing",
                "www.pinterest.com/medicalcarebillingus/"
            ]
        }
        </script>

    <!-- Google Tag Manager -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-T8GNNMJG');
    </script>
    <!-- End Google Tag Manager -->
</head>

<body>
    <!-- Google Tag Manager (noscript) -->
    <noscript>
        <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T8GNNMJG" height="0" width="0"
            style="display:none;visibility:hidden">
        </iframe>
    </noscript>
    <!-- End Google Tag Manager (noscript) -->
    <main>
        <?php echo $__env->make('web.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('web.layouts.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/demodesignproboa/public_html/ebookghostwriting-services/blogs/resources/views/web/layouts/main.blade.php ENDPATH**/ ?>