@extends('web.layouts.main')
@section('content')
    <main>
        <section class="home-banner-sec blog-sec" style="background-image: url({{ asset(getCMS('blog-detail-banner-image', 'value')) }});">
            <div class="container">
                <div class="row justify-content-between">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                        <div class="banner-content">
                            <h1>Blog</h1>
                            <div>
                                <a href="/">Home</a>
                                <i class="fa-solid fa-arrow-right"></i>
                                <a href="{{route('blog')}}">Blog</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="sectionTwelve-wrap py-5">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                        <div class="head">
                            <!--<h2>Uncover Expert Tips with Medical Care Billing</h2>-->
                            <!--<p>At Medical Care Billing, we provide all the essential knowledge you need to lead a successful healthcare organization. Dive into our blog for expert advice, innovative strategies, and the latest trends that will help you excel in your practice.</p>-->
                        </div>
                    </div>
                </div>
                <div class="row">
                    @foreach ($blogs as $blog)
                        <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                            <div class="blog-card my-3">
                                <div class="main-img">
                                    <img src="{{ asset($blog->image) }}" alt="img" class="img-fluid">
                                </div>
                                <div class="desc">
                                    <h4>{{ $blog->name }}</h4>
                                    <p>{{ $blog->short_desc }}</p>
                                    <div class="btn-box">
                                        <a href="{{ route('blog.detail', $blog->url) }}"
                                            class="btn btn-gradient hvr-bounce-to-left btn-wh">
                                            Read more
                                            <i class="fa-solid fa-arrow-right"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                {{-- <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="load-more-btn">
                            <button class="loadmore-btn" id="load_more">Load More</button>
                        </div>
                    </div>
                </div> --}}
            </div>
        </section>
    </main>
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            var size_li = $(".listing").length;
            var x = 4;
            $('.listing').hide();
            $('.listing:lt(' + x + ')').show();
            $('#load_more').click(function() {
                x = (x + 4 <= size_li) ? x + 4 : size_li;
                $('.listing:lt(' + x + ')').show();
            });
        });
    </script>
@endsection
