<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <meta name="google-site-verification" content="mOEWkJeZ_EQ-mOLQXdgyRxmeZu_Ln-zMjKXq8y346NY" />

    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "ProfessionalService",
        "name": "Medical Care Billing",
        "image": "https://medicalcarebilling.com/assets/images/logo.png",
        "@id": "https://medicalcarebilling.com/",
        "url": "https://medicalcarebilling.com/",
        "telephone": "(619) 393-5052",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "5005 Texas St #301",
            "addressLocality": "San Diego",
            "addressRegion": "CA",
            "postalCode": "92108",
            "addressCountry": "US"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": 32.7669716,
            "longitude": -117.1384906
        },
        "sameAs": [
            "www.facebook.com/medicalcarebilling",
            "www.instagram.com/medicalcarebilling",
            "www.linkedin.com/company/medical-care-billing",
            "www.pinterest.com/medicalcarebillingus/"
        ]
    }
    </script>

    <!-- Google Tag Manager -->
    <script>
    (function(w, d, s, l, i) {
        w[l] = w[l] || [];
        w[l].push({
            'gtm.start': new Date().getTime(),
            event: 'gtm.js'
        });
        var f = d.getElementsByTagName(s)[0],
            j = d.createElement(s),
            dl = l != 'dataLayer' ? '&l=' + l : '';
        j.async = true;
        j.src =
            'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
        f.parentNode.insertBefore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-T8GNNMJG');
    </script>
    <!-- End Google Tag Manager -->
<link rel="canonical" href="https://medicalcarebilling.com/">
<link rel="icon" href="https://medicalcarebilling.com/assets/images/fav.png" type="image/png" sizes="">
<link rel="stylesheet" href="https://medicalcarebilling.com/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="https://medicalcarebilling.com/assets/css/owl.theme.default.min.css" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
<link href="https://site-assets.fontawesome.com/releases/v6.0.0/css/all.css" rel="stylesheet">
<link rel="stylesheet" href="assets/css/owl.carousel.min.css" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
<link href="https://medicalcarebilling.com/assets/css/custom.css" rel="stylesheet" type="text/css">
<link href="https://medicalcarebilling.com/assets/css/responsive.css" rel="stylesheet" type="text/css"></head>

<body>

    <section class="sectionTwelve-wrap">
        <div class="container">
            <div class="row">
                @foreach ($blogs as $blog)
                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="blog-card">
                            <div class="main-img">
                                <img src="{{ asset($blog->image) }}" alt="img" class="img-fluid">
                            </div>
                            <div class="desc">
                                <h4>{{ $blog->name }}</h4>
                                <p>{{ $blog->short_desc }}</p>
                                <div class="btn-box">
                                    <a href="{{ route('blog.detail', $blog->url) }}" target='_blank'
                                        class="btn btn-gradient hvr-bounce-to-left btn-wh">
                                        Read more
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

<script src="https://medicalcarebilling.com/assets/js/jquery-3.6.1.min.js"></script>
<script src="https://medicalcarebilling.com/assets/js/bootstrap.min.js"></script>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script src="https://code.jquery.com/ui/1.13.0-rc.3/jquery-ui.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.0/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
<script src="https://medicalcarebilling.com/assets/js/owl.carousel.min.js"></script>
<script src="https://medicalcarebilling.com/assets/js/custom.js"></script>
<script src="https://unpkg.com/aos@next/dist/aos.js"></script>
  <script>
    AOS.init();
  </script></body>

</html>