<?php
namespace App\Http\Controllers;
use App\Models\blogs;
use App\Models\category;
use App\Models\newsletter;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

// use Auth;


class IndexController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function blog($slug = "")
    {
        $allCategory = category::active()->latest('id')->get();
        $category = category::active()->first();
        if (isset($slug) && $slug != "") {
            $category = category::where('url', $slug)->first();
        }
        $blogs = blogs::where('is_active',1)->where('is_deleted',0)->latest('id')->get();
        
        $recentBlogs = blogs::active()->where('category_id','!=',$category->id)->latest('id')->take(2)->get();

        return view('web.pages.blogs', compact('allCategory', 'blogs','recentBlogs','category'))
        ->with('title', 'Expert Insights & Tips About Medical Care Billing')
        ->with('meta_description', 'Explore expert insights, practical tips, and the latest trends in healthcare billing. Stay informed and elevate your practice with Medical Care Billing.');
    }

    public function blogInHml() {
        $blogs = blogs::latest('id')->get();
        return view('web.pages.blogHtml', compact('blogs'))
        ->with('title', 'Expert Insights & Tips About Medical Care Billing')
        ->with('meta_description', 'Explore expert insights, practical tips, and the latest trends in healthcare billing. Stay informed and elevate your practice with Medical Care Billing.');
    }

    public function blog_detail($slug)
    {
        $blog = blogs::where('url', $slug)->first();
        $category = category::active()->latest('id')->get();

        if (!$blog) {
            abort(404);
        }
        $related = blogs::active()->where('category_id', $blog->category_id)->where('id', '!=', $blog->id)->get();
        return view('web.pages.blog_detail', compact('blog', 'related','category'))->with('title', $blog->meta_title)->with('meta_description', $blog->meta_description)->with('meta_keywords', $blog->meta_keywords)->with('blog_image', $blog->image)->with('canonical', $blog->url);
    }
    public function newsletter(Request $request)
    {
        $check = newsletter::where('email',$request->email)->first();
        if ($check) {
            return back()->with('warning','Email is already Subscribed');
        }
        $newsletter = new newsletter();
        $newsletter->email = $request->email;
        $newsletter->save();
        return back()->with('message','Subscribed Successfully');
    }
    public function login()
    {
        if (Auth::check()) {

            return redirect()->route('dashboard');
        }
        return view('auth.login');
    }
}
