<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use App\Http\Requests\RequestAttributes;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\attributes;
use App\Models\blogs;
use App\Models\role_assign;
use App\Models\category;
use Exception;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class GenericController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('adminy');
        $user = Helper::curren_user();
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function roles()
    {
        $user = Auth::user();
        if ($user->role_id != 1) {
            return redirect()->back()->with('error', "No Link found");
        }
        $attributes = attributes::where('is_active', 1)->get();
        $role_assign = role_assign::where('is_active', 1)->where("role_id", $user->role_id)->first();

        return view('roles/roles')->with(compact('attributes', 'role_assign'));
    }

    public function generic_submit(RequestAttributes $request)
    {
        $token_ignore = ['_token' => '', 'type' => ''];
        $post_feilds = array_diff_key($_POST, $token_ignore);

        try {
            attributes::insert($post_feilds);
            return redirect()->back()->with('message', 'Information updated successfully');
        } catch (Exception $e) {
            return redirect()->back()->with('error', 'Error will saving record');
        }
    }

    public function role_assign_modal()
    {
        $user = Auth::user();
        $role_assign = role_assign::where('is_active', 1)->where("role_id", $_POST['role_id'])->orderBy('id', 'desc')->first();
        $att_tag = attributes::where('is_active', 1)->select('attribute')->distinct()->get();
        $body = "";
        if ($att_tag) {
            $route = route('roleassign_submit');
            $body .= "<input type='hidden' name='role_id' id='fetch-role-id' value='" . $_POST['role_id'] . "'>";
            if ($role_assign && $role_assign->assignee != 'N;') {
                $checker = unserialize($role_assign->assignee);
                $body .= "<input type='hidden' name='record_id' value='" . $role_assign->id . "'>";
            } else {
                $checker = [];
            }
            foreach ($att_tag as $key => $role) {
                $body .= "<tr><td>" . ucwords($role->attribute) . "</td><td><div class='custom-control custom-checkbox'>
                                  <input type='checkbox' name='assignee[]' class='custom-control-input' id='customCheck1" . $key . "' ";
                if (in_array($role->attribute . "_1", $checker)) {
                    $body .= "checked";
                }
                $body .= " value='" . $role->attribute . "_1'>
                                  <label class='custom-control-label' for='customCheck1" . $key . "'>1</label></div></td>
                            
                            <td><div class='custom-control custom-checkbox'>
                                  <input type='checkbox' name='assignee[]' class='custom-control-input' id='customCheck2" . $key . "' ";
                if (in_array($role->attribute . "_2", $checker)) {
                    $body .= "checked";
                }
                $body .= " value='" . $role->attribute . "_2'>
                                  <label class='custom-control-label' for='customCheck2" . $key . "'>2</label></div></td>

                            <td><div class='custom-control custom-checkbox'>
                                  <input type='checkbox' name='assignee[]' class='custom-control-input' id='customCheck3" . $key . "' ";
                if (in_array($role->attribute . "_3", $checker)) {
                    $body .= "checked";
                }
                $body .= " value='" . $role->attribute . "_3'>
                                  <label class='custom-control-label' for='customCheck3" . $key . "'>3</label></div></td>

                            <td><div class='custom-control custom-checkbox'>
                                  <input type='checkbox' name='assignee[]' class='custom-control-input' id='customCheck4" . $key . "' ";
                if (in_array($role->attribute . "_4", $checker)) {
                    $body .= "checked";
                }
                $body .= " value='" . $role->attribute . "_4'>
                                  <label class='custom-control-label' for='customCheck4" . $key . "'>4</label></div></td></tr>";
            }
        }

        $bod['body'] = $body;
        $response = json_encode($bod);
        return $response;
    }

    public function roleassign_submit(Request $request)
    {
        if (isset($request->record_id) && $request->record_id != 0) {
            $role_assign = role_assign::where('is_active', 1)->where("id", $request->record_id)->first();
        } else {
            $role_assign = new role_assign;
            $role_assign->role_id = $request->role_id;
        }

        $role_assign->assignee = serialize($request->assignee);
        $role_assign->save();
        return redirect()->back()->with('message', 'Role has been assigned successfully');
    }

    public function listing($slug = '')
    {
        $user = Auth::user();
        $role_assign = role_assign::where('is_active', 1)->where("role_id", $user->role_id)->first();
        if ($role_assign) {
            $validator = Helper::check_rights($slug);
            if (is_null($validator)) {
                return redirect()->back()->with('error', "Don't have sufficient rights to access this page");
            }
        } else {
            return redirect()->back()->with('error', "Don't have sufficient rights to access this page");
        }

        $form = null;
        $table = null;
        $eloquent = '';
        if ($slug == "roles") {
            $attributes = attributes::where('is_active', 1)->where('attribute', $slug)->get();
        } else {
            $attributes = attributes::where('is_active', 1)->where('attribute', $slug)->get();
            $get_eloquent = attributes::where('is_active', 1)->where('attribute', $slug)->first();
            $eloquent = ($get_eloquent->model != '') ? $get_eloquent->model : '';

            if ($eloquent != '') {
                $form = $this->generated_form($slug);
                $table = $this->generated_table($slug);
            }
        }
        return view('roles/crud')->with(compact('attributes', 'slug', 'eloquent', 'form', 'table'))->with('title',ucwords(str_replace('-',' ',$slug)));
    }

    private function generated_form($slug = '')
    {
        $body = '';

        if ($slug == 'brand') {
            $route_url = route('crud_generator', $slug);
            $body = '<form  id="generic-form" enctype="multipart/form-data" method="POST" action="' . $route_url . '">
                    <input type="hidden" name="_token" value="' . csrf_token() . '">
                    <input type="hidden" name="record_id" id="record_id" value="">
                    <div class="row">
                        <div id="assignrole"></div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Name:</label>
                                <div class="d-flex">
                                    <input id="name" placeholder="Name" name="name" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Image:</label>
                                <div class="d-flex">
                                    <input type="file" id="image" accept="image/*" name="image" class="form-control" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>';
            return $body;
        } elseif ($slug == 'category') {
            $route_url = route('crud_generator', $slug);
            $body = '<form  id="generic-form" enctype="multipart/form-data" method="POST" action="' . $route_url . '">
                    <input type="hidden" name="_token" value="' . csrf_token() . '">
                    <input type="hidden" name="record_id" id="record_id" value="">
                    <div class="row">
                        <div id="assignrole"></div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Name:</label>
                                <div class="d-flex">
                                    <input id="name" placeholder="Name" name="name" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Meta Title:</label>
                                <div class="d-flex">
                                    <input id="meta_title" placeholder="Meta Title" name="meta_title" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Meta Description:</label>
                                <div class="d-flex">
                                    <input id="meta_description" placeholder="Meta Description" name="meta_description" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Meta Keywords:</label>
                                <div class="d-flex">
                                    <input id="meta_keywords" placeholder="Meta Keywords" name="meta_keywords" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >URL:</label>
                                <div class="d-flex">
                                    <input id="url" placeholder="URL" name="url" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>';
            return $body;
        } elseif ($slug == 'blogs') {
            $route_url = route('crud_generator', $slug);
            $body = '<form  id="generic-form" enctype="multipart/form-data" method="POST" action="' . $route_url . '">
                    <input type="hidden" name="_token" value="' . csrf_token() . '">
                    <input type="hidden" name="record_id" id="record_id" value="">
                    <div class="row">
                        <div id="assignrole"></div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Category:</label>
                                <div class="d-flex">
                                    <select name="category_id" id="category_id" class="form-control profession category_id" required value="">
                                        <option selected="true" disabled="disabled" >Select Category</option>';
                                    $category = category::active()->get();
                                    if ($category) {
                                        foreach ($category as $k => $val) {
                                            $body .= '<option value="' . $val->id . '">' . $val->name . '</option>';
                                        }
                                    }
                                    $body .= '</select>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Name:</label>
                                <div class="d-flex">
                                    <input id="name" placeholder="Name" name="name" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Image:</label>
                                <div class="d-flex">
                                    <input type="file" id="image" accept="image/*" name="image" class="form-control" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <div class="d-flex">
                                    <td><img id="image-add" style="height:80px;display:none;" src=""></td>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Meta Title:</label>
                                <div class="d-flex">
                                    <input id="meta_title" placeholder="Meta Title" name="meta_title" class="form-control" type="text" autocomplete="off" />
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Meta Description:</label>
                                <div class="d-flex">
                                    <input id="meta_description" placeholder="Meta Description" name="meta_description" class="form-control" type="text" autocomplete="off" />
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >Meta Keywords:</label>
                                <div class="d-flex">
                                    <input id="meta_keywords" placeholder="Meta Keywords" name="meta_keywords" class="form-control" type="text" autocomplete="off" />
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group start-date">
                                <label >URL:</label>
                                <div class="d-flex">
                                    <input id="url" placeholder="URL" name="url" class="form-control" type="text" autocomplete="off" required/>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group end-date">
                                <label for="end-date" >Short Description:</label>
                                <div class="d-flex">
                                    <textarea id="short_desc" required name="short_desc" class="form-control" ></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-12 col-lg-12 col-xl-12 col-xxl-12" >
                            <div class="form-group end-date">
                                <label for="end-date" >Description:</label>
                                <div class="">
                                    <textarea id="description" name="description" class="form-control tinyEditor" ></textarea>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </form>';
            return $body;
        } else {
            return $body;
        }
    }

    private function generated_table($slug = '')
    {


        $body = '';
        if ($slug == "brand") {
            $data = 'App\Models\\' . $slug;
            $loop = $data::where("is_active", 1)->where("is_deleted", 0)->get();
            if ($loop) {
                $body = '<thead>
                                       <tr>
                                          <th>S. No</th>
                                          <th>Name</th>
                                          <th>Image</th>
                                          <th>Creation Date</th>';
                if (Helper::can_edit($slug) || Helper::can_delete($slug)) {
                    $body .= '<th>Action</th>';
                }
                $body .= '
                                       </tr>
                                    </thead>
                                    <tbody>';
                if ($loop) {
                    foreach ($loop as $key => $val) {
                        $i = asset($val->image);
                        $body .= '<tr>
                                          <td>' . ++$key . '</td> 
                                          <td>' . $val->name . '</td> 
                                          <td><img style="width:80px;height:80px;" src="' . $i . '"></td>
                                          <td>' . date("M d,Y", strtotime($val->created_at)) . '</td>';
                        if (Helper::can_edit($slug) || Helper::can_delete($slug)) {
                            $body .= '<td>';
                            if (Helper::can_edit($slug)) {
                                $body .= '<button type="button" class="btn btn-primary editor-form" data-edit_id= "' . $val->id . '" data-name= "' . $val->name . '" >Edit</button>';
                            }
                            if (Helper::can_delete($slug)) {
                                $body .= '<button type="button" class="btn btn-danger delete-record" data-model="' . $data . '" data-id= "' . $val->id . '" >Delete</button>';
                            }

                            $body .= '</td>';
                        }
                        $body .= '</tr>';
                    }
                }
                $body .= '</tbody>
                                    <tfoot>
                                        <tr>
                                            <th>S. No</th>
                                            <th>Name</th>
                                            <th>Image</th>
                                            <th>Creation Date</th>';
                if (Helper::can_edit($slug) || Helper::can_delete($slug)) {
                    $body .= '<th>Action</th>';
                }
                $body .= '
                                        </tr>
                                    </tfoot>';
            }
            $script = '$("body").on("click" ,".editor-form",function(){
                                                $("#name").val($(this).data("name"))
                                                $("#record_id").val($(this).data("edit_id"))
                                                $("#addevent").modal("show")
                                            })';
            $resp['body'] = $body;
            $resp['script'] = $script;
            return $resp;
        } elseif ($slug == "category") {
            $data = 'App\Models\\' . $slug;
            $loop = $data::where("is_active", 1)->where("is_deleted", 0)->orderBy('id','desc')->get();
            if ($loop) {
                $body = '<thead>
                                       <tr>
                                          <th>S. No</th>
                                          <th>Name</th>
                                          <th>Meta Title</th>
                                          <th>Meta Description</th>
                                          <th>Meta Keywords</th>
                                          <th>URL</th>
                                          <th>Creation Date</th>
                                          <th>Action</th>
                                       </tr>
                                    </thead>
                                    <tbody>';
                if ($loop) {
                    foreach ($loop as $key => $val) {
                        $body .= '<tr>
                                          <td>' . ++$key . '</td> 
                                          <td>' . $val->name . '</td> 
                                          <td>' . $val->meta_title . '</td> 
                                          <td>' . $val->meta_description . '</td>
                                          <td>' . $val->meta_keywords . '</td>
                                          <td>' . $val->url . '</td> 
                                          <td>' . date("M d,Y", strtotime($val->created_at)) . '</td>
                                          <td>
                                             <button type="button" class="btn btn-primary editor-form" data-edit_id= "' . $val->id . '" data-name= "' . $val->name . '" data-meta_title= "' . $val->meta_title . '" data-meta_description= "' . $val->meta_description . '" data-meta_keywords= "' . $val->meta_keywords . '" data-url= "' . $val->url . '" >Edit</button>
                                             <button type="button" class="btn btn-danger delete-record" data-model="' . $data . '" data-id= "' . $val->id . '" >Delete</button>
                                          </td>
                                       </tr>';
                    }
                }
                $body .= '</tbody>
                                    <tfoot>
                                       <tr>
                                        <th>S. No</th>
                                        <th>Name</th>
                                        <th>Meta Title</th>
                                        <th>Meta Description</th>
                                        <th>URL</th>
                                        <th>Creation Date</th>
                                        <th>Action</th>
                                       </tr>
                                    </tfoot>';
            }
            $script = '$("body").on("click" ,".editor-form",function(){
                                                $("#name").val($(this).data("name"))
                                                $("#record_id").val($(this).data("edit_id"))
                                                $("#addevent").modal("show")
                                            })';
            $resp['body'] = $body;
            $resp['script'] = $script;
            return $resp;
        } elseif ($slug == "newsletter") {
            $data = 'App\Models\\' . $slug;
            $loop = $data::where("is_active", 1)->where("is_deleted", 0)->orderBy('id','desc')->get();
            if ($loop) {
                $body = '<thead>
                                       <tr>
                                          <th>S. No</th>
                                          <th>Email</th>
                                          <th>Creation Date</th>
                                       </tr>
                                    </thead>
                                    <tbody>';
                if ($loop) {
                    foreach ($loop as $key => $val) {
                        $body .= '<tr>
                                          <td>' . ++$key . '</td> 
                                          <td>' . $val->email . '</td> 
                                          <td>' . date("M d,Y", strtotime($val->created_at)) . '</td>
                                       </tr>';
                    }
                }
                $body .= '</tbody>
                                    <tfoot>
                                       <tr>
                                       <th>S. No</th>
                                       <th>Email</th>
                                       <th>Creation Date</th>
                                       </tr>
                                    </tfoot>';
            }
            $script = '';
            $resp['body'] = $body;
            $resp['script'] = $script;
            return $resp;
        } elseif ($slug == "blogs") {
            $data = 'App\Models\\' . $slug;
            $loop = $data::where("is_active", 1)->where("is_deleted", 0)->orderBy('id','desc')->get();
            if ($loop) {
                $body = '<thead>
                                       <tr>
                                          <th>S. No</th>
                                          <th>Category</th>
                                          <th>Name</th>
                                          <th>Image</th>
                                          <th>Meta Title</th>
                                          <th>Meta Description</th>
                                          <th>Meta Keywords</th>
                                          <th>URL</th>
                                          <th>Short Description</th>
                                          <th>Creation Date</th>
                                          <th>Action</th>
                                       </tr>
                                    </thead>
                                    <tbody>';
                if ($loop) {
                    foreach ($loop as $key => $val) {
                        $body .= '<tr>
                                          <td>' . ++$key . '</td> 
                                          <td>' . $val->getCategory->name . '</td> 
                                          <td>' . $val->name . '</td> 
                                          <td><img style="height:80px;" src="' . asset($val->image) . '"></td>
                                          <td>' . $val->meta_title . '</td> 
                                          <td>' . $val->meta_description . '</td> 
                                          <td>' . $val->meta_keywords . '</td>
                                          <td>' . $val->url . '</td> 
                                          <td>' . $val->short_desc . '</td> 
                                          <td>' . date("M d,Y", strtotime($val->created_at)) . '</td>
                                          <td>
                                             <button type="button" class="btn btn-primary editor-form" data-edit_id= "' . $val->id . '" >Edit</button>
                                             <button type="button" class="btn btn-danger delete-record" data-model="' . $data . '" data-id= "' . $val->id . '" >Delete</button>
                                          </td>
                                       </tr>';
                    }
                }
                $body .= '</tbody>
                                    <tfoot>
                                       <tr>
                                       <th>S. No</th>
                                       <th>Category</th>
                                       <th>Name</th>
                                       <th>Image</th>
                                       <th>Meta Title</th>
                                       <th>Meta Description</th>
                                       <th>Meta Keywords</th>
                                       <th>URL</th>
                                       <th>Short Description</th>
                                       <th>Creation Date</th>
                                       <th>Action</th>
                                       </tr>
                                    </tfoot>';
            }
            $script = '';
            $resp['body'] = $body;
            $resp['script'] = $script;
            return $resp;
        } else {
            return $body;
        }
    }


    public function crud_generator($slug = '', Request $request)
    {
        $token_ignore = ['_token' => '', 'record_id' => '', 'image' => ''];
        $post_feilds = array_diff_key($_POST, $token_ignore);
        $data = 'App\Models\\' . $slug;

        if (isset($request->image)) {
            $file = $request->image;
            $file_name = $request->image->getClientOriginalName();
            $file_name = substr($file_name, 0, strpos($file_name, "."));
            $name = "uploads/product/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();
            $destinationPath = public_path() . '/uploads/product/';
            $request->image->move($destinationPath, $name);
            $post_feilds['image'] = $name;
        }
        if ($slug == 'category' || $slug == 'blogs') {
            $check_record = $data::where('is_active', 1)->where('url', $post_feilds['url']);
            if (isset($_POST['record_id']) && $_POST['record_id'] != '') {
                $check_record = $check_record->where('id','!=',$_POST['record_id']);
            }
            $check_record = $check_record->first();
            if ($check_record) {
                $msg = "This ". ucwords(str_replace('-',' ',$slug)) ." already exists";
                return redirect()->back()->with('error', $msg);
            }
        }
        try {
            if (isset($_POST['record_id']) && $_POST['record_id'] != '') {
                $create = $data::where("id", $_POST['record_id'])->update($post_feilds);
                $msg = "Record has been updated";
            } else {
                
                $create = $data::create($post_feilds);
                $msg = "Record has been created";
            }
            return redirect()->back()->with('message', $msg);
        } catch (Exception $e) {
            $error = $e->getMessage();
            return redirect()->back()->with('error', "Error Code: " . $error);
        }
    }
    public function delete_record(Request $request)
    {
        $token_ignore = ['_token' => '', 'id' => '', 'model' => ''];
        $post_feilds = array_diff_key($_POST, $token_ignore);
        $data = $_POST['model'];
        try {
            $update = $data::where("id", $_POST['id'])->update($post_feilds);
            $status['message'] = "Record has been deleted";
            $status['status'] = 1;
            return json_encode($status);
        } catch (Exception $e) {
            $error = $e->getMessage();
            $status['message'] = $error;
            $status['status'] = 0;
            return json_encode($status);
        }
    }

    public function get_blog_data(Request $request)
    {
        $blog = blogs::findOrFail($request->record_id);
        $blog->image = asset($blog->image);
        return json_encode($blog);
    }
}
