{{ ucfunc("put_docready_start") }}

  gsap.registerPlugin(ScrollTrigger);
  const container = document.querySelector('#{{uc_id}}');
  const canvas = document.querySelector("#{{uc_id}} .sequence");
  const context = canvas.getContext("2d");
  let images = [];
  let frames = { frame: 0 };
  
  function getScreenWidth(){
    var windowWidth = screen.width;
    var device;
    
    if(windowWidth > 1024)
      device = "desktop";
    
    if(windowWidth > 767 && windowWidth <= 1024)
      device = "tablet";
    
    if(windowWidth <= 767)
      device = "mobile";
    
    return(device);
  }


  function run(mode){
	
    switch ( mode || getScreenWidth() ) {
      case 'desktop':
        initDesktop();
        break;
      case 'tablet':
        {% if tablet_folder_url is not empty %}
          initTablet();
          break;
        {% endif %}	
      case 'mobile':
        {% if mobile_folder_url is not empty %}
          initMobile();
          break;
        {% endif %}	
      default:
        initDesktop();
        break;
    }
  }
	
  function initDesktop(){
    
      function render() {
        context.clearRect(0, 0, canvas.width, canvas.height);
        context.drawImage(images[frames.frame], {{image_horizontal_shift_desktop_nounit}}, 0); 
      }
		
      images = [];
      frames.frame = 0;
      canvas.width = {{canvas_width}};
      canvas.height = {{canvas_height}};
      const frameCount = {{image_count}};
      const currentFrame = index => (`{{folder_url|raw}}{{file_name|raw}}${(index + 1).toString().padStart({{file_name_prefix_padding}}, '0')}.{{image_extention|raw}}`);

      for (let i = 0; i < frameCount; i++) {
        const img = new Image();
        img.src = currentFrame(i);
        images.push(img);
        if( i === 0 ) { images[0].onload = render; }
      }

      gsap.to(frames, {
        frame: frameCount - 1,
        snap: "frame",
        scrollTrigger: {
          scrub: {{scrub}},
          pin: canvas, 
          start: "top {{start_location}}%",
          end: "bottom {{end_location}}%",
          markers: {{show_markers}},
          id: "{{marker_id|raw}}"
        },
        onUpdate: render 
      });
  }

  function initMobile(){
    
      function render() {
        context.clearRect(0, 0, canvas.width, canvas.height);
        context.drawImage(images[frames.frame], {{image_horizontal_shift_mobile_nounit}}, 0); 
      }
    
      images = [];
      frames.frame = 0;

      canvas.width = {{mobile_canvas_width}};
      canvas.height = {{mobile_canvas_height}};
      const frameCount = {{mobile_image_count}};
      const currentFrame = index => (`{{mobile_folder_url|raw}}{{file_name_mobile|raw}}${(index + 1).toString().padStart({{mobile_file_name_prefix_padding}}, '0')}.{{image_extention|raw}}`);

      for (let i = 0; i < frameCount; i++) {
        const img = new Image();
        img.src = currentFrame(i);
        images.push(img);
		if( i === 0 ) { images[0].onload = render; }
      }

      gsap.to(frames, {
        frame: frameCount - 1,
        snap: "frame",
        scrollTrigger: {
          scrub: {{mobile_scrub}},
          pin: canvas, 
          start: "top {{mobile_start_location}}%",
          end: "bottom {{mobile_end_location}}%",
          markers: {{mobile_show_markers}},
          id: "{{mobile_marker_id|raw}}"
        },
        onUpdate: render 
      });
  }
  
  function initTablet(){

      function render() {
        context.clearRect(0, 0, canvas.width, canvas.height);
        context.drawImage(images[frames.frame], {{image_horizontal_shift_tab_nounit}}, 0); 
      }

	  images = [];
      frames.frame = 0;

      canvas.width = {{tablet_canvas_width}};
      canvas.height = {{tablet_canvas_height}};
      const frameCount = {{tablet_image_count}};
      const currentFrame = index => (`{{tablet_folder_url|raw}}{{file_name_tab|raw}}${(index + 1).toString().padStart({{tablet_file_name_prefix_padding}}, '0')}.{{image_extention|raw}}`);

      for (let i = 0; i < frameCount; i++) {
        const img = new Image();
        img.src = currentFrame(i);
        images.push(img);
		if( i === 0 ) { images[0].onload = render; }
      }

      gsap.to(frames, {
        frame: frameCount - 1,
        snap: "frame",
        scrollTrigger: {
          scrub: {{tablet_scrub}},
          pin: canvas, 
          start: "top {{tablet_start_location}}%",
          end: "bottom {{tablet_end_location}}%",
          markers: {{tablet_show_markers}},
          id: "{{tablet_marker_id|raw}}"
        },
        onUpdate: render 
      });
  }

  function observePreview(){

	const config = { attributes: true };
	const callback = function(mutationsList, observer) {
    console.log(mutationsList);
      for(let mutation of mutationsList) {
         if ( mutation.attributeName === 'class' ) {
			if ( mutation.target.classList.contains('elementor-device-desktop') ) { return run('desktop') };
			if ( mutation.target.classList.contains('elementor-device-tablet') ) { return run('tablet') };
			if ( mutation.target.classList.contains('elementor-device-mobile') ) { return run('mobile') };
				
			}
		 }
	};

    const observer = new MutationObserver(callback)
    observer.observe(elementor.$previewResponsiveWrapper.find('iframe').contents().find('body')[0], config);
 }

		
  if ( elementorFrontend.config.environmentMode.edit && elementor.loaded ) {
	observePreview();
	run(null);
  }else{
    run(null);
  }

{{ ucfunc("put_docready_end") }}