<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="assets/images/logo.png" />
    <title>Add New Order</title>
    <?php
    include 'includes/css.php';
    ?>
</head>

<body class="sidebar-nonactive">

    <?php
include 'includes/header.php';
?>
    <main>
        <?php
include 'includes/sidebar.php';
?>
        <section class="sec-main">
            <div class="container-fluid">
                <div class="inner-area">
                    <div class="project-add-area">
                        <div class="container-ct">
                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="card multi-card project-card">
                                        <div class="top-area">
                                            <h4>🧑‍⚕️ Dentist Information</h4>
                                        </div>
                                        <div class="form-main">
                                            <form action="">
                                                <div class="row">
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Dentist Name</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter Dentist Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Clinic Name</label>
                                                            <input type="text" class="form-control ct-fm unit-icon"
                                                                placeholder="Enter Clinic Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Email Address</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter Email Address">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Phone Number</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter Phone Number">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Shipping Address</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter Shipping Address">
                                                        </div>
                                                    </div>
                                                    <br><br><br><br><br>
                                                    <hr>
                                                    <div class="top-area">
                                                      <h4>🧵 Patient Case Details</h4>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Patient Name</label>
                                                            <input type="text" class="form-control ct-fm"
                                                                placeholder="Enter Patient Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Case Type</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select Type</option>
                                                                <option value="Crown">Crown</option>
                                                                <option value="Bridge">Bridge</option>
                                                                <option value="Retainer">Retainer</option>
                                                                <option value="Night Guard">Night Guard</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Tooth Number(s)</label>
                                                            <input type="text" class="form-control ct-fm unit-icon"
                                                                placeholder="Enter Tooth Number(s)">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Notes/Instructions</label>
                                                            <textarea class="form-control ct-fm" style="height:185px" row="4" placeholder="Enter Notes/Instructions (e.g., shade, material preference, margins, etc.)"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Attach Documents</label>
                                                            <div class="file-upload-area">
                                                                <img src="assets/images/file.png"
                                                                    class="img-fluid upload-icon" alt="">
                                                                <span>Choose Patient Files (X-rays, scans, images, etc.)</span>
                                                                <button type="button" class="btn file-btn">
                                                                    Choose File
                                                                    <input type="file" class="file-upload"
                                                                        value="browse file" multiple>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br><br><br><br><br>
                                                    <hr>
                                                    <div class="top-area">
                                                      <h4>🛍️ Product Selection</h4>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Product Type</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select Type</option>
                                                                <option value="Zirconia Crown">Zirconia Crown</option>
                                                                <option value="Night Guard">Night Guard</option>
                                                                <option value="Aligners">Aligners</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Quantity</label>
                                                            <input type="number" class="form-control ct-fm"
                                                                placeholder="Enter Quantity">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Priority</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select Type</option>
                                                                <option value="Standard">Standard</option>
                                                                <option value="Rush Order">Rush Order</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Estimated Delivery Date</label>
                                                            <input type="text" class="form-control ct-fm calendar-icon"
                                                                placeholder="Select date" onfocus="(this.type='date')"
                                                                onblur="(this.type='text')">
                                                        </div>
                                                    </div>
                                                    <br><br><br><br><br>
                                                    <hr>
                                                    <div class="top-area">
                                                      <h4>📦 Shipping Options</h4>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Clinic Address</label>
                                                            <input type="text" class="form-control ct-fm" placeholder="Clinic Address">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">Delivery Option</label>
                                                            <select class="form-select ct-select"
                                                                aria-label="Default select example">
                                                                <option selected>Select Delivery Option</option>
                                                                <option value="Standard">Standard</option>
                                                                <option value="Express">Express</option>
                                                                <option value="Courier Pickup">Courier Pickup</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <br><br><br><br><br>
                                                    <hr>
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                                        <div class="inp-main">
                                                            <label for="" class="ct-lbl">💬 Additional Comments</label>
                                                            <textarea class="form-control ct-fm" style="height:185px" row="4" placeholder="Additional Comments"></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="margin-top: 50px;">
                                                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4 col-xxl-4">
                                                        <button type="submit" class="btn submit-btn">✅ Submit Request</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php
include 'includes/footer.php';
include 'includes/scripts.php';
?>
</body>

</html>