$(document).ready(function () {

  window.addEventListener("scroll", function () {
    var header = document.querySelector("header");
    header.classList.toggle("sticky", window.scrollY > 50);
    // header.classList.toggle("fixed-top",window.scrollY > 600);
  });

  var url = window.location.pathname;
  var fileName = url.substring(url.lastIndexOf('/') + 1);
  $(".main-ul .mn-item .mn-link").removeClass("mn-active");
  if (fileName == "") {
    fileName = "index.php"
  }
  $(`.main-ul .mn-item .mn-link[href="${fileName}"]`).addClass("mn-active")

  var accURL = window.location.pathname;
  var acc_File_name = accURL.substring(accURL.lastIndexOf('/') + 1);
  $(".prop-sidebar ul li a").removeClass("active-link");
  if (acc_File_name == "") {
    acc_File_name = "index.php"
  }
  $(`.prop-sidebar ul li a[href="${acc_File_name}"]`).addClass("active-link");

  function togglePassword(toggleClass) {
    $(document).on('click', toggleClass, function() {
      $(this).toggleClass("fa-eye fa-eye-slash");
      
      // Get the related input field using the data-toggle attribute
      var input = $(this).siblings('input'); 
      
      // Toggle the type attribute of the input field
      if (input.attr("type") === "password") {
        input.attr("type", "text");
      } else {
        input.attr("type", "password");
      }
    });
  }
  // Call the function for any class you want
  togglePassword('.toggle-password');


  $(".document-area .toggle-side").click(function () {
    
    $(".doc-side").toggleClass("side-open");
  });

  // global ct select box start
$('.ct-select .select-box').on('click', function() {
  $(this).next('.select-options').toggle().toggleClass("open");
});

$('.ct-select .select-options .option').on('click', function() {
  var value = $(this).attr('data-value');
  var text = $(this).text();
  $(this).closest('.ct-select').find('.selected-option').text(text);
  $(this).closest('.select-options').removeClass("open").hide();
  // Handle value selection (you can add your own logic here)
  console.log("Selected value:", value);
});

// Close the select box if clicked outside
$(document).on('click', function(e) {
  if (!$(e.target).closest('.ct-select').length) {
    $('.ct-select .select-options').hide();
  }
});

// global ct select box close

//   $('#ongoing-table').DataTable({
//     searching: false,
//     lengthChange: false ,
//     ordering: false,
//     info: false
// });

      function checkWidth() {
        var windowWidth = $(window).width();
        if (windowWidth >= 10 && windowWidth <= 1199) {
          $(".side-bar").addClass("sidebar-close");
        } else {
          $(".side-bar").removeClass("sidebar-close");
        }
      }
      checkWidth();
      $(window).resize(function () {
        checkWidth();
      });
    


  $('.sub-menu').hide();
  $('.menu-toggle').click(function () {
    var subMenu = $(this).next('.sub-menu');
    subMenu.slideToggle();
    $(this).toggleClass('toggle-active');
  });

  $('.side-bar .side-bar-toggle').click(function () {
    // Toggle the 'sidebar-active' class on the body
    $('body').toggleClass('sidebar-nonactive');

    // Toggle the 'sidebar-close' class on the side-bar
    $('.side-bar').toggleClass('sidebar-close');
  });

  // Will wait for everything on the page to load.
  $(window).bind('load', function () {
    $('.overlay, body').addClass('loaded');
    setTimeout(function () {
      $('.overlay').css({ 'display': 'none' })
    }, 2000)
  });

  // Will remove overlay after 1min for users cannnot load properly.
  setTimeout(function () {
    $('.overlay, body').addClass('loaded');
  }, 60000);
  });
//**********  chat js start here */
function ImageInput(element) {
  // Variables
  var $wrapper = element;
  var $file = $wrapper.querySelector('input[type=file]');
  var $input = $wrapper.querySelector('input[type=hidden]');
  var $img = $wrapper.querySelector('img');
  var maxSize = Number($file.getAttribute('max-size'));
  var types = $file.accept.split(',');

  var api = {
    onInvalid: onInvalid,
    onChanged: onChanged,
  };

  // Methods
  function fileHandler(e) {
    var file = $file.files.length && $file.files[0];

    if (!file) return;

    var errors = checkValidity(file);

    if (errors) {
      api.onInvalid(errors);
      $file.value = null;
      return;
    }

    api.onChanged(file, update, $wrapper)
  }

  function humanizeFormat(string) {
    return string.replace(/.*?\//, '');
  }

  function checkValidity(file) {
    var errors = [];

    types.includes(file.type) || errors.push('Format file harus: ' + types.map(humanizeFormat).join(', '));
    file.size < maxSize || errors.push('Ukuran file maksimal ' + maxSize / 1000000 + 'MB');

    return errors.length ? errors : false;
  }

  function getFileData(file, callback) {
    var reader = new FileReader();

    reader.addEventListener("load", function () {
      callback(reader.result);
    }, false);

    if (file) {
      reader.readAsDataURL(file);
    }
  }

  function update(data) {
    $img.src = data;
    $input.value = data;
  }

  function onInvalid(errors) {
    alert(errors.join('. '));
  }

  function onChanged(file, update, $wrapper) {
    console.log('.onChanged called');
    getFileData(file, update);
  }

  // Init
  $file.addEventListener('change', fileHandler);

  return api;
};

document.querySelectorAll('.image-input').forEach(_ => {
  var imageInput = new ImageInput(_);
  _.addEventListener("click", (e) => {
    if (e.target.classList.contains('image-remove')) {
      _.remove()
    }
  });



  if (_.classList.contains('withAjax')) {
    imageInput.onChanged = customOnChanged;

  }

  function customOnChanged(file, update, $el) {
    if (!$el.nextElementSibling) {
      var $remove = document.createElement('button');
      $remove.className = "image-remove";

      var $new = $el.cloneNode(true);
      $new.querySelector('input[type=hidden]').value = "";
      $new.querySelector('input[type=file]').value = "";
      $new.querySelector('img').src = "";

      $el.parentElement.append($new);
      $el.append($remove);

      var imageInput = new ImageInput($new);
      imageInput.onChanged = customOnChanged;
    }

    $el.classList.add('isUploading');
    setTimeout(function () {
      const reader = new FileReader();
      reader.onload = function (e) {
        const src = e.target.result;
        update(src);
      }
      reader.readAsDataURL(file);
      $el.classList.remove("isUploading");
    }, 500);

  };

});

$(document).on('click', '.upload-btn', function () {
  if ($('.file-attatch').css('display') == "none") {
    $('.file-attatch').css('display', 'flex')
  } else {
    $('.file-attatch').css('display', 'none')
  }
});

// $(document).on('click','.btn-send',function(){
//   console.log('here');
//   var input_val = $(this).closest('.form-group').find('input').val();
//   console.log(input_val);
// });

$(document).on('click', '#dropdownchat', function () {
  console.log('here');
  if ($('.chat-menu').css('display') == "none") {
    $('.chat-menu').css('display', 'block')
  } else {
    $('.chat-menu').css('display', 'none')
  }
});

$(document).on('click', '.user-card', function () {
  console.log('message show');
  if (window.matchMedia('(max-width: 767px)').matches) {
    // do functionality on screens smaller than 768px
    if ($('.messages-box').css('display') == "none") {
      $('.messages-box').css('display', 'flex')
    } else {
      $('.messages-box').css('display', 'none')
    }
    $(this).closest('.chat-main').find('.user-box').css('display', 'none');
  }
});

$(document).on('click', '.icon-back', function () {
  console.log('User show');
  if (window.matchMedia('(max-width: 767px)').matches) {
    // do functionality on screens smaller than 768px
    if ($('.user-box').css('display') == "none") {
      $('.user-box').css('display', 'block')
    } else {
      $('.user-box').css('display', 'none')
    }
    $(this).closest('.chat-main').find('.messages-box').css('display', 'none');
  }
});
//**********  chat js end here */



