$(document).ready(function () {
   // Sample data for the chart
const chartData1 = {
    weekdays: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday','Saturday','Sunday'],
    acceptedBids: [31, 40, 28, 51, 42, 109, 100],
    rejectedBids: [11, 32, 45, 32, 34, 52, 41],
    completedOrders: [11, 62, 15, 92, 104, 120, 90]
  };

  // Create the chart options1
  const options1 = {
    chart: {
        height: 423,
        type: 'area',
        toolbar: {
            show: false
          }
    },
    dataLabels: {
        enabled: false
      },
    xaxis: {
      categories: chartData1.weekdays
    },
    series: [
      {
        name: 'Accepted Bids',
        data: chartData1.acceptedBids
      },
      {
        name: 'Rejected Bids',
        data: chartData1.rejectedBids
      },
      {
        name: 'Completed Orders',
        data: chartData1.completedOrders
      }
    ],
    colors: ['#1F2067', '#CF0210', '#00BD57'],
    legend: {
      position: 'bottom',
      onItemClick: {
        toggleDataSeries: false
      },
      onItemHover: {
        highlightDataSeries: false
      }
    }
  };

  // Initialize the chart
  const chart1 = new ApexCharts(document.querySelector("#chart1"), options1);

  // Render the chart
  chart1.render();


    chart1.toggleSeries('Rejected Bids', false);
    chart1.toggleSeries('Completed Orders', false);

    document.querySelector("#chart1").addEventListener('click', function (e) {
      if (e.target && e.target.classList.contains('apexcharts-legend-text')) {
        const seriesName = e.target.textContent.trim();
        chart1.toggleSeries(seriesName);
      }
    });



// Get the current date
const currentDate = new Date();
const currentDay = currentDate.getDate();
const currentMonth = currentDate.getMonth() + 1; // Note: Months are zero-based, so we add 1

// Sample data for the chart
const chartDataCurrentDay = {
  hours: ['00:00', '01:00', '02:00', '03:00', '04:00', '05:00', '06:00', '07:00', '08:00', '09:00', '10:00', '11:00', '12:00',
    '13:00', '14:00', '15:00', '16:00', '17:00', '18:00', '19:00', '20:00', '21:00', '22:00', '23:00'],
    acceptedBids: [31, 40, 28, 51, 42, 109, 100,11, 32, 45, 32, 34,11, 32, 45, 32, 34, 52, 41,31, 40, 28, 51, 42],
    rejectedBids: [11, 32, 45, 32, 34, 52, 41,31, 40, 28, 51, 42,31, 40, 28, 51, 42, 109, 100,11, 32, 45, 32, 34],
    completedOrders: [11, 62, 15, 92, 104, 120, 90,42, 109, 100,11, 32,41,31, 40, 28, 51, 42,31, 40, 28, 51, 42]
};

// Assuming you have a function to fetch the data for the current day
// Replace this with your actual data fetching logic
function fetchDataForCurrentDay() {
  // ... Fetch data for the current day from your backend or other sources
  return {
    acceptedBids: [31, 40, 28, 51, 42, 109, 100,11, 32, 45, 32, 34,11, 32, 45, 32, 34, 52, 41,31, 40, 28, 51, 42],
    rejectedBids: [11, 32, 45, 32, 34, 52, 41,31, 40, 28, 51, 42,31, 40, 28, 51, 42, 109, 100,11, 32, 45, 32, 34],
    completedOrders: [11, 62, 15, 92, 104, 120, 90,42, 109, 100,11, 32,41,31, 40, 28, 51, 42,31, 40, 28, 51, 42]
  };
}

// Fetch data for the current day
const currentDayData = fetchDataForCurrentDay();

// Merge the fetched data with the sample data
Object.assign(chartDataCurrentDay, currentDayData);

// Create the chart options
const optionsCurrentDay = {
  chart: {
    height: 320,
    type: 'area',
    toolbar: {
      show: false
    }
  },
  dataLabels: {
    enabled: false
  },
  xaxis: {
    categories: chartDataCurrentDay.hours
  },
  series: [
    {
      name: 'Accepted Bids',
      data: chartDataCurrentDay.acceptedBids
    },
    {
      name: 'Rejected Bids',
      data: chartDataCurrentDay.rejectedBids
    },
    {
      name: 'Completed Orders',
      data: chartDataCurrentDay.completedOrders
    }
  ],
  colors: ['#1F2067', '#CF0210', '#00BD57'],
  legend: {
    position: 'bottom'
  }
};

// Initialize the chart for the current day
const chartCurrentDay = new ApexCharts(document.querySelector("#chartCurrentDay"), optionsCurrentDay);

// Render the chart
chartCurrentDay.render();



  // Sample data for the chart
const chartData3 = {
    years: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    acceptedBids: [31, 40, 28, 51, 42, 109, 100,11, 32, 45, 32, 34],
    rejectedBids: [11, 32, 45, 32, 34, 52, 41,31, 40, 28, 51, 42],
    completedOrders: [11, 62, 15, 92, 104, 120, 90,42, 109, 100,11, 32,]
  };
  
  // Create the chart options3
  const options3 = {
    chart: {
        height: 320,
        type: 'area',
        toolbar: {
            show: false
          }
    },
    dataLabels: {
        enabled: false
      },
    xaxis: {
      categories: chartData3.years
    },
    series: [
      {
        name: 'Accepted Bids',
        data: chartData3.acceptedBids
      },
      {
        name: 'Rejected Bids',
        data: chartData3.rejectedBids
      },
      {
        name: 'Completed Orders',
        data: chartData3.completedOrders
      }
    ],
    colors: ['#1F2067', '#CF0210', '#00BD57'],
    legend: {
      position: 'bottom'
    }
  };
  
  // Initialize the chart
  const chart3 = new ApexCharts(document.querySelector("#chart3"), options3);
  
  // Render the chart
  chart3.render();


  
  // Sample data for the chart
  const chartData4 = {
    years: ['2018', '2019', '2020', '2021', '2022', '2023', '2024'],
    acceptedBids: [31, 40, 28, 51, 42, 109, 100],
    rejectedBids: [11, 32, 45, 32, 34, 52, 41],
    completedOrders: [11, 62, 15, 92, 104, 120, 90]
  };
  
  // Create the chart options4
  const options4 = {
    chart: {
        height: 320,
        type: 'area',
        toolbar: {
            show: false
          }
    },
    dataLabels: {
        enabled: false
      },
    xaxis: {
      categories: chartData4.years
    },
    series: [
      {
        name: 'Accepted Bids',
        data: chartData4.acceptedBids
      },
      {
        name: 'Rejected Bids',
        data: chartData4.rejectedBids
      },
      {
        name: 'Completed Orders',
        data: chartData4.completedOrders
      }
    ],
    colors: ['#1F2067', '#CF0210', '#00BD57'],
    legend: {
      position: 'bottom'
    }
  };
  
  // Initialize the chart
  const chart4 = new ApexCharts(document.querySelector("#chart4"), options4);
  
  // Render the chart
  chart4.render();

});

