$(document).ready(function () {

    // Sample data for the chart
    const chartData1 = {
        years: ['2018', '2019', '2020', '2021', '2022', '2023', '2024'],
        yearData: [500, 800, 500, 1000, 700, 600, 800]
    };

    // Create the chart options4
    const options1 = {
        chart: {
            height: '100%',
            type: 'line',
            toolbar: {
                show: false
            },
            animations: {
                enabled: true,
                easing: 'easeinout',
                speed: 2000,
            }
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            width: 4,
            curve: 'smooth'
        },
        markers: {
            size: 6,
            hover: {
                sizeOffset: 5
            },
            colors: ['#000000'],
        strokeColor: '#3B90AA',
        strokeWidth: 3
        },
        xaxis: {
            categories: chartData1.years,
            labels: {
                // rotate: 0,
                // trim: true,
                style: {
                    fontSize: '14px',
                    colors: '#64748B',
                    fontFamily: '"Urbanist", sans-serif',
                    fontWeight: '500',
                }
            },
            axisTicks: {
                show: false
            },
        },
        yaxis: {
            show: true,
            max: 1000,
            min: 0,
            axisBorder: {
                show: true
            },
            axisTicks: {
                show: false,
            },
            labels: {
                show: true,
                style: {
                    fontSize: '14px',
                    colors: '#64748B',
                    fontFamily: '"Poppins", sans-serif',
                    fontWeight: '500',
                }
            }

        },
        series: [
            {
                name: 'Yearly',
                data: chartData1.yearData
            }
        ],
        colors: ['#3B90AA'],
        legend: {
            show: false,
        }
    };

    // Initialize the chart
    const chart1 = new ApexCharts(document.querySelector("#chart1"), options1);

    // Render the chart
    chart1.render();


    // Sample data for the chart
    const chartData2 = {
        months: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        monthData: [500, 800, 500, 1000, 700, 600, 800, 300, 1000, 600, 1000, 400],
    };

    // Create the chart options3
    const options2 = {
        chart: {
            height: '100%',
            type: 'line',
            toolbar: {
                show: false
            },
            animations: {
                enabled: true,
                easing: 'easeinout',
                speed: 2000,
            }
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            width: 4,
            curve: 'smooth'
        },
        markers: {
            size: 6,
            hover: {
                sizeOffset: 5
            },
            colors: ['#000000'],
        strokeColor: '#3B90AA',
        strokeWidth: 3
        },
        xaxis: {
            categories: chartData2.months,
            labels: {
                // rotate: 0,
                // trim: true,
                style: {
                    fontSize: '14px',
                    colors: '#64748B',
                    fontFamily: '"Urbanist", sans-serif',
                    fontWeight: '500',
                }
            },
            axisTicks: {
                show: false
            },
        },
        yaxis: {
            show: true,
            max: 1000,
            min: 0,
            axisBorder: {
                show: true
            },
            axisTicks: {
                show: false,
            },
            labels: {
                show: true,
                style: {
                    fontSize: '14px',
                    colors: '#64748B',
                    fontFamily: '"Poppins", sans-serif',
                    fontWeight: '500',
                }
            }

        },
        series: [
            {
                name: 'Monthly',
                data: chartData2.monthData
            }
        ],
        colors: ['#3B90AA'],
        legend: {
            show: false,
        }
    };

    // Initialize the chart
    const chart2 = new ApexCharts(document.querySelector("#chart2"), options2);

    // Render the chart
    chart2.render();


    // Sample data for the chart
    const chartData3 = {
        weekdays: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'],
        weekData: [1000, 400, 300, 800, 200, 700, 500],
    };

    // Create the chart options1
    const options3 = {
        chart: {
            height: '100%',
            type: 'line',
            toolbar: {
                show: false
            },
            animations: {
                enabled: true,
                easing: 'easeinout',
                speed: 2000,
            }
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            width: 4,
            curve: 'smooth'
        },
        markers: {
            size: 6,
            hover: {
                sizeOffset: 5
            },
            colors: ['#000000'],
        strokeColor: '#3B90AA',
        strokeWidth: 3
        },
        xaxis: {
            categories: chartData3.weekdays,
            labels: {
                // rotate: 0,
                // trim: true,
                style: {
                    fontSize: '14px',
                    colors: '#64748B',
                    fontFamily: '"Urbanist", sans-serif',
                    fontWeight: '500',
                }
            },
            axisTicks: {
                show: false
            }
        },
        yaxis: {
            show: true,
            max: 1000,
            min: 0,
            axisBorder: {
                show: true
            },
            axisTicks: {
                show: false,
            },
            labels: {
                show: true,
                style: {
                    fontSize: '14px',
                    colors: '#64748B',
                    fontFamily: '"Poppins", sans-serif',
                    fontWeight: '500',
                }
            }

        },
        series: [
            {
                name: 'weekly',
                data: chartData3.weekData
            }
        ],
        colors: ['#3B90AA'],
        legend: {
            show: false,
        }
    };

    // Initialize the chart
    const chart3 = new ApexCharts(document.querySelector("#chart3"), options3);

    // Render the chart
    chart3.render();
});