$(window).on('load', function() {
    var reverseLogoCard = true;
    var lastLogoCardIndex = -1;
    $('.logo-card .back').show();
    $('.logo-card').data('reverseLogoCard', reverseLogoCard).flip({
        trigger: 'manual',
        reverse: reverseLogoCard
    });

    function flipLogoCard() {
        var max = $('.logo-card').length;
        if ($('body').width() < 551) max = Math.min(max, 6);
        
        var index;
        do {
            index = Math.floor(Math.random() * max);
        } while (index === lastLogoCardIndex);
        
        lastLogoCardIndex = index;
        
        var wait = Math.random() * 500 + Math.floor(Math.random() * 8) * 100 + 750;
        var card = $('.logo-card').eq(index);
        
        reverseLogoCard = !card.data('reverseLogoCard');
        card.data('reverseLogoCard', reverseLogoCard);
        
        card.flip('toggle', function() {
            card.flip({
                reverse: reverseLogoCard
            });
            setTimeout(flipLogoCard, wait);
        });
    }

    setTimeout(flipLogoCard, 500);
});
