<?php
include 'includes/header.php';
$page = 'home';
?>

<section class="main-banner main-box" data-aos="fade-down" data-aos-duration="1000">
        <div class="row fir-mhead">
            <div class="col-7 mheadingsec ">
                <h1 class="mb-heading">We Deliver</h1>
            </div>
            <div class="col-5 firstLine">
                <div class="box box1">
                    <div class="inner">
                        <span>Next-Gen Scalable Game-Changing </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row sec-mhead">
            <div class="col-lg-2 col-md-2 mheadingsec">
                <h1 class="mb-heading">and</h1>
            </div>
            <div class="col-lg-6 col-md-4 up-down">
                <div class="box">
                    <div class="inner">
                        <span>Impactful <br> Reliable <br> Seamless </span>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mheadingsec-end">
                <h1 class="mb-heading"> Web &  <h1 class="mb-mobile-heading">Mobile Apps for</h1>
                </h1>
            </div>
        </div>
        <div class="row last-mhead">
            <div class="col-6 mheadingsec">
                <h1 class="mb-heading">Mobile Apps for</h1>
            </div>
            <div class="col-6 lastLine">
                <div class="box slide-box">
                    <div class="inner">
                        <span>Brands &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Organisations
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            Nonprofits</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-2 mb-button">
                <div class="button-outer">
                    <svg xmlns="http://www.w3.org/2000/svg" width="126" height="124" viewBox="0 0 126 124" fill="none">
                        <path
                            d="M47.4686 12.7716C45.5486 13.3544 43.9371 12.6687 43.4571 11.1944L44.4857 10.8859C44.8286 11.6401 45.6857 12.4287 47.2629 11.9487C48.6 11.5373 49.1143 10.5087 48.84 9.51443C47.9829 6.703 43.2514 10.0973 42.1543 6.49728C41.7086 5.023 42.5657 3.54871 44.4171 3.00014C46.2343 2.45157 47.64 3.103 48.2229 4.37157L47.0914 4.71442C46.7829 4.063 45.8914 3.44585 44.5543 3.85728C43.4229 4.20014 42.6686 5.09157 43.0114 6.223C43.8686 9.00014 48.6 5.67443 49.6971 9.24014C50.1429 10.5087 49.4914 12.1544 47.4686 12.7716Z"
                            fill="white" />
                        <path
                            d="M62.1086 0.2229L68.6915 0.4629L68.6572 1.28576L65.8801 1.1829L65.5372 10.3715L64.5429 10.3372L64.8858 1.14861L62.1086 1.04576V0.2229Z"
                            fill="white" />
                        <path
                            d="M86.0744 12.9428L81.8573 11.2285L80.143 13.0799L79.1487 12.6685L86.2801 4.91992L87.3087 5.36564L86.9315 15.8914L85.9715 15.4456L86.0744 12.9428ZM86.3144 6.29135L82.4401 10.5428L86.1087 12.0514L86.3144 6.29135Z"
                            fill="white" />
                        <path
                            d="M105.686 17.0571C107.4 18.6343 107.332 20.3143 106.2 21.5143C105.274 22.5086 103.903 22.8514 102.429 21.9257L101.4 26.7943L100.509 25.9714L101.537 21.2057L100.166 19.9371L97.3201 23.0229L96.6001 22.3371L103.457 15L105.686 17.0571ZM105.103 17.6743L103.629 16.3029L100.783 19.3543L102.257 20.7257C103.457 21.8571 104.589 21.6857 105.412 20.7943C106.303 19.9029 106.372 18.84 105.103 17.6743Z"
                            fill="white" />
                        <path
                            d="M117.137 31.1829L120.154 37.0114L119.434 37.3886L118.166 34.92L110.006 39.1371L109.56 38.2457L117.72 34.0286L116.417 31.56L117.137 31.1829Z"
                            fill="white" />
                        <path
                            d="M125.674 67.4573L125.537 68.5887L120.051 70.5087L124.886 73.7658L124.714 74.863L119.057 70.8858L115.183 70.3716L115.32 69.3773L119.194 69.8916L125.674 67.4573Z"
                            fill="white" />
                        <path
                            d="M109.011 88.4744C110.383 86.0058 113.263 85.1487 115.903 86.623C118.543 88.063 119.331 90.9773 117.96 93.4458C116.589 95.9144 113.709 96.7716 111.069 95.2973C108.429 93.8573 107.64 90.9773 109.011 88.4744ZM109.766 88.9201C108.703 90.8744 109.286 93.1373 111.583 94.4058C113.88 95.6744 116.109 94.9544 117.206 93.0344C118.269 91.0801 117.72 88.8173 115.423 87.5487C113.091 86.2458 110.863 86.9658 109.766 88.9201Z"
                            fill="white" />
                        <path
                            d="M105.206 109.491L104.417 110.109L100.474 105.206C99.1716 103.594 97.8002 103.629 96.5659 104.589C95.3659 105.583 95.0573 106.886 96.3602 108.497L100.337 113.4L99.5487 114.017L95.6059 109.114C93.9259 107.057 94.4402 105.137 96.0516 103.869C97.6287 102.6 99.6173 102.497 101.297 104.554L105.206 109.491Z"
                            fill="white" />
                        <path
                            d="M82.7144 122.52C80.5201 123.24 79.0801 122.383 78.5658 120.84C78.1201 119.537 78.4972 118.2 80.0058 117.343L76.2344 114.12L77.3658 113.743L81.0344 116.932L82.7829 116.349L81.4801 112.372L82.4401 112.063L85.5944 121.56L82.7144 122.52ZM82.4401 121.732L84.3601 121.114L83.0572 117.172L81.1372 117.823C79.5944 118.337 79.1829 119.4 79.5601 120.566C79.9372 121.732 80.8287 122.28 82.4401 121.732Z"
                            fill="white" />
                        <path
                            d="M46.0971 117.411L48.0171 117.994L49.2857 113.914L50.2457 114.223L47.2971 123.789L44.4171 122.897C42.1886 122.211 41.5371 120.703 42.0171 119.126C42.4971 117.583 43.8686 116.691 46.0971 117.411ZM45.8571 118.234C44.2457 117.72 43.3886 118.269 43.0114 119.469C42.6343 120.703 43.0457 121.594 44.6571 122.109L46.5771 122.691L47.7771 118.817L45.8571 118.234Z"
                            fill="white" />
                        <path
                            d="M25.1831 113.057C23.3316 111.652 23.2288 109.972 24.2231 108.669C25.0459 107.572 26.3831 107.126 27.9259 107.88L28.4402 102.909L29.4002 103.629L28.8516 108.463L30.3259 109.594L32.8631 106.234L33.6516 106.852L27.5831 114.874L25.1831 113.057ZM25.6973 112.372L27.3088 113.572L29.8459 110.246L28.2345 109.012C26.9316 108.017 25.8002 108.292 25.0802 109.252C24.2916 110.314 24.3602 111.343 25.6973 112.372Z"
                            fill="white" />
                        <path
                            d="M18.0516 90.2571C19.4916 92.6571 18.8402 95.5714 16.2688 97.1485C13.6973 98.6914 10.7831 97.9714 9.34306 95.5714C7.86878 93.1714 8.58878 90.2228 11.1259 88.6799C13.6631 87.1371 16.5773 87.8571 18.0516 90.2571ZM17.2973 90.7371C16.1316 88.8514 13.8688 88.2342 11.6402 89.5714C9.41163 90.9085 8.93163 93.2057 10.0631 95.1257C11.1945 97.0114 13.4573 97.6628 15.7202 96.2914C17.9831 94.9199 18.4288 92.6228 17.2973 90.7371Z"
                            fill="white" />
                        <path
                            d="M1.08012 73.08L0.908691 72.0857L8.38298 70.7143C9.89155 70.44 11.0573 71.2629 11.3315 72.8057C11.6058 74.4172 10.783 75.6172 9.10298 75.9257L8.93155 74.9314C9.92583 74.7257 10.6801 74.1429 10.4744 72.9772C10.2687 71.8457 9.37726 71.5714 8.5544 71.7086L1.08012 73.08Z"
                            fill="white" />
                        <path
                            d="M2.21153 51.0344L1.59438 55.2172L5.29724 55.7658L5.8801 51.9944L6.70295 52.1315L6.1201 55.9029L9.89153 56.4858L10.5087 52.3029L11.3315 52.4401L10.543 57.5829L0.600098 56.0744L1.38867 50.8972L2.21153 51.0344Z"
                            fill="white" />
                        <path
                            d="M8.24585 32.1773C9.343 30.223 11.1259 29.3316 13.1487 29.6401L12.5659 30.6687C11.1259 30.4973 9.823 31.1144 9.00014 32.623C7.93728 34.543 8.52014 36.8058 10.8173 38.0744C13.0801 39.343 15.343 38.6916 16.4059 36.7716C17.2287 35.2973 17.0916 33.8573 16.2344 32.7258L16.8173 31.6973C18.1201 33.2401 18.2916 35.2287 17.1944 37.183C15.823 39.6173 12.9773 40.4401 10.3373 38.9658C7.663 37.4916 6.87443 34.6116 8.24585 32.1773Z"
                            fill="white" />
                        <path
                            d="M20.4172 16.8514L25.4915 12.6343L26.0058 13.2857L23.8801 15.0686L29.743 22.1314L28.9544 22.7829L23.1258 15.6857L20.9658 17.4686L20.4172 16.8514Z"
                            fill="white" />
                    </svg>
                    <div class="button-inner">
                        <a href="contact-us">
                            <svg xmlns="http://www.w3.org/2000/svg" width="62" height="62" viewBox="0 0 62 62" fill="none">
                                <path
                                    d="M34.5298 22.1107C34.3411 21.9348 34.1897 21.7227 34.0846 21.487C33.9796 21.2513 33.9232 20.9969 33.9186 20.7389C33.9141 20.481 33.9615 20.2247 34.0582 19.9855C34.1548 19.7462 34.2986 19.5289 34.4811 19.3464C34.6635 19.164 34.8808 19.0202 35.1201 18.9235C35.3593 18.8269 35.6156 18.7794 35.8736 18.784C36.1315 18.7885 36.386 18.845 36.6216 18.95C36.8573 19.055 37.0694 19.2064 37.2453 19.3952L47.4925 29.6424C47.8523 30.0027 48.0544 30.491 48.0544 31.0002C48.0544 31.5093 47.8523 31.9977 47.4925 32.3579L37.2453 42.6051C37.0694 42.7939 36.8573 42.9453 36.6216 43.0503C36.386 43.1553 36.1315 43.2118 35.8736 43.2163C35.6156 43.2209 35.3593 43.1734 35.1201 43.0768C34.8808 42.9802 34.6635 42.8363 34.4811 42.6539C34.2986 42.4714 34.1548 42.2541 34.0582 42.0149C33.9615 41.7756 33.9141 41.5194 33.9186 41.2614C33.9232 41.0034 33.9796 40.749 34.0846 40.5133C34.1897 40.2776 34.3411 40.0655 34.5298 39.8896L41.4979 32.9215L16.6741 32.9215C16.1645 32.9215 15.6758 32.7191 15.3155 32.3588C14.9552 31.9984 14.7528 31.5097 14.7528 31.0002C14.7528 30.4906 14.9552 30.0019 15.3155 29.6416C15.6758 29.2812 16.1645 29.0788 16.6741 29.0788L41.4979 29.0788L34.5298 22.1107Z"
                                    fill="#20b8f9" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-9 mb-desc-div">
                <h4 class="mb-desc">
                Beyond Browse is a  <span> creative development and consulting agency </span> on web and mobile app solutions dedicated to transcending boundaries and reaching the heights of success.</h4>
                <a href="#costumModal9" data-toggle="modal">
                    <button class="header-btn">Get Started
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none">
                            <path
                                d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z"
                                fill="#20b8f9" />
                        </svg>
                    </button></a>
            </div>
        </div>
</section>

<section class="second-sec mobilelogos-sec">
    <section>
        <div class="container-fluid">
            <div class="row">
                <div class="col-7">
                    <div class="row mobile-center">
                        <h2 class="col-7 up-down-before">Recognised for</h2>
                        <div class="col-12 common-up-down">
                            <div class="box">
                                <div class="inner">
                                    <span>Innovation <br> Innovation</span>
                                </div>
                            </div>
                        </div>
                        <h2 class="up-down-before">and Impact</h2>
                    </div>
                </div>
                <div class="col-5">
                    <p class="second-sec-desc">We are very proud of the accolades we have earned for our outstanding
                        work. Beyond Browse’s commitment to innovation, quality, and client contribution was honoured by
                        many industrial awards; and placed us on fronts in the entire tech and design world. This seems
                        to be a recognition of our team's work, and also a motivation to deliver excellent and
                        transforming digital experiences that have an impact.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <div class="row" data-aos="fade-up" data-aos-duration="1000">
        <div class="logo-container">
            <!-- Additional required wrapper -->
            <div class="swiper-wrapper">
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/2020-gold.png" /></div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/Inc.-5000-Color-Medallion-Logo-1024x1024-1.png" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/Clutch_100_2023Badge.jpg" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/ClutchTop1000.png" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/Rankwatch-Award-2023.png" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/rightfirms-award.png" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/Top-Developers.png" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/logo.png" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/2024.svg" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/2023.svg" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/2022.svg" /></div>
                <div class="swiper-slide"><img src="assets/wp-content/uploads/2024/03/2021-1.svg" /></div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_web_developers_government_california.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_software_developers_supply_chain_logistics_and_transport_california.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_mendix_development_san_francisco_2024.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_web_developers_gaming_california.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_software_developers_manufacturing_california.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_software_developers_gaming_california.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_app_development_company_supply_chain_logistics_and_transport_united_states.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_app_development_company_supply_chain_logistics_and_transport_california.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_app_development_company_government_united_states.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_app_development_company_california_2024.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_angular_developers_palo_alto_2024.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_clutch.co_android_app_development_company_california_2024-1.png" />
                </div>
                <div class="swiper-slide"><img
                        src="assets/wp-content/uploads/2024/03/top_the_manifest_sem_company_san_francisco_2022_award.svg" />
                </div>

            </div>

            <!-- If we need navigation buttons -->
            <!--         <div class="swiper-button-prev"></div>
        <div class="swiper-button-next"></div> -->
            <div class="cursor-slider">drag</div>
        </div>
    </div>
</section>

<section class="third-sec">
    <div class="container-fluid">
        <div class="row">
            <div class="col-6 heading" data-aos="fade-right" data-aos-duration="1000">
                <div class="row">
                    <h2 class="up-down-before">Driving</h2>
                    <div class="col-12 col-md-12 col-xxl-12 up-down">
                        <div class="box innovation">
                            <div class="inner">
                                <span>Innovation  <br> Change <br> Excellence </span>
                            </div>
                        </div>
                    </div>
                    <h2 class="up-down-before" style="width: 100% !important;"> in Every Project</h2>
                </div>
            </div>
            <div class="col-5" data-aos="fade-left" data-aos-duration="1000">
                <p class="third-sec-desc">Our agency believes in speaking the language of creating tailor-fit
                    high-impact web and mobile solutions for an organisation to be successful. As we do that, we involve
                    close collaboration with brands, organisations, and nonprofits essentially to ensure that we are
                    well attuned to their needs and aspirational goals. After that, we mix innovative design with a
                    number of the world's best technologies and strategic thinking so they create seamless digital
                    experiences that can grow and elevate any brand in the competitive digital marketplace.</p>
            </div>
        </div>
    </div>
</section>

<section class="fourth-sec">
    <div class="row" data-aos="fade-up" data-aos-duration="1000">
        <div class="col-12 first-tabs">
            <ul class="nav nav-tabs card-header-tabs" id="tabs">
                <li class="nav-item active">
                    <a class="nav-link" href="#post" data-toggle="tab">Game App Development</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#link" data-toggle="tab">Mobile App Development</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#branding" data-toggle="tab">Website Development</a>
                </li>
                <!-- <li class="nav-item">
                    <a class="nav-link" href="#staff" data-toggle="tab">Staff Augmentation</a>
                </li> -->
            </ul>
            <select id="tabSelect" class="mobile-tabs-dropdown">
                <option value="post">Game App Development</option>
                <option value="link">Mobile App Development</option>
                <option value="branding">Website Development</option>
                <!-- <option value="staff">Satff Augmentation</option> -->
            </select>
            <div class="tab-content">
                <div class="tab-pane active" id="post">
                    <div class="row">
                        <div class="col-8">
                            <h2 class="tab-pane-heading">Game App Development <span><a href="contact-us"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                            viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#20b8f9" />
                                        </svg></a></span></h2>
                            <p>Beyond Browse creates games that would be truly immersive and entertaining apps to lock
                                people in. Our team of dedicated developers is well-versed in the possibilities of
                                creative design coupled with modern technologies for polished usability from concept to
                                launch. Be it a simple mobile game a fun-filled interactive multiplayer experience or an
                                educational game; every project is built according to the specific needs of the clients.
                                Game apps that entertain are also valuable and provide that special experience for users
                                that they will remember and keep returning for more.
                            </p>
                            <a href="contact-us" class="designBtn">Get Started </a>
                            <!--                 <button class="header-btn">Get Started 
                  <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"><path d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z" fill="#20b8f9"/></svg>
                </button> -->
                        </div>
                        <div class="col-4">
                            <ul>
                                <li><a href="android-app-development-company">
                                        Android App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="ios-app-development-services">
                                        IOS App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="cross-platform-app-development-company">
                                        Cross-Platform App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="20" height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="flutter-app-development-company">
                                        Flutter App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="react-native-app-development-company">
                                        React Native App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="20" height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="mvp-development-company">
                                        MVP App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="link">
                    <div class="row">
                        <div class="col-8">
                            <h2 class="tab-pane-heading">Mobile App Development <span><a href="contact-us"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                            viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#20b8f9" />
                                        </svg></a></span></h2>
                            <p>Our mobile application development services are high-performance and user-friendly in iOS
                                as well as Android. We continually partner with brands, corporates, and startups to
                                develop customised mobile solutions that help solve real problems of efficiency and
                                added value for users. Beyond Browse ensure that your app provides a reliable, smooth,
                                and engaging experience, from intuitive design through seamless functionality. Our team
                                uses both technical and innovative strategies to ensure that your app shines in the
                                highly competitive mobile applications market whether it is an e-commerce app, a social
                                platform, or an enterprise solution.
                            </p>
                            <a href="contact-us" class="designBtn">Get Started </a>
                            <!--                 <button class="header-btn">Get Started 
                  <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"><path d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z" fill="#20b8f9"/></svg>
                </button> -->
                        </div>
                        <div class="col-4">
                            <ul>
                                <li><a href="android-app-development-company">
                                        Android App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="ios-app-development-services">
                                        IOS App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="cross-platform-app-development-company">
                                        Cross-Platform App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="20" height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="flutter-app-development-company">
                                        Flutter App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="react-native-app-development-company">
                                        React Native App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="20" height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="mvp-development-company">
                                        MVP App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="branding">
                    <div class="row">
                        <div class="col-8">
                            <h2 class="tab-pane-heading">Website Development <span><a href="contact-us"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                            viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#20b8f9" />
                                        </svg></a></span></h2>
                            <p>We offer extensive services for website development, from dynamic responsive websites to
                                complex web applications that serve your business needs. Our team is skilled in the
                                creation of visually stunning, functionally robust, and user-centric websites, assuring
                                seamless experiences across all devices. Whether a corporate website, an e-commerce
                                platform, or a content management system, Beyond Browse builds fast, secure, and
                                scalable websites using the latest technologies. Performance-focused, SEO optimised, and
                                clean-coded. These are some of our facets of building an online presence that's as
                                good-looking as extremely effective and engagingly user-friendly.
                            </p>
                            <a href="contact-us" class="designBtn">Get Started </a>
                            <!--                 <button class="header-btn">Get Started 
                  <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"><path d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z" fill="#20b8f9"/></svg>
                </button> -->
                        </div>
                        <div class="col-4">
                            <ul>
                                <li><a href="android-app-development-company">
                                        Android App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="ios-app-development-services">
                                        IOS App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="cross-platform-app-development-company">
                                        Cross-Platform App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="20" height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="flutter-app-development-company">
                                        Flutter App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="#">
                                        React Native App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="20" height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                                <li><a href="mvp-development-company">
                                        MVP App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                height="20" viewBox="0 0 28 28" fill="none">
                                                <path
                                                    d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                    fill="#ffffff" />
                                            </svg></span>
                                    </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="staff">
                    <div class="row">
                        <!-- <div class="col-8">
                            <h2 class="tab-pane-heading">Staff Augmentation <span><a href="contact-us"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                            viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#20b8f9" />
                                        </svg></a></span></h2>
                            <p>Partnering with Beyond Browse for staff augmentation means unlocking a reservoir of
                                expertise and
                                efficiency for your projects. We seamlessly integrate our skilled professionals into
                                your team,
                                enhancing capabilities and accelerating project timelines.
                                Our augmentation services offer flexibility and scalability, allowing your business to
                                adapt to
                                fluctuating demands without compromising quality. With Beyond Browse's adept
                                professionals
                                working
                                alongside your team, you gain access to a pool of talent committed to achieving your
                                business
                                objectives efficiently and effectively. </p>
                            <a href="contact-us" class="designBtn">Get Started </a>
                            <!--                 <button class="header-btn">Get Started 
                  <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"><path d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z" fill="#20b8f9"/></svg>
                </button> -->
                    </div> -->
                    <div class="col-4">
                        <ul>
                            <li><a href="android-app-development-company">
                                    Android App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                            height="20" viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#ffffff" />
                                        </svg></span>
                                </a></li>
                            <li><a href="ios-app-development-services">
                                    IOS App Development<span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                            height="20" viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#ffffff" />
                                        </svg></span>
                                </a></li>
                            <li><a href="cross-platform-app-development-company">
                                    Cross-Platform App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                            width="20" height="20" viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#ffffff" />
                                        </svg></span>
                                </a></li>
                            <li><a href="flutter-app-development-company">
                                    Flutter App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                            height="20" viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#ffffff" />
                                        </svg></span>
                                </a></li>
                            <li><a href="react-native-app-development-company">
                                    React Native App Development <span><svg xmlns="http://www.w3.org/2000/svg"
                                            width="20" height="20" viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#ffffff" />
                                        </svg></span>
                                </a></li>
                            <li><a href="mvp-development-company">
                                    MVP App Development <span><svg xmlns="http://www.w3.org/2000/svg" width="20"
                                            height="20" viewBox="0 0 28 28" fill="none">
                                            <path
                                                d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                                fill="#ffffff" />
                                        </svg></span>
                                </a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</section>

<!-- <section class="fifth-sec">
    <div class="container-fluid">
        <div class="row fifth-anim-sec">
            <div class="col-6 fifth-anim-sec-div" data-aos="fade-right" data-aos-duration="1000">
                <div class="row mainBox">
                    <h2 class="col-12 up-down-before">Our Success</h2>
                    <div class="col-12 common-up-down">
                        <div class="box">
                            <div class="inner">
                                <span>Impact <br> Results </span>
                            </div>
                        </div>
                    </div>
                    <h2 class="up-down-before">in Action</h2>
                </div>
            </div>
            <div class="col-6" data-aos="fade-left" data-aos-duration="1000">
                <p class="third-sec-desc fifth-sec-desc">Check out our extensive selection of case studies and examples
                    that prove how we can turn initiatives into successful web and mobile applications. This is the
                    premise, in which each project demonstrates our commitment to excellence, appreciating innovations,
                    and results that go further than what the client holds previewed.</p>
            </div>
        </div>
        <div class="hover-sec" data-aos="fade-up" data-aos-duration="1000">
            <div class="container-fluid">



                <a href="https://lecel.com/">
                    <div class="row hover-row" id="hover-element">
                        <div class="col-4 hover-row-heading">
                            <h3>lacavalier</h3>
                            <p class="hover-text">A logistics company faced challenges in tracking and optimizing their
                                fleet
                                operations efficiently. Manual processes resulted in delays, errors, and increased
                                costs. They needed
                                an easy-to-use and lightweight mobile app solution.</p>
                        </div>
                        <div class="col-7">
                            <div class="row hidden-row">
                                <div class="col">
                                </div>
                                <div class="col">
                                    <img src="assets/wp-content/uploads/2023/12/lacavalier-hover-1-1024x548.png"
                                        alt="image">
                                </div>
                            </div>
                            <p class="tobehide">Ecommerce &nbsp; / &nbsp; <svg xmlns="http://www.w3.org/2000/svg"
                                    width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path
                                        d="M12.0001 13.03C12.9859 13.03 13.7851 12.2309 13.7851 11.245C13.7851 10.2592 12.9859 9.46002 12.0001 9.46002C11.0143 9.46002 10.2151 10.2592 10.2151 11.245C10.2151 12.2309 11.0143 13.03 12.0001 13.03Z"
                                        fill="black" />
                                    <path
                                        d="M7.00199 14.794L6.60699 14.693C3.67299 13.952 1.98999 12.692 1.98999 11.241C1.98999 9.78899 3.67399 8.52999 6.60699 7.78899L7.00199 7.68899L7.11299 8.07999C7.40953 9.10368 7.78947 10.1014 8.24899 11.063L8.33399 11.241L8.24899 11.419C7.78899 12.382 7.40799 13.38 7.11299 14.404L7.00199 14.794ZM6.42499 8.69899C4.19599 9.32699 2.82699 10.285 2.82699 11.241C2.82699 12.195 4.19499 13.154 6.42499 13.781C6.69799 12.913 7.02799 12.064 7.40999 11.241C7.02522 10.4166 6.69615 9.56738 6.42499 8.69899ZM16.997 14.794L16.887 14.402C16.5897 13.3781 16.2094 12.3801 15.75 11.418L15.665 11.241L15.75 11.062C16.21 10.101 16.589 9.10199 16.887 8.07799L16.997 7.68799L17.392 7.78799C20.327 8.52899 22.009 9.78799 22.009 11.241C22.009 12.693 20.326 13.952 17.392 14.693L16.997 14.794ZM16.587 11.241C16.987 12.107 17.32 12.959 17.574 13.781C19.804 13.154 21.173 12.195 21.173 11.241C21.173 10.285 19.805 9.32799 17.574 8.69899C17.3013 9.56711 16.9715 10.4163 16.587 11.241Z"
                                        fill="black" />
                                    <path
                                        d="M6.41902 8.695L6.30902 8.305C5.48302 5.397 5.73302 3.314 6.99602 2.588C8.23102 1.873 10.218 2.718 12.299 4.853L12.583 5.145L12.299 5.436C11.5599 6.20469 10.8843 7.03207 10.279 7.91L10.166 8.072L9.97002 8.088C8.90561 8.1716 7.84978 8.34183 6.81302 8.597L6.41902 8.695ZM8.00102 3.166C7.77702 3.166 7.57902 3.215 7.41202 3.311C6.58402 3.788 6.43802 5.449 7.00802 7.691C7.89902 7.494 8.79802 7.353 9.70402 7.274C10.2285 6.53005 10.8007 5.8209 11.417 5.151C10.114 3.884 8.88402 3.166 8.00102 3.166ZM15.998 20.15C14.81 20.15 13.284 19.254 11.7 17.628L11.417 17.337L11.7 17.047C12.4393 16.2771 13.1151 15.4487 13.721 14.57L13.833 14.41L14.027 14.391C15.0918 14.3089 16.148 14.1393 17.185 13.884L17.58 13.784L17.691 14.175C18.513 17.081 18.264 19.167 17.003 19.893C16.6969 20.0665 16.3499 20.1553 15.998 20.15ZM12.583 17.33C13.885 18.597 15.116 19.316 15.998 19.316C16.223 19.316 16.421 19.266 16.587 19.171C17.416 18.693 17.563 17.029 16.991 14.787C16.101 14.985 15.201 15.127 14.293 15.206C13.7707 15.9511 13.1995 16.6607 12.583 17.33Z"
                                        fill="black" />
                                    <path
                                        d="M17.58 8.69501L17.185 8.59601C16.1481 8.34004 15.0918 8.1698 14.027 8.08701L13.833 8.07001L13.721 7.90801C13.116 7.0296 12.44 6.20217 11.7 5.43401L11.417 5.14301L11.7 4.85301C13.78 2.71901 15.766 1.87401 17.003 2.58801C18.265 3.31501 18.516 5.39801 17.691 8.30501L17.58 8.69501ZM14.293 7.27401C15.247 7.35901 16.151 7.50201 16.991 7.69101C17.562 5.44901 17.416 3.78801 16.587 3.31001C15.763 2.83301 14.212 3.56301 12.583 5.15101C13.199 5.82101 13.771 6.52901 14.293 7.27401ZM8.00101 20.15C7.64914 20.155 7.30227 20.0663 6.99601 19.893C5.73301 19.167 5.48301 17.082 6.30801 14.175L6.41601 13.784L6.81101 13.884C7.77501 14.127 8.83701 14.298 9.96901 14.391L10.163 14.41L10.276 14.57C10.88 15.448 11.556 16.277 12.296 17.047L12.58 17.337L12.296 17.628C10.713 19.255 9.18701 20.15 8.00101 20.15ZM7.00801 14.788C6.43801 17.03 6.58401 18.694 7.41201 19.172C8.23701 19.642 9.78301 18.917 11.417 17.33C10.801 16.6599 10.2288 15.9508 9.70401 15.207C8.7971 15.1268 7.89648 14.9868 7.00801 14.788Z"
                                        fill="black" />
                                    <path
                                        d="M11.9999 15.313C11.3129 15.313 10.6079 15.284 9.89991 15.225L9.70391 15.208L9.59091 15.046C9.19167 14.4719 8.81602 13.8818 8.46491 13.277C8.1164 12.6707 7.79247 12.0505 7.49391 11.418L7.40991 11.241L7.49391 11.062C7.79291 10.43 8.11591 9.81002 8.46491 9.20402C8.81191 8.60802 9.19091 8.01202 9.59091 7.43402L9.70391 7.27402L9.89991 7.25602C11.2968 7.13902 12.701 7.13902 14.0979 7.25602L14.2919 7.27502L14.4049 7.43502C15.2047 8.58378 15.9071 9.79733 16.5049 11.063L16.5879 11.242L16.5049 11.419C15.9088 12.6856 15.2063 13.8993 14.4049 15.047L14.2919 15.209L14.0979 15.226C13.3919 15.283 12.6859 15.313 11.9999 15.313ZM10.1659 14.409C11.4009 14.502 12.5989 14.502 13.8329 14.409C14.5218 13.4002 15.1342 12.3413 15.6649 11.241C15.1361 10.1398 14.5236 9.08068 13.8329 8.07302C12.6124 7.97902 11.3864 7.97902 10.1659 8.07302C9.47465 9.08032 8.86217 10.1395 8.33391 11.241C8.86579 12.3407 9.47812 13.3995 10.1659 14.409Z"
                                        fill="black" />
                                </svg></p>
                            <div class="row tobehide">

                                <div class="col-2 category">Mobile App Development</div>


                                <div class="col-2 category">Prototyping</div>

                            </div>
                        </div>
                        <div class="col-1 tobehide"><svg xmlns="http://www.w3.org/2000/svg" width="43" height="43"
                                viewBox="0 0 43 43" fill="none">
                                <g clip-path="url(#clip0_364_424)">
                                    <path
                                        d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                        fill="#65649F" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_364_424">
                                        <rect width="32.527" height="27.3266" fill="white"
                                            transform="translate(0 23) rotate(-45)" />
                                    </clipPath>
                                </defs>
                            </svg></div>
                    </div>
                </a>


                <a href="https://becomeahappieryou.com/">
                    <div class="row hover-row" id="hover-element">
                        <div class="col-4 hover-row-heading">
                            <h3>mind nourishment</h3>
                            <p class="hover-text">Mind Nourishment application belongs in the mental health and wellness
                                category.
                                It’s a revolutionary concept promoting coaching and therapy, while offering flexibility
                                and a huge
                                repository of thought-provoking, self-help content to adapt change and take a step
                                closer towards a
                                more promising and rewarding life. </p>
                        </div>
                        <div class="col-7">
                            <div class="row hidden-row">
                                <div class="col">
                                </div>
                                <div class="col">
                                    <img src="assets/wp-content/uploads/2023/12/mind-hover-1-1024x548.png" alt="image">
                                </div>
                            </div>
                            <p class="tobehide">Ecommerce &nbsp; / &nbsp; <svg xmlns="http://www.w3.org/2000/svg"
                                    width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path
                                        d="M12.0001 13.03C12.9859 13.03 13.7851 12.2309 13.7851 11.245C13.7851 10.2592 12.9859 9.46002 12.0001 9.46002C11.0143 9.46002 10.2151 10.2592 10.2151 11.245C10.2151 12.2309 11.0143 13.03 12.0001 13.03Z"
                                        fill="black" />
                                    <path
                                        d="M7.00199 14.794L6.60699 14.693C3.67299 13.952 1.98999 12.692 1.98999 11.241C1.98999 9.78899 3.67399 8.52999 6.60699 7.78899L7.00199 7.68899L7.11299 8.07999C7.40953 9.10368 7.78947 10.1014 8.24899 11.063L8.33399 11.241L8.24899 11.419C7.78899 12.382 7.40799 13.38 7.11299 14.404L7.00199 14.794ZM6.42499 8.69899C4.19599 9.32699 2.82699 10.285 2.82699 11.241C2.82699 12.195 4.19499 13.154 6.42499 13.781C6.69799 12.913 7.02799 12.064 7.40999 11.241C7.02522 10.4166 6.69615 9.56738 6.42499 8.69899ZM16.997 14.794L16.887 14.402C16.5897 13.3781 16.2094 12.3801 15.75 11.418L15.665 11.241L15.75 11.062C16.21 10.101 16.589 9.10199 16.887 8.07799L16.997 7.68799L17.392 7.78799C20.327 8.52899 22.009 9.78799 22.009 11.241C22.009 12.693 20.326 13.952 17.392 14.693L16.997 14.794ZM16.587 11.241C16.987 12.107 17.32 12.959 17.574 13.781C19.804 13.154 21.173 12.195 21.173 11.241C21.173 10.285 19.805 9.32799 17.574 8.69899C17.3013 9.56711 16.9715 10.4163 16.587 11.241Z"
                                        fill="black" />
                                    <path
                                        d="M6.41902 8.695L6.30902 8.305C5.48302 5.397 5.73302 3.314 6.99602 2.588C8.23102 1.873 10.218 2.718 12.299 4.853L12.583 5.145L12.299 5.436C11.5599 6.20469 10.8843 7.03207 10.279 7.91L10.166 8.072L9.97002 8.088C8.90561 8.1716 7.84978 8.34183 6.81302 8.597L6.41902 8.695ZM8.00102 3.166C7.77702 3.166 7.57902 3.215 7.41202 3.311C6.58402 3.788 6.43802 5.449 7.00802 7.691C7.89902 7.494 8.79802 7.353 9.70402 7.274C10.2285 6.53005 10.8007 5.8209 11.417 5.151C10.114 3.884 8.88402 3.166 8.00102 3.166ZM15.998 20.15C14.81 20.15 13.284 19.254 11.7 17.628L11.417 17.337L11.7 17.047C12.4393 16.2771 13.1151 15.4487 13.721 14.57L13.833 14.41L14.027 14.391C15.0918 14.3089 16.148 14.1393 17.185 13.884L17.58 13.784L17.691 14.175C18.513 17.081 18.264 19.167 17.003 19.893C16.6969 20.0665 16.3499 20.1553 15.998 20.15ZM12.583 17.33C13.885 18.597 15.116 19.316 15.998 19.316C16.223 19.316 16.421 19.266 16.587 19.171C17.416 18.693 17.563 17.029 16.991 14.787C16.101 14.985 15.201 15.127 14.293 15.206C13.7707 15.9511 13.1995 16.6607 12.583 17.33Z"
                                        fill="black" />
                                    <path
                                        d="M17.58 8.69501L17.185 8.59601C16.1481 8.34004 15.0918 8.1698 14.027 8.08701L13.833 8.07001L13.721 7.90801C13.116 7.0296 12.44 6.20217 11.7 5.43401L11.417 5.14301L11.7 4.85301C13.78 2.71901 15.766 1.87401 17.003 2.58801C18.265 3.31501 18.516 5.39801 17.691 8.30501L17.58 8.69501ZM14.293 7.27401C15.247 7.35901 16.151 7.50201 16.991 7.69101C17.562 5.44901 17.416 3.78801 16.587 3.31001C15.763 2.83301 14.212 3.56301 12.583 5.15101C13.199 5.82101 13.771 6.52901 14.293 7.27401ZM8.00101 20.15C7.64914 20.155 7.30227 20.0663 6.99601 19.893C5.73301 19.167 5.48301 17.082 6.30801 14.175L6.41601 13.784L6.81101 13.884C7.77501 14.127 8.83701 14.298 9.96901 14.391L10.163 14.41L10.276 14.57C10.88 15.448 11.556 16.277 12.296 17.047L12.58 17.337L12.296 17.628C10.713 19.255 9.18701 20.15 8.00101 20.15ZM7.00801 14.788C6.43801 17.03 6.58401 18.694 7.41201 19.172C8.23701 19.642 9.78301 18.917 11.417 17.33C10.801 16.6599 10.2288 15.9508 9.70401 15.207C8.7971 15.1268 7.89648 14.9868 7.00801 14.788Z"
                                        fill="black" />
                                    <path
                                        d="M11.9999 15.313C11.3129 15.313 10.6079 15.284 9.89991 15.225L9.70391 15.208L9.59091 15.046C9.19167 14.4719 8.81602 13.8818 8.46491 13.277C8.1164 12.6707 7.79247 12.0505 7.49391 11.418L7.40991 11.241L7.49391 11.062C7.79291 10.43 8.11591 9.81002 8.46491 9.20402C8.81191 8.60802 9.19091 8.01202 9.59091 7.43402L9.70391 7.27402L9.89991 7.25602C11.2968 7.13902 12.701 7.13902 14.0979 7.25602L14.2919 7.27502L14.4049 7.43502C15.2047 8.58378 15.9071 9.79733 16.5049 11.063L16.5879 11.242L16.5049 11.419C15.9088 12.6856 15.2063 13.8993 14.4049 15.047L14.2919 15.209L14.0979 15.226C13.3919 15.283 12.6859 15.313 11.9999 15.313ZM10.1659 14.409C11.4009 14.502 12.5989 14.502 13.8329 14.409C14.5218 13.4002 15.1342 12.3413 15.6649 11.241C15.1361 10.1398 14.5236 9.08068 13.8329 8.07302C12.6124 7.97902 11.3864 7.97902 10.1659 8.07302C9.47465 9.08032 8.86217 10.1395 8.33391 11.241C8.86579 12.3407 9.47812 13.3995 10.1659 14.409Z"
                                        fill="black" />
                                </svg></p>
                            <div class="row tobehide">

                                <div class="col-2 category">Mobile App Development</div>


                                <div class="col-2 category">Prototyping</div>


                                <div class="col-2 category">UI/UX Design</div>

                             
                            </div>
                        </div>
                        <div class="col-1 tobehide"><svg xmlns="http://www.w3.org/2000/svg" width="43" height="43"
                                viewBox="0 0 43 43" fill="none">
                                <g clip-path="url(#clip0_364_424)">
                                    <path
                                        d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                        fill="#65649F" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_364_424">
                                        <rect width="32.527" height="27.3266" fill="white"
                                            transform="translate(0 23) rotate(-45)" />
                                    </clipPath>
                                </defs>
                            </svg></div>
                    </div>
                </a>


                <a href="https://kelstech.com/">
                    <div class="row hover-row" id="hover-element">
                        <div class="col-4 hover-row-heading">
                            <h3>kelstech</h3>
                            <p class="hover-text">A healthcare provider needs to enhance patient care and communication
                                among
                                medical staff, facing challenges in accessing patient records promptly. This solution
                                had to be
                                deployed at multiple campuses with similar capabilities but variations in disease types
                                and their stay
                                at the campus.</p>
                        </div>
                        <div class="col-7">
                            <div class="row hidden-row">
                                <div class="col">
                                </div>
                                <div class="col">
                                    <img src="assets/wp-content/uploads/2023/12/kelstech-hover-2.png" alt="image">
                                </div>
                            </div>
                            <p class="tobehide">Ecommerce &nbsp; / &nbsp; <svg xmlns="http://www.w3.org/2000/svg"
                                    width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path
                                        d="M12.0001 13.03C12.9859 13.03 13.7851 12.2309 13.7851 11.245C13.7851 10.2592 12.9859 9.46002 12.0001 9.46002C11.0143 9.46002 10.2151 10.2592 10.2151 11.245C10.2151 12.2309 11.0143 13.03 12.0001 13.03Z"
                                        fill="black" />
                                    <path
                                        d="M7.00199 14.794L6.60699 14.693C3.67299 13.952 1.98999 12.692 1.98999 11.241C1.98999 9.78899 3.67399 8.52999 6.60699 7.78899L7.00199 7.68899L7.11299 8.07999C7.40953 9.10368 7.78947 10.1014 8.24899 11.063L8.33399 11.241L8.24899 11.419C7.78899 12.382 7.40799 13.38 7.11299 14.404L7.00199 14.794ZM6.42499 8.69899C4.19599 9.32699 2.82699 10.285 2.82699 11.241C2.82699 12.195 4.19499 13.154 6.42499 13.781C6.69799 12.913 7.02799 12.064 7.40999 11.241C7.02522 10.4166 6.69615 9.56738 6.42499 8.69899ZM16.997 14.794L16.887 14.402C16.5897 13.3781 16.2094 12.3801 15.75 11.418L15.665 11.241L15.75 11.062C16.21 10.101 16.589 9.10199 16.887 8.07799L16.997 7.68799L17.392 7.78799C20.327 8.52899 22.009 9.78799 22.009 11.241C22.009 12.693 20.326 13.952 17.392 14.693L16.997 14.794ZM16.587 11.241C16.987 12.107 17.32 12.959 17.574 13.781C19.804 13.154 21.173 12.195 21.173 11.241C21.173 10.285 19.805 9.32799 17.574 8.69899C17.3013 9.56711 16.9715 10.4163 16.587 11.241Z"
                                        fill="black" />
                                    <path
                                        d="M6.41902 8.695L6.30902 8.305C5.48302 5.397 5.73302 3.314 6.99602 2.588C8.23102 1.873 10.218 2.718 12.299 4.853L12.583 5.145L12.299 5.436C11.5599 6.20469 10.8843 7.03207 10.279 7.91L10.166 8.072L9.97002 8.088C8.90561 8.1716 7.84978 8.34183 6.81302 8.597L6.41902 8.695ZM8.00102 3.166C7.77702 3.166 7.57902 3.215 7.41202 3.311C6.58402 3.788 6.43802 5.449 7.00802 7.691C7.89902 7.494 8.79802 7.353 9.70402 7.274C10.2285 6.53005 10.8007 5.8209 11.417 5.151C10.114 3.884 8.88402 3.166 8.00102 3.166ZM15.998 20.15C14.81 20.15 13.284 19.254 11.7 17.628L11.417 17.337L11.7 17.047C12.4393 16.2771 13.1151 15.4487 13.721 14.57L13.833 14.41L14.027 14.391C15.0918 14.3089 16.148 14.1393 17.185 13.884L17.58 13.784L17.691 14.175C18.513 17.081 18.264 19.167 17.003 19.893C16.6969 20.0665 16.3499 20.1553 15.998 20.15ZM12.583 17.33C13.885 18.597 15.116 19.316 15.998 19.316C16.223 19.316 16.421 19.266 16.587 19.171C17.416 18.693 17.563 17.029 16.991 14.787C16.101 14.985 15.201 15.127 14.293 15.206C13.7707 15.9511 13.1995 16.6607 12.583 17.33Z"
                                        fill="black" />
                                    <path
                                        d="M17.58 8.69501L17.185 8.59601C16.1481 8.34004 15.0918 8.1698 14.027 8.08701L13.833 8.07001L13.721 7.90801C13.116 7.0296 12.44 6.20217 11.7 5.43401L11.417 5.14301L11.7 4.85301C13.78 2.71901 15.766 1.87401 17.003 2.58801C18.265 3.31501 18.516 5.39801 17.691 8.30501L17.58 8.69501ZM14.293 7.27401C15.247 7.35901 16.151 7.50201 16.991 7.69101C17.562 5.44901 17.416 3.78801 16.587 3.31001C15.763 2.83301 14.212 3.56301 12.583 5.15101C13.199 5.82101 13.771 6.52901 14.293 7.27401ZM8.00101 20.15C7.64914 20.155 7.30227 20.0663 6.99601 19.893C5.73301 19.167 5.48301 17.082 6.30801 14.175L6.41601 13.784L6.81101 13.884C7.77501 14.127 8.83701 14.298 9.96901 14.391L10.163 14.41L10.276 14.57C10.88 15.448 11.556 16.277 12.296 17.047L12.58 17.337L12.296 17.628C10.713 19.255 9.18701 20.15 8.00101 20.15ZM7.00801 14.788C6.43801 17.03 6.58401 18.694 7.41201 19.172C8.23701 19.642 9.78301 18.917 11.417 17.33C10.801 16.6599 10.2288 15.9508 9.70401 15.207C8.7971 15.1268 7.89648 14.9868 7.00801 14.788Z"
                                        fill="black" />
                                    <path
                                        d="M11.9999 15.313C11.3129 15.313 10.6079 15.284 9.89991 15.225L9.70391 15.208L9.59091 15.046C9.19167 14.4719 8.81602 13.8818 8.46491 13.277C8.1164 12.6707 7.79247 12.0505 7.49391 11.418L7.40991 11.241L7.49391 11.062C7.79291 10.43 8.11591 9.81002 8.46491 9.20402C8.81191 8.60802 9.19091 8.01202 9.59091 7.43402L9.70391 7.27402L9.89991 7.25602C11.2968 7.13902 12.701 7.13902 14.0979 7.25602L14.2919 7.27502L14.4049 7.43502C15.2047 8.58378 15.9071 9.79733 16.5049 11.063L16.5879 11.242L16.5049 11.419C15.9088 12.6856 15.2063 13.8993 14.4049 15.047L14.2919 15.209L14.0979 15.226C13.3919 15.283 12.6859 15.313 11.9999 15.313ZM10.1659 14.409C11.4009 14.502 12.5989 14.502 13.8329 14.409C14.5218 13.4002 15.1342 12.3413 15.6649 11.241C15.1361 10.1398 14.5236 9.08068 13.8329 8.07302C12.6124 7.97902 11.3864 7.97902 10.1659 8.07302C9.47465 9.08032 8.86217 10.1395 8.33391 11.241C8.86579 12.3407 9.47812 13.3995 10.1659 14.409Z"
                                        fill="black" />
                                </svg></p>
                            <div class="row tobehide">

                                <div class="col-2 category">Mobile App Development</div>


                                <div class="col-2 category">Prototyping</div>


                                <div class="col-2 category">UI/UX Design</div>

                   
                            </div>
                        </div>
                        <div class="col-1 tobehide"><svg xmlns="http://www.w3.org/2000/svg" width="43" height="43"
                                viewBox="0 0 43 43" fill="none">
                                <g clip-path="url(#clip0_364_424)">
                                    <path
                                        d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                        fill="#65649F" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_364_424">
                                        <rect width="32.527" height="27.3266" fill="white"
                                            transform="translate(0 23) rotate(-45)" />
                                    </clipPath>
                                </defs>
                            </svg></div>
                    </div>
                </a>


                <a href="https://v-streamaviation.com/">
                    <div class="row hover-row" id="hover-element">
                        <div class="col-4 hover-row-heading">
                            <h3>v-stream aviation</h3>
                            <p class="hover-text">A field service company faced difficulties in coordinating on-site
                                tasks, leading
                                to inefficiencies and delays. Working on remote sites at times posed challenges with
                                data transfer,
                                tracking, and other similar matters, and despite having a basic digital solution, the
                                business was far
                                from thriving.</p>
                        </div>
                        <div class="col-7">
                            <div class="row hidden-row">
                                <div class="col">
                                </div>
                                <div class="col">
                                    <img src="assets/wp-content/uploads/2023/12/vstream-aviation-hover-1-1024x548.png"
                                        alt="image">
                                </div>
                            </div>
                            <p class="tobehide">Ecommerce &nbsp; / &nbsp; <svg xmlns="http://www.w3.org/2000/svg"
                                    width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path
                                        d="M12.0001 13.03C12.9859 13.03 13.7851 12.2309 13.7851 11.245C13.7851 10.2592 12.9859 9.46002 12.0001 9.46002C11.0143 9.46002 10.2151 10.2592 10.2151 11.245C10.2151 12.2309 11.0143 13.03 12.0001 13.03Z"
                                        fill="black" />
                                    <path
                                        d="M7.00199 14.794L6.60699 14.693C3.67299 13.952 1.98999 12.692 1.98999 11.241C1.98999 9.78899 3.67399 8.52999 6.60699 7.78899L7.00199 7.68899L7.11299 8.07999C7.40953 9.10368 7.78947 10.1014 8.24899 11.063L8.33399 11.241L8.24899 11.419C7.78899 12.382 7.40799 13.38 7.11299 14.404L7.00199 14.794ZM6.42499 8.69899C4.19599 9.32699 2.82699 10.285 2.82699 11.241C2.82699 12.195 4.19499 13.154 6.42499 13.781C6.69799 12.913 7.02799 12.064 7.40999 11.241C7.02522 10.4166 6.69615 9.56738 6.42499 8.69899ZM16.997 14.794L16.887 14.402C16.5897 13.3781 16.2094 12.3801 15.75 11.418L15.665 11.241L15.75 11.062C16.21 10.101 16.589 9.10199 16.887 8.07799L16.997 7.68799L17.392 7.78799C20.327 8.52899 22.009 9.78799 22.009 11.241C22.009 12.693 20.326 13.952 17.392 14.693L16.997 14.794ZM16.587 11.241C16.987 12.107 17.32 12.959 17.574 13.781C19.804 13.154 21.173 12.195 21.173 11.241C21.173 10.285 19.805 9.32799 17.574 8.69899C17.3013 9.56711 16.9715 10.4163 16.587 11.241Z"
                                        fill="black" />
                                    <path
                                        d="M6.41902 8.695L6.30902 8.305C5.48302 5.397 5.73302 3.314 6.99602 2.588C8.23102 1.873 10.218 2.718 12.299 4.853L12.583 5.145L12.299 5.436C11.5599 6.20469 10.8843 7.03207 10.279 7.91L10.166 8.072L9.97002 8.088C8.90561 8.1716 7.84978 8.34183 6.81302 8.597L6.41902 8.695ZM8.00102 3.166C7.77702 3.166 7.57902 3.215 7.41202 3.311C6.58402 3.788 6.43802 5.449 7.00802 7.691C7.89902 7.494 8.79802 7.353 9.70402 7.274C10.2285 6.53005 10.8007 5.8209 11.417 5.151C10.114 3.884 8.88402 3.166 8.00102 3.166ZM15.998 20.15C14.81 20.15 13.284 19.254 11.7 17.628L11.417 17.337L11.7 17.047C12.4393 16.2771 13.1151 15.4487 13.721 14.57L13.833 14.41L14.027 14.391C15.0918 14.3089 16.148 14.1393 17.185 13.884L17.58 13.784L17.691 14.175C18.513 17.081 18.264 19.167 17.003 19.893C16.6969 20.0665 16.3499 20.1553 15.998 20.15ZM12.583 17.33C13.885 18.597 15.116 19.316 15.998 19.316C16.223 19.316 16.421 19.266 16.587 19.171C17.416 18.693 17.563 17.029 16.991 14.787C16.101 14.985 15.201 15.127 14.293 15.206C13.7707 15.9511 13.1995 16.6607 12.583 17.33Z"
                                        fill="black" />
                                    <path
                                        d="M17.58 8.69501L17.185 8.59601C16.1481 8.34004 15.0918 8.1698 14.027 8.08701L13.833 8.07001L13.721 7.90801C13.116 7.0296 12.44 6.20217 11.7 5.43401L11.417 5.14301L11.7 4.85301C13.78 2.71901 15.766 1.87401 17.003 2.58801C18.265 3.31501 18.516 5.39801 17.691 8.30501L17.58 8.69501ZM14.293 7.27401C15.247 7.35901 16.151 7.50201 16.991 7.69101C17.562 5.44901 17.416 3.78801 16.587 3.31001C15.763 2.83301 14.212 3.56301 12.583 5.15101C13.199 5.82101 13.771 6.52901 14.293 7.27401ZM8.00101 20.15C7.64914 20.155 7.30227 20.0663 6.99601 19.893C5.73301 19.167 5.48301 17.082 6.30801 14.175L6.41601 13.784L6.81101 13.884C7.77501 14.127 8.83701 14.298 9.96901 14.391L10.163 14.41L10.276 14.57C10.88 15.448 11.556 16.277 12.296 17.047L12.58 17.337L12.296 17.628C10.713 19.255 9.18701 20.15 8.00101 20.15ZM7.00801 14.788C6.43801 17.03 6.58401 18.694 7.41201 19.172C8.23701 19.642 9.78301 18.917 11.417 17.33C10.801 16.6599 10.2288 15.9508 9.70401 15.207C8.7971 15.1268 7.89648 14.9868 7.00801 14.788Z"
                                        fill="black" />
                                    <path
                                        d="M11.9999 15.313C11.3129 15.313 10.6079 15.284 9.89991 15.225L9.70391 15.208L9.59091 15.046C9.19167 14.4719 8.81602 13.8818 8.46491 13.277C8.1164 12.6707 7.79247 12.0505 7.49391 11.418L7.40991 11.241L7.49391 11.062C7.79291 10.43 8.11591 9.81002 8.46491 9.20402C8.81191 8.60802 9.19091 8.01202 9.59091 7.43402L9.70391 7.27402L9.89991 7.25602C11.2968 7.13902 12.701 7.13902 14.0979 7.25602L14.2919 7.27502L14.4049 7.43502C15.2047 8.58378 15.9071 9.79733 16.5049 11.063L16.5879 11.242L16.5049 11.419C15.9088 12.6856 15.2063 13.8993 14.4049 15.047L14.2919 15.209L14.0979 15.226C13.3919 15.283 12.6859 15.313 11.9999 15.313ZM10.1659 14.409C11.4009 14.502 12.5989 14.502 13.8329 14.409C14.5218 13.4002 15.1342 12.3413 15.6649 11.241C15.1361 10.1398 14.5236 9.08068 13.8329 8.07302C12.6124 7.97902 11.3864 7.97902 10.1659 8.07302C9.47465 9.08032 8.86217 10.1395 8.33391 11.241C8.86579 12.3407 9.47812 13.3995 10.1659 14.409Z"
                                        fill="black" />
                                </svg></p>
                            <div class="row tobehide">

                                <div class="col-2 category">Mobile App Development</div>


                                <div class="col-2 category">Prototyping</div>


                                <div class="col-2 category">UI/UX Design</div>

                            </div>
                        </div>
                        <div class="col-1 tobehide"><svg xmlns="http://www.w3.org/2000/svg" width="43" height="43"
                                viewBox="0 0 43 43" fill="none">
                                <g clip-path="url(#clip0_364_424)">
                                    <path
                                        d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                        fill="#65649F" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_364_424">
                                        <rect width="32.527" height="27.3266" fill="white"
                                            transform="translate(0 23) rotate(-45)" />
                                    </clipPath>
                                </defs>
                            </svg></div>
                    </div>
                </a>


                <a href="https://hourlypresence.com/">
                    <div class="row hover-row" id="hover-element">
                        <div class="col-4 hover-row-heading">
                            <h3>Hourly Presence</h3>
                            <p class="hover-text">Hourly Presence, a unique app which is inspired by divine guidance
                                drawn from
                                Sarah Young's devotionals. The app focuses on sending daily reminders with Bible verses
                                to help users
                                stay connected with God. This well designed app helps users to uplift their spiritual
                                journey with
                                customizable features and curated verses.</p>
                        </div>
                        <div class="col-7">
                            <div class="row hidden-row">
                                <div class="col">
                                </div>
                                <div class="col">
                                    <img src="assets/wp-content/uploads/2024/04/Group-1000008337-1.png" alt="image">
                                </div>
                            </div>
                            <p class="tobehide">Ecommerce &nbsp; / &nbsp; <svg xmlns="http://www.w3.org/2000/svg"
                                    width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path
                                        d="M12.0001 13.03C12.9859 13.03 13.7851 12.2309 13.7851 11.245C13.7851 10.2592 12.9859 9.46002 12.0001 9.46002C11.0143 9.46002 10.2151 10.2592 10.2151 11.245C10.2151 12.2309 11.0143 13.03 12.0001 13.03Z"
                                        fill="black" />
                                    <path
                                        d="M7.00199 14.794L6.60699 14.693C3.67299 13.952 1.98999 12.692 1.98999 11.241C1.98999 9.78899 3.67399 8.52999 6.60699 7.78899L7.00199 7.68899L7.11299 8.07999C7.40953 9.10368 7.78947 10.1014 8.24899 11.063L8.33399 11.241L8.24899 11.419C7.78899 12.382 7.40799 13.38 7.11299 14.404L7.00199 14.794ZM6.42499 8.69899C4.19599 9.32699 2.82699 10.285 2.82699 11.241C2.82699 12.195 4.19499 13.154 6.42499 13.781C6.69799 12.913 7.02799 12.064 7.40999 11.241C7.02522 10.4166 6.69615 9.56738 6.42499 8.69899ZM16.997 14.794L16.887 14.402C16.5897 13.3781 16.2094 12.3801 15.75 11.418L15.665 11.241L15.75 11.062C16.21 10.101 16.589 9.10199 16.887 8.07799L16.997 7.68799L17.392 7.78799C20.327 8.52899 22.009 9.78799 22.009 11.241C22.009 12.693 20.326 13.952 17.392 14.693L16.997 14.794ZM16.587 11.241C16.987 12.107 17.32 12.959 17.574 13.781C19.804 13.154 21.173 12.195 21.173 11.241C21.173 10.285 19.805 9.32799 17.574 8.69899C17.3013 9.56711 16.9715 10.4163 16.587 11.241Z"
                                        fill="black" />
                                    <path
                                        d="M6.41902 8.695L6.30902 8.305C5.48302 5.397 5.73302 3.314 6.99602 2.588C8.23102 1.873 10.218 2.718 12.299 4.853L12.583 5.145L12.299 5.436C11.5599 6.20469 10.8843 7.03207 10.279 7.91L10.166 8.072L9.97002 8.088C8.90561 8.1716 7.84978 8.34183 6.81302 8.597L6.41902 8.695ZM8.00102 3.166C7.77702 3.166 7.57902 3.215 7.41202 3.311C6.58402 3.788 6.43802 5.449 7.00802 7.691C7.89902 7.494 8.79802 7.353 9.70402 7.274C10.2285 6.53005 10.8007 5.8209 11.417 5.151C10.114 3.884 8.88402 3.166 8.00102 3.166ZM15.998 20.15C14.81 20.15 13.284 19.254 11.7 17.628L11.417 17.337L11.7 17.047C12.4393 16.2771 13.1151 15.4487 13.721 14.57L13.833 14.41L14.027 14.391C15.0918 14.3089 16.148 14.1393 17.185 13.884L17.58 13.784L17.691 14.175C18.513 17.081 18.264 19.167 17.003 19.893C16.6969 20.0665 16.3499 20.1553 15.998 20.15ZM12.583 17.33C13.885 18.597 15.116 19.316 15.998 19.316C16.223 19.316 16.421 19.266 16.587 19.171C17.416 18.693 17.563 17.029 16.991 14.787C16.101 14.985 15.201 15.127 14.293 15.206C13.7707 15.9511 13.1995 16.6607 12.583 17.33Z"
                                        fill="black" />
                                    <path
                                        d="M17.58 8.69501L17.185 8.59601C16.1481 8.34004 15.0918 8.1698 14.027 8.08701L13.833 8.07001L13.721 7.90801C13.116 7.0296 12.44 6.20217 11.7 5.43401L11.417 5.14301L11.7 4.85301C13.78 2.71901 15.766 1.87401 17.003 2.58801C18.265 3.31501 18.516 5.39801 17.691 8.30501L17.58 8.69501ZM14.293 7.27401C15.247 7.35901 16.151 7.50201 16.991 7.69101C17.562 5.44901 17.416 3.78801 16.587 3.31001C15.763 2.83301 14.212 3.56301 12.583 5.15101C13.199 5.82101 13.771 6.52901 14.293 7.27401ZM8.00101 20.15C7.64914 20.155 7.30227 20.0663 6.99601 19.893C5.73301 19.167 5.48301 17.082 6.30801 14.175L6.41601 13.784L6.81101 13.884C7.77501 14.127 8.83701 14.298 9.96901 14.391L10.163 14.41L10.276 14.57C10.88 15.448 11.556 16.277 12.296 17.047L12.58 17.337L12.296 17.628C10.713 19.255 9.18701 20.15 8.00101 20.15ZM7.00801 14.788C6.43801 17.03 6.58401 18.694 7.41201 19.172C8.23701 19.642 9.78301 18.917 11.417 17.33C10.801 16.6599 10.2288 15.9508 9.70401 15.207C8.7971 15.1268 7.89648 14.9868 7.00801 14.788Z"
                                        fill="black" />
                                    <path
                                        d="M11.9999 15.313C11.3129 15.313 10.6079 15.284 9.89991 15.225L9.70391 15.208L9.59091 15.046C9.19167 14.4719 8.81602 13.8818 8.46491 13.277C8.1164 12.6707 7.79247 12.0505 7.49391 11.418L7.40991 11.241L7.49391 11.062C7.79291 10.43 8.11591 9.81002 8.46491 9.20402C8.81191 8.60802 9.19091 8.01202 9.59091 7.43402L9.70391 7.27402L9.89991 7.25602C11.2968 7.13902 12.701 7.13902 14.0979 7.25602L14.2919 7.27502L14.4049 7.43502C15.2047 8.58378 15.9071 9.79733 16.5049 11.063L16.5879 11.242L16.5049 11.419C15.9088 12.6856 15.2063 13.8993 14.4049 15.047L14.2919 15.209L14.0979 15.226C13.3919 15.283 12.6859 15.313 11.9999 15.313ZM10.1659 14.409C11.4009 14.502 12.5989 14.502 13.8329 14.409C14.5218 13.4002 15.1342 12.3413 15.6649 11.241C15.1361 10.1398 14.5236 9.08068 13.8329 8.07302C12.6124 7.97902 11.3864 7.97902 10.1659 8.07302C9.47465 9.08032 8.86217 10.1395 8.33391 11.241C8.86579 12.3407 9.47812 13.3995 10.1659 14.409Z"
                                        fill="black" />
                                </svg></p>
                            <div class="row tobehide">

                                <div class="col-2 category">Mobile App Development</div>


                                <div class="col-2 category">Prototyping</div>


                                <div class="col-2 category">UI/UX DesignMobile App Development</div>

                            </div>
                        </div>
                        <div class="col-1 tobehide"><svg xmlns="http://www.w3.org/2000/svg" width="43" height="43"
                                viewBox="0 0 43 43" fill="none">
                                <g clip-path="url(#clip0_364_424)">
                                    <path
                                        d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                        fill="#65649F" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_364_424">
                                        <rect width="32.527" height="27.3266" fill="white"
                                            transform="translate(0 23) rotate(-45)" />
                                    </clipPath>
                                </defs>
                            </svg></div>
                    </div>
                </a>


            </div>
        
        </div>
        <div class="mobile-hover-row" data-aos="fade-up" data-aos-duration="1000">


            <div class="row">
                <div class="case-img"><img src="assets/wp-content/uploads/2023/12/lacavalier-hover-1-1024x548.png"
                        alt="">
                </div>
                <div class="row case-detail-row">
                    <div class="col case-name-div">
                        <h2 class="case-name">lacavalier</h2>
                    </div>
                    <div class="col">
                        <p class="">Ecommerce &nbsp; / &nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"
                                fill="none">
                                <path
                                    d="M6.00004 6.51498C6.49296 6.51498 6.89254 6.11539 6.89254 5.62248C6.89254 5.12957 6.49296 4.72998 6.00004 4.72998C5.50713 4.72998 5.10754 5.12957 5.10754 5.62248C5.10754 6.11539 5.50713 6.51498 6.00004 6.51498Z"
                                    fill="black" />
                                <path
                                    d="M3.501 7.39699L3.30349 7.34649C1.83649 6.97599 0.994995 6.34599 0.994995 5.62049C0.994995 4.89449 1.83699 4.26499 3.30349 3.89449L3.501 3.84449L3.5565 4.03999C3.70477 4.55184 3.89473 5.05068 4.1245 5.53149L4.167 5.62049L4.1245 5.70949C3.8945 6.19099 3.704 6.68999 3.5565 7.20199L3.501 7.39699ZM3.2125 4.34949C2.098 4.66349 1.4135 5.14249 1.4135 5.62049C1.4135 6.09749 2.0975 6.57699 3.2125 6.89049C3.349 6.45649 3.514 6.03199 3.705 5.62049C3.51261 5.20831 3.34808 4.78369 3.2125 4.34949ZM8.4985 7.39699L8.44349 7.20099C8.29483 6.68905 8.1047 6.19006 7.875 5.70899L7.8325 5.62049L7.875 5.53099C8.105 5.05049 8.29449 4.55099 8.44349 4.03899L8.4985 3.84399L8.696 3.89399C10.1635 4.26449 11.0045 4.89399 11.0045 5.62049C11.0045 6.34649 10.163 6.97599 8.696 7.34649L8.4985 7.39699ZM8.2935 5.62049C8.49349 6.05349 8.66 6.47949 8.78699 6.89049C9.90199 6.57699 10.5865 6.09749 10.5865 5.62049C10.5865 5.14249 9.90249 4.66399 8.78699 4.34949C8.65063 4.78356 8.48577 5.20814 8.2935 5.62049Z"
                                    fill="black" />
                                <path
                                    d="M3.20951 4.3475L3.15451 4.1525C2.74151 2.6985 2.86651 1.657 3.49801 1.294C4.11551 0.936499 5.10901 1.359 6.14951 2.4265L6.29151 2.5725L6.14951 2.718C5.77995 3.10234 5.44217 3.51603 5.13951 3.955L5.08301 4.036L4.98501 4.044C4.4528 4.0858 3.92489 4.17091 3.40651 4.2985L3.20951 4.3475ZM4.00051 1.583C3.88851 1.583 3.78951 1.6075 3.70601 1.6555C3.29201 1.894 3.21901 2.7245 3.50401 3.8455C3.94951 3.747 4.39901 3.6765 4.85201 3.637C5.11427 3.26503 5.40037 2.91045 5.70851 2.5755C5.05701 1.942 4.44201 1.583 4.00051 1.583ZM7.99901 10.075C7.40501 10.075 6.64201 9.627 5.85001 8.814L5.70851 8.6685L5.85001 8.5235C6.21963 8.13854 6.55756 7.72436 6.86051 7.285L6.91651 7.205L7.01351 7.1955C7.54591 7.15444 8.07402 7.06965 8.59251 6.942L8.79001 6.892L8.84551 7.0875C9.25651 8.5405 9.13201 9.5835 8.50151 9.9465C8.34843 10.0333 8.17496 10.0776 7.99901 10.075ZM6.29151 8.665C6.94251 9.2985 7.55801 9.658 7.99901 9.658C8.11151 9.658 8.21051 9.633 8.29351 9.5855C8.70801 9.3465 8.78151 8.5145 8.49551 7.3935C8.05051 7.4925 7.60051 7.5635 7.14651 7.603C6.88537 7.97556 6.59974 8.33034 6.29151 8.665Z"
                                    fill="black" />
                                <path
                                    d="M8.79 4.34747L8.5925 4.29797C8.07404 4.16999 7.54592 4.08487 7.0135 4.04347L6.9165 4.03497L6.8605 3.95397C6.55798 3.51477 6.22002 3.10105 5.85 2.71697L5.7085 2.57147L5.85 2.42647C6.89 1.35947 7.883 0.936975 8.5015 1.29397C9.1325 1.65747 9.258 2.69897 8.8455 4.15247L8.79 4.34747ZM7.1465 3.63697C7.6235 3.67947 8.0755 3.75097 8.4955 3.84547C8.781 2.72447 8.708 1.89397 8.2935 1.65497C7.8815 1.41647 7.106 1.78147 6.2915 2.57547C6.5995 2.91047 6.8855 3.26447 7.1465 3.63697ZM4.0005 10.075C3.82457 10.0775 3.65113 10.0331 3.498 9.94647C2.8665 9.58347 2.7415 8.54097 3.154 7.08747L3.208 6.89197L3.4055 6.94197C3.8875 7.06347 4.4185 7.14897 4.9845 7.19547L5.0815 7.20497L5.138 7.28497C5.44 7.72397 5.778 8.13848 6.148 8.52348L6.29 8.66847L6.148 8.81397C5.3565 9.62747 4.5935 10.075 4.0005 10.075ZM3.504 7.39397C3.219 8.51497 3.292 9.34697 3.706 9.58597C4.1185 9.82097 4.8915 9.45848 5.7085 8.66497C5.40048 8.32992 5.11439 7.97535 4.852 7.60347C4.39855 7.56337 3.94824 7.49339 3.504 7.39397Z"
                                    fill="black" />
                                <path
                                    d="M5.99996 7.6566C5.65646 7.6566 5.30396 7.6421 4.94996 7.6126L4.85196 7.6041L4.79546 7.5231C4.59583 7.23605 4.40801 6.94097 4.23246 6.6386C4.0582 6.33542 3.89624 6.02533 3.74696 5.7091L3.70496 5.6206L3.74696 5.5311C3.89646 5.2151 4.05796 4.9051 4.23246 4.6021C4.40596 4.3041 4.59546 4.0061 4.79546 3.7171L4.85196 3.6371L4.94996 3.6281C5.6484 3.5696 6.35051 3.5696 7.04896 3.6281L7.14596 3.6376L7.20246 3.7176C7.60235 4.29198 7.95357 4.89876 8.25246 5.5316L8.29396 5.6211L8.25246 5.7096C7.9544 6.34288 7.60314 6.94973 7.20246 7.5236L7.14596 7.6046L7.04896 7.6131C6.69596 7.6416 6.34296 7.6566 5.99996 7.6566ZM5.08296 7.2046C5.70046 7.2511 6.29946 7.2511 6.91646 7.2046C7.2609 6.70021 7.56709 6.17073 7.83246 5.6206C7.56803 5.06998 7.2618 4.54043 6.91646 4.0366C6.30619 3.9896 5.69322 3.9896 5.08296 4.0366C4.73733 4.54025 4.43108 5.06982 4.16696 5.6206C4.43289 6.17042 4.73906 6.69986 5.08296 7.2046Z"
                                    fill="black" />
                            </svg>
                        </p>
                        <div class="row">

                            <div class="category">Mobile App Development</div>


                            <div class="category">Prototyping</div>

                        </div>
                    </div>
                    <div class="col-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43" fill="none">
                            <g clip-path="url(#clip0_364_424)">
                                <path
                                    d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                    fill="#65649F" />
                            </g>
                            <defs>
                                <clipPath id="clip0_364_424">
                                    <rect width="32.527" height="27.3266" fill="white"
                                        transform="translate(0 23) rotate(-45)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="case-img"><img src="assets/wp-content/uploads/2023/12/mind-hover-1-1024x548.png" alt="">
                </div>
                <div class="row case-detail-row">
                    <div class="col case-name-div">
                        <h2 class="case-name">mind nourishment</h2>
                    </div>
                    <div class="col">
                        <p class="">Ecommerce &nbsp; / &nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"
                                fill="none">
                                <path
                                    d="M6.00004 6.51498C6.49296 6.51498 6.89254 6.11539 6.89254 5.62248C6.89254 5.12957 6.49296 4.72998 6.00004 4.72998C5.50713 4.72998 5.10754 5.12957 5.10754 5.62248C5.10754 6.11539 5.50713 6.51498 6.00004 6.51498Z"
                                    fill="black" />
                                <path
                                    d="M3.501 7.39699L3.30349 7.34649C1.83649 6.97599 0.994995 6.34599 0.994995 5.62049C0.994995 4.89449 1.83699 4.26499 3.30349 3.89449L3.501 3.84449L3.5565 4.03999C3.70477 4.55184 3.89473 5.05068 4.1245 5.53149L4.167 5.62049L4.1245 5.70949C3.8945 6.19099 3.704 6.68999 3.5565 7.20199L3.501 7.39699ZM3.2125 4.34949C2.098 4.66349 1.4135 5.14249 1.4135 5.62049C1.4135 6.09749 2.0975 6.57699 3.2125 6.89049C3.349 6.45649 3.514 6.03199 3.705 5.62049C3.51261 5.20831 3.34808 4.78369 3.2125 4.34949ZM8.4985 7.39699L8.44349 7.20099C8.29483 6.68905 8.1047 6.19006 7.875 5.70899L7.8325 5.62049L7.875 5.53099C8.105 5.05049 8.29449 4.55099 8.44349 4.03899L8.4985 3.84399L8.696 3.89399C10.1635 4.26449 11.0045 4.89399 11.0045 5.62049C11.0045 6.34649 10.163 6.97599 8.696 7.34649L8.4985 7.39699ZM8.2935 5.62049C8.49349 6.05349 8.66 6.47949 8.78699 6.89049C9.90199 6.57699 10.5865 6.09749 10.5865 5.62049C10.5865 5.14249 9.90249 4.66399 8.78699 4.34949C8.65063 4.78356 8.48577 5.20814 8.2935 5.62049Z"
                                    fill="black" />
                                <path
                                    d="M3.20951 4.3475L3.15451 4.1525C2.74151 2.6985 2.86651 1.657 3.49801 1.294C4.11551 0.936499 5.10901 1.359 6.14951 2.4265L6.29151 2.5725L6.14951 2.718C5.77995 3.10234 5.44217 3.51603 5.13951 3.955L5.08301 4.036L4.98501 4.044C4.4528 4.0858 3.92489 4.17091 3.40651 4.2985L3.20951 4.3475ZM4.00051 1.583C3.88851 1.583 3.78951 1.6075 3.70601 1.6555C3.29201 1.894 3.21901 2.7245 3.50401 3.8455C3.94951 3.747 4.39901 3.6765 4.85201 3.637C5.11427 3.26503 5.40037 2.91045 5.70851 2.5755C5.05701 1.942 4.44201 1.583 4.00051 1.583ZM7.99901 10.075C7.40501 10.075 6.64201 9.627 5.85001 8.814L5.70851 8.6685L5.85001 8.5235C6.21963 8.13854 6.55756 7.72436 6.86051 7.285L6.91651 7.205L7.01351 7.1955C7.54591 7.15444 8.07402 7.06965 8.59251 6.942L8.79001 6.892L8.84551 7.0875C9.25651 8.5405 9.13201 9.5835 8.50151 9.9465C8.34843 10.0333 8.17496 10.0776 7.99901 10.075ZM6.29151 8.665C6.94251 9.2985 7.55801 9.658 7.99901 9.658C8.11151 9.658 8.21051 9.633 8.29351 9.5855C8.70801 9.3465 8.78151 8.5145 8.49551 7.3935C8.05051 7.4925 7.60051 7.5635 7.14651 7.603C6.88537 7.97556 6.59974 8.33034 6.29151 8.665Z"
                                    fill="black" />
                                <path
                                    d="M8.79 4.34747L8.5925 4.29797C8.07404 4.16999 7.54592 4.08487 7.0135 4.04347L6.9165 4.03497L6.8605 3.95397C6.55798 3.51477 6.22002 3.10105 5.85 2.71697L5.7085 2.57147L5.85 2.42647C6.89 1.35947 7.883 0.936975 8.5015 1.29397C9.1325 1.65747 9.258 2.69897 8.8455 4.15247L8.79 4.34747ZM7.1465 3.63697C7.6235 3.67947 8.0755 3.75097 8.4955 3.84547C8.781 2.72447 8.708 1.89397 8.2935 1.65497C7.8815 1.41647 7.106 1.78147 6.2915 2.57547C6.5995 2.91047 6.8855 3.26447 7.1465 3.63697ZM4.0005 10.075C3.82457 10.0775 3.65113 10.0331 3.498 9.94647C2.8665 9.58347 2.7415 8.54097 3.154 7.08747L3.208 6.89197L3.4055 6.94197C3.8875 7.06347 4.4185 7.14897 4.9845 7.19547L5.0815 7.20497L5.138 7.28497C5.44 7.72397 5.778 8.13848 6.148 8.52348L6.29 8.66847L6.148 8.81397C5.3565 9.62747 4.5935 10.075 4.0005 10.075ZM3.504 7.39397C3.219 8.51497 3.292 9.34697 3.706 9.58597C4.1185 9.82097 4.8915 9.45848 5.7085 8.66497C5.40048 8.32992 5.11439 7.97535 4.852 7.60347C4.39855 7.56337 3.94824 7.49339 3.504 7.39397Z"
                                    fill="black" />
                                <path
                                    d="M5.99996 7.6566C5.65646 7.6566 5.30396 7.6421 4.94996 7.6126L4.85196 7.6041L4.79546 7.5231C4.59583 7.23605 4.40801 6.94097 4.23246 6.6386C4.0582 6.33542 3.89624 6.02533 3.74696 5.7091L3.70496 5.6206L3.74696 5.5311C3.89646 5.2151 4.05796 4.9051 4.23246 4.6021C4.40596 4.3041 4.59546 4.0061 4.79546 3.7171L4.85196 3.6371L4.94996 3.6281C5.6484 3.5696 6.35051 3.5696 7.04896 3.6281L7.14596 3.6376L7.20246 3.7176C7.60235 4.29198 7.95357 4.89876 8.25246 5.5316L8.29396 5.6211L8.25246 5.7096C7.9544 6.34288 7.60314 6.94973 7.20246 7.5236L7.14596 7.6046L7.04896 7.6131C6.69596 7.6416 6.34296 7.6566 5.99996 7.6566ZM5.08296 7.2046C5.70046 7.2511 6.29946 7.2511 6.91646 7.2046C7.2609 6.70021 7.56709 6.17073 7.83246 5.6206C7.56803 5.06998 7.2618 4.54043 6.91646 4.0366C6.30619 3.9896 5.69322 3.9896 5.08296 4.0366C4.73733 4.54025 4.43108 5.06982 4.16696 5.6206C4.43289 6.17042 4.73906 6.69986 5.08296 7.2046Z"
                                    fill="black" />
                            </svg>
                        </p>
                        <div class="row">

                            <div class="category">Mobile App Development</div>


                            <div class="category">Prototyping</div>


                            <div class="category">UI/UX Design</div>

                        </div>
                    </div>
                    <div class="col-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43" fill="none">
                            <g clip-path="url(#clip0_364_424)">
                                <path
                                    d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                    fill="#65649F" />
                            </g>
                            <defs>
                                <clipPath id="clip0_364_424">
                                    <rect width="32.527" height="27.3266" fill="white"
                                        transform="translate(0 23) rotate(-45)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="case-img"><img src="assets/wp-content/uploads/2023/12/kelstech-hover-2.png" alt=""></div>
                <div class="row case-detail-row">
                    <div class="col case-name-div">
                        <h2 class="case-name">kelstech</h2>
                    </div>
                    <div class="col">
                        <p class="">Ecommerce &nbsp; / &nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"
                                fill="none">
                                <path
                                    d="M6.00004 6.51498C6.49296 6.51498 6.89254 6.11539 6.89254 5.62248C6.89254 5.12957 6.49296 4.72998 6.00004 4.72998C5.50713 4.72998 5.10754 5.12957 5.10754 5.62248C5.10754 6.11539 5.50713 6.51498 6.00004 6.51498Z"
                                    fill="black" />
                                <path
                                    d="M3.501 7.39699L3.30349 7.34649C1.83649 6.97599 0.994995 6.34599 0.994995 5.62049C0.994995 4.89449 1.83699 4.26499 3.30349 3.89449L3.501 3.84449L3.5565 4.03999C3.70477 4.55184 3.89473 5.05068 4.1245 5.53149L4.167 5.62049L4.1245 5.70949C3.8945 6.19099 3.704 6.68999 3.5565 7.20199L3.501 7.39699ZM3.2125 4.34949C2.098 4.66349 1.4135 5.14249 1.4135 5.62049C1.4135 6.09749 2.0975 6.57699 3.2125 6.89049C3.349 6.45649 3.514 6.03199 3.705 5.62049C3.51261 5.20831 3.34808 4.78369 3.2125 4.34949ZM8.4985 7.39699L8.44349 7.20099C8.29483 6.68905 8.1047 6.19006 7.875 5.70899L7.8325 5.62049L7.875 5.53099C8.105 5.05049 8.29449 4.55099 8.44349 4.03899L8.4985 3.84399L8.696 3.89399C10.1635 4.26449 11.0045 4.89399 11.0045 5.62049C11.0045 6.34649 10.163 6.97599 8.696 7.34649L8.4985 7.39699ZM8.2935 5.62049C8.49349 6.05349 8.66 6.47949 8.78699 6.89049C9.90199 6.57699 10.5865 6.09749 10.5865 5.62049C10.5865 5.14249 9.90249 4.66399 8.78699 4.34949C8.65063 4.78356 8.48577 5.20814 8.2935 5.62049Z"
                                    fill="black" />
                                <path
                                    d="M3.20951 4.3475L3.15451 4.1525C2.74151 2.6985 2.86651 1.657 3.49801 1.294C4.11551 0.936499 5.10901 1.359 6.14951 2.4265L6.29151 2.5725L6.14951 2.718C5.77995 3.10234 5.44217 3.51603 5.13951 3.955L5.08301 4.036L4.98501 4.044C4.4528 4.0858 3.92489 4.17091 3.40651 4.2985L3.20951 4.3475ZM4.00051 1.583C3.88851 1.583 3.78951 1.6075 3.70601 1.6555C3.29201 1.894 3.21901 2.7245 3.50401 3.8455C3.94951 3.747 4.39901 3.6765 4.85201 3.637C5.11427 3.26503 5.40037 2.91045 5.70851 2.5755C5.05701 1.942 4.44201 1.583 4.00051 1.583ZM7.99901 10.075C7.40501 10.075 6.64201 9.627 5.85001 8.814L5.70851 8.6685L5.85001 8.5235C6.21963 8.13854 6.55756 7.72436 6.86051 7.285L6.91651 7.205L7.01351 7.1955C7.54591 7.15444 8.07402 7.06965 8.59251 6.942L8.79001 6.892L8.84551 7.0875C9.25651 8.5405 9.13201 9.5835 8.50151 9.9465C8.34843 10.0333 8.17496 10.0776 7.99901 10.075ZM6.29151 8.665C6.94251 9.2985 7.55801 9.658 7.99901 9.658C8.11151 9.658 8.21051 9.633 8.29351 9.5855C8.70801 9.3465 8.78151 8.5145 8.49551 7.3935C8.05051 7.4925 7.60051 7.5635 7.14651 7.603C6.88537 7.97556 6.59974 8.33034 6.29151 8.665Z"
                                    fill="black" />
                                <path
                                    d="M8.79 4.34747L8.5925 4.29797C8.07404 4.16999 7.54592 4.08487 7.0135 4.04347L6.9165 4.03497L6.8605 3.95397C6.55798 3.51477 6.22002 3.10105 5.85 2.71697L5.7085 2.57147L5.85 2.42647C6.89 1.35947 7.883 0.936975 8.5015 1.29397C9.1325 1.65747 9.258 2.69897 8.8455 4.15247L8.79 4.34747ZM7.1465 3.63697C7.6235 3.67947 8.0755 3.75097 8.4955 3.84547C8.781 2.72447 8.708 1.89397 8.2935 1.65497C7.8815 1.41647 7.106 1.78147 6.2915 2.57547C6.5995 2.91047 6.8855 3.26447 7.1465 3.63697ZM4.0005 10.075C3.82457 10.0775 3.65113 10.0331 3.498 9.94647C2.8665 9.58347 2.7415 8.54097 3.154 7.08747L3.208 6.89197L3.4055 6.94197C3.8875 7.06347 4.4185 7.14897 4.9845 7.19547L5.0815 7.20497L5.138 7.28497C5.44 7.72397 5.778 8.13848 6.148 8.52348L6.29 8.66847L6.148 8.81397C5.3565 9.62747 4.5935 10.075 4.0005 10.075ZM3.504 7.39397C3.219 8.51497 3.292 9.34697 3.706 9.58597C4.1185 9.82097 4.8915 9.45848 5.7085 8.66497C5.40048 8.32992 5.11439 7.97535 4.852 7.60347C4.39855 7.56337 3.94824 7.49339 3.504 7.39397Z"
                                    fill="black" />
                                <path
                                    d="M5.99996 7.6566C5.65646 7.6566 5.30396 7.6421 4.94996 7.6126L4.85196 7.6041L4.79546 7.5231C4.59583 7.23605 4.40801 6.94097 4.23246 6.6386C4.0582 6.33542 3.89624 6.02533 3.74696 5.7091L3.70496 5.6206L3.74696 5.5311C3.89646 5.2151 4.05796 4.9051 4.23246 4.6021C4.40596 4.3041 4.59546 4.0061 4.79546 3.7171L4.85196 3.6371L4.94996 3.6281C5.6484 3.5696 6.35051 3.5696 7.04896 3.6281L7.14596 3.6376L7.20246 3.7176C7.60235 4.29198 7.95357 4.89876 8.25246 5.5316L8.29396 5.6211L8.25246 5.7096C7.9544 6.34288 7.60314 6.94973 7.20246 7.5236L7.14596 7.6046L7.04896 7.6131C6.69596 7.6416 6.34296 7.6566 5.99996 7.6566ZM5.08296 7.2046C5.70046 7.2511 6.29946 7.2511 6.91646 7.2046C7.2609 6.70021 7.56709 6.17073 7.83246 5.6206C7.56803 5.06998 7.2618 4.54043 6.91646 4.0366C6.30619 3.9896 5.69322 3.9896 5.08296 4.0366C4.73733 4.54025 4.43108 5.06982 4.16696 5.6206C4.43289 6.17042 4.73906 6.69986 5.08296 7.2046Z"
                                    fill="black" />
                            </svg>
                        </p>
                        <div class="row">

                            <div class="category">Mobile App Development</div>


                            <div class="category">Prototyping</div>


                            <div class="category">UI/UX Design</div>

                        </div>
                    </div>
                    <div class="col-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43" fill="none">
                            <g clip-path="url(#clip0_364_424)">
                                <path
                                    d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                    fill="#65649F" />
                            </g>
                            <defs>
                                <clipPath id="clip0_364_424">
                                    <rect width="32.527" height="27.3266" fill="white"
                                        transform="translate(0 23) rotate(-45)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="case-img"><img src="assets/wp-content/uploads/2023/12/vstream-aviation-hover-1-1024x548.png"
                        alt="">
                </div>
                <div class="row case-detail-row">
                    <div class="col case-name-div">
                        <h2 class="case-name">v-stream aviation</h2>
                    </div>
                    <div class="col">
                        <p class="">Ecommerce &nbsp; / &nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"
                                fill="none">
                                <path
                                    d="M6.00004 6.51498C6.49296 6.51498 6.89254 6.11539 6.89254 5.62248C6.89254 5.12957 6.49296 4.72998 6.00004 4.72998C5.50713 4.72998 5.10754 5.12957 5.10754 5.62248C5.10754 6.11539 5.50713 6.51498 6.00004 6.51498Z"
                                    fill="black" />
                                <path
                                    d="M3.501 7.39699L3.30349 7.34649C1.83649 6.97599 0.994995 6.34599 0.994995 5.62049C0.994995 4.89449 1.83699 4.26499 3.30349 3.89449L3.501 3.84449L3.5565 4.03999C3.70477 4.55184 3.89473 5.05068 4.1245 5.53149L4.167 5.62049L4.1245 5.70949C3.8945 6.19099 3.704 6.68999 3.5565 7.20199L3.501 7.39699ZM3.2125 4.34949C2.098 4.66349 1.4135 5.14249 1.4135 5.62049C1.4135 6.09749 2.0975 6.57699 3.2125 6.89049C3.349 6.45649 3.514 6.03199 3.705 5.62049C3.51261 5.20831 3.34808 4.78369 3.2125 4.34949ZM8.4985 7.39699L8.44349 7.20099C8.29483 6.68905 8.1047 6.19006 7.875 5.70899L7.8325 5.62049L7.875 5.53099C8.105 5.05049 8.29449 4.55099 8.44349 4.03899L8.4985 3.84399L8.696 3.89399C10.1635 4.26449 11.0045 4.89399 11.0045 5.62049C11.0045 6.34649 10.163 6.97599 8.696 7.34649L8.4985 7.39699ZM8.2935 5.62049C8.49349 6.05349 8.66 6.47949 8.78699 6.89049C9.90199 6.57699 10.5865 6.09749 10.5865 5.62049C10.5865 5.14249 9.90249 4.66399 8.78699 4.34949C8.65063 4.78356 8.48577 5.20814 8.2935 5.62049Z"
                                    fill="black" />
                                <path
                                    d="M3.20951 4.3475L3.15451 4.1525C2.74151 2.6985 2.86651 1.657 3.49801 1.294C4.11551 0.936499 5.10901 1.359 6.14951 2.4265L6.29151 2.5725L6.14951 2.718C5.77995 3.10234 5.44217 3.51603 5.13951 3.955L5.08301 4.036L4.98501 4.044C4.4528 4.0858 3.92489 4.17091 3.40651 4.2985L3.20951 4.3475ZM4.00051 1.583C3.88851 1.583 3.78951 1.6075 3.70601 1.6555C3.29201 1.894 3.21901 2.7245 3.50401 3.8455C3.94951 3.747 4.39901 3.6765 4.85201 3.637C5.11427 3.26503 5.40037 2.91045 5.70851 2.5755C5.05701 1.942 4.44201 1.583 4.00051 1.583ZM7.99901 10.075C7.40501 10.075 6.64201 9.627 5.85001 8.814L5.70851 8.6685L5.85001 8.5235C6.21963 8.13854 6.55756 7.72436 6.86051 7.285L6.91651 7.205L7.01351 7.1955C7.54591 7.15444 8.07402 7.06965 8.59251 6.942L8.79001 6.892L8.84551 7.0875C9.25651 8.5405 9.13201 9.5835 8.50151 9.9465C8.34843 10.0333 8.17496 10.0776 7.99901 10.075ZM6.29151 8.665C6.94251 9.2985 7.55801 9.658 7.99901 9.658C8.11151 9.658 8.21051 9.633 8.29351 9.5855C8.70801 9.3465 8.78151 8.5145 8.49551 7.3935C8.05051 7.4925 7.60051 7.5635 7.14651 7.603C6.88537 7.97556 6.59974 8.33034 6.29151 8.665Z"
                                    fill="black" />
                                <path
                                    d="M8.79 4.34747L8.5925 4.29797C8.07404 4.16999 7.54592 4.08487 7.0135 4.04347L6.9165 4.03497L6.8605 3.95397C6.55798 3.51477 6.22002 3.10105 5.85 2.71697L5.7085 2.57147L5.85 2.42647C6.89 1.35947 7.883 0.936975 8.5015 1.29397C9.1325 1.65747 9.258 2.69897 8.8455 4.15247L8.79 4.34747ZM7.1465 3.63697C7.6235 3.67947 8.0755 3.75097 8.4955 3.84547C8.781 2.72447 8.708 1.89397 8.2935 1.65497C7.8815 1.41647 7.106 1.78147 6.2915 2.57547C6.5995 2.91047 6.8855 3.26447 7.1465 3.63697ZM4.0005 10.075C3.82457 10.0775 3.65113 10.0331 3.498 9.94647C2.8665 9.58347 2.7415 8.54097 3.154 7.08747L3.208 6.89197L3.4055 6.94197C3.8875 7.06347 4.4185 7.14897 4.9845 7.19547L5.0815 7.20497L5.138 7.28497C5.44 7.72397 5.778 8.13848 6.148 8.52348L6.29 8.66847L6.148 8.81397C5.3565 9.62747 4.5935 10.075 4.0005 10.075ZM3.504 7.39397C3.219 8.51497 3.292 9.34697 3.706 9.58597C4.1185 9.82097 4.8915 9.45848 5.7085 8.66497C5.40048 8.32992 5.11439 7.97535 4.852 7.60347C4.39855 7.56337 3.94824 7.49339 3.504 7.39397Z"
                                    fill="black" />
                                <path
                                    d="M5.99996 7.6566C5.65646 7.6566 5.30396 7.6421 4.94996 7.6126L4.85196 7.6041L4.79546 7.5231C4.59583 7.23605 4.40801 6.94097 4.23246 6.6386C4.0582 6.33542 3.89624 6.02533 3.74696 5.7091L3.70496 5.6206L3.74696 5.5311C3.89646 5.2151 4.05796 4.9051 4.23246 4.6021C4.40596 4.3041 4.59546 4.0061 4.79546 3.7171L4.85196 3.6371L4.94996 3.6281C5.6484 3.5696 6.35051 3.5696 7.04896 3.6281L7.14596 3.6376L7.20246 3.7176C7.60235 4.29198 7.95357 4.89876 8.25246 5.5316L8.29396 5.6211L8.25246 5.7096C7.9544 6.34288 7.60314 6.94973 7.20246 7.5236L7.14596 7.6046L7.04896 7.6131C6.69596 7.6416 6.34296 7.6566 5.99996 7.6566ZM5.08296 7.2046C5.70046 7.2511 6.29946 7.2511 6.91646 7.2046C7.2609 6.70021 7.56709 6.17073 7.83246 5.6206C7.56803 5.06998 7.2618 4.54043 6.91646 4.0366C6.30619 3.9896 5.69322 3.9896 5.08296 4.0366C4.73733 4.54025 4.43108 5.06982 4.16696 5.6206C4.43289 6.17042 4.73906 6.69986 5.08296 7.2046Z"
                                    fill="black" />
                            </svg>
                        </p>
                        <div class="row">

                            <div class="category">Mobile App Development</div>


                            <div class="category">Prototyping</div>


                            <div class="category">UI/UX Design</div>

                        </div>
                    </div>
                    <div class="col-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43" fill="none">
                            <g clip-path="url(#clip0_364_424)">
                                <path
                                    d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                    fill="#65649F" />
                            </g>
                            <defs>
                                <clipPath id="clip0_364_424">
                                    <rect width="32.527" height="27.3266" fill="white"
                                        transform="translate(0 23) rotate(-45)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="case-img"><img src="assets/wp-content/uploads/2024/04/Group-1000008337-1.png" alt=""></div>
                <div class="row case-detail-row">
                    <div class="col case-name-div">
                        <h2 class="case-name">Hourly Presence</h2>
                    </div>
                    <div class="col">
                        <p class="">Ecommerce &nbsp; / &nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"
                                fill="none">
                                <path
                                    d="M6.00004 6.51498C6.49296 6.51498 6.89254 6.11539 6.89254 5.62248C6.89254 5.12957 6.49296 4.72998 6.00004 4.72998C5.50713 4.72998 5.10754 5.12957 5.10754 5.62248C5.10754 6.11539 5.50713 6.51498 6.00004 6.51498Z"
                                    fill="black" />
                                <path
                                    d="M3.501 7.39699L3.30349 7.34649C1.83649 6.97599 0.994995 6.34599 0.994995 5.62049C0.994995 4.89449 1.83699 4.26499 3.30349 3.89449L3.501 3.84449L3.5565 4.03999C3.70477 4.55184 3.89473 5.05068 4.1245 5.53149L4.167 5.62049L4.1245 5.70949C3.8945 6.19099 3.704 6.68999 3.5565 7.20199L3.501 7.39699ZM3.2125 4.34949C2.098 4.66349 1.4135 5.14249 1.4135 5.62049C1.4135 6.09749 2.0975 6.57699 3.2125 6.89049C3.349 6.45649 3.514 6.03199 3.705 5.62049C3.51261 5.20831 3.34808 4.78369 3.2125 4.34949ZM8.4985 7.39699L8.44349 7.20099C8.29483 6.68905 8.1047 6.19006 7.875 5.70899L7.8325 5.62049L7.875 5.53099C8.105 5.05049 8.29449 4.55099 8.44349 4.03899L8.4985 3.84399L8.696 3.89399C10.1635 4.26449 11.0045 4.89399 11.0045 5.62049C11.0045 6.34649 10.163 6.97599 8.696 7.34649L8.4985 7.39699ZM8.2935 5.62049C8.49349 6.05349 8.66 6.47949 8.78699 6.89049C9.90199 6.57699 10.5865 6.09749 10.5865 5.62049C10.5865 5.14249 9.90249 4.66399 8.78699 4.34949C8.65063 4.78356 8.48577 5.20814 8.2935 5.62049Z"
                                    fill="black" />
                                <path
                                    d="M3.20951 4.3475L3.15451 4.1525C2.74151 2.6985 2.86651 1.657 3.49801 1.294C4.11551 0.936499 5.10901 1.359 6.14951 2.4265L6.29151 2.5725L6.14951 2.718C5.77995 3.10234 5.44217 3.51603 5.13951 3.955L5.08301 4.036L4.98501 4.044C4.4528 4.0858 3.92489 4.17091 3.40651 4.2985L3.20951 4.3475ZM4.00051 1.583C3.88851 1.583 3.78951 1.6075 3.70601 1.6555C3.29201 1.894 3.21901 2.7245 3.50401 3.8455C3.94951 3.747 4.39901 3.6765 4.85201 3.637C5.11427 3.26503 5.40037 2.91045 5.70851 2.5755C5.05701 1.942 4.44201 1.583 4.00051 1.583ZM7.99901 10.075C7.40501 10.075 6.64201 9.627 5.85001 8.814L5.70851 8.6685L5.85001 8.5235C6.21963 8.13854 6.55756 7.72436 6.86051 7.285L6.91651 7.205L7.01351 7.1955C7.54591 7.15444 8.07402 7.06965 8.59251 6.942L8.79001 6.892L8.84551 7.0875C9.25651 8.5405 9.13201 9.5835 8.50151 9.9465C8.34843 10.0333 8.17496 10.0776 7.99901 10.075ZM6.29151 8.665C6.94251 9.2985 7.55801 9.658 7.99901 9.658C8.11151 9.658 8.21051 9.633 8.29351 9.5855C8.70801 9.3465 8.78151 8.5145 8.49551 7.3935C8.05051 7.4925 7.60051 7.5635 7.14651 7.603C6.88537 7.97556 6.59974 8.33034 6.29151 8.665Z"
                                    fill="black" />
                                <path
                                    d="M8.79 4.34747L8.5925 4.29797C8.07404 4.16999 7.54592 4.08487 7.0135 4.04347L6.9165 4.03497L6.8605 3.95397C6.55798 3.51477 6.22002 3.10105 5.85 2.71697L5.7085 2.57147L5.85 2.42647C6.89 1.35947 7.883 0.936975 8.5015 1.29397C9.1325 1.65747 9.258 2.69897 8.8455 4.15247L8.79 4.34747ZM7.1465 3.63697C7.6235 3.67947 8.0755 3.75097 8.4955 3.84547C8.781 2.72447 8.708 1.89397 8.2935 1.65497C7.8815 1.41647 7.106 1.78147 6.2915 2.57547C6.5995 2.91047 6.8855 3.26447 7.1465 3.63697ZM4.0005 10.075C3.82457 10.0775 3.65113 10.0331 3.498 9.94647C2.8665 9.58347 2.7415 8.54097 3.154 7.08747L3.208 6.89197L3.4055 6.94197C3.8875 7.06347 4.4185 7.14897 4.9845 7.19547L5.0815 7.20497L5.138 7.28497C5.44 7.72397 5.778 8.13848 6.148 8.52348L6.29 8.66847L6.148 8.81397C5.3565 9.62747 4.5935 10.075 4.0005 10.075ZM3.504 7.39397C3.219 8.51497 3.292 9.34697 3.706 9.58597C4.1185 9.82097 4.8915 9.45848 5.7085 8.66497C5.40048 8.32992 5.11439 7.97535 4.852 7.60347C4.39855 7.56337 3.94824 7.49339 3.504 7.39397Z"
                                    fill="black" />
                                <path
                                    d="M5.99996 7.6566C5.65646 7.6566 5.30396 7.6421 4.94996 7.6126L4.85196 7.6041L4.79546 7.5231C4.59583 7.23605 4.40801 6.94097 4.23246 6.6386C4.0582 6.33542 3.89624 6.02533 3.74696 5.7091L3.70496 5.6206L3.74696 5.5311C3.89646 5.2151 4.05796 4.9051 4.23246 4.6021C4.40596 4.3041 4.59546 4.0061 4.79546 3.7171L4.85196 3.6371L4.94996 3.6281C5.6484 3.5696 6.35051 3.5696 7.04896 3.6281L7.14596 3.6376L7.20246 3.7176C7.60235 4.29198 7.95357 4.89876 8.25246 5.5316L8.29396 5.6211L8.25246 5.7096C7.9544 6.34288 7.60314 6.94973 7.20246 7.5236L7.14596 7.6046L7.04896 7.6131C6.69596 7.6416 6.34296 7.6566 5.99996 7.6566ZM5.08296 7.2046C5.70046 7.2511 6.29946 7.2511 6.91646 7.2046C7.2609 6.70021 7.56709 6.17073 7.83246 5.6206C7.56803 5.06998 7.2618 4.54043 6.91646 4.0366C6.30619 3.9896 5.69322 3.9896 5.08296 4.0366C4.73733 4.54025 4.43108 5.06982 4.16696 5.6206C4.43289 6.17042 4.73906 6.69986 5.08296 7.2046Z"
                                    fill="black" />
                            </svg>
                        </p>
                        <div class="row">

                            <div class="category">Mobile App Development</div>


                            <div class="category">Prototyping</div>


                            <div class="category">UI/UX DesignMobile App Development</div>

                        </div>
                    </div>
                    <div class="col-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43" fill="none">
                            <g clip-path="url(#clip0_364_424)">
                                <path
                                    d="M16.4881 17.1085C16.291 17.1155 16.0945 17.0827 15.9103 17.012C15.7262 16.9414 15.5582 16.8344 15.4163 16.6974C15.2744 16.5605 15.1615 16.3963 15.0844 16.2148C15.0073 16.0332 14.9676 15.838 14.9676 15.6408C14.9676 15.4435 15.0073 15.2483 15.0844 15.0668C15.1615 14.8852 15.2744 14.7211 15.4163 14.5841C15.5582 14.4471 15.7262 14.3401 15.9103 14.2695C16.0945 14.1989 16.291 14.166 16.4881 14.173L27.5655 14.173C27.9547 14.1732 28.3279 14.328 28.6031 14.6032C28.8783 14.8784 29.0331 15.2516 29.0333 15.6408L29.0333 26.7182C29.0403 26.9153 29.0075 27.1118 28.9368 27.296C28.8662 27.4801 28.7592 27.6482 28.6222 27.7901C28.4852 27.932 28.3211 28.0448 28.1395 28.1219C27.958 28.199 27.7628 28.2387 27.5655 28.2387C27.3683 28.2387 27.1731 28.199 26.9916 28.1219C26.81 28.0448 26.6459 27.932 26.5089 27.7901C26.3719 27.6482 26.2649 27.4801 26.1943 27.296C26.1236 27.1118 26.0908 26.9153 26.0978 26.7182L26.0978 19.1856L12.6802 32.6031C12.4048 32.8785 12.0312 33.0333 11.6417 33.0333C11.2522 33.0333 10.8786 32.8785 10.6032 32.6031C10.3278 32.3277 10.173 31.9541 10.173 31.5646C10.173 31.1751 10.3278 30.8015 10.6032 30.5261L24.0208 17.1085L16.4881 17.1085Z"
                                    fill="#65649F" />
                            </g>
                            <defs>
                                <clipPath id="clip0_364_424">
                                    <rect width="32.527" height="27.3266" fill="white"
                                        transform="translate(0 23) rotate(-45)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>


            <div class="container-fluid cs-button-sec">
                <a href="#costumModal9" data-toggle="modal">
                    <button class="cs-button">Get Started
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none">
                            <path
                                d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z"
                                fill="#20b8f9" />
                        </svg>
                    </button></a>
            </div>
</section> -->

<section class="sixth-sec">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-5 full-width" data-aos="fade-right" data-aos-duration="1000">
                    <div class="row">
                        <h2 class="col-2 up-down-before" style="width: 100% !important;">Serving </h2>
                        <div class="col-6 common-up-down">
                            <div class="box">
                                <div class="inner" style="width: 460px !important;">
                                    <span>Forward-Thinking <br> Growth-Oriented</span>
                                </div>
                            </div>
                        </div>
                        <h2 class="up-down-before full-width">Progressive Industries with Expertise</h2>
                    </div>
                </div>
                <div class="col-7 full-width" data-aos="fade-left" data-aos-duration="1000">
                    <p class="third-sec-desc">Beyond Browse company has a great deal of experience working across a
                        broad spectrum of industries, defining and delivering customer web and mobile solutions that
                        support growth and innovation. We have exposure to multiple sectors from healthcare to fintech
                        thereby allowing us to develop unique and scalable solutions tailoring each industry-specific
                        unique challenge and opportunity. </p>
                </div>
            </div>
        </div>
    <div class="expertise-sec">
        <div class="container-fluid">
            <div class="row expertise-row">
                <div class="col-3 expertise-card" data-aos="fade-right" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/002-heartbeat-1-2.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Health</h2>
                        </div>
                        <div class="expertise-description">
                            <p>We design secure, user-friendly applications and platforms for the healthcare industry
                                that focus on making patient management more effective, service delivery more efficient,
                                and enhancing communication for health service providers and patients. From telemedicine
                                apps to health tracking systems and hospital management systems, we designed original
                                tools for measuring the progress of the improvement in health facility access and care.
                            </p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg>
                            </a>
                            <a href="contact-us">
                                <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                            </a>
                        </div>
                    </a>
                </div>

                <div class="col-3 expertise-card" data-aos="fade-up" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/003-shopping-store-1.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Retail</h2>
                        </div>
                        <div class="expertise-description">
                            <p>Much more, we help retailers build seamless digital experiences that enrich, engage, and
                                ultimately convert customers into buyers. From e-commerce to mobile apps, we build
                                solutions that make it possible for retailers to connect with their customers through
                                various touchpoints, whether online or offline. By integrating the latest in technology
                                and the data-driven approach, we build personalised, effective shopping experiences that
                                drive loyalty and increase revenue.</p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us"><img class="logo-anim"
                                    src="assets/wp-content/uploads/2023/12/frame-1.png" alt=""></a>
                        </div>
                    </a>
                </div>

                <div class="col-3 expertise-card" data-aos="fade-down" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/008-online-store-1.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>E-commerce</h2>
                        </div>
                        <div class="expertise-description">
                            <p>Powerful, scalable, and completely secure online destinations that convert are built
                                using our expertise in eCommerce development. We develop completely customisable
                                eCommerce platforms that are mobile responsive, integrated with payment systems, and
                                provide customers with what we term the perfect shopping experience. Our services will
                                assist both a new startup and a big brand with extending their values online and gaining
                                success in their e-commerce marketplace.</p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us">
                                <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                            </a>
                        </div>
                    </a>
                </div>

                <div class="col-3 expertise-card" data-aos="fade-left" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/004-agreement-1.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Real Estate</h2>
                        </div>
                        <div class="expertise-description">
                            <p>For the property industry, we provide excellent solutions for making property convenient
                                to use and interaction with, simplifying transaction processes. Our web and mobile
                                applications allow real estate agents, property managers, and buyers to create listings,
                                manage viewing schedules, and maintain properties. We feature platforms that provide
                                simple browsing, reliable information on properties, and simple transactions.</p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us"><img class="logo-anim"
                                    src="assets/wp-content/uploads/2023/12/frame-1.png" alt=""></a>
                        </div>
                    </a>
                </div>
            </div>
            <div class="row expertise-row mobile-hidden">

                <div class="col-3 expertise-card" data-aos="fade-right" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/007-car-services-1.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Food & Beverages</h2>
                        </div>
                        <div class="expertise-description">
                            <p>With digital solutions to improve customer engagement, and facilitate effective order and
                                delivery management, we incorporate food and beverage industries. From applications in
                                restaurants to food delivery systems, we create customised solutions to satisfy the
                                needs of the contemporary consumer. We primarily focus on easy learning platforms and
                                interfaces for accomplishing operational efficiency and putting your brand to the online
                                public.</p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us"><img class="logo-anim"
                                    src="assets/wp-content/uploads/2023/12/frame-1.png" alt=""></a>
                        </div>
                    </a>
                </div>

                <div class="col-3 expertise-card" data-aos="fade-up" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/005-education-1.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Training & Education</h2>
                        </div>
                        <div class="expertise-description">
                            <p>Innovative learning platforms and mobile applications have also been created in the
                                education sector to make education accessible and interesting. E-learning management
                                systems are tailored into a customised digital solution with student portals to support
                                teaching and associate the institutions. Programs that have been characterised by
                                interactivity, personal learning experiences, and collaborative mechanisms could promote
                                better learning outcomes and, indeed, facilitate proper online education.</p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us"><img class="logo-anim"
                                    src="assets/wp-content/uploads/2023/12/frame-1.png" alt=""></a>
                        </div>
                    </a>
                </div>

                <div class="col-3 expertise-card" data-aos="fade-down" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2024/01/006-truck-1.png" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Transportation and logistics</h2>
                        </div>
                        <div class="expertise-description">
                            <p>We are building digital platforms for freight forwarding and logistics companies to build
                                strong online infrastructure for route planning, supply chain management, and real-time
                                tracking. Fleet management systems, logistics dashboards, or passenger apps all
                                integrate solutions into line operations to save time and gain productivity and control
                                along with clear visibility over logistics and transportation processes. </p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us"><img class="logo-anim"
                                    src="assets/wp-content/uploads/2023/12/frame-1.png" alt=""></a>
                        </div>
                    </a>
                </div>

                <div class="col-3 expertise-card" data-aos="fade-left" data-aos-duration="1000">
                    <a href="contact-us">
                        <div class="icon">
                            <img src="assets/wp-content/uploads/2023/12/001-fintech-1-1.svg" alt="">
                        </div>
                        <div class="expertise-heading">
                            <h2>Fintech</h2>
                        </div>
                        <div class="expertise-description">
                            <p>Creating safe, fiat, and consumer-friendly applications for finance in the fintech arena
                                where businesses can help control their finances and manage their funds will range from
                                mobile banking apps, to electronic payments, and investment applications. From these
                                solutions, assurance, and security will evolve towards innovation. To that end, building
                                platforms will streamline financial transactions, providing adequate security and
                                allowing the user to bring their financial well-being within reach.</p>
                        </div>
                        <div class="expertise-arrow">
                            <a href="contact-us"><svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 28 28" fill="none">
                                    <path
                                        d="M15.715 9.95168C15.6291 9.87158 15.5601 9.77498 15.5123 9.66764C15.4645 9.56031 15.4388 9.44445 15.4367 9.32696C15.4346 9.20947 15.4562 9.09277 15.5002 8.98382C15.5442 8.87487 15.6097 8.77589 15.6928 8.6928C15.7759 8.60972 15.8749 8.54421 15.9838 8.50021C16.0928 8.4562 16.2095 8.43459 16.327 8.43666C16.4445 8.43873 16.5603 8.46445 16.6677 8.51227C16.775 8.5601 16.8716 8.62905 16.9517 8.71502L21.6184 13.3817C21.7822 13.5457 21.8743 13.7681 21.8743 14C21.8743 14.2319 21.7822 14.4543 21.6184 14.6184L16.9517 19.285C16.8716 19.371 16.775 19.4399 16.6677 19.4878C16.5603 19.5356 16.4445 19.5613 16.327 19.5634C16.2095 19.5654 16.0928 19.5438 15.9838 19.4998C15.8749 19.4558 15.7759 19.3903 15.6928 19.3072C15.6097 19.2241 15.5442 19.1252 15.5002 19.0162C15.4562 18.9073 15.4346 18.7906 15.4367 18.6731C15.4388 18.5556 15.4645 18.4397 15.5123 18.3324C15.5601 18.2251 15.6291 18.1285 15.715 18.0484L18.8884 14.875L7.58337 14.875C7.35131 14.875 7.12875 14.7828 6.96465 14.6187C6.80056 14.4546 6.70837 14.2321 6.70837 14C6.70837 13.768 6.80056 13.5454 6.96465 13.3813C7.12875 13.2172 7.35131 13.125 7.58337 13.125L18.8884 13.125L15.715 9.95168Z"
                                        fill="white" />
                                </svg></a>
                            <a href="contact-us"><img class="logo-anim"
                                    src="assets/wp-content/uploads/2023/12/frame-1.png" alt=""></a>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid" style="text-align:center;">
        <a href="contact-us" class="designBtn">Start Your Project</a>
    </div>
</section>

<section class="seventh-sec">
    <div class="container-fluid">
        <div class="row blue-sec">
            <div class="col-6" data-aos="fade-right" data-aos-duration="1000">
                <div class="row">
                    <h2>
                        Looking For a
                    </h2>
                    <div class="box">
                        <div class="inner">
                            <span>customized <br> focused <br> tailored </span>
                        </div>
                    </div>
                </div>
                <h2> technology solution?</h2>
                <p>
                    You are at the right place. Your search for an expert technology partner ends here—let's discuss how
                    Beyond Browse can assist you in realizing your goals—let's make big things happen.
                </p>
                <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
            </div>
            <div class="col-6 contact-col" data-aos="fade-up" data-aos-duration="1000">
                <div class="contact-info">
                    <a href="tel:<?php echo $locNumber; ?>">
                        <h2><span>Call Now:</span><br><?php echo $locNumber; ?> </h2>
                    </a>
                </div>
                <div class="contact-info ">
                    <a class="emial-txt" href="mailto:<?php echo $locEmail; ?>">
                        <h2><span>Email Now:</span><br><?php echo $locEmail; ?></h2>
                    </a>
                    <a class="designBtn" href="#costumModal9" data-toggle="modal">Get Started</a>
                </div>
                <div class="row started-row">
                    <!--           <button class="cs-button">Get Started 
            <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"><path d="M10.3653 6.56381C10.3086 6.51097 10.2631 6.44726 10.2316 6.37647C10.2 6.30567 10.1831 6.22925 10.1817 6.15176C10.1803 6.07427 10.1946 5.9973 10.2236 5.92543C10.2526 5.85357 10.2958 5.78829 10.3506 5.73349C10.4054 5.67869 10.4707 5.63548 10.5426 5.60646C10.6144 5.57743 10.6914 5.56318 10.7689 5.56454C10.8464 5.56591 10.9228 5.58287 10.9936 5.61441C11.0644 5.64596 11.1281 5.69144 11.1809 5.74814L14.259 8.82614C14.367 8.93435 14.4277 9.08104 14.4277 9.23398C14.4277 9.38692 14.367 9.5336 14.259 9.64181L11.1809 12.7198C11.1281 12.7765 11.0644 12.822 10.9936 12.8535C10.9228 12.8851 10.8464 12.902 10.7689 12.9034C10.6914 12.9048 10.6144 12.8905 10.5426 12.8615C10.4707 12.8325 10.4054 12.7893 10.3506 12.7345C10.2958 12.6797 10.2526 12.6144 10.2236 12.5425C10.1946 12.4707 10.1803 12.3937 10.1817 12.3162C10.183 12.2387 10.2 12.1623 10.2316 12.0915C10.2631 12.0207 10.3086 11.957 10.3653 11.9041L12.4583 9.8111L5.00186 9.8111C4.8488 9.8111 4.702 9.7503 4.59377 9.64207C4.48554 9.53383 4.42474 9.38704 4.42474 9.23398C4.42474 9.08091 4.48554 8.93412 4.59377 8.82589C4.702 8.71765 4.8488 8.65685 5.00186 8.65685L12.4583 8.65685L10.3653 6.56381Z" fill="#20b8f9"/></svg>
          </button> -->

                    <img class="logo-anim d-flex" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                </div>
            </div>
        </div>
    </div>
</section>

<section class="eighth-sec">
    <div class="container-fluid">
        <div class="row face-row">
            <div class="col-6 accordion-sec" data-aos="fade-right" data-aos-duration="1000">
                <h2 class="accordion-heading">Solutions to Upgrade <br> <span>Outdated </span> Systems</h2>
                <div class="accordion" id="accordionExample">

                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapseOne">
                                <span> 1 </span>
                                <h2>Mobile App Solution </h2>
                            </button>
                        </h2>
                        <div id="collapse1" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>This is what our team believes, mobile can solve all your mobility problems without
                                    exception. Keeping this in mind, we have developed mobile app solutions for
                                    customers: viewing intuitive and high-performance user experiences across iOS and
                                    Android platforms. We build completely customised mobile applications tailored to
                                    meet business requirements from e-commerce to social networking, enterprise
                                    solutions to customer engagement.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse2" aria-expanded="true" aria-controls="collapseOne">
                                <span> 2 </span>
                                <h2>Web Apps Solution</h2>
                            </button>
                        </h2>
                        <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>We provide innovative Web App Solutions that provide dynamic, responsive, and
                                    interactive end-user experiences. From complex business applications to the simplest
                                    usable platform, we build web apps that are intuitive, fast yet scalable. We create
                                    secure applications, cross-browser compatible and mobile responsive, which are going
                                    to increase your presence on the web and enhance your business operations. </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse3" aria-expanded="true" aria-controls="collapseOne">
                                <span> 3 </span>
                                <h2>Hybrid Digital Solution</h2>
                            </button>
                        </h2>
                        <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>Our Hybrid Digital Solutions bring the best of both worlds, that is, native and web
                                    app development. This will bring a broader audience without compromising on running
                                    performance. We build hybrid apps that work well cross-platform so that your
                                    solution is available on both mobile and web without compromising the functionality
                                    or user experience. We use advanced technologies such as React Native, Flutter, and
                                    Xamarin to provide cost-effective, scalable, and high-quality solutions so that they
                                    have the flexibility to grow with your business needs.</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-6 face-div" data-aos="fade-up" data-aos-duration="1000">
                <div class="face-sec">
                    <img src="assets/wp-content/uploads/2023/12/b6bd5c6d4150a4f797dd0866f74f9e4d.png" alt="">
                </div>
                <div class="mobile-accordion accordion" id="accordionExample">

                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapseOne">
                                <span> 1 </span>
                                <h2>Mobile Apps</h2>
                            </button>
                        </h2>
                        <div id="collapse1" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>Beyond Browse is a premier mobile app development company with years of experience in
                                    developing
                                    incredible mobile apps for various industries for our clients around the globe. We
                                    understand you,
                                    your thought process and then build your solution to ensure maximum satisfaction.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse2" aria-expanded="true" aria-controls="collapseOne">
                                <span> 2 </span>
                                <h2>Web Apps</h2>
                            </button>
                        </h2>
                        <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>We also specialize in other technologies including web applications. From portals to
                                    online
                                    management systems to mobile responsive applications, we build them all - all while
                                    ensuring utmost
                                    security and agility, and by following the instructions to develop the perfect app
                                    for you.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse3" aria-expanded="true" aria-controls="collapseOne">
                                <span> 3 </span>
                                <h2>Hybrid Digital Solutions</h2>
                            </button>
                        </h2>
                        <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>The changing requirements of today's world have compelled businesses to be everywhere
                                    simultaneously. With our custom hybrid digital solutions, we enable you to establish
                                    your identity
                                    and boast your authority across multiple platforms, delivering your audience the
                                    right results,
                                    exactly when they matter.</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="row counter-row" id="counter">
            <div class="col-3 counter-col" data-aos="fade-right" data-aos-duration="1000">
                <div class="counter-card">
                    <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                    <div id="yes" class="timer" data-from="0" data-to="11" data-speed="3000" data-target="#yesyes">0
                    </div>
                    <p>Years of Experience</p>
                </div>
            </div>
            <div class="col-3 counter-col" data-aos="fade-up" data-aos-duration="1000">
                <div class="counter-card">
                    <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                    <div class="combineCount">
                        <div id="yes" class="timer" data-from="0" data-to="2" data-speed="3000" data-target="#yesyes">
                        </div>
                        <h2>K+<h2>
                    </div>

                    <p>Project’s Complete</p>
                </div>
            </div>
            <div class="col-3 counter-col" data-aos="fade-down" data-aos-duration="1000">
                <div class="counter-card">
                    <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                    <div id="yes" class="timer" data-from="0" data-to="48" data-speed="3000" data-target="#yesyes">
                    </div>
                    <p>Team Members</p>
                </div>
            </div>
            <div class="col-3 counter-col" data-aos="fade-left" data-aos-duration="1000">
                <div class="counter-card">
                    <img class="logo-anim" src="assets/wp-content/uploads/2023/12/frame-1.png" alt="">
                    <div class="combineCount">
                        <div id="yes" class="timer" data-from="0" data-to="50" data-speed="6000" data-target="#yesyes">
                        </div>
                        <h2>+<h2>
                    </div>
                    <p>Award Winning</p>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid cs-button-sec" data-aos="fade-up" data-aos-duration="1000">
        <a class="designBtn" href="#costumModal9" data-toggle="modal">Talk To Our Expert</a>
    </div>
</section>

<section class="ninth-sec">
    <div class="container-fluid">
        <div class="row row-1">
            <div class="col-6 full-width" data-aos="fade-right" data-aos-duration="1000">
                    <h2 class="reviewHeading">
                        Clients that <br><strong>Vouch </strong> for Us
                    </h2>
            </div>
            <div class="col-6 full-width" data-aos="fade-down" data-aos-duration="1000">
                <h6>"Working with this team was absolutely a game changer for our business. Their understanding of our
                    vision and delivering an uninterrupted mobile app has contributed to building up our growth."</h6>
                <img src="assets/wp-content/uploads/2023/12/Untitled-design-2023-05-03T134807.484-1.png" alt="">
            </div>
        </div>
    </div>
    <section class="reviews-sec" data-aos="fade-up" data-aos-duration="1000">
        <div class="reviewSlider-container ">
            <div class="swiper-wrapper">



                <div class="review-card swiper-slide">
                    <h5 class="title">&#8220;They will not disappointed you!&#8221;</h5>
                    <img class="rating" src="assets/wp-content/uploads/2023/12/Group-28.svg" alt="">
                    <div class="review">
                        <p>"The speed and efficiency with which the team created our web app blew my mind away. They
                            were always attentive and communicative and provided awesome suggestions that made a real
                            difference. Highly recommended for everyone searching for expert web solutions!"</p>
                    </div>
                    <div class="mergeBox">
                        <h6 class="client">Sarah Jones</h6>
                        <p class="designation">Trustpilot</p>
                        <div class="row">
                            <div class="col-2 platform">
                                <a href="javascript:;">
                                    <img src="assets/wp-content/uploads/2023/12/clutch-2.svg" alt=""> </a>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="review-card swiper-slide">
                    <h5 class="title">&#8220;Thank you for all of your support&#8221;</h5>
                    <img class="rating" src="assets/wp-content/uploads/2023/12/Group-28.svg" alt="">
                    <div class="review">
                        <p>"Professional yet easy to talk to were the characteristics of the team. They listened deeply
                            to what we needed and then presented creative, right-on solutions. The app is doing great,
                            and the user feedback has been fantastic!" </p>
                    </div>
                    <div class="mergeBox">
                        <h6 class="client">John Garcia</h6>
                        <p class="designation">Trustpilot</p>
                        <div class="row">
                            <div class="col-2 platform">
                                <a href="javascript:;">
                                    <img src="assets/wp-content/uploads/2023/12/trustpilot-2.svg" alt=""> </a>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="review-card swiper-slide">
                    <h5 class="title">&#8220;Thank you Peter and your team!!&#8221;</h5>
                    <img class="rating" src="assets/wp-content/uploads/2023/12/Group-28.svg" alt="">
                    <div class="review">
                        <p>
                            "These are real guys. They didn't just build a top-notch app for us, but their support was
                            just, at any time, top of the line," made sure that we were always in the loop and delivered
                            exactly what we envisioned. Fantastic experience!"
                        </p>
                    </div>
                    <div class="mergeBox">
                        <h6 class="client">Emily Lopez</h6>
                        <p class="designation">Trustpilot</p>
                        <div class="row">
                            <div class="col-2 platform">
                                <a href="https://www.thumbtack.com/profile/services/427573743556763651/reviews">
                                    <img src="assets/wp-content/uploads/2024/01/Rectangle-438.png" alt=""> </a>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="review-card swiper-slide">
                    <h5 class="title">&#8220;I am very pleased&#8221;</h5>
                    <img class="rating" src="assets/wp-content/uploads/2023/12/Group-28.svg" alt="">
                    <div class="review">
                        <p>"I've worked with multiple agencies in times gone by, but none of them is as responsive and
                            dedicated as this. They pay attention to the smallest details and are so committed to
                            delivering a well-finished product. The result was a slick, user-friendly website that
                            really put us on the map online." — Jessica Thomas</p>
                    </div>
                    <div class="mergeBox">
                        <h6 class="client">Tom Anderson</h6>
                        <p class="designation">Trustpilot</p>
                        <div class="row">
                            <div class="col-2 platform">
                                <a href="javascript:;">
                                    <img src="assets/wp-content/uploads/2023/12/trustpilot-2.svg" alt=""> </a>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="review-card swiper-slide">
                    <h5 class="title">&#8220;Love this company!&#8221;</h5>
                    <img class="rating" src="assets/wp-content/uploads/2023/12/Group-28.svg" alt="">
                    <div class="review">
                        <p>They are very responsive and professional. I will be hiring them for all future web design
                            needs. I had
                            a great experience and it’s so nice working with a company you can trust with your own
                            business. Highly
                            recommend!!</p>
                    </div>
                    <div class="mergeBox">
                        <h6 class="client">Madison Bullington</h6>
                        <p class="designation">Trustpilot</p>
                        <div class="row">
                            <div class="col-2 platform">
                                <a href="https://www.thumbtack.com/profile/services/465161594888675344/reviews">
                                    <img src="assets/wp-content/uploads/2024/01/Rectangle-438.png" alt=""> </a>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="review-card swiper-slide">
                    <h5 class="title">&#8220;I could not be more happier&#8221;</h5>
                    <img class="rating" src="assets/wp-content/uploads/2023/12/Group-28.svg" alt="">
                    <div class="review">
                        <p>My friend referred me after a disastrous and costly debacle with another developer. Within a
                            week the
                            team had delivered EXACTLY what I was looking for in my website revision! I could not be any
                            happier or
                            more satisfied with their professionalism and efficiency!</p>
                    </div>
                    <div class="mergeBox">
                        <h6 class="client">Gabrielle Johnson</h6>
                        <p class="designation">Trustpilot</p>
                        <div class="row">
                            <div class="col-2 platform">
                                <a href="https://www.trustpilot.com/users/5fef5ff6750ed7001936f126">
                                    <img src="assets/wp-content/uploads/2023/12/trustpilot-2.svg" alt=""> </a>
                            </div>
                        </div>
                    </div>

                </div>


            </div>
            <div class="cursor-slider">drag</div>
        </div>
    </section>
</section>

<section class="tenth-sec">
    <div class="container-fluid second-tabs">
        <div class="row">
            <div class="col-6 full-width" data-aos="fade-right" data-aos-duration="1000">
                <div class="row">
                    <h2 class="reviewHeading2">
                        Clients with <strong>strong </strong><br>trust relation
                    </h2>
                </div>
            </div>
            <div class="col-6 full-width" data-aos="fade-up" data-aos-duration="1000">
                <p>Over the past years, we have established an entire digital family where digital excellence comes
                    alive truly and delivers what we claim is the best for you.
                </p>
                <ul class="nav nav-tabs card-header-tabs" id="tabs">
                    <li class="nav-item active">
                        <a class="nav-link active" href="#clients" data-toggle="tab">Clients</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#partners" data-toggle="tab">Partners</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div class="row" data-aos="fade-up" data-aos-duration="1000">
        <div class="tab-content">
            <div class="tab-pane active" id="clients">
                <div class="container-fluid">
                    <div class="row row-1">
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/Mask-group.png" alt="">
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-107.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/Group-1000008318-1.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-5.png" alt="">

                            </div>
                        </div>
                    </div>
                    <div class="row row-2">
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-105.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-8.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-112.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-113.png" alt="">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane" id="partners">
                <div class="container-fluid">
                    <div class="row row-1">
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-95.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-96.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-101.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-102.png" alt="">

                            </div>
                        </div>
                    </div>
                    <div class="row row-2">
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-4.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-103.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-100.png" alt="">

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="vc_column-inner">
                                <img src="assets/wp-content/uploads/2024/02/image-104.png" alt="">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section data-vc-full-width="true" data-vc-full-width-init="false" class="vc_section ihone-android-faqs">
    <div class="container fluid">
    <div class="vc_row wpb_row vc_row-fluid">
        <div
            class="wpb_animate_when_almost_visible wpb_fadeInLeft fadeInLeft wpb_column vc_column_container vc_col-sm-6">
            <div class="vc_column-inner">
                <div class="wpb_wrapper">
                    <div class="wpb_text_column wpb_content_element ">
                        <div class="wpb_wrapper">
                            <h2>Frequently Asked <strong>Questions</strong></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div
            class="wpb_animate_when_almost_visible wpb_fadeInRight fadeInRight wpb_column vc_column_container vc_col-sm-6">
            <div class="vc_column-inner">
                <div class="wpb_wrapper">
                    <div class="wpb_text_column wpb_content_element ">
                        <div class="wpb_wrapper">
                            <p>Here are some of the standard replies we have provided to questions that often come our
                                way. If you have any further inquiries, feel free to reach out to us directly. We're
                                here to help!" </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="vc_row wpb_row vc_row-fluid">
        <div class="wpb_column vc_column_container vc_col-sm-12">
            <div class="vc_column-inner">
                <div class="wpb_wrapper">
                    <div class="wpb_text_column wpb_content_element ">
                        <div class="wpb_wrapper">
                            <div id="sp_easy_accordion-1704652731">
                                <div id="sp-ea-1567" class="sp-ea-one sp-easy-accordion" data-ex-icon="minus"
                                    data-col-icon="plus" data-ea-active="ea-click" data-ea-mode="vertical"
                                    data-preloader="" data-scroll-active-item="" data-offset-to-scroll="0">
                                    <!-- Start accordion card div. -->
                                    <div class="ea-card ea-expand sp-ea-single">
                                        <!-- Start accordion header. -->
                                        <h3 class="ea-header">
                                            <!-- Add anchor tag for header. -->
                                            <a class="collapsed" id="ea-header-15670" data-sptoggle="spcollapse"
                                                data-sptarget="#collapse15670" aria-controls="collapse15670" href="#"
                                                aria-expanded="true" tabindex="0">
                                                <i class="ea-expand-icon ea-icon-expand-minus"></i> What platforms do
                                                you develop for?
                                            </a> <!-- Close anchor tag for header. -->
                                        </h3> <!-- Close header tag. -->
                                        <!-- Start collapsible content div. -->
                                        <div class="sp-collapse spcollapse collapsed show" id="collapse15670"
                                            data-parent="#sp-ea-1567" role="region" aria-labelledby="ea-header-15670">
                                            <!-- Content div. -->
                                            <div class="ea-body">
                                                <p>We develop custom web and mobile applications for both iOS and
                                                    Android platforms. Native, hybrid, or web-based solutions are all
                                                    tailored to meet specific needs and objectives.</p>
                                            </div> <!-- Close content div. -->
                                        </div> <!-- Close collapse div. -->
                                    </div> <!-- Close card div. -->
                                    <!-- Start accordion card div. -->
                                    <div class="ea-card  sp-ea-single">
                                        <!-- Start accordion header. -->
                                        <h3 class="ea-header">
                                            <!-- Add anchor tag for header. -->
                                            <a class="collapsed" id="ea-header-15671" data-sptoggle="spcollapse"
                                                data-sptarget="#collapse15671" aria-controls="collapse15671" href="#"
                                                aria-expanded="false" tabindex="0">
                                                <i class="ea-expand-icon ea-icon-expand-plus"></i> How long does it take
                                                to build an app or website?
                                            </a> <!-- Close anchor tag for header. -->
                                        </h3> <!-- Close header tag. -->
                                        <!-- Start collapsible content div. -->
                                        <div class="sp-collapse spcollapse " id="collapse15671"
                                            data-parent="#sp-ea-1567" role="region" aria-labelledby="ea-header-15671">
                                            <!-- Content div. -->
                                            <div class="ea-body">
                                                <p>The timeline depends on the complexity of the project. However, our
                                                    projects typically take 6 to 12 weeks, and once we understand what
                                                    you want, we could elaborate on the timeline.</p>
                                            </div> <!-- Close content div. -->
                                        </div> <!-- Close collapse div. -->
                                    </div> <!-- Close card div. -->
                                    <!-- Start accordion card div. -->
                                    <div class="ea-card  sp-ea-single">
                                        <!-- Start accordion header. -->
                                        <h3 class="ea-header">
                                            <!-- Add anchor tag for header. -->
                                            <a class="collapsed" id="ea-header-15672" data-sptoggle="spcollapse"
                                                data-sptarget="#collapse15672" aria-controls="collapse15672" href="#"
                                                aria-expanded="false" tabindex="0">
                                                <i class="ea-expand-icon ea-icon-expand-plus"></i> How much does it cost
                                                to develop an app or website? </a> <!-- Close anchor tag for header. -->
                                        </h3> <!-- Close header tag. -->
                                        <!-- Start collapsible content div. -->
                                        <div class="sp-collapse spcollapse " id="collapse15672"
                                            data-parent="#sp-ea-1567" role="region" aria-labelledby="ea-header-15672">
                                            <!-- Content div. -->
                                            <div class="ea-body">
                                                <p>Pricing varies based on the scope, features, and technologies needed.
                                                    After sitting with us for a thorough consultation on your needs, we
                                                    will give you a full proposal, with costs broken down as needed for
                                                    your specific project.</p>
                                            </div> <!-- Close content div. -->
                                        </div> <!-- Close collapse div. -->
                                    </div> <!-- Close card div. -->
                                    <!-- Start accordion card div. -->
                                    <div class="ea-card  sp-ea-single">
                                        <!-- Start accordion header. -->
                                        <h3 class="ea-header">
                                            <!-- Add anchor tag for header. -->
                                            <a class="collapsed" id="ea-header-15673" data-sptoggle="spcollapse"
                                                data-sptarget="#collapse15673" aria-controls="collapse15673" href="#"
                                                aria-expanded="false" tabindex="0">
                                                <i class="ea-expand-icon ea-icon-expand-plus"></i> Do you offer ongoing
                                                support after the project is completed?</a>
                                            <!-- Close anchor tag for header. -->
                                        </h3> <!-- Close header tag. -->
                                        <!-- Start collapsible content div. -->
                                        <div class="sp-collapse spcollapse " id="collapse15673"
                                            data-parent="#sp-ea-1567" role="region" aria-labelledby="ea-header-15673">
                                            <!-- Content div. -->
                                            <div class="ea-body">
                                                <p> Yes, we have maintenance and support services available after launch
                                                    to make sure that the app or website has an ongoing successful
                                                    performance, gets updates, and changes to future requirements if
                                                    necessary.</p>
                                            </div> <!-- Close content div. -->
                                        </div> <!-- Close collapse div. -->
                                    </div>

                                    <div class="ea-card  sp-ea-single">
                                        <!-- Start accordion header. -->
                                        <h3 class="ea-header">
                                            <!-- Add anchor tag for header. -->
                                            <a class="collapsed" id="ea-header-15674" data-sptoggle="spcollapse"
                                                data-sptarget="#collapse15674" aria-controls="collapse15674" href="#"
                                                aria-expanded="false" tabindex="0">
                                                <i class="ea-expand-icon ea-icon-expand-plus"></i> Will my app or
                                                website be optimised for SEO?</a>
                                            <!-- Close anchor tag for header. -->
                                        </h3> <!-- Close header tag. -->
                                        <!-- Start collapsible content div. -->
                                        <div class="sp-collapse spcollapse " id="collapse15674"
                                            data-parent="#sp-ea-1567" role="region" aria-labelledby="ea-header-15674">
                                            <!-- Content div. -->
                                            <div class="ea-body">
                                                <p>Absolutely! SEO-friendliness is the focus of our websites and apps so
                                                    that they get search engine visibility and improve organic traffic.
                                                </p>
                                            </div> <!-- Close content div. -->
                                        </div> <!-- Close collapse div. -->
                                    </div>
                                    <!-- Close card div. -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</section>

<?php
include 'includes/footer.php';
$page = 'home';
?>