<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex,nofollow">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <?php include 'includes/variable.php'; ?>
    <?php include 'includes/links.php'; ?>
</head>
<style>
section.thankyou-page-wrap {
    background-image: url(./assets/images/main-banner.png);
    padding: 150px 0 100px;
    height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    background-repeat: no-repeat;
    z-index: 1;
    background-size: cover;
    background-position: 100% 100%;
    position: relative;
    z-index: 1;
}

section.thankyou-page-wrap::before {
    position: absolute;
    content: '';
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #000;
    z-index: -1;
    width: 100%;
    height: 100%;
    opacity: .8;
}

.thankyou-page-wrap .thankyou-page-content {
    text-align: center;
}

.thankyou-page-content h1 {
    font-size: 80px;
    line-height: 100px;
    margin: 0 auto 30px;
    width: 90%;
    letter-spacing: 5px;
    position: relative;
    color: #00838c;
    font-weight: 700;
}

.thankyou-page-content p {
    color: #F0F7F7;
    margin: 0 0 20px;
    font-size: 25px;
    line-height: 34px;
}

.thankyou-page-content .btn-box {
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: row;
    flex-wrap: nowrap;
    gap: 10px;
    margin: 20px 0 0 0;
}

.thankyou-page-content .btn-box .back-home-btn {
    background: #00838c;
    color: #fff;
    font-size: 18px;
    width: 250px;
    border: 2px solid #00838c;
    border-radius: 0px;
    padding: 10px 10px;
    margin: 0;
    text-transform: uppercase;
    transition: all .3s ease-in-out;
    display: block;
    animation: cta2 3s infinite linear;
}

.thankyou-page-content .btn-box .back-home-btn:hover {
    background: #fff;
    color: #00838c;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
    .thankyou-page-content h1 {
        font-size: 85px;
        line-height: 85px;
        letter-spacing: 20px;
        width: 90%;
    }

    .thankyou-page-content h1::before {
        width: 90%;
    }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
    .thankyou-page-wrap::before {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-wrap::after {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-content h1 {
        font-size: 85px;
        line-height: 85px;
        letter-spacing: 20px;
        width: 100%;
    }

    .thankyou-page-content h1::before {
        width: 100%;
    }

    .thankyou-page-content a.back-home-btn {
        font-size: 16px;
    }
}

@media only screen and (min-width: 576px) and (max-width: 767px) {
    .thankyou-page-wrap::before {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-wrap::after {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-content h1 {
        font-size: 60px;
        line-height: 60px;
        letter-spacing: 15px;
        width: 100%;
    }

    .thankyou-page-content h1::before {
        width: 100%;
    }

    .thankyou-page-content a.back-home-btn {
        font-size: 16px;
    }
}

@media only screen and (min-width: 300px) and (max-width: 575px) {
    .thankyou-page-wrap::before {
        width: 200px;
        height: 200px;
    }

    .thankyou-page-wrap::after {
        width: 200px;
        height: 200px;
    }

    .thankyou-page-content h1 {
        font-size: 30px;
        line-height: 30px;
        letter-spacing: 10px;
        width: 100%;
    }

    .thankyou-page-content h1::before {
        width: 100%;
    }

    .thankyou-page-content a.back-home-btn {
        font-size: 16px;
    }
}
</style>

<body>
    <header>
        <div class="header-btm" id="myHeader">
            <div class="container">
                <nav class="navbar navbar-expand-lg">
                    <a class="navbar-brand" href="index">
                        <img src="assets/images/logo.png" alt="img" class="img-fluid logo">
                    </a>
                    <div class="btn-box"></div>
                </nav>
            </div>
        </div>
    </header>
    <section class="thankyou-page-wrap">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-sm-12 col-md-12 col-lg-10 col-xl-10 col-xxl-10">
                    <div class="thankyou-page-content">
                        <h1>Oops, <span>something went wrong!</span></h1>
                        <p>We apologize, but there was an issue with your submission. Please try again later or contact
                            our support team for assistance.</p>
                        <div class="btn-box">
                            <a href="javascript:;" class="back-home-btn">
                                Contact Support
                            </a>
                            <a href="index" class="back-home-btn">
                                Go Back to Home
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/scripts.php'; ?>
</body>

</html>