<!doctype php>
<php class="no-js" lang="zxx">
    <?php include_once("analyticstracking.php") ?>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>Lax Power</title>
        <link rel="shortcut icon" href="assets/img/logo/lax-logo.png" type="images/x-icon">
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        <link rel="stylesheet" href="assets/css/font-awesome.min.css">
        <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
        <link rel="stylesheet" href="assets/css/main.css">
        <link rel="stylesheet" href="assets/css/responsive.css">
    </head>
    <body>
        <div class="ta-main-wrapper">
            <div class="ta-theme-switcher-wrapper">
                <nav class="ta-theme-switcher">
                    <span class="ta-theme-switcher__btn light-mode" data-ta-switcher-btn><i
                            class="fa fa-sun"></b></i></span>
                    <span class="ta-theme-switcher__mode" data-ta-switcher-mode></span>
                    <span class="ta-theme-switcher__btn dark-mode" data-ta-switcher-btn><i
                            class="fa fa-moon"></b></i></span>
                </nav>
            </div>
            <div class="progress-wrap">
                <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
                </svg>
            </div>
            <header class="ta-header">
                <div class="ta-header__top">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-3 align-self-center d-none d-md-block">
                                <div class="ta-social-links d-flex align-items-center">
                                    <img src="assets/img/logo/lax-power-logo.png" width="35%">
                                </div>
                            </div>
                            <div class="col-md-6 align-self-center">
                                <div class="ta-header__top__center">
                                    <img src="assets/img/logo-vert.svg" alt="not found" class='vert'>
                                    <div class="ta-logo">
                                        <a href="/">
                                            <img src="assets/img/logo/lax-power-logo.png" width="100%">
                                        </a>
                                        <p>For the Fan, For the Sport </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 align-self-center d-none d-md-block">
                                <div class="ta-social-links d-flex align-items-center">
                                    <img src="assets/img/stick.gif" width="50%">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ta-overlay"></div>
                <div class="ta-side-info-wrapper">
                    <button class="ta-info-close" data-ta-close>Close</button>
                    <div class="top pb-60">
                        <div class="ta-logo">
                            <a href="/">
                                Lax<span>Power</span>
                            </a>
                            <p>For the Fan, For the Sport </p>
                        </div>
                    </div>
                    <div class="bottom-wrapper mt-75">
                        <div class="ta-mobile-menu"></div>
                    </div>
                </div>
            </header>
            <main>
                <div class="featured-post-area pt-60">
                    <div class="container-fluid">
                        <div class="row ta-column-gap-30 mt-none-30">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="see_more">
                                    <h3>Consensus Ratings Index (CRI) </h3>
                                    <img src="rpi.png" height="70" width="60">
                                    <img src="npi.png" height="70" width="60">
                                    <img src="massey.png" height="70" width="60">
                                    <img src="laxpower.png" height="100" width="100">
                                    <img src="laxnumbers.png" height="70" width="60">
                                    <img src="s3s.png" height="70" width="60">
                                    <img src="pwr.png" height="70" width="60">
                                    <img src="poll.png" height="70" width="60">
                                    <div class="visible-content">
                                        <p class="para">The following eight rating systems are employed:</p>
                                            <ul>
                                                <li>(1) Ratings Percentage Index (RPI)</li>
                                                <li>(2) NCAA Power Index (NPI)</li>
                                                <li>(3) Massey Ratings (formerly of BCS)</li>
                                                <li>(4) Laxpower Power Ratings</li>
                                                <li>(5) Laxnumber Power Ratings</li>
                                                <li>(6) Safe3Step Ratings (New)</li>
                                                <li>(7) Powerwise Ratings (New)</li>
                                                <li>(8) Coaches Poll</li>
                                            </ul>
                                        <p class="para">The Consensus Rating Index (CRI) averages the results for all methods
                                        into one consensus for both power ranking and toughest schedule 
                                        </p> 
                                    </div>
                                </div>
                                <div class="headlines">
                                    <h4>Rating News Headlines</h4>
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="home" role="tabpanel"
                                            aria-labelledby="home-tab">
                                            <ul>
                                                <li>
                                                    <a href="Army.php">Army Lacrosse: Winning Battles But Losing To A
                                                        Spreadsheet
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="laxmath.php">LaxMath and Laxpower
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="NPI.pdf">Pros and Cons of NCAA Power Index (NPI) for
                                                        Division 3 Lacrosse
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane fade" id="profile" role="tabpanel"
                                            aria-labelledby="profile-tab">
                                            <ul>
                                                <li><a href="https://www.usalacrosse.com/news-blog-listing">UAlbany
                                                        Lacrosse Has 14 Commitments for 2008-2009</a></li>
                                                <li><a href="https://www.usalacrosse.com/news-blog-listing">ECAC
                                                        Lacrosse League Adds Five New Members</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="see_more">
                                    <div class="visible-content">
                                        <div>
                                            <h3> Laxpower Archives</h3>
                                            <div class="date-btns">
                                            <a href="..\laxpower2\men_archive.php"><b>Men (2004-2024)</b></a>
                                            <a href="..\laxpower2\wom_archive.php"><b>Women (2004-2024)</b></a>
                                            <a href="..\laxpower2\boys_archive.php"><b>Boys (2004-2024)</b></a>
                                            <a href="..\laxpower2\girls_archive.php"><b>Girls (2004-2024)</b></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="see_more">
                                    <h3>New Stuff</h3>
                                    <div class="visible-content">
                                        <pre></pre>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mt-30">
                                <div class="right_feature">
                                    <H3>2025 UPDATED 08/05 2025 15:00 PDT</b></H3>
                                    <div class="bg_ls">
                                        <h4>Men's Consensus Index</h4>
                                        <div>
                                            <a href="men/md1a.php"><b>Men's Division I</b></a>
                                            <a href="men/md2a.php"><b>Men's Division II</b></a>
                                            <a href="men/md3a.php"><b>Men's Division III</b></a>
                                        </div>
                                    </div>
                                    <div class="bg_ls items-box">
                                        <h4>Boy's Consensus Index</h4>
                                        <a href="boys/alabamaa.php"><b>Alabama</b></a>
                                        <a href="boys/arizonaa.php"><b>Arizona</b></a>
                                        <a href="boys/arkansasa.php"><b>Arkansas</b></a>
                                        <a href="boys/californiaa.php"><b>California</b></a>
                                        <a href="boys/coloradoa.php"><b>Colorado</b></a>
                                        <a href="boys/connecticuta.php"><b>Connecticut</b></a>
                                        <a href="boys/delawarea.php"><b>Delaware</b></a>
                                        <a href="boys/floridaa.php"><b>Florida</b></a>
                                        <a href="boys/georgiaa.php"><b>Georgia</b></a>
                                        <a href="boys/idahoa.php"><b>Idaho</b></a>
                                        <a href="boys/illinoisa.php"><b>Illinois</b></a>
                                        <a href="boys/indianaa.php"><b>Indiana</b></a>
                                        <a href="boys/independenta.php"><b>Independent</b></a>
                                        <a href="boys/kentuckya.php"><b>Kentucky</b></a>
                                        <a href="boys/mainea.php"><b>Maine</b></a>
                                        <a href="boys/marylanda.php"><b>Maryland</b></a>
                                        <a href="boys/massachusettsa.php"><b>Massachusetts</b></a>
                                        <a href="boys/michigana.php"><b>Michigan</b></a>
                                        <a href="boys/minnesotaa.php"><b>Minnesota</b></a>
                                        <a href="boys/missouria.php"><b>Missouri</b></a>
                                        <a href="boys/montanaa.php"><b>Montana</b></a>
                                        <a href="boys/nebraskaa.php"><b>Nebraska</b></a>
                                        <a href="boys/nevadaa.php"><b>Nevada</b></a>
                                        <a href="boys/newenglanda.php"><b>New England</b></a>
                                        <a href="boys/newhampshirea.php"><b>New Hampshire</b></a>
                                        <a href="boys/newjerseya.html"><b>New Jersey</b></a>
                                        <a href="boys/newmexicoa.html"><b>New Mexico</b></a>
                                        <a href="boys/newyorka.html"><b>New York</b></a>
                                        <a href="boys/northcarolinaa.html"><b>North Carolina</b></a>
                                        <a href="boys/ohioa.html"><b>Ohio</b></a>
                                        <a href="boys/oklahomaa.html"><b>Oklahoma</b></a>
                                        <a href="boys/oregona.html"><b>Oregon</b></a>
                                        <a href="boys/pennsylvaniaa.html"><b>Pennsylvania</b></a>
                                        <a href="boys/rhodeislanda.html"><b>Rhode Island</b></a>
                                        <a href="boys/southcarolinaa.html"><b>South Carolina</b></a>
                                        <a href="boys/southdakotaa.html"><b>South Dakota</b></a>
                                        <a href="boys/tennesseea.html"><b>Tennessee</b></a>
                                        <a href="boys/texasa.html"><b>Texas</b></a>
                                        <a href="boys/utaha.html"><b>Utah</b></a>
                                        <a href="boys/vermonta.html"><b>Vermont</b></a>
                                        <a href="boys/virginiaa.html"><b>Virginia</b></a>
                                        <a href="boys/washingtona.html"><b>Washington</b></a>
                                        <a href="boys/westvirginiaa.html"><b>West Virginia</b></a>
                                        <a href="boys/wisconsina.html"><b>Wisconsin</b></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mt-30">
                                <div class="right_feature">
                                    <H3>2025 UPDATED 08/05 2025 15:00 PDT</b></H3>
                                    <div class="bg_ls">
                                        <h4>Women's Consensus Index</h4>
                                        <div>
                                            <a href="wom/wd1a.html"><b>Women's Division I</b></a>
                                            <a href="wom/wd2a.html"><b>Women's Division II</b></a>
                                            <a href="wom/wd3a.html"><b>Women's Division III</b></a>
                                        </div>
                                    </div>
                                    <div class="bg_ls items-box">
                                        <h4>Girl's Consensus Index</h4>
                                        <a href="girls/alabamaa.html"><b>Alabama</b></a>
                                        <a href="girls/arizonaa.html"><b>Arizona</b></a>
                                        <a href="girls/arkansasa.html"><b>Arkansas</b></a>
                                        <a href="girls/californiaa.html"><b>California</b></a>
                                        <a href="girls/coloradoa.html"><b>Colorado</b></a>
                                        <a href="girls/connecticuta.html"><b>Connecticut</b></a>
                                        <a href="girls/delawarea.html"><b>Delaware</b></a>
                                        <a href="girls/floridaa.html"><b>Florida</b></a>
                                        <a href="girls/georgiaa.html"><b>Georgia</b></a>
                                        <a href="girls/idahoa.html"><b>Idaho</b></a>
                                        <a href="girls/illinoisa.html"><b>Illinois</b></a>
                                        <a href="girls/indianaa.html"><b>Indiana</b></a>
                                        <a href="girls/kentuckya.html"><b>Kentucky</b></a>
                                        <a href="girls/mainea.html"><b>Maine</b></a>
                                        <a href="girls/marylanda.html"><b>Maryland</b></a>
                                        <a href="girls/massachusettsa.html"><b>Massachusetts</b></a>
                                        <a href="girls/michigana.html"><b>Michigan</b></a>
                                        <a href="girls/minnesotaa.html"><b>Minnesota</b></a>
                                        <a href="girls/missouria.html"><b>Missouri</b></a>
                                        <a href="girls/nebraskaa.html"><b>Nebraska</b></a>
                                        <a href="girls/nevadaa.html"><b>Nevada</b></a>
                                        <a href="girls/newenglanda.html"><b>New England</b></a>
                                        <a href="girls/newhampshirea.html"><b>New Hampshire</b></a>
                                        <a href="girls/newjerseya.html"><b>New Jersey</b></a>
                                        <a href="girls/newmexicoa.html"><b>New Mexico</b></a>
                                        <a href="girls/newyorka.html"><b>New York</b></a>
                                        <a href="girls/northcarolinaa.html"><b>North Carolina</b></a>
                                        <a href="girls/ohioa.html"><b>Ohio</b></a>
                                        <a href="girls/oregona.html"><b>Oregon</b></a>
                                        <a href="girls/pennsylvaniaa.html"><b>Pennsylvania</b></a>
                                        <a href="girls/rhodeislanda.html"><b>Rhode Island</b></a>
                                        <a href="girls/southcarolinaa.html"><b>South Carolina</b></a>
                                        <a href="girls/tennesseea.html"><b>Tennessee</b></a>
                                        <a href="girls/texasa.html"><b>Texas</b></a>
                                        <a href="girls/utaha.html"><b>Utah</b></a>
                                        <a href="girls/vermonta.html"><b>Vermont</b></a>
                                        <a href="girls/virginiaa.html"><b>Virginia</b></a>
                                        <a href="girls/washingtona.html"><b>Washington</b></a>
                                        <a href="girls/westvirginiaa.html"><b>West Virginia</b></a>
                                        <a href="girls/wisconsina.html"><b>Wisconsin</b></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
        <footer class="ta-footer ta-footer__style-2 ta-dark-mode mt-5" data-ta-sticky-footer>
            <div class="container-fluid">
                <div class="row mt-none-30">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 mt-30">
                        <div class="ta-footer-widget widget">
                            <ul>
                                <li><a href="about_us.php">About Us</a></li>
                                <li><a href="contactus.php">Contact Us</a></li>
                                <li>The content presented on this website is the property of LaxData Limited
                                    Partnership.
                                    Active Network, the former owner of Laxpower transferred the trademark and domain
                                    name "laxpower.com" to the non-profit USA Lacrosse. Laxnumbers.com (owned and
                                    operated
                                    by LaxData) partnered with USA Lacrosse to present this information as a
                                    continuation
                                    of the Laxpower website. For a history of Laxpower, see the "About Us."
                                    link.
                                </li>
                            </ul>
                            <p><img src="assets/img/ball_in_stick.gif" width="3%"></p>
                            <p>Copyright ©️ 2019-2025 <img src="assets/images/laxmath_logo.png" width="50" height="25" </p>
                        </div>
                        <p class="foot-para">
                               The content presented on this website is the property of LaxData Limited Partnership.                                               
                               Active Network, the former owner of Laxpower transferred their rights to the trademark                                                   
                               and domain name "laxpower.com" to the non-profit USA Lacrosse. Laxnumbers.com (owned                                                     
                               and operated by LaxData partnered with USA Lacrosse to present this information as a                                                     
                               continuation of the Laxpower website. For a history of Laxpower, see the "About Us."                                                     
                               link.
                           </p>
                    </div>
                </div>
            </div>
        </footer>
        <script src="assets/js/jquery-2.2.4.min.js"></script>
        <script src="assets/js/sticky-header.min.js"></script>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const seeMoreBtn = document.querySelector('.see-more');
            const hiddenContent = document.querySelector('.hidden-content');
            let isExpanded = false;

            seeMoreBtn.addEventListener('click', function(e) {
                e.preventDefault();

                if (isExpanded) {
                    hiddenContent.style.display = 'none';
                    seeMoreBtn.textContent = 'Full Story';
                } else {
                    hiddenContent.style.display = 'block';
                    seeMoreBtn.textContent = 'See Less';
                }

                isExpanded = !isExpanded;
            });
        });
        </script>
    </body>
</php>