<!DOCTYPE php>
<php>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Montecarlo Explanation</title>
<?php include_once("analyticstracking.php") ?>
<style>
* {
  box-sizing: border-box;
}
boby{
    background-color:#f1f1f1
}
.menu {
  float: left;
  width: 20%;
}
.menuitem {
  padding: 8px;
  margin-top: 7px;
  border-bottom: 1px solid #f1f1f1;
}
.main {
  float: left;
  width: 60%;
  padding: 0 20px;
  overflow: hidden;
}
.right {
  background-color: lightblue;
  float: left;
  width: 20%;
  padding: 10px 15px;
  margin-top: 7px;
}
.main-box{
    padding: 30px 60px;
}
img {
    width: 100%;
    height: 80px;
    object-fit: contain;
    margin: 20px 0px 30px;
}

h1 {
    font-size: 30px;
}

p {
    font-size: 16px;
    line-height: 26px;
    text-align: justify;
    margin: 0px;
}

h3 {
    font-size: 25px;
    margin: 25px 0px 15px;
}

b {
    font-size: 19px;
    display: block;
    margin: 20px 0px 10px;
}

@media only screen and (max-width:800px) {
  /* For tablets: */
  .main {
    width: 80%;
    padding: 0;
  }
  .right {
    width: 100%;
  }
}
@media only screen and (max-width:500px) {
  /* For mobile phones: */
  .menu, .main, .right {
    width: 100%;
  }
    .main-box{
    padding: 15px;
}
  img {
    width: 100%;
    height: 40px;
    object-fit: contain;
    margin: 20px 0px 10px;
}

h1 {
    font-size: 23px;
}

p {
    font-size: 14px;
    line-height: 24px;
    text-align: justify;
    margin: 0px;
}

h3 {
    font-size: 18px;
    margin: 20px 0px 10px;
}

b {
    font-size: 19px;
    display: block;
    margin: 20px 0px 10px;
}
}
@media only screen and (max-width:300px) {
  /* For mobile phones: */
  .menu, .main, .right {
    width: 100%;
  }
  .main-box{
    padding: 15px;
}
  img {
    width: 100%;
    height: 40px;
    object-fit: contain;
    margin: 20px 0px 10px;
}

h1 {
    font-size: 23px;
}

p {
    font-size: 14px;
    line-height: 24px;
    text-align: justify;
    margin: 0px;
}

h3 {
    font-size: 18px;
    margin: 20px 0px 10px;
}

b {
    font-size: 19px;
    display: block;
    margin: 20px 0px 10px;
}
}
</style>
</head>
<body style="font-family:Verdana;">

<div  class="main-box">
<p>
    <a href="http://www.laxmath.com/laxpower2/index.php"><img src="assets/img/logo/lax-power-logo.png">
    </a>
</p>  
<H1>Explanation Of "Monte Carlo" Championship</H1>
<p>
The Monte Carlo method calulates the odds or probability that teams will be selected to and win the Championship
Tournament. A description of the method we use to calculate these probabilities and a list of assumptions
and limitations to this method are discussed below. 
</p>
<H3>VERY TECHNICAL DESCRIPTION</H3>
<p>
The short answer for describing the method is that we use a “Monte Carlo” simulation to predict all 
outcomes. “Monte Carlo methods, or Monte Carlo experiments, are a broad class of computational algorithms
that rely on repeated random sampling to obtain numerical results. The underlying concept is to use 
randomness ------------. They are ---- are most useful when it is difficult or impossible to use other
approaches. ---" (source: Wikipedia).So let’s apply this to lacrosse, and specifically predict what is  
the probability a team will be crowned champion.
</p>

<H3> SIMPLER TECHNICAL DESCRIPTION</H3>
<p>
Lets understand the method applying it to Lacrosse.
<b>What we know?</b>: We know a team’s regular season schedule and scores of games already played. 
<b>What we do not know?</b>: We don’t know the outcome of games yet to be played for the remainder
 of the season and post season tournament games
</p>

<p>
If we can predict the scores of games to be played, we can predict who will be champion! But obviously
we cannot predict the future so where do we go from here? The answer is we use some basic assumptions
and hypotheses that, if true, will predict a probable outcome when computed over a large enough sample. 
So let me repeat this in sport’s lingo. Every team plays a schedule of games and we guess at the score
of each game that have not been played for the remainder of the season. Based on these scores, we
predict who will get in the tournaments and advance to their final destination.
</p>

<p>
<b>Now how do we predict the game score of a game yet to be played?</b> We use a random number to 
generate the winner for each game but we bias the score based on the strength of the two teams playing
each other. In this way, the outcome is semi-random, but favors the better team. How do we know the 
strength of each team? We use the power rating based on goal margin of victories of each team resulting
in the better team winning in most contest. What this means is that if a team A is much better than 
team B, team  A will randomly win a disproportionate number of games to team B. On the other hand, 
if team A and B are of equal strength, then team A and B will win about the same number of games if the 
sample is large enough.  Thus for a particular game a weak team will occasionally beat a stronger team, 
but if we were to generate this game score multiple times the better team will win more often.
</p>

<p>
So if we apply this technique to one entire season and predict the outcome of remaining games, then 
we will get results but they will be at the mercy of the random numbers selected and final results will
 not be accurate. But what if we applied this technique to 100,000 seasons or simulations, where each
season is replayed with new random outcomes of game scores. Then the results are no longer dependent
 on the random number but rather by the validity of the power ratings and other assumptions. This is 
analogous to gambling in Las Vegas. You may win a few times but over the long haul, the house will
eventually rule. In short, we made an assumption that the power ratings accurately predict the 
strength of teams and that by running 100,000 simulations we managed to collect results that satisfy 
other guidelines (e.g., the NCAA selection criteria) to predict the final outcome. So it’s possible 
that a weak team can get lucky in defeating stronger teams all the way to the championship. It is 
highly likely though and that team will have a low or zero probability of being champion. On the 
otherhand no team is completely left out.
</p>

<p>
<b>How do we get the final probabilities?</b> We count for each simulation how many times a team advances
and wins the tournament. Then we divide these results by the total number of simulations. As an example,
team A wins the championship 10,000 times out of 100,000 simulations. Then team A has a 10% chance 
{10,000/100,000 )* 100} of being champion.
</p>

<H3>Why not employ the RPI Method instead of the PR method</H3>
<p>
We do not use rhe RPI method to predict probabilities because if does not provide relative strengths
of teams in terms of goal margins and when used, much weaker teams would have a much higher probability
to win the championship than would actually occur.
</p>
</div>
</body>
<div style="overflow:auto">
</php>

