<?php include 'include/header.php' ?>

<section class="hero-section hero-style-two">
  <div class="container">
    <div class="row">
      <div class="col-12 col-sm-12 col-md-12 col-xl-7 col-xxl-7 col-lg-7">
        <div class="hero-text">
          <div class="circle-image">
            <img src="assets/img/circle-image-2.png" alt="img">
            <i class="fa-solid fa-arrow-right"></i>
          </div>
          <h1>Healthcare Web Design & Development in the UK </h1>
          <p>Creating secure, bespoke, and user friendly websites for UK clinics, hospitals, and medical professionals.</p>
          <div class="experience">
            <a href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2" class="btn bb">
              <span>Book Appointment<i class="fa-solid fa-arrow-right"></i></span>
            </a>
            <ul class="experience-team">
              <li><img src="assets/img/team-2.jpg" alt="img"></li>
              <li><img src="assets/img/team-3.png" alt="img"></li>
              <li><a href="#">+</a></li>
            </ul>
            <div>
              <h6>150+</h6>
              <span>Experience Web Designers</span>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-12 col-md-12 col-xl-5 col-xxl-5 col-lg-5">
        <div class="hero-img">
          <img src="https://www.fomatmedical.com/wp-content/uploads/2023/05/KVs_Web-Banner.ai-9-e1684795381411-600x655.png" alt="img">
          <ul class="shaps">
            <li><img src="assets/img/shaps-9.png" alt="img"></li>
            <li><img src="assets/img/shaps-10.png" alt="img"></li>
            <li><img src="assets/img/shaps-4.png" alt="img"></li>
            <li><img src="assets/img/shaps-5.png" alt="img"></li>
            <li><img src="assets/img/shaps-6.png" alt="img"></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>




<div class="marquee marquee-three">
  <div class="marquee-icon">
    <div class="marquee-content">
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3>Custom Web Solutions for Clinics</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3> Hospitals & Private Practices </h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3>Trusted by 200+ Healthcare</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3>Providers Across the UK</h3>
      </div>
    </div>
    <div class="marquee-content">
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3>Custom Web Solutions for Clinics</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3> Hospitals & Private Practices </h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3>Trusted by 200+ Healthcare</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/marquee-img.png" alt="img">
        <h3>Providers Across the UK</h3>
      </div>
    </div>
  </div>
</div>

<section class="gap no-top section-about-two">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <div class="about-two-img">
          <div class="circle-img">
            <img alt="img" src="https://www.instantwebmakers.co.uk/assets/images/instant-favicon.png">
          </div>
          <img src="assets/img/about-three.png" alt="img">
        </div>
      </div>
      <div class="col-lg-6">
        <div class="heading">
          <span># About Us</span>
          <h2>Your Healthcare Web Design Partner in the UK</h2>
          <p>We are a healthcare web design and development agency that helps clinics, hospitals, and medical professionals build modern, user friendly, bespoke, and beautiful websites. Our UK based design team combines creative design, strong technical expertise, and healthcare compliance to deliver digital experiences that earn trust and attract new patients.</p>
        </div>
        <div class="about-text-two">
          <div class="d-flex">
            <i>
              <svg width="55" height="55" viewBox="0 0 55 55" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12.5207 1V12.5217M42.4773 1V12.5217M0.999023 17.1305H53.999M3.30337 5.60887H51.6947C51.6947 5.60887 53.999 5.60887 53.999 7.91321V51.6957C53.999 51.6957 53.999 54 51.6947 54H3.30337C3.30337 54 0.999023 54 0.999023 51.6957V7.91321C0.999023 7.91321 0.999023 5.60887 3.30337 5.60887ZM37.8685 34.4131C37.8685 34.1075 37.7471 33.8145 37.5311 33.5984C37.315 33.3823 37.0219 33.2609 36.7164 33.2609H30.9555V27.5001C30.9555 27.1945 30.8341 26.9015 30.618 26.6854C30.402 26.4693 30.1089 26.3479 29.8033 26.3479H25.1946C24.8891 26.3479 24.596 26.4693 24.3799 26.6854C24.1638 26.9015 24.0425 27.1945 24.0425 27.5001V33.2609H18.2816C17.976 33.2609 17.6829 33.3823 17.4669 33.5984C17.2508 33.8145 17.1294 34.1075 17.1294 34.4131V39.0218C17.1294 39.3274 17.2508 39.6204 17.4669 39.8365C17.6829 40.0526 17.976 40.174 18.2816 40.174H24.0425V45.9348C24.0425 46.2404 24.1638 46.5334 24.3799 46.7495C24.596 46.9656 24.8891 47.087 25.1946 47.087H29.8033C30.1089 47.087 30.402 46.9656 30.618 46.7495C30.8341 46.5334 30.9555 46.2404 30.9555 45.9348V40.174H36.7164C37.0219 40.174 37.315 40.0526 37.5311 39.8365C37.7471 39.6204 37.8685 39.3274 37.8685 39.0218V34.4131Z" stroke="#5454FF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </i>
            <h3>Experienced Design Team</h3>
          </div>
          <div class="d-flex">
            <i>
              <svg width="52" height="57" viewBox="0 0 52 57" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M48.771 43.0446C50.5024 42.3112 51.4918 40.1112 50.7498 38.1557L47.287 30.3334C46.7923 28.8667 46.2976 27.4001 46.2976 25.9334V21.0445C46.2976 9.80003 37.146 1 26.0156 1C14.6377 1 5.73341 10.0445 5.73341 21.0445V26.1779C5.73341 27.6445 5.48609 29.1112 4.74406 30.5779L1.28128 38.4001C0.539252 40.3557 1.28125 42.3112 3.25999 43.289M49.513 56C45.3082 47.4444 36.4039 41.3333 26.0156 41.3333C15.6271 41.3333 6.72278 47.4444 2.51796 56M19.09 48.6663V55.9996M15.627 52.3334H23.0472M26.0155 12.0001C26.0155 12.0001 22.5527 20.8001 13.6483 21.0446C13.4009 22.2668 13.1536 23.489 13.1536 24.7112C13.1536 31.8002 19.0898 37.4224 26.0155 37.4224C32.9411 37.4224 38.8773 31.5557 38.8773 24.7112C38.8773 23.489 38.6299 22.2668 38.3826 21.0446C29.4783 20.5557 26.0155 12.0001 26.0155 12.0001Z" stroke="#5454FF" stroke-width="2.0001" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </i>
            <h3>Dedicated to supporting </h3>
          </div>
        </div>
        <div class="skill-wrapper">
          <div class="skill-focus">
            <span>Focused on Results </span>
          </div>
          <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="max-width:80%;"></div>
          </div>
        </div>
        <div class="about-service">
          <a href="void:;" onclick="LC_API.open_chat_window();return false" class="btn"><span>Let's Chat<i class="fa-solid fa-arrow-right"></i></span></a>
          <div>
            <i>
              <svg width="46" height="46" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8.65471 0.66883C8.65471 0.491728 8.72506 0.32188 8.85029 0.19665C8.97552 0.0714199 9.14536 0.0010664 9.32246 0.0010664C11.0929 0.00301066 12.7902 0.70717 14.042 1.95905C15.2939 3.21093 15.9981 4.90828 16 6.6787C16 6.8558 15.9296 7.02565 15.8044 7.15088C15.6792 7.27611 15.5093 7.34647 15.3322 7.34647C15.1551 7.34647 14.9853 7.27611 14.8601 7.15088C14.7348 7.02565 14.6645 6.8558 14.6645 6.6787C14.6629 5.26238 14.0996 3.90451 13.0981 2.90302C12.0966 1.90152 10.7388 1.33818 9.32246 1.33659C9.14536 1.33659 8.97552 1.26624 8.85029 1.14101C8.72506 1.01578 8.65471 0.845932 8.65471 0.66883ZM9.32246 4.00765C10.0309 4.00765 10.7102 4.28906 11.2112 4.78998C11.7121 5.2909 11.9935 5.97029 11.9935 6.6787C11.9935 6.8558 12.0638 7.02565 12.1891 7.15088C12.3143 7.27611 12.4841 7.34647 12.6612 7.34647C12.8383 7.34647 13.0082 7.27611 13.1334 7.15088C13.2586 7.02565 13.329 6.8558 13.329 6.6787C13.3279 5.61642 12.9055 4.59794 12.1543 3.84679C11.4032 3.09564 10.3847 2.67318 9.32246 2.67212C9.14536 2.67212 8.97552 2.74247 8.85029 2.8677C8.72506 2.99293 8.65471 3.16278 8.65471 3.33988C8.65471 3.51699 8.72506 3.68683 8.85029 3.81206C8.97552 3.93729 9.14536 4.00765 9.32246 4.00765ZM15.3943 11.1788C15.7813 11.5668 15.9986 12.0925 15.9986 12.6405C15.9986 13.1885 15.7813 13.7142 15.3943 14.1022L14.7867 14.8027C9.31779 20.0386 -3.99055 6.73346 1.16451 1.24711L1.93243 0.57935C2.32091 0.203183 2.84186 -0.0049107 3.38259 8.80176e-05C3.92332 0.00508674 4.44034 0.222776 4.8218 0.60606C4.8425 0.626761 6.07985 2.23407 6.07985 2.23407C6.447 2.61979 6.65138 3.13216 6.65051 3.66469C6.64964 4.19721 6.44358 4.70892 6.07517 5.09343L5.30192 6.0657C5.72984 7.10548 6.35901 8.05045 7.15327 8.84633C7.94753 9.6422 8.89122 10.2733 9.93012 10.7033L10.9084 9.92537C11.2929 9.55724 11.8045 9.35142 12.3369 9.35068C12.8693 9.34993 13.3814 9.55431 13.767 9.92136C13.767 9.92136 15.3736 11.1581 15.3943 11.1788ZM14.4755 12.1497C14.4755 12.1497 12.8776 10.9203 12.8569 10.8996C12.7193 10.7632 12.5334 10.6867 12.3397 10.6867C12.146 10.6867 11.9601 10.7632 11.8225 10.8996C11.8045 10.9183 10.4576 11.9914 10.4576 11.9914C10.3669 12.0637 10.2589 12.111 10.1442 12.1288C10.0296 12.1466 9.91231 12.1343 9.80391 12.0929C8.45803 11.5918 7.23555 10.8073 6.2193 9.79254C5.20304 8.77776 4.41674 7.55643 3.91365 6.21127C3.86905 6.10139 3.8545 5.98162 3.87152 5.86426C3.88854 5.7469 3.9365 5.63619 4.01048 5.5435C4.01048 5.5435 5.08356 4.19596 5.10159 4.1786C5.23799 4.04103 5.31452 3.85514 5.31452 3.66141C5.31452 3.46768 5.23799 3.2818 5.10159 3.14423C5.08089 3.1242 3.85155 1.5249 3.85155 1.5249C3.71193 1.3997 3.5297 1.33265 3.34222 1.33749C3.15475 1.34234 2.97622 1.4187 2.84325 1.55095L2.07533 2.21871C-1.69214 6.74882 9.84064 17.642 13.8104 13.8905L14.4188 13.1894C14.5613 13.0574 14.6469 12.8751 14.6575 12.681C14.6681 12.487 14.6028 12.2965 14.4755 12.1497Z" fill="#021935" />
              </svg>
            </i>
            <div>
              <span>Call Service</span>
              <a href="tel:<?php echo $number ?>">
                <?php echo $number ?>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="gap counter_bg">
  <div class="container">
    <div class="heading two">
      <span class="text-white"># Our Services</span>
      <h2 class="text-white">Digital Solutions for Modern Healthcare Providers</h2>
      <p class="txt2">Our services cover everything your healthcare business needs to establish a professional online presence</p>
    </div>
    <div class="row row-two g-4 d-flex justify-content-center">
      <div class="col-lg-4 col-12 col-sm-12 col-md-4 col-xl-3 col-xxl-3">
        <div class="dental-services">
          <h3><a href="#" class="text-white">Custom Healthcare Website Design</a></h3>
          <i>
            <svg width="45" height="47" viewBox="0 0 45 47" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M43.5125 16.973C43.7364 16.8433 43.8999 16.6296 43.9668 16.379C44.0337 16.1284 43.9987 15.8614 43.8694 15.6367L39.9691 8.85935C39.8415 8.63609 39.6313 8.47231 39.3841 8.40348C39.1346 8.33658 38.8687 8.37176 38.645 8.5013L27.3753 15.0263V1.97826C27.3753 1.71881 27.2726 1.46999 27.0897 1.28653C26.9068 1.10307 26.6588 1 26.4002 1H18.5998C18.3412 1 18.0932 1.10307 17.9103 1.28653C17.7274 1.46999 17.6247 1.71881 17.6247 1.97826V15.0243L6.36279 8.5013C6.13884 8.37158 5.8727 8.33643 5.62292 8.40358C5.37314 8.47072 5.16017 8.63467 5.03086 8.85935L1.13063 15.6367C1.00134 15.8614 0.966298 16.1284 1.03322 16.379C1.10015 16.6296 1.26356 16.8433 1.4875 16.973L12.7494 23.5L1.4875 30.023C1.26356 30.1528 1.10015 30.3664 1.03322 30.617C0.966298 30.8676 1.00134 31.1347 1.13063 31.3593L5.03086 38.1367C5.16017 38.3614 5.37314 38.5254 5.62292 38.5925C5.8727 38.6597 6.13884 38.6245 6.36279 38.4948L17.6247 31.9698V45.0217C17.6247 45.2812 17.7274 45.53 17.9103 45.7135C18.0932 45.8969 18.3412 46 18.5998 46H26.4002C26.6588 46 26.9068 45.8969 27.0897 45.7135C27.2726 45.53 27.3753 45.2812 27.3753 45.0217V31.9698L38.6392 38.4948C38.8629 38.6243 39.1287 38.6595 39.3783 38.5926C39.6254 38.5238 39.8356 38.36 39.9633 38.1367L43.8635 31.3593C43.9928 31.1347 44.0279 30.8676 43.9609 30.617C43.894 30.3664 43.7306 30.1528 43.5066 30.023L32.2506 23.5L43.5125 16.973Z" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
          </i>
          <p class="text-white">Tailored designs for clinics, hospitals, and consultants that reflect your brand and inspire trust.</p>
          <a href="#" class="btn two"><span>Read more<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-12 col-sm-12 col-md-4 col-xl-3 col-xxl-3">
        <div class="dental-services">
          <h3><a href="#" class="text-white">Healthcare Website Development</a></h3>
          <i>
            <svg width="45" height="47" viewBox="0 0 45 47" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M40.834 24.9998H38.834C38.1306 24.9981 37.4495 24.7582 36.9054 24.3206C36.3613 23.8831 35.9876 23.2746 35.8475 22.5979L34.8047 17.4503C22.623 17.4503 22.5 11.4979 22.5 11.4979C22.5 11.4979 22.3727 17.4482 10.1952 17.4482L9.15244 22.5979C9.01183 23.2748 8.63776 23.8833 8.09332 24.3208C7.54889 24.7584 6.86742 24.9982 6.16385 24.9998H4.16173M19.4446 25.0593C19.1204 24.562 18.6653 24.16 18.1274 23.8958C17.5896 23.6316 16.9891 23.515 16.3893 23.5584C15.7895 23.515 15.189 23.6316 14.6512 23.8958C14.1133 24.16 13.6582 24.562 13.334 25.0593M31.6764 25.0592C31.3522 24.5619 30.8971 24.1599 30.3592 23.8957C29.8214 23.6315 29.2209 23.5149 28.6211 23.5583C28.021 23.5145 27.42 23.6309 26.8818 23.8952C26.3435 24.1594 25.8881 24.5616 25.5637 25.0592M22.5 46C17.9118 46 8.78126 43.7046 7.44651 35.7886C7.34747 35.2389 7.09227 34.7279 6.71031 34.3144C6.50325 34.3475 6.29429 34.368 6.08465 34.3758C4.90799 34.3725 3.76869 33.9698 2.85994 33.2359C1.95119 32.502 1.32891 31.4822 1.09862 30.3493C0.86833 29.2164 1.0442 28.0401 1.5964 27.02C2.14861 25.9998 3.04317 25.1986 4.12841 24.7521C2.6435 15.7959 2.87708 1 22.5 1C42.1229 1 42.3565 15.7939 40.8716 24.7521V24.7603C41.9568 25.2068 42.8514 26.008 43.4036 27.0282C43.9558 28.0483 44.1317 29.2246 43.9014 30.3575C43.6711 31.4904 43.0488 32.5102 42.1401 33.2441C41.2313 33.978 40.092 34.3807 38.9153 34.384C38.7113 34.3766 38.5079 34.3568 38.3064 34.3246C37.9264 34.7394 37.6715 35.2499 37.5702 35.7989C36.2208 43.7046 27.0882 46 22.5 46ZM22.5 46C18.3289 46 10.3746 44.0774 7.98872 37.7462V29.7012M22.5 46C26.7733 46 34.9945 43.9996 37.1864 37.3285V29.7012M37.1864 29.7012C27.6527 32.4327 17.5224 32.4327 7.98872 29.7012M37.1864 29.7012L40.3148 25.6058M7.98872 29.7012L4.86039 25.6058" stroke="#021935" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
          </i>
          <p class="text-white">Fast, responsive, and secure platforms built using modern frameworks and healthcare specific integrations.</p>
          <a href="#" class="btn two"><span>Read more<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-12 col-sm-12 col-md-4 col-xl-3 col-xxl-3">
        <div class="dental-services">
          <h3><a href="#" class="text-white">Online Appointment Booking Systems</a></h3>
          <i>
            <svg width="48" height="47" viewBox="0 0 48 47" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M24.0001 17.016C34 17.016 42.3334 25.0511 46 29.0688C47.3333 30.5037 47.3333 32.5124 46 33.9474C42.3334 37.9648 34 46 24.0001 46C14 46 5.66667 38.2517 2 33.9474C0.666667 32.5124 0.666667 30.5037 2 29.0688C2.53746 28.4798 3.17521 27.8046 3.90377 27.0811M23.9984 38.6917C28.0116 38.6917 31.2649 35.4755 31.2649 31.5078C31.2649 27.5404 28.0116 24.3239 23.9984 24.3239C19.9855 24.3239 16.7322 27.5404 16.7322 31.5078C16.7322 35.4755 19.9855 38.6917 23.9984 38.6917ZM19.0061 16.0624C19.0061 11.6555 11.089 1 11.089 1C11.089 1 2.90582 11.6555 2.90582 16.0624C2.90582 18.1732 3.75394 20.1977 5.26365 21.6902C6.77335 23.1828 8.82095 24.0212 10.956 24.0212C13.091 24.0212 15.1386 23.1828 16.6483 21.6902C18.158 20.1977 19.0061 18.1732 19.0061 16.0624Z" stroke="#021935" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
          </i>
          <p class="text-white">Seamless integration with your scheduling software for real time patient booking and management.</p>
          <a href="#" class="btn two"><span>Read more<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-12 col-sm-12 col-md-4 col-xl-3 col-xxl-3">
        <div class="dental-services">
          <h3><a href="#" class="text-white">Patient Portals & Secure Messaging</a></h3>
          <i>
            <svg width="44" height="47" viewBox="0 0 44 47" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M7.10271 46V33.47C4.29238 30.9098 2.33244 27.5758 1.47885 23.9034C0.625239 20.231 0.917648 16.3907 2.31786 12.8842C3.71808 9.37764 6.16105 6.3678 9.32774 4.2477C12.4944 2.1276 16.2376 0.995768 20.0686 1.00001C34.5883 1.00001 37.7225 12.756 42.8987 25.96C42.9874 26.1874 43.0185 26.4324 42.9894 26.6742C42.9605 26.916 42.8721 27.1472 42.7319 27.348C42.592 27.5486 42.4043 27.7128 42.1854 27.8264C41.9664 27.94 41.7225 27.9996 41.475 28H37.6107V34C37.6107 35.5914 36.9678 37.1174 35.8235 38.2426C34.6793 39.3678 33.1272 40 31.5091 40H28.4583V46M17.2088 7.54045C18.3488 8.87667 19.0441 10.5247 19.2014 12.262C19.3584 13.9993 18.9695 15.7421 18.0872 17.2551C17.3074 17.3147 16.5339 17.081 15.9226 16.6013C15.3114 16.1217 14.908 15.4317 14.7941 14.6709C13.6261 15.2982 12.6646 16.2406 12.0229 17.3872C11.3812 18.5338 11.086 19.8368 11.172 21.1428C11.1726 23.204 12.0057 25.1804 13.4881 26.6378C14.9704 28.095 16.9806 28.9136 19.0767 28.9136C21.1638 28.8858 23.1574 28.0582 24.6334 26.607C26.1092 25.1556 26.9508 23.1952 26.9791 21.1428C27.2422 18.1068 26.4061 15.077 24.6186 12.5882C22.8308 10.0994 20.2065 8.31161 17.2088 7.54045Z" stroke="#021935" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
          </i>
          <p class="text-white">Custom solutions that improve patient engagement and streamline communications.</p>
          <a href="#" class="btn two"><span>Read more<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-12 col-sm-12 col-md-4 col-xl-3 col-xxl-3">
        <div class="dental-services">
          <h3><a href="#" class="text-white">Medical SEO & Local Search Optimisation</a></h3>
          <i>
            <svg width="45" height="47" viewBox="0 0 45 47" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M43.5125 16.973C43.7364 16.8433 43.8999 16.6296 43.9668 16.379C44.0337 16.1284 43.9987 15.8614 43.8694 15.6367L39.9691 8.85935C39.8415 8.63609 39.6313 8.47231 39.3841 8.40348C39.1346 8.33658 38.8687 8.37176 38.645 8.5013L27.3753 15.0263V1.97826C27.3753 1.71881 27.2726 1.46999 27.0897 1.28653C26.9068 1.10307 26.6588 1 26.4002 1H18.5998C18.3412 1 18.0932 1.10307 17.9103 1.28653C17.7274 1.46999 17.6247 1.71881 17.6247 1.97826V15.0243L6.36279 8.5013C6.13884 8.37158 5.8727 8.33643 5.62292 8.40358C5.37314 8.47072 5.16017 8.63467 5.03086 8.85935L1.13063 15.6367C1.00134 15.8614 0.966298 16.1284 1.03322 16.379C1.10015 16.6296 1.26356 16.8433 1.4875 16.973L12.7494 23.5L1.4875 30.023C1.26356 30.1528 1.10015 30.3664 1.03322 30.617C0.966298 30.8676 1.00134 31.1347 1.13063 31.3593L5.03086 38.1367C5.16017 38.3614 5.37314 38.5254 5.62292 38.5925C5.8727 38.6597 6.13884 38.6245 6.36279 38.4948L17.6247 31.9698V45.0217C17.6247 45.2812 17.7274 45.53 17.9103 45.7135C18.0932 45.8969 18.3412 46 18.5998 46H26.4002C26.6588 46 26.9068 45.8969 27.0897 45.7135C27.2726 45.53 27.3753 45.2812 27.3753 45.0217V31.9698L38.6392 38.4948C38.8629 38.6243 39.1287 38.6595 39.3783 38.5926C39.6254 38.5238 39.8356 38.36 39.9633 38.1367L43.8635 31.3593C43.9928 31.1347 44.0279 30.8676 43.9609 30.617C43.894 30.3664 43.7306 30.1528 43.5066 30.023L32.2506 23.5L43.5125 16.973Z" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
          </i>
          <p class="text-white">Rank higher on Google for UK healthcare keywords such as “private clinic near me,” “NHS GP website design,” “healthcare web development UK”, and more.</p>
          <a href="#" class="btn two"><span>Read more<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-12 col-sm-12 col-md-4 col-xl-3 col-xxl-3">
        <div class="dental-services">
          <h3><a href="#" class="text-white">Website Maintenance & Support</a></h3>
          <i>
            <svg width="45" height="47" viewBox="0 0 45 47" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M40.834 24.9998H38.834C38.1306 24.9981 37.4495 24.7582 36.9054 24.3206C36.3613 23.8831 35.9876 23.2746 35.8475 22.5979L34.8047 17.4503C22.623 17.4503 22.5 11.4979 22.5 11.4979C22.5 11.4979 22.3727 17.4482 10.1952 17.4482L9.15244 22.5979C9.01183 23.2748 8.63776 23.8833 8.09332 24.3208C7.54889 24.7584 6.86742 24.9982 6.16385 24.9998H4.16173M19.4446 25.0593C19.1204 24.562 18.6653 24.16 18.1274 23.8958C17.5896 23.6316 16.9891 23.515 16.3893 23.5584C15.7895 23.515 15.189 23.6316 14.6512 23.8958C14.1133 24.16 13.6582 24.562 13.334 25.0593M31.6764 25.0592C31.3522 24.5619 30.8971 24.1599 30.3592 23.8957C29.8214 23.6315 29.2209 23.5149 28.6211 23.5583C28.021 23.5145 27.42 23.6309 26.8818 23.8952C26.3435 24.1594 25.8881 24.5616 25.5637 25.0592M22.5 46C17.9118 46 8.78126 43.7046 7.44651 35.7886C7.34747 35.2389 7.09227 34.7279 6.71031 34.3144C6.50325 34.3475 6.29429 34.368 6.08465 34.3758C4.90799 34.3725 3.76869 33.9698 2.85994 33.2359C1.95119 32.502 1.32891 31.4822 1.09862 30.3493C0.86833 29.2164 1.0442 28.0401 1.5964 27.02C2.14861 25.9998 3.04317 25.1986 4.12841 24.7521C2.6435 15.7959 2.87708 1 22.5 1C42.1229 1 42.3565 15.7939 40.8716 24.7521V24.7603C41.9568 25.2068 42.8514 26.008 43.4036 27.0282C43.9558 28.0483 44.1317 29.2246 43.9014 30.3575C43.6711 31.4904 43.0488 32.5102 42.1401 33.2441C41.2313 33.978 40.092 34.3807 38.9153 34.384C38.7113 34.3766 38.5079 34.3568 38.3064 34.3246C37.9264 34.7394 37.6715 35.2499 37.5702 35.7989C36.2208 43.7046 27.0882 46 22.5 46ZM22.5 46C18.3289 46 10.3746 44.0774 7.98872 37.7462V29.7012M22.5 46C26.7733 46 34.9945 43.9996 37.1864 37.3285V29.7012M37.1864 29.7012C27.6527 32.4327 17.5224 32.4327 7.98872 29.7012M37.1864 29.7012L40.3148 25.6058M7.98872 29.7012L4.86039 25.6058" stroke="#021935" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
          </i>
          <p class="text-white">Ongoing security, updates, and performance monitoring so your site always runs smoothly.</p>
          <a href="#" class="btn two"><span>Read more<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
    </div>
    <div class="btns_group d-flex justify-content-center">
      <a href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2" class="btn two"><span>Get a Quote <i class="fa-solid fa-arrow-right"></i></span></a>
      <a href="tel:<?php echo $number ?>" class="btn two"><span>Schedule a Call <i class="fa-solid fa-phone-volume"></i></span></a>
    </div>
  </div>
</section>

<div class="marquee">
  <div class="marquee-icon">
    <div class="marquee-content">
      <div class="marquee-item">
        <img src="assets/img/health-img-3.png" alt="img">
        <h3>Medical group</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/health-img-2.png" alt="img">
        <h3>Core Services</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/health-img-1.png" alt="img">
        <h3>Technology</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/health-img-2.png" alt="img">
        <h3>Health blogs</h3>
      </div>
    </div>
    <div class="marquee-content">
      <div class="marquee-item">
        <img src="assets/img/health-img-3.png" alt="img">
        <h3>Medical group</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/health-img-2.png" alt="img">
        <h3>Core Services</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/health-img-1.png" alt="img">
        <h3>Technology</h3>
      </div>
      <div class="marquee-item">
        <img src="assets/img/health-img-2.png" alt="img">
        <h3>Health blogs</h3>
      </div>
    </div>
  </div>
</div>

<section class="gap">
  <div class="container">
    <div class="heading-three two">
      <span><img src="assets/img/heading-img2.png" alt="img">About Our Approach </span>
      <h2>Transforming UK Healthcare Brands Through Smart Web Design </h2>
      <h3>Approach</h3>
    </div>
    <div class="row align-items-center">
      <div class="col-12 col-sm-12 col-md-4 col-xl-4 col-lg-4">
        <div class="mu-service-three">
          <img src="assets/img/mu-service-three-icon-1.png" alt="img">
          <h3>Human Centred Creativity</h3>
          <p>We believe great healthcare websites blend empathy with design, creating experiences that comfort, inform, and build trust with every visitor.</p>
        </div>
        <div class="mu-service-three">
          <img src="assets/img/mu-service-three-icon-2.png" alt="img">
          <h3>Deep Industry Understanding</h3>
          <p>Our team specialises exclusively in UK healthcare, giving us insight into patient behaviour, clinic operations, and regulatory expectations.</p>
        </div>
      </div>
      <div class="col-12 col-sm-12 col-md-4 col-xl-4 col-lg-4">
        <div class="mu-service-three-img img-hover">
          <figure>
            <img src="assets/img/mu-service-three-img.jpg" alt="img">
          </figure>

        </div>
      </div>
      <div class="col-12 col-sm-12 col-md-4 col-xl-4 col-lg-4">
        <div class="mu-service-three left-side">
          <img src="assets/img/mu-service-three-icon-3.png" alt="img">
          <h3>Partnership Over Projects</h3>
          <p>We work as an extension of your team, listening, advising, and building long term relationships focused on your growth and success.</p>
        </div>
        <div class="mu-service-three left-side">
          <img src="assets/img/mu-service-three-icon-4.png" alt="img">
          <h3>Integrity & Transparency</h3>
          <p>Every project is managed with clear communication, honest timelines, and measurable outcomes, no hidden costs, just consistent results.</p>
        </div>
      </div>
    </div>
    <div class="btns_group d-flex justify-content-center">
      <a class='btn' href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2" class="btn two"><span>Tell us about your project <i class="fa-solid fa-arrow-right"></i></span></a>
      <a href="tel:<?php echo $number ?>" class="btn two"><span>Schedule a Call <i class="fa-solid fa-phone-volume"></i></span></a>
    </div>
  </div>
</section>

<section class="portfolio_wrapper">
  <div class="container-fluid">
    <div class="heading-btn">
      <div class="heading-three">
        <span class="text-white"><img src="assets/img/heading-img2.png" alt="img">Recent Work</span>
        <h2 class="text-white">Have a Look at What We Do</h2>
      </div>
      <a href="our-work" class="btn three-color">
        <span>All Project<i>
            <svg width="20" height="18" viewBox="0 0 20 18" xmlns="http://www.w3.org/2000/svg">
              <path d="M11.3306 16.6283C11.3456 16.6433 11.8036 16.7581 12.3485 16.8833C12.8934 17.0085 13.3451 17.0919 13.3524 17.0686C13.3596 17.0453 13.416 16.6671 13.4776 16.2281C13.6015 15.3466 13.9013 14.3174 14.2217 13.6738C15.2204 11.6678 17.0123 10.3395 19.1856 9.99425L19.739 9.90632V8.13393L19.2374 8.04976C15.9511 7.49843 13.8086 5.04123 13.4078 1.36401C13.3817 1.12389 13.3504 0.927498 13.3383 0.927498C13.2275 0.927498 11.391 1.37009 11.3563 1.40515C11.3312 1.4305 11.3498 1.65561 11.3979 1.90529C11.9293 4.67015 13.4509 6.91999 15.4255 7.8607L15.8992 8.08636L0 8.11525V9.90871L15.892 9.93768L15.2941 10.2407C13.7427 11.0266 12.5145 12.5683 11.7913 14.6377C11.5852 15.2272 11.2742 16.5713 11.3306 16.6283Z"></path>
            </svg>
          </i>
        </span>
      </a>
    </div>
    <div class="mt-4 row align-items-center">
      <div class="col-12 col-sm-12 col-lg-4 col-md-6">
        <div class="three-project img-hover">
          <a href="assets/img//portfolio/3.png" data-fancybox>
            <figure>
              <img src="assets/img//portfolio/bn-1.png" alt="img">
            </figure>
          </a>
        </div>
        <div class="three-project img-hover">
          <a href="assets/img//portfolio/5.png" data-fancybox>
            <figure>
              <img src="assets/img//portfolio/bn-5.png" alt="img">
            </figure>
          </a>
        </div>
      </div>
      <div class="col-12 col-sm-12 col-lg-4 col-md-6">
        <div class="three-project img-hover">
          <a href="assets/img//portfolio/2.png" data-fancybox>
            <figure class="bn">
              <img src="assets/img//portfolio/2.png" alt="img">
            </figure>
          </a>
        </div>
      </div>
      <div class="col-12 col-sm-12 col-lg-4">
        <div class="three-project img-hover">
          <a href="assets/img//portfolio/4.png" data-fancybox>
            <figure>
              <img src="assets/img//portfolio/bn-3.png" alt="img">
            </figure>
          </a>
        </div>
        <div class="three-project img-hover">
          <a href="assets/img//portfolio/1.png" data-fancybox>
            <figure>
              <img src="assets/img//portfolio/bn-4.png" alt="img">
            </figure>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="gap section-pricing" style="background-image: url(assets/img/graph.png);">
  <div class="container">
    <div class="heading two">
      <span># Pricing Table</span>
      <h2>Flexible Web Design Packages for Every Healthcare Provider </h2>
    </div>
    <div class="row">
      <div class="col-lg-4 col-md-6">
        <div class="pricing-plan">
          <img src="assets/img/pricing-plan-shap.png" alt="img">
          <h5>Basic Plan</h5>
          <h3>399/<span>Usd</span></h3>
          <span>Basic Web Design Plan</span>
          <ul class="list-style">
            <li>3 Page Website Design </li>
            <li>5 Stock Photos </li>
            <li>2 Banners Design </li>
            <li>Unlimited Revisions </li>
            <li>1 jQuery Slider banner </li>
            <li>Template Based Design </li>
            <li>Striking hover effect included </li>
          </ul>
          <a href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2" class="btn two"><span>Pick This Package<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-md-6">
        <div class="pricing-plan two">
          <img src="assets/img/pricing-plan-shap-1.png" alt="img">
          <h5>Professional</h5>
          <h3>579/<span>Usd</span></h3>
          <span>Professional Web Design Plan</span>
          <ul class="list-style">
            <li>5 Page Website Design </li>
            <li>10 Stock Photos </li>
            <li>5 Banners Design </li>
            <li>Unlimited Revisions </li>
            <li>3 jQuery Slider banner </li>
            <li>Custom Design </li>
            <li>Striking hover effect included </li>
            <li>Mobile Responsive </li>
          </ul>
          <a href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2" class="btn two"><span>Pick This Package<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
      <div class="col-lg-4 col-md-6">
        <div class="pricing-plan mb-0">
          <img src="assets/img/pricing-plan-shap.png" alt="img">
          <h5>Elite</h5>
          <h3>989/<span>Usd</span></h3>
          <span>Elite Web Design Plan</span>
          <ul class="list-style">
            <li>Unlimited Pages </li>
            <li>20 Stock Photos </li>
            <li>10 Banners Design </li>
            <li>Unlimited Revisions </li>
            <li>5 jQuery Slider banner </li>
            <li>Bespoke Custom Design </li>
            <li>Striking hover effect included </li>
            <li>Mobile Responsive </li>
            <li>CMS </li>
            <li>Custom Forms </li>
            <li>Booking Feature included </li>
          </ul>
          <a href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2" class="btn two"><span>Pick This Package<i class="fa-solid fa-arrow-right"></i></span></a>
        </div>
      </div>
    </div>
    <div class="btns_group d-flex justify-content-center">
      <a class="btn" href="void:;" data-bs-toggle="modal" data-bs-target="#exampleModal2"><span>Tell us about your project <i class="fa-solid fa-arrow-right"></i></span></a>
      <a href="tel:<?php echo $number ?>" class="btn two"><span>Schedule a Call <i class="fa-solid fa-phone-volume"></i></span></a>
    </div>
  </div>
  <ul class="shaps">
    <li><img src="assets/img/shaps-7.png" alt="img"></li>
    <li><img src="assets/img/shaps-8.png" alt="img"></li>
    <li><img src="assets/img/dots-img.png" alt="img"></li>
    <li><img src="assets/img/dots-img.png" alt="img"></li>
  </ul>
</section>

<div class="container brand_logo ">
  <div class="swiper brand-slide">
    <div class="swiper-wrapper">
      <div class="swiper-slide">
        <img src="assets/img/goodfirms.png" alt="img">
      </div>
      <div class="swiper-slide">
        <img src="assets/img/top-digital-agency.png" alt="img">
      </div>
      <div class="swiper-slide">
        <img src="assets/img/top-design-firm.png" alt="img">
      </div>
      <div class="swiper-slide">
        <img src="assets/img/brand-logo-4.png" alt="img">
      </div>
      <div class="swiper-slide">
        <img src="assets/img/clutch.png" alt="img">
      </div>
    </div>
  </div>
</div>

<section class="testimonials_wrapper gap">
  <div class="container">
    <div class="heading">
      <span><i class="fa-solid fa-heart"></i> Testimonials </span>
      <h2>Our Happy Patients Say?</h2>
    </div>
    <div class="swiper quote-slide">
      <div class="swiper-wrapper">
        <div class="swiper-slide">
          <div class="quote">
            <img src="assets/img/quote.png" alt="img">
            <p>I recently worked with Instant Web Makers to create a charity website and I'm really
              impressed with how quick the team managed to have the website created within the short
              deadline we had! They communicated well, understood my vision and delivered a fantastic
              website! I highly recommend their services!</p>
            <div class="admin-img">
              <div>
                <h3>Shakila</h3>
                <span>Client</span>
              </div>
              <h4><i class="fa-solid fa-star"></i>4.4</h4>
            </div>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="quote">
            <img src="assets/img/quote.png" alt="img">
            <p>They were very helpfull and efficient. They are always available and reliable. I will
              recommend their service to anyone. Keep it up and thanks for a job welldone.</p>
            <div class="admin-img">
              <div>
                <h3>Justice Pius</h3>
                <span>Client</span>
              </div>
              <h4><i class="fa-solid fa-star"></i>4.8</h4>
            </div>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="quote">
            <img src="assets/img/quote.png" alt="img">
            <p>I used Instant Web Makers Instant
              I’m very happy with the service. They provide to me. Very helpful affordable.
              And very good website.
              Nothing is problem.
              Hallway happy in to help.
              I will recommend Instantwebmakers</p>
            <div class="admin-img">
              <div>
                <h3>Jorge Pereira</h3>
                <span>Client</span>
              </div>
              <h4><i class="fa-solid fa-star"></i>4.1</h4>
            </div>
          </div>
        </div>
      </div>
      <div class="swiper-button">
        <div class="swiper-button-next"><i class="fa-solid fa-arrow-right"></i></div>
        <div class="swiper-button-prev"><i class="fa-solid fa-arrow-left"></i></div>
      </div>
    </div>
  </div>
</section>

<?php include 'include/footer.php' ?>